/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.StatsEnvelope;

public class ReadOnlyKeyCommand<K, V, R>
extends AbstractDataCommand {
    public static final int COMMAND_ID = 62;
    protected Function<EntryView.ReadEntryView<K, V>, R> f;
    protected Params params;
    protected DataConversion keyDataConversion;
    protected DataConversion valueDataConversion;

    public ReadOnlyKeyCommand(Object key, Function<EntryView.ReadEntryView<K, V>, R> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(key, segment, 0L);
        this.f = f;
        this.params = params;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
        this.setFlagsBitSet(params.toFlagsBitSet());
    }

    public ReadOnlyKeyCommand() {
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    @Override
    public byte getCommandId() {
        return 62;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.f);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
        Params.writeObject(output, this.params);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.f = (Function)input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        this.params = Params.readObject(input);
        this.setFlagsBitSet(this.params.toFlagsBitSet());
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadOnlyKeyCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public Object performOnLostData() {
        return StatsEnvelope.create(this.f.apply(EntryViews.noValue(this.key, this.keyDataConversion)), true);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ReadOnlyKeyCommand{");
        sb.append(", key=").append(this.key);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }

    public Function<EntryView.ReadEntryView<K, V>, R> getFunction() {
        return this.f;
    }

    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }

    public Params getParams() {
        return this.params;
    }
}

