/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.persistence.async.AsyncNonBlockingStore;
import org.infinispan.persistence.async.Modification;
import org.infinispan.persistence.spi.MarshallableEntry;

class PutModification
implements Modification {
    private final int segment;
    private final MarshallableEntry entry;

    PutModification(int segment, MarshallableEntry entry) {
        this.segment = segment;
        this.entry = entry;
    }

    @Override
    public <K, V> void apply(AsyncNonBlockingStore<K, V> store) {
        store.putModification(AsyncNonBlockingStore.wrapKeyIfNeeded(this.entry.getKey()), this);
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    @Override
    public <K, V> CompletionStage<MarshallableEntry<K, V>> asStage() {
        return CompletableFuture.completedFuture(this.entry);
    }

    public <K, V> MarshallableEntry<K, V> getEntry() {
        return this.entry;
    }

    public String toString() {
        return "PutModification{segment=" + this.segment + ", key=" + this.entry.getKey() + '}';
    }
}

