/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.deployers.WebServiceAnnotationInfo;
import org.jboss.as.webservices.deployers.WebServiceProviderAnnotationInfo;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.metadata.model.JAXWSDeployment;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.msc.service.ServiceName;

public final class WSIntegrationProcessorJAXWS_EJB
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        WSIntegrationProcessorJAXWS_EJB.processAnnotation(unit, WebService.class);
        WSIntegrationProcessorJAXWS_EJB.processAnnotation(unit, WebServiceProvider.class);
    }

    private static void processAnnotation(DeploymentUnit unit, Class annotationType) {
        EEModuleDescription moduleDescription = (EEModuleDescription)ASHelper.getRequiredAttachment(unit, Attachments.EE_MODULE_DESCRIPTION);
        JAXWSDeployment jaxwsDeployment = ASHelper.getJaxwsDeployment(unit);
        for (EEModuleClassDescription description : moduleDescription.getClassDescriptions()) {
            ClassAnnotationInformation classAnnotationInfo = description.getAnnotationInformation(annotationType);
            if (classAnnotationInfo == null || classAnnotationInfo.getClassLevelAnnotations().isEmpty()) continue;
            Object obj = classAnnotationInfo.getClassLevelAnnotations().get(0);
            AnnotationTarget target = null;
            if (obj instanceof WebServiceAnnotationInfo) {
                target = ((WebServiceAnnotationInfo)obj).getTarget();
            } else if (obj instanceof WebServiceProviderAnnotationInfo) {
                target = ((WebServiceProviderAnnotationInfo)obj).getTarget();
            } else {
                return;
            }
            ClassInfo webServiceClassInfo = (ClassInfo)target;
            String webServiceClassName = webServiceClassInfo.name().toString();
            List componentDescriptions = moduleDescription.getComponentsByClassName(webServiceClassName);
            List<SessionBeanComponentDescription> sessionBeans = WSIntegrationProcessorJAXWS_EJB.getSessionBeans(componentDescriptions);
            Set<String> securityRoles = WSIntegrationProcessorJAXWS_EJB.getDeclaredSecurityRoles(unit, webServiceClassInfo);
            WebContextAnnotationWrapper webCtx = WSIntegrationProcessorJAXWS_EJB.getWebContextWrapper(webServiceClassInfo);
            String authMethod = webCtx.getAuthMethod();
            boolean isSecureWsdlAccess = webCtx.isSecureWsdlAccess();
            String transportGuarantee = webCtx.getTransportGuarantee();
            String realmName = webCtx.getRealmName();
            for (SessionBeanComponentDescription sessionBean : sessionBeans) {
                if (!sessionBean.isStateless() && !sessionBean.isSingleton()) continue;
                EJBViewDescription ejbViewDescription = sessionBean.addWebserviceEndpointView();
                ServiceName ejbViewName = ejbViewDescription.getServiceName();
                jaxwsDeployment.addEndpoint(new EJBEndpoint(sessionBean, ejbViewName, securityRoles, authMethod, realmName, isSecureWsdlAccess, transportGuarantee));
            }
        }
    }

    private static WebContextAnnotationWrapper getWebContextWrapper(ClassInfo webServiceClassInfo) {
        if (!webServiceClassInfo.annotationsMap().containsKey(DotNames.WEB_CONTEXT_ANNOTATION)) {
            return new WebContextAnnotationWrapper(null);
        }
        AnnotationInstance webContextAnnotation = (AnnotationInstance)((List)webServiceClassInfo.annotationsMap().get(DotNames.WEB_CONTEXT_ANNOTATION)).get(0);
        return new WebContextAnnotationWrapper(webContextAnnotation);
    }

    private static List<SessionBeanComponentDescription> getSessionBeans(List<ComponentDescription> componentDescriptions) {
        LinkedList<SessionBeanComponentDescription> sessionBeans = new LinkedList<SessionBeanComponentDescription>();
        for (ComponentDescription componentDescription : componentDescriptions) {
            if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
            sessionBeans.add((SessionBeanComponentDescription)componentDescription);
        }
        return sessionBeans;
    }

    private static Set<String> getDeclaredSecurityRoles(DeploymentUnit unit, ClassInfo webServiceClassInfo) {
        HashSet<String> securityRoles = new HashSet<String>();
        EjbJarMetaData ejbJarMD = (EjbJarMetaData)unit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMD != null && ejbJarMD.getAssemblyDescriptor() != null) {
            Object securityRolesMD;
            List securityRoleMetaDatas = ejbJarMD.getAssemblyDescriptor().getAny(SecurityRoleMetaData.class);
            if (securityRoleMetaDatas != null) {
                for (Object securityRoleMetaData : securityRoleMetaDatas) {
                    securityRoles.add(securityRoleMetaData.getRoleName());
                }
            }
            if ((securityRolesMD = ejbJarMD.getAssemblyDescriptor().getSecurityRoles()) != null && !securityRolesMD.isEmpty()) {
                Object securityRoleMetaData;
                securityRoleMetaData = securityRolesMD.iterator();
                while (securityRoleMetaData.hasNext()) {
                    SecurityRoleMetaData securityRoleMD = (SecurityRoleMetaData)securityRoleMetaData.next();
                    securityRoles.add(securityRoleMD.getRoleName());
                }
            }
        }
        if (webServiceClassInfo.annotationsMap().containsKey(DotNames.ROLES_ALLOWED_ANNOTATION)) {
            List allowedRoles = (List)webServiceClassInfo.annotationsMap().get(DotNames.ROLES_ALLOWED_ANNOTATION);
            for (AnnotationInstance allowedRole : allowedRoles) {
                if (!allowedRole.target().equals(webServiceClassInfo)) continue;
                for (String roleName : allowedRole.value().asStringArray()) {
                    securityRoles.add(roleName);
                }
            }
        }
        if (webServiceClassInfo.annotationsMap().containsKey(DotNames.DECLARE_ROLES_ANNOTATION)) {
            List declareRoles = (List)webServiceClassInfo.annotationsMap().get(DotNames.DECLARE_ROLES_ANNOTATION);
            for (AnnotationInstance declareRole : declareRoles) {
                if (!declareRole.target().equals(webServiceClassInfo)) continue;
                for (String roleName : declareRole.value().asStringArray()) {
                    securityRoles.add(roleName);
                }
            }
        }
        if (webServiceClassInfo.annotationsMap().containsKey(DotNames.PERMIT_ALL_ANNOTATION)) {
            for (AnnotationInstance permitAll : (List)webServiceClassInfo.annotationsMap().get(DotNames.PERMIT_ALL_ANNOTATION)) {
                if (!permitAll.target().equals(webServiceClassInfo)) continue;
                securityRoles.add("*");
                break;
            }
        }
        if (securityRoles.isEmpty()) {
            securityRoles.add("*");
        }
        return Collections.unmodifiableSet(securityRoles);
    }

    private static final class WebContextAnnotationWrapper {
        private final String authMethod;
        private final String transportGuarantee;
        private final boolean secureWsdlAccess;
        private final String realmName;

        WebContextAnnotationWrapper(AnnotationInstance annotation) {
            this.authMethod = this.stringValueOrNull(annotation, "authMethod");
            this.transportGuarantee = this.stringValueOrNull(annotation, "transportGuarantee");
            this.realmName = this.stringValueOrNull(annotation, "realmName");
            this.secureWsdlAccess = this.booleanValue(annotation, "secureWSDLAccess");
        }

        String getAuthMethod() {
            return this.authMethod;
        }

        String getTransportGuarantee() {
            return this.transportGuarantee;
        }

        boolean isSecureWsdlAccess() {
            return this.secureWsdlAccess;
        }

        String getRealmName() {
            return this.realmName;
        }

        private String stringValueOrNull(AnnotationInstance annotation, String attribute) {
            if (annotation == null) {
                return null;
            }
            AnnotationValue value = annotation.value(attribute);
            return value != null ? value.asString() : null;
        }

        private boolean booleanValue(AnnotationInstance annotation, String attribute) {
            if (annotation == null) {
                return false;
            }
            AnnotationValue value = annotation.value(attribute);
            return value != null ? value.asBoolean() : false;
        }
    }
}

