/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.group;

import java.io.DataOutput;
import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.IpAddressUUID;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.SimpleDataOutput;
import org.wildfly.clustering.server.infinispan.group.IpAddressBuilder;
import org.wildfly.clustering.server.infinispan.group.IpAddressMarshaller;

public class IpAddressUUIDMarshaller
implements ProtoStreamMarshaller<IpAddressUUID> {
    private static final long DEFAULT_LOW_BITS = 0L;
    private static final int DEFAULT_HIGH_BITS = 0;
    private static final int IP_ADDRESS_INDEX = 1;
    private static final int LOW_INDEX = 1 + IpAddressMarshaller.INSTANCE.getFields();
    private static final int HIGH_INDEX = LOW_INDEX + 1;

    public IpAddressUUID readFrom(ProtoStreamReader reader) throws IOException {
        IpAddressBuilder ipAddressBuilder = IpAddressMarshaller.INSTANCE.getBuilder();
        long low = 0L;
        int high = 0;
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index >= 1 && index < LOW_INDEX) {
                ipAddressBuilder = IpAddressMarshaller.INSTANCE.readField(reader, index - 1, ipAddressBuilder);
                continue;
            }
            if (index == LOW_INDEX) {
                low = reader.readSFixed64();
                continue;
            }
            if (index == HIGH_INDEX) {
                high = reader.readSFixed32();
                continue;
            }
            reader.skipField(tag);
        }
        return new DefaultIpAddressUUID((IpAddress)ipAddressBuilder.build(), low, high);
    }

    public void writeTo(ProtoStreamWriter writer, IpAddressUUID address) throws IOException {
        int high;
        IpAddressMarshaller.INSTANCE.writeFields(writer, 1, (IpAddress)address);
        long[] longs = new long[1];
        int[] ints = new int[1];
        DataOutput output = new SimpleDataOutput.Builder().with(longs).with(ints).build();
        address.writeTo(output);
        long low = longs[0];
        if (low != 0L) {
            writer.writeSFixed64(LOW_INDEX, low);
        }
        if ((high = ints[0]) != 0) {
            writer.writeSFixed32(HIGH_INDEX, high);
        }
    }

    public Class<? extends IpAddressUUID> getJavaClass() {
        return IpAddressUUID.class;
    }

    private static class DefaultIpAddressUUID
    extends IpAddressUUID {
        DefaultIpAddressUUID(IpAddress ipAddress, long low, int high) {
            super(ipAddress.getIpAddress(), ipAddress.getPort(), low, high);
        }
    }
}

