/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule.attribute;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.schedule.attribute.DayOfWeek;
import org.jboss.as.ejb3.timerservice.schedule.attribute.IntegerBasedExpression;
import org.jboss.as.ejb3.timerservice.schedule.util.CalendarUtil;
import org.jboss.as.ejb3.timerservice.schedule.value.RangeValue;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleExpressionType;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleValue;
import org.jboss.as.ejb3.timerservice.schedule.value.SingleValue;

public class DayOfMonth
extends IntegerBasedExpression {
    public static final Pattern REGEX_SPACES = Pattern.compile("\\s+");
    public static final Integer MAX_DAY_OF_MONTH = 31;
    public static final Integer MIN_DAY_OF_MONTH = -7;
    private static final Map<String, Integer> ORDINAL_TO_WEEK_NUMBER_MAPPING = new HashMap<String, Integer>(8);

    public DayOfMonth(String value) {
        super(value);
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_DAY_OF_MONTH;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_DAY_OF_MONTH;
    }

    public Integer getNextMatch(Calendar currentCal) {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return currentCal.get(5);
        }
        int currentDayOfMonth = currentCal.get(5);
        SortedSet<Integer> eligibleDaysOfMonth = this.getEligibleDaysOfMonth(currentCal);
        if (eligibleDaysOfMonth.isEmpty()) {
            return null;
        }
        for (Integer hour : eligibleDaysOfMonth) {
            if (currentDayOfMonth == hour) {
                return currentDayOfMonth;
            }
            if (hour <= currentDayOfMonth) continue;
            return hour;
        }
        return eligibleDaysOfMonth.first();
    }

    @Override
    protected void assertValid(Integer value) throws IllegalArgumentException {
        if (value != null && value == 0) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleValue(DayOfMonth.class.getSimpleName(), String.valueOf(value));
        }
        super.assertValid(value);
    }

    private boolean hasRelativeDayOfMonth() {
        return !this.relativeValues.isEmpty();
    }

    private SortedSet<Integer> getEligibleDaysOfMonth(Calendar cal) {
        if (!this.hasRelativeDayOfMonth()) {
            return this.absoluteValues;
        }
        TreeSet<Integer> eligibleDaysOfMonth = new TreeSet<Integer>(this.absoluteValues);
        for (ScheduleValue relativeValue : this.relativeValues) {
            int i;
            if (relativeValue instanceof SingleValue) {
                SingleValue singleValue = (SingleValue)relativeValue;
                String value = singleValue.getValue();
                Integer absoluteDayOfMonth = this.getAbsoluteDayOfMonth(cal, value);
                eligibleDaysOfMonth.add(absoluteDayOfMonth);
                continue;
            }
            if (!(relativeValue instanceof RangeValue)) continue;
            RangeValue range = (RangeValue)relativeValue;
            String start = range.getStart();
            String end = range.getEnd();
            Integer dayOfMonthStart = this.isRelativeValue(start) ? Integer.valueOf(this.getAbsoluteDayOfMonth(cal, start)) : this.parseInt(start);
            Integer dayOfMonthEnd = this.isRelativeValue(end) ? Integer.valueOf(this.getAbsoluteDayOfMonth(cal, end)) : this.parseInt(end);
            this.assertValid(dayOfMonthStart);
            this.assertValid(dayOfMonthEnd);
            if (dayOfMonthStart.equals(dayOfMonthEnd)) {
                eligibleDaysOfMonth.add(dayOfMonthEnd);
                continue;
            }
            if (dayOfMonthStart > dayOfMonthEnd) {
                for (i = dayOfMonthStart.intValue(); i <= this.getMaxValue(); ++i) {
                    eligibleDaysOfMonth.add(i);
                }
                for (i = this.getMinValue().intValue(); i <= dayOfMonthEnd; ++i) {
                    eligibleDaysOfMonth.add(i);
                }
                continue;
            }
            for (i = dayOfMonthStart.intValue(); i <= dayOfMonthEnd; ++i) {
                eligibleDaysOfMonth.add(i);
            }
        }
        return eligibleDaysOfMonth;
    }

    private int getAbsoluteDayOfMonth(Calendar cal, String trimmedRelativeDayOfMonth) {
        if (trimmedRelativeDayOfMonth.isEmpty()) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleValue(DayOfMonth.class.getSimpleName(), trimmedRelativeDayOfMonth);
        }
        if ((trimmedRelativeDayOfMonth = trimmedRelativeDayOfMonth.toLowerCase(Locale.ROOT)).equals("last")) {
            return CalendarUtil.getLastDateOfMonth(cal);
        }
        if (this.isValidNegativeDayOfMonth(trimmedRelativeDayOfMonth)) {
            int negativeRelativeDayOfMonth = Integer.parseInt(trimmedRelativeDayOfMonth);
            int lastDayOfCurrentMonth = CalendarUtil.getLastDateOfMonth(cal);
            return lastDayOfCurrentMonth + negativeRelativeDayOfMonth;
        }
        String[] parts = this.splitDayOfWeekBased(trimmedRelativeDayOfMonth);
        if (parts != null) {
            Integer date;
            String ordinal = parts[0];
            String day = parts[1];
            int dayOfWeek = DayOfWeek.DAY_OF_WEEK_ALIAS.get(day) + 1;
            if (ordinal.equals("last")) {
                date = CalendarUtil.getDateOfLastDayOfWeekInMonth(cal, dayOfWeek);
            } else {
                int weekNumber = ORDINAL_TO_WEEK_NUMBER_MAPPING.get(ordinal);
                date = CalendarUtil.getNthDayOfMonth(cal, weekNumber, dayOfWeek);
            }
            if (date == null) {
                date = CalendarUtil.getLastDateOfMonth(cal);
            }
            return date;
        }
        throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleValue(DayOfMonth.class.getSimpleName(), trimmedRelativeDayOfMonth);
    }

    private boolean isValidNegativeDayOfMonth(String dayOfMonth) {
        try {
            int val = Integer.parseInt(dayOfMonth.trim());
            return val <= -1 && val >= -7;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private String[] splitDayOfWeekBased(String trimmedLowerCaseRelativeVal) {
        String[] relativeParts = REGEX_SPACES.split(trimmedLowerCaseRelativeVal);
        if (relativeParts == null) {
            return null;
        }
        if (relativeParts.length != 2) {
            return null;
        }
        String lowerCaseOrdinal = relativeParts[0];
        String lowerCaseDayOfWeek = relativeParts[1];
        if (lowerCaseOrdinal == null || lowerCaseDayOfWeek == null) {
            return null;
        }
        if (!ORDINAL_TO_WEEK_NUMBER_MAPPING.containsKey(lowerCaseOrdinal) && !lowerCaseOrdinal.equals("last")) {
            return null;
        }
        if (!DayOfWeek.DAY_OF_WEEK_ALIAS.containsKey(lowerCaseDayOfWeek)) {
            return null;
        }
        return relativeParts;
    }

    @Override
    public boolean isRelativeValue(String value) {
        String lowerCaseValue = value.toLowerCase(Locale.ROOT);
        if (lowerCaseValue.equals("last")) {
            return true;
        }
        if (this.isValidNegativeDayOfMonth(lowerCaseValue)) {
            return true;
        }
        return this.splitDayOfWeekBased(lowerCaseValue) != null;
    }

    @Override
    protected boolean accepts(ScheduleExpressionType scheduleExprType) {
        switch (scheduleExprType) {
            case RANGE: 
            case LIST: 
            case SINGLE_VALUE: 
            case WILDCARD: {
                return true;
            }
        }
        return false;
    }

    public Integer getFirstMatch(Calendar cal) {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return 1;
        }
        SortedSet<Integer> eligibleDaysOfMonth = this.getEligibleDaysOfMonth(cal);
        if (eligibleDaysOfMonth.isEmpty()) {
            return null;
        }
        return eligibleDaysOfMonth.first();
    }

    @Override
    protected Integer parseInt(String alias) {
        try {
            return super.parseInt(alias);
        }
        catch (NumberFormatException nfe) {
            String lowerCaseAlias = alias.toLowerCase(Locale.ENGLISH);
            Integer dayOfWeekInteger = DayOfWeek.DAY_OF_WEEK_ALIAS.get(lowerCaseAlias);
            return dayOfWeekInteger == null ? null : Integer.valueOf(dayOfWeekInteger + 1);
        }
    }

    static {
        ORDINAL_TO_WEEK_NUMBER_MAPPING.put("1st", 1);
        ORDINAL_TO_WEEK_NUMBER_MAPPING.put("2nd", 2);
        ORDINAL_TO_WEEK_NUMBER_MAPPING.put("3rd", 3);
        ORDINAL_TO_WEEK_NUMBER_MAPPING.put("4th", 4);
        ORDINAL_TO_WEEK_NUMBER_MAPPING.put("5th", 5);
    }
}

