/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SingletonProtocolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class JChannelFactoryServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
ProtocolStackConfiguration {
    private final PathAddress address;
    private volatile boolean statisticsEnabled;
    private volatile SupplierDependency<TransportConfiguration<? extends TP>> transport = null;
    private volatile List<SupplierDependency<ProtocolConfiguration<? extends Protocol>>> protocols = null;
    private volatile SupplierDependency<RelayConfiguration> relay = null;
    private volatile SupplierDependency<SocketBindingManager> socketBindingManager;
    private volatile Supplier<ServerEnvironment> environment;

    public JChannelFactoryServiceConfigurator(PathAddress address) {
        super((Capability)StackResourceDefinition.Capability.JCHANNEL_FACTORY, address);
        this.address = address;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = new CompositeDependency(new Dependency[]{this.transport, this.relay, this.socketBindingManager}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        this.environment = builder.requires(ServerEnvironmentService.SERVICE_NAME);
        for (Dependency dependency : this.protocols) {
            dependency.register(builder);
        }
        Service service = Service.newInstance((Consumer)factory, (Object)new JChannelFactory(this));
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.statisticsEnabled = StackResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        Resource resource = context.readResourceFromRoot(this.address, false);
        Iterator transports = resource.getChildren(TransportResourceDefinition.WILDCARD_PATH.getKey()).iterator();
        if (!transports.hasNext()) {
            throw JGroupsLogger.ROOT_LOGGER.transportNotDefined(this.getName());
        }
        this.transport = new ServiceSupplierDependency((ServiceNameProvider)new SingletonProtocolServiceNameProvider(this.address, ((Resource.ResourceEntry)transports.next()).getPathElement()));
        Set entries = resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey());
        this.protocols = new ArrayList<SupplierDependency<ProtocolConfiguration<? extends Protocol>>>(entries.size());
        for (Resource.ResourceEntry entry : entries) {
            this.protocols.add((SupplierDependency<ProtocolConfiguration<? extends Protocol>>)new ServiceSupplierDependency((ServiceNameProvider)new ProtocolServiceNameProvider(this.address, entry.getPathElement())));
        }
        this.relay = resource.hasChild(RelayResourceDefinition.PATH) ? new ServiceSupplierDependency((ServiceNameProvider)new SingletonProtocolServiceNameProvider(this.address, RelayResourceDefinition.PATH)) : null;
        this.socketBindingManager = new ServiceSupplierDependency(CommonRequirement.SOCKET_BINDING_MANAGER.getServiceName(context));
        return this;
    }

    public String getName() {
        return this.address.getLastElement().getValue();
    }

    public TransportConfiguration<? extends TP> getTransport() {
        return (TransportConfiguration)this.transport.get();
    }

    public List<ProtocolConfiguration<? extends Protocol>> getProtocols() {
        ArrayList<ProtocolConfiguration<? extends Protocol>> protocols = new ArrayList<ProtocolConfiguration<? extends Protocol>>(this.protocols.size());
        for (Supplier supplier : this.protocols) {
            ProtocolConfiguration protocol = (ProtocolConfiguration)supplier.get();
            protocols.add((ProtocolConfiguration<? extends Protocol>)protocol);
        }
        return protocols;
    }

    public String getNodeName() {
        return this.environment.get().getNodeName();
    }

    public Optional<RelayConfiguration> getRelay() {
        return this.relay != null ? Optional.of((RelayConfiguration)this.relay.get()) : Optional.empty();
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public SocketBindingManager getSocketBindingManager() {
        return (SocketBindingManager)this.socketBindingManager.get();
    }
}

