/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.trycatch;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.trycatch.TryCatchFinallyControlFlow;

public class FinallyHandler
extends CommandHandlerWithHelp {
    public FinallyHandler() {
        super("finally", true);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        TryCatchFinallyControlFlow flow = TryCatchFinallyControlFlow.get(ctx);
        return flow != null && !flow.isInFinally();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        TryCatchFinallyControlFlow flow = TryCatchFinallyControlFlow.get(ctx);
        if (flow == null) {
            throw new CommandLineException("finally is available only in try-catch-finally control flow");
        }
        if (flow.isInFinally()) {
            throw new CommandLineException("Already in finally");
        }
        flow.moveToFinally();
    }
}

