/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.InstrumentationScopeUtil;
import io.opentelemetry.sdk.logs.LogBuilder;
import io.opentelemetry.sdk.logs.LogEmitter;
import io.opentelemetry.sdk.logs.LogEmitterSharedState;
import io.opentelemetry.sdk.logs.SdkLogBuilder;
import io.opentelemetry.sdk.logs.data.LogDataBuilder;

final class SdkLogEmitter
implements LogEmitter {
    private final LogEmitterSharedState logEmitterSharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;

    SdkLogEmitter(LogEmitterSharedState logEmitterSharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        this.logEmitterSharedState = logEmitterSharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.instrumentationLibraryInfo = InstrumentationScopeUtil.toInstrumentationLibraryInfo((InstrumentationScopeInfo)instrumentationScopeInfo);
    }

    @Override
    public LogBuilder logBuilder() {
        LogDataBuilder logDataBuilder = LogDataBuilder.create(this.logEmitterSharedState.getResource(), this.instrumentationLibraryInfo, this.logEmitterSharedState.getClock());
        return new SdkLogBuilder(this.logEmitterSharedState, logDataBuilder);
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }
}

