/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.audit.AuditLogItem;
import org.jboss.as.controller.audit.AuditLogItemFormatter;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;

abstract class AuditLogHandler {
    private volatile int maxFailureCount = 10;
    private int failureCount;
    protected final String name;
    private volatile String formatterName;
    private final Set<PathAddress> references = new HashSet<PathAddress>();
    private AuditLogItemFormatter formatter;

    AuditLogHandler(String name, String formatterName, int maxFailureCount) {
        this.name = name;
        this.formatterName = formatterName;
        this.maxFailureCount = maxFailureCount;
    }

    String getName() {
        return this.name;
    }

    void setFormatter(AuditLogItemFormatter formatter) {
        this.formatter = formatter;
    }

    String getFormatterName() {
        return this.formatterName;
    }

    public void setMaxFailureCount(int count) {
        this.maxFailureCount = count;
    }

    public void setFormatterName(String formatterName) {
        this.formatterName = formatterName;
    }

    void writeLogItem(AuditLogItem item) {
        FailureCountHandler fch = this.getFailureCountHandler();
        try {
            this.initialize();
            String formattedItem = item.format(this.formatter);
            this.writeLogItem(formattedItem);
            fch.success();
        }
        catch (Throwable t) {
            fch.failure(t);
        }
    }

    void recycle() {
        this.failureCount = 0;
        this.stop();
    }

    boolean isActive() {
        return !this.hasTooManyFailures();
    }

    boolean isDisabledDueToFailures() {
        return this.hasTooManyFailures();
    }

    boolean hasTooManyFailures() {
        return this.maxFailureCount > 0 && this.failureCount >= this.maxFailureCount;
    }

    void addReference(PathAddress address) {
        this.references.add(address);
    }

    void removeReference(PathAddress address) {
        this.references.remove(address);
        if (this.references.isEmpty()) {
            this.stop();
        }
    }

    Set<PathAddress> getReferences() {
        return this.references;
    }

    int getFailureCount() {
        return this.failureCount;
    }

    FailureCountHandler getFailureCountHandler() {
        return new StandardFailureCountHandler();
    }

    abstract boolean isDifferent(AuditLogHandler var1);

    abstract void initialize();

    abstract void stop();

    abstract void writeLogItem(String var1) throws IOException;

    List<ModelNode> listLastEntries() {
        return Collections.emptyList();
    }

    class ReconnectFailureCountHandler
    implements FailureCountHandler {
        ReconnectFailureCountHandler() {
        }

        @Override
        public void success() {
            AuditLogHandler.this.failureCount = 0;
        }

        @Override
        public void failure(Throwable t) {
            ControllerLogger.MGMT_OP_LOGGER.reconnectToSyslogFailed(AuditLogHandler.this.name, t);
        }
    }

    class StandardFailureCountHandler
    implements FailureCountHandler {
        StandardFailureCountHandler() {
        }

        @Override
        public void success() {
            AuditLogHandler.this.failureCount = 0;
        }

        @Override
        public void failure(Throwable t) {
            ++AuditLogHandler.this.failureCount;
            ControllerLogger.MGMT_OP_LOGGER.logHandlerWriteFailed(t, AuditLogHandler.this.name);
            if (AuditLogHandler.this.hasTooManyFailures()) {
                ControllerLogger.MGMT_OP_LOGGER.disablingLogHandlerDueToFailures(AuditLogHandler.this.failureCount, AuditLogHandler.this.name);
            }
        }
    }

    static interface FailureCountHandler {
        public void success();

        public void failure(Throwable var1);
    }
}

