/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.StaticFilterAliasGenerator;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.JoinedList;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.UnionTableGroup;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class UnionSubclassEntityPersister
extends AbstractEntityPersister {
    private final String subquery;
    private final String tableName;
    private final String[] subclassTableNames;
    private final String[] spaces;
    private final String[] subclassSpaces;
    private final String[] subclassTableExpressions;
    private final Object discriminatorValue;
    private final String discriminatorSQLValue;
    private final BasicType<?> discriminatorType;
    private final Map<Object, String> subclassByDiscriminatorValue = new HashMap<Object, String>();
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;

    @Deprecated(since="6.0")
    public UnionSubclassEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        this(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, (RuntimeModelCreationContext)creationContext);
    }

    public UnionSubclassEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, RuntimeModelCreationContext creationContext) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, creationContext);
        boolean callable;
        if (this.getIdentifierGenerator() instanceof IdentityGenerator) {
            throw new MappingException("Cannot use identity column key generation with <union-subclass> mapping for: " + this.getEntityName());
        }
        SessionFactoryImplementor factory = creationContext.getSessionFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        this.tableName = this.determineTableName(persistentClass.getTable());
        this.subclassTableNames = new String[]{this.tableName};
        String sql = persistentClass.getCustomSQLInsert();
        boolean bl = callable = sql != null && persistentClass.isCustomInsertCallable();
        ExecuteUpdateResultCheckStyle checkStyle = sql == null ? ExecuteUpdateResultCheckStyle.COUNT : (persistentClass.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(sql, callable) : persistentClass.getCustomSQLInsertCheckStyle());
        this.customSQLInsert = new String[]{sql};
        this.insertCallable = new boolean[]{callable};
        this.insertResultCheckStyles = new ExecuteUpdateResultCheckStyle[]{checkStyle};
        sql = persistentClass.getCustomSQLUpdate();
        boolean bl2 = callable = sql != null && persistentClass.isCustomUpdateCallable();
        checkStyle = sql == null ? ExecuteUpdateResultCheckStyle.COUNT : (persistentClass.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(sql, callable) : persistentClass.getCustomSQLUpdateCheckStyle());
        this.customSQLUpdate = new String[]{sql};
        this.updateCallable = new boolean[]{callable};
        this.updateResultCheckStyles = new ExecuteUpdateResultCheckStyle[]{checkStyle};
        sql = persistentClass.getCustomSQLDelete();
        boolean bl3 = callable = sql != null && persistentClass.isCustomDeleteCallable();
        checkStyle = sql == null ? ExecuteUpdateResultCheckStyle.COUNT : (persistentClass.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(sql, callable) : persistentClass.getCustomSQLDeleteCheckStyle());
        this.customSQLDelete = new String[]{sql};
        this.deleteCallable = new boolean[]{callable};
        this.deleteResultCheckStyles = new ExecuteUpdateResultCheckStyle[]{checkStyle};
        this.discriminatorValue = persistentClass.getSubclassId();
        this.discriminatorSQLValue = String.valueOf(persistentClass.getSubclassId());
        this.discriminatorType = factory.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
        this.subclassByDiscriminatorValue.put(persistentClass.getSubclassId(), persistentClass.getEntityName());
        if (persistentClass.isPolymorphic()) {
            for (Subclass subclass : persistentClass.getSubclasses()) {
                this.subclassByDiscriminatorValue.put(subclass.getSubclassId(), subclass.getEntityName());
            }
        }
        int spacesSize = 1 + persistentClass.getSynchronizedTables().size();
        this.spaces = new String[spacesSize];
        this.spaces[0] = this.tableName;
        Iterator<String> iter = persistentClass.getSynchronizedTables().iterator();
        for (int i = 1; i < spacesSize; ++i) {
            this.spaces[i] = iter.next();
        }
        HashSet<String> subclassTables = new HashSet<String>();
        for (Table table : persistentClass.getSubclassTableClosure()) {
            subclassTables.add(this.determineTableName(table));
        }
        this.subclassSpaces = ArrayHelper.toStringArray(subclassTables);
        this.subquery = this.generateSubquery(persistentClass, creationContext.getMetadata());
        ArrayList<String> tableExpressions = new ArrayList<String>(this.subclassSpaces.length * 2);
        Collections.addAll(tableExpressions, this.subclassSpaces);
        tableExpressions.add(this.subquery);
        for (PersistentClass parentPersistentClass = persistentClass.getSuperclass(); parentPersistentClass != null; parentPersistentClass = parentPersistentClass.getSuperclass()) {
            tableExpressions.add(this.generateSubquery(parentPersistentClass, creationContext.getMetadata()));
        }
        for (PersistentClass subPersistentClass : persistentClass.getSubclassClosure()) {
            if (!subPersistentClass.hasSubclasses()) continue;
            tableExpressions.add(this.generateSubquery(subPersistentClass, creationContext.getMetadata()));
        }
        this.subclassTableExpressions = ArrayHelper.toStringArray(tableExpressions);
        if (this.hasMultipleTables()) {
            int idColumnSpan = this.getIdentifierColumnSpan();
            ArrayList<String> tableNames = new ArrayList<String>();
            ArrayList<String[]> keyColumns = new ArrayList<String[]>();
            for (Table table : persistentClass.getSubclassTableClosure()) {
                if (table.isAbstractUnionTable()) continue;
                tableNames.add(this.determineTableName(table));
                String[] key = new String[idColumnSpan];
                List<Column> columns = table.getPrimaryKey().getColumns();
                for (int k = 0; k < idColumnSpan; ++k) {
                    key[k] = columns.get(k).getQuotedName(dialect);
                }
                keyColumns.add(key);
            }
            this.constraintOrderedTableNames = ArrayHelper.toStringArray(tableNames);
            this.constraintOrderedKeyColumnNames = ArrayHelper.to2DStringArray(keyColumns);
        } else {
            this.constraintOrderedTableNames = new String[]{this.tableName};
            this.constraintOrderedKeyColumnNames = new String[][]{this.getIdentifierColumnNames()};
        }
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(creationContext.getMetadata());
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        for (String subclassTableExpression : this.subclassTableExpressions) {
            if (!subclassTableExpression.equals(tableExpression)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAliasBase sqlAliasBase, SqlExpressionResolver expressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        UnionTableReference tableReference = this.resolvePrimaryTableReference(sqlAliasBase);
        return new UnionTableGroup(canUseInnerJoins, navigablePath, tableReference, this, explicitSourceAlias);
    }

    @Override
    protected UnionTableReference resolvePrimaryTableReference(SqlAliasBase sqlAliasBase) {
        return new UnionTableReference(this.getTableName(), this.subclassTableExpressions, sqlAliasBase.generateNewAlias(), false, this.getFactory());
    }

    @Override
    public Serializable[] getQuerySpaces() {
        return this.subclassSpaces;
    }

    @Override
    public String getRootTableName() {
        return this.tableName;
    }

    @Override
    public String getTableName() {
        return this.hasSubclasses() ? this.subquery : this.tableName;
    }

    @Override
    public Type getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLValue;
    }

    @Override
    public String getSubclassForDiscriminatorValue(Object value) {
        return this.subclassByDiscriminatorValue.get(value);
    }

    @Override
    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    @Override
    protected boolean shouldProcessSuperMapping() {
        return false;
    }

    @Override
    public boolean hasDuplicateTables() {
        return false;
    }

    @Override
    public String getTableName(int j) {
        return this.tableName;
    }

    @Override
    public String[] getKeyColumns(int j) {
        return this.getIdentifierColumnNames();
    }

    @Override
    public boolean isTableCascadeDeleteEnabled(int j) {
        return false;
    }

    @Override
    public boolean isPropertyOfTable(int property, int j) {
        return true;
    }

    @Override
    public String fromTableFragment(String name) {
        return this.getTableName() + " " + name;
    }

    @Override
    public String getSubclassPropertyTableName(int i) {
        return this.getTableName();
    }

    @Override
    protected int getSubclassPropertyTableNumber(int i) {
        return 0;
    }

    @Override
    public int getSubclassPropertyTableNumber(String propertyName) {
        return 0;
    }

    @Override
    protected boolean hasMultipleTables() {
        return this.isAbstract() || this.hasSubclasses();
    }

    @Override
    public void pruneForSubclasses(TableGroup tableGroup, Set<String> treatedEntityNames) {
        NamedTableReference tableReference = (NamedTableReference)tableGroup.resolveTableReference(this.getRootTableName());
        tableReference.setPrunedTableExpression(this.generateSubquery(treatedEntityNames));
    }

    @Override
    public void visitConstraintOrderedTables(EntityMappingType.ConstraintOrderedTableConsumer consumer) {
        int i = 0;
        while (i < this.constraintOrderedTableNames.length) {
            String tableName = this.constraintOrderedTableNames[i];
            int tablePosition = i++;
            consumer.consume(tableName, () -> columnConsumer -> columnConsumer.accept(tableName, this.constraintOrderedKeyColumnNames[tablePosition]));
        }
    }

    @Override
    protected boolean isPhysicalDiscriminator() {
        return false;
    }

    @Override
    protected EntityDiscriminatorMapping generateDiscriminatorMapping(PersistentClass bootEntityDescriptor, MappingModelCreationProcess modelCreationProcess) {
        return this.hasSubclasses() ? super.generateDiscriminatorMapping(bootEntityDescriptor, modelCreationProcess) : null;
    }

    @Override
    public int getTableSpan() {
        return 1;
    }

    @Override
    protected boolean[] getTableHasColumns() {
        return ArrayHelper.TRUE;
    }

    @Override
    protected int[] getPropertyTableNumbers() {
        return new int[this.getPropertySpan()];
    }

    protected String generateSubquery(PersistentClass model, Metadata mapping) {
        Dialect dialect = this.getFactory().getJdbcServices().getDialect();
        SqlStringGenerationContext sqlStringGenerationContext = this.getFactory().getSqlStringGenerationContext();
        if (!model.hasSubclasses()) {
            return model.getTable().getQualifiedName(sqlStringGenerationContext);
        }
        LinkedHashSet<Column> columns = new LinkedHashSet<Column>();
        for (Table table : model.getSubclassTableClosure()) {
            if (table.isAbstractUnionTable()) continue;
            columns.addAll(table.getColumns());
        }
        StringBuilder buf = new StringBuilder().append("( ");
        JoinedList classes = new JoinedList(List.of(model), Collections.unmodifiableList(model.getSubclasses()));
        for (PersistentClass clazz : classes) {
            Table table = clazz.getTable();
            if (table.isAbstractUnionTable()) continue;
            buf.append("select ");
            for (Column col : columns) {
                if (!table.containsColumn(col)) {
                    int sqlType = col.getSqlTypeCode(mapping);
                    buf.append(dialect.getSelectClauseNullString(sqlType, this.getFactory().getTypeConfiguration())).append(" as ");
                }
                buf.append(col.getQuotedName(dialect));
                buf.append(", ");
            }
            buf.append(clazz.getSubclassId()).append(" as clazz_");
            buf.append(" from ").append(table.getQualifiedName(sqlStringGenerationContext));
            buf.append(" union ");
            if (!dialect.supportsUnionAll()) continue;
            buf.append("all ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - (dialect.supportsUnionAll() ? 11 : 7));
        }
        return buf.append(" )").toString();
    }

    protected String generateSubquery(Set<String> treated) {
        if (!this.hasSubclasses()) {
            return this.getTableName();
        }
        Dialect dialect = this.getFactory().getJdbcServices().getDialect();
        MappingMetamodelImplementor metamodel = this.getFactory().getRuntimeMetamodels().getMappingMetamodel();
        LinkedHashMap selectables = new LinkedHashMap();
        SelectableConsumer selectableConsumer = (i, selectable) -> selectables.computeIfAbsent(selectable.getSelectionExpression(), k -> new HashMap()).put(selectable.getContainingTableExpression(), selectable);
        HashSet<String> treatedTableNames = new HashSet<String>(treated.size());
        for (String subclassName : treated) {
            UnionSubclassEntityPersister subPersister = (UnionSubclassEntityPersister)metamodel.getEntityDescriptor(subclassName);
            for (String subclassTableName : subPersister.getSubclassTableNames()) {
                if (ArrayHelper.indexOf(this.subclassSpaces, subclassTableName) == -1) continue;
                treatedTableNames.add(subclassTableName);
            }
            subPersister.getIdentifierMapping().forEachSelectable(selectableConsumer);
            if (subPersister.getVersionMapping() != null) {
                subPersister.getVersionMapping().forEachSelectable(selectableConsumer);
            }
            subPersister.visitSubTypeAttributeMappings(attributeMapping -> attributeMapping.forEachSelectable(selectableConsumer));
        }
        StringBuilder buf = new StringBuilder(this.subquery.length()).append("( ");
        for (String name : this.getSubclassEntityNames()) {
            AbstractEntityPersister persister = (AbstractEntityPersister)metamodel.findEntityDescriptor(name);
            String subclassTableName = persister.getTableName();
            if (!treatedTableNames.contains(subclassTableName)) continue;
            buf.append("select ");
            for (Map selectableMappings : selectables.values()) {
                SelectableMapping selectableMapping = (SelectableMapping)selectableMappings.get(subclassTableName);
                if (selectableMapping == null) {
                    selectableMapping = (SelectableMapping)selectableMappings.values().iterator().next();
                    int sqlType = selectableMapping.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
                    buf.append(dialect.getSelectClauseNullString(sqlType, this.getFactory().getTypeConfiguration())).append(" as ");
                }
                buf.append(new ColumnReference((String)null, selectableMapping, this.getFactory()).getExpressionText());
                buf.append(", ");
            }
            buf.append(persister.getDiscriminatorSQLValue()).append(" as clazz_");
            buf.append(" from ").append(subclassTableName);
            buf.append(" union ");
            if (!dialect.supportsUnionAll()) continue;
            buf.append("all ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - (dialect.supportsUnionAll() ? 11 : 7));
        }
        return buf.append(" )").toString();
    }

    @Override
    protected String[] getSubclassTableKeyColumns(int j) {
        if (j != 0) {
            throw new AssertionFailure("only one table");
        }
        return this.getIdentifierColumnNames();
    }

    @Override
    public String getSubclassTableName(int j) {
        if (j != 0) {
            throw new AssertionFailure("only one table");
        }
        return this.tableName;
    }

    @Override
    protected String[] getSubclassTableNames() {
        return this.subclassTableNames;
    }

    @Override
    public int getSubclassTableSpan() {
        return 1;
    }

    @Override
    protected boolean isClassOrSuperclassTable(int j) {
        if (j != 0) {
            throw new AssertionFailure("only one table");
        }
        return true;
    }

    @Override
    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    @Override
    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return new StaticFilterAliasGenerator(rootAlias);
    }
}

