/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.grammars.hql.HqlParserBaseVisitor;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.internal.util.QuotingHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.EntitySqmPathSource;
import org.hibernate.query.PathException;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.hql.internal.DomainPathPart;
import org.hibernate.query.hql.internal.QualifiedJoinPathConsumer;
import org.hibernate.query.hql.internal.QualifiedJoinPredicatePathConsumer;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.query.sqm.FrameMode;
import org.hibernate.query.sqm.LiteralNumberFormatException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.NullPrecedence;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.query.sqm.SortOrder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.UnknownEntityException;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.internal.ParameterCollector;
import org.hibernate.query.sqm.internal.SqmCreationProcessingStateImpl;
import org.hibernate.query.sqm.internal.SqmDmlCreationProcessingState;
import org.hibernate.query.sqm.internal.SqmQueryPartCreationProcessingStateStandardImpl;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.spi.ParameterDeclarationContext;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmElementAggregateFunction;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmFkExpression;
import org.hibernate.query.sqm.tree.domain.SqmIndexAggregateFunction;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCollation;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmOver;
import org.hibernate.query.sqm.tree.expression.SqmOverflow;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmSummarization;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmAliasedNode;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class SemanticQueryBuilder<R>
extends HqlParserBaseVisitor<Object>
implements SqmCreationState {
    private static final Logger log = Logger.getLogger(SemanticQueryBuilder.class);
    private static final Set<String> JPA_STANDARD_FUNCTIONS;
    private final Class<R> expectedResultType;
    private final SqmCreationOptions creationOptions;
    private final SqmCreationContext creationContext;
    private final Stack<DotIdentifierConsumer> dotIdentifierConsumerStack;
    private final Stack<ParameterDeclarationContext> parameterDeclarationContextStack = new StandardStack<ParameterDeclarationContext>();
    private final Stack<SqmCreationProcessingState> processingStateStack = new StandardStack<SqmCreationProcessingState>();
    private final BasicDomainType<Integer> integerDomainType;
    private final JavaType<List<?>> listJavaType;
    private final JavaType<Map<?, ?>> mapJavaType;
    private ParameterCollector parameterCollector;
    private ParameterStyle parameterStyle;
    private boolean isExtractingJdbcTemporalType;

    public static <R> SqmStatement<R> buildSemanticModel(HqlParser.StatementContext hqlParseTree, Class<R> expectedResultType, SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        return new SemanticQueryBuilder<R>(expectedResultType, creationOptions, creationContext).visitStatement(hqlParseTree);
    }

    public SemanticQueryBuilder(Class<R> expectedResultType, SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        this.expectedResultType = expectedResultType;
        this.creationOptions = creationOptions;
        this.creationContext = creationContext;
        this.dotIdentifierConsumerStack = new StandardStack<BasicDotIdentifierConsumer>(new BasicDotIdentifierConsumer(this));
        this.parameterStyle = creationOptions.useStrictJpaCompliance() ? ParameterStyle.UNKNOWN : ParameterStyle.MIXED;
        this.integerDomainType = creationContext.getNodeBuilder().getTypeConfiguration().standardBasicTypeForJavaType(Integer.class);
        this.listJavaType = creationContext.getNodeBuilder().getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor((Type)((Object)List.class));
        this.mapJavaType = creationContext.getNodeBuilder().getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor((Type)((Object)Map.class));
    }

    @Override
    public SqmCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqmCreationOptions getCreationOptions() {
        return this.creationOptions;
    }

    @Override
    public Stack<SqmCreationProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmStatement<R> visitStatement(HqlParser.StatementContext ctx) {
        this.parameterDeclarationContextStack.push(() -> false);
        try {
            ParseTree parseTree = ctx.getChild(0);
            if (parseTree instanceof HqlParser.SelectStatementContext) {
                Object selectStatement = this.visitSelectStatement((HqlParser.SelectStatementContext)parseTree);
                ((SqmQueryPart)((AbstractSqmSelectQuery)selectStatement).getQueryPart()).validateQueryStructureAndFetchOwners();
                Object object = selectStatement;
                return object;
            }
            if (parseTree instanceof HqlParser.InsertStatementContext) {
                Object object = this.visitInsertStatement((HqlParser.InsertStatementContext)parseTree);
                return object;
            }
            if (parseTree instanceof HqlParser.UpdateStatementContext) {
                Object object = this.visitUpdateStatement((HqlParser.UpdateStatementContext)parseTree);
                return object;
            }
            if (parseTree instanceof HqlParser.DeleteStatementContext) {
                Object object = this.visitDeleteStatement((HqlParser.DeleteStatementContext)parseTree);
                return object;
            }
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
        throw new ParsingException("Unexpected statement type [not INSERT, UPDATE, DELETE or SELECT] : " + ctx.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSelectStatement<R> visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        SqmSelectStatement selectStatement;
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        this.parameterCollector = selectStatement = new SqmSelectStatement(this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
        try {
            queryExpressionContext.accept(this);
        }
        finally {
            this.processingStateStack.pop();
        }
        return selectStatement;
    }

    @Override
    public SqmRoot<R> visitTargetEntity(HqlParser.TargetEntityContext dmlTargetContext) {
        HqlParser.EntityNameContext entityNameContext = (HqlParser.EntityNameContext)dmlTargetContext.getChild(0);
        String identificationVariable = dmlTargetContext.getChildCount() == 1 ? null : this.applyJpaCompliance(this.visitVariable((HqlParser.VariableContext)dmlTargetContext.getChild(1)));
        return new SqmRoot(this.visitEntityName(entityNameContext), identificationVariable, false, this.creationContext.getNodeBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmInsertStatement<R> visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        SqmInsertValuesStatement insertStatement;
        int dmlTargetIndex = ctx.getChild(1) instanceof HqlParser.TargetEntityContext ? 1 : 2;
        HqlParser.TargetEntityContext dmlTargetContext = (HqlParser.TargetEntityContext)ctx.getChild(dmlTargetIndex);
        HqlParser.TargetFieldsContext targetFieldsSpecContext = (HqlParser.TargetFieldsContext)ctx.getChild(dmlTargetIndex + 1);
        Object root = this.visitTargetEntity(dmlTargetContext);
        if (((SqmRoot)root).getReferencedPathSource() instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException(String.format("Target type '%s' in insert statement is not an entity", ((SqmRoot)root).getReferencedPathSource().getHibernateEntityName()));
        }
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        if (queryExpressionContext != null) {
            SqmInsertSelectStatement insertStatement2;
            this.parameterCollector = insertStatement2 = new SqmInsertSelectStatement(root, this.creationContext.getNodeBuilder());
            SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(insertStatement2, this);
            this.processingStateStack.push(processingState);
            try {
                queryExpressionContext.accept(this);
                SqmCreationProcessingStateImpl stateFieldsProcessingState = new SqmCreationProcessingStateImpl(insertStatement2, this);
                stateFieldsProcessingState.getPathRegistry().register((SqmPath<?>)root);
                this.processingStateStack.push(stateFieldsProcessingState);
                try {
                    for (HqlParser.SimplePathContext stateFieldCtx : targetFieldsSpecContext.simplePath()) {
                        SqmPath stateField = (SqmPath)this.visitSimplePath(stateFieldCtx);
                        insertStatement2.addInsertTargetStateField(stateField);
                    }
                }
                finally {
                    this.processingStateStack.pop();
                }
                SqmInsertSelectStatement sqmInsertSelectStatement = insertStatement2;
                return sqmInsertSelectStatement;
            }
            finally {
                this.processingStateStack.pop();
            }
        }
        this.parameterCollector = insertStatement = new SqmInsertValuesStatement(root, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(insertStatement, this);
        this.processingStateStack.push(processingState);
        processingState.getPathRegistry().register((SqmPath<?>)root);
        try {
            HqlParser.ValuesListContext valuesListContext = ctx.valuesList();
            for (int i = 1; i < valuesListContext.getChildCount(); i += 2) {
                ParseTree values = valuesListContext.getChild(i);
                SqmValues sqmValues = new SqmValues();
                for (int j = 1; j < values.getChildCount(); j += 2) {
                    sqmValues.getExpressions().add((SqmExpression)values.getChild(j).accept((ParseTreeVisitor)this));
                }
                insertStatement.getValuesList().add(sqmValues);
            }
            for (HqlParser.SimplePathContext stateFieldCtx : targetFieldsSpecContext.simplePath()) {
                SqmPath stateField = (SqmPath)this.visitSimplePath(stateFieldCtx);
                insertStatement.addInsertTargetStateField(stateField);
            }
            SqmInsertValuesStatement sqmInsertValuesStatement = insertStatement;
            return sqmInsertValuesStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmUpdateStatement<R> visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        SqmUpdateStatement updateStatement;
        boolean versioned = !(ctx.getChild(1) instanceof HqlParser.TargetEntityContext);
        int dmlTargetIndex = versioned ? 2 : 1;
        HqlParser.TargetEntityContext dmlTargetContext = (HqlParser.TargetEntityContext)ctx.getChild(dmlTargetIndex);
        Object root = this.visitTargetEntity(dmlTargetContext);
        if (((SqmRoot)root).getReferencedPathSource() instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException(String.format("Target type '%s' in update statement is not an entity", ((SqmRoot)root).getReferencedPathSource().getHibernateEntityName()));
        }
        this.parameterCollector = updateStatement = new SqmUpdateStatement(root, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(updateStatement, this);
        this.processingStateStack.push(processingState);
        processingState.getPathRegistry().register((SqmPath<?>)root);
        try {
            updateStatement.versioned(versioned);
            HqlParser.SetClauseContext setClauseCtx = (HqlParser.SetClauseContext)ctx.getChild(dmlTargetIndex + 1);
            for (ParseTree subCtx : setClauseCtx.children) {
                if (!(subCtx instanceof HqlParser.AssignmentContext)) continue;
                HqlParser.AssignmentContext assignmentContext = (HqlParser.AssignmentContext)subCtx;
                updateStatement.applyAssignment(this.consumeDomainPath((HqlParser.SimplePathContext)assignmentContext.getChild(0)), (SqmExpression)assignmentContext.getChild(2).accept((ParseTreeVisitor)this));
            }
            if (dmlTargetIndex + 2 <= ctx.getChildCount()) {
                updateStatement.applyPredicate(this.visitWhereClause((HqlParser.WhereClauseContext)ctx.getChild(dmlTargetIndex + 2)));
            }
            SqmUpdateStatement sqmUpdateStatement = updateStatement;
            return sqmUpdateStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmDeleteStatement<R> visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        SqmDeleteStatement deleteStatement;
        int dmlTargetIndex = ctx.getChild(1) instanceof HqlParser.TargetEntityContext ? 1 : 2;
        HqlParser.TargetEntityContext dmlTargetContext = (HqlParser.TargetEntityContext)ctx.getChild(dmlTargetIndex);
        Object root = this.visitTargetEntity(dmlTargetContext);
        this.parameterCollector = deleteStatement = new SqmDeleteStatement(root, SqmQuerySource.HQL, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState sqmDeleteCreationState = new SqmDmlCreationProcessingState(deleteStatement, this);
        sqmDeleteCreationState.getPathRegistry().register((SqmPath<?>)root);
        this.processingStateStack.push(sqmDeleteCreationState);
        try {
            if (dmlTargetIndex + 1 <= ctx.getChildCount()) {
                deleteStatement.applyPredicate(this.visitWhereClause((HqlParser.WhereClauseContext)ctx.getChild(dmlTargetIndex + 1)));
            }
            SqmDeleteStatement sqmDeleteStatement = deleteStatement;
            return sqmDeleteStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    @Override
    public SqmQueryPart<Object> visitSimpleQueryGroup(HqlParser.SimpleQueryGroupContext ctx) {
        return (SqmQueryPart)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmQueryPart<Object> visitQuerySpecExpression(HqlParser.QuerySpecExpressionContext ctx) {
        List children = ctx.children;
        Object queryPart = this.visitQuery((HqlParser.QueryContext)((Object)children.get(0)));
        if (children.size() > 1) {
            this.visitQueryOrder((SqmQueryPart<?>)queryPart, (HqlParser.QueryOrderContext)((Object)children.get(1)));
        }
        return queryPart;
    }

    @Override
    public SqmQueryPart<Object> visitNestedQueryExpression(HqlParser.NestedQueryExpressionContext ctx) {
        List children = ctx.children;
        SqmQueryPart queryPart = (SqmQueryPart)((ParseTree)children.get(1)).accept((ParseTreeVisitor)this);
        if (children.size() > 3) {
            SqmCreationProcessingState firstProcessingState = this.processingStateStack.pop();
            this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), firstProcessingState.getProcessingQuery(), this));
            this.visitQueryOrder(queryPart, (HqlParser.QueryOrderContext)((Object)children.get(3)));
        }
        return queryPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmQueryGroup<Object> visitSetQueryGroup(HqlParser.SetQueryGroupContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SET_OPERATIONS);
        }
        List children = ctx.children;
        SqmQueryPart firstQueryPart = (SqmQueryPart)((ParseTree)children.get(0)).accept((ParseTreeVisitor)this);
        SqmQueryGroup<Object> queryGroup = firstQueryPart instanceof SqmQueryGroup ? (SqmQueryGroup<Object>)firstQueryPart : new SqmQueryGroup<Object>(firstQueryPart);
        this.setCurrentQueryPart(queryGroup);
        int size = children.size();
        SqmCreationProcessingState firstProcessingState = this.processingStateStack.pop();
        for (int i = 1; i < size; i += 2) {
            List queryParts;
            SetOperator operator = this.visitSetOperator((HqlParser.SetOperatorContext)((Object)children.get(i)));
            HqlParser.OrderedQueryContext simpleQueryCtx = (HqlParser.OrderedQueryContext)((Object)children.get(i + 1));
            this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), firstProcessingState.getProcessingQuery(), this));
            if (queryGroup.getSetOperator() == null || queryGroup.getSetOperator() == operator) {
                queryGroup.setSetOperator(operator);
                queryParts = queryGroup.queryParts();
            } else {
                queryParts = new ArrayList<SqmQueryPart<Object>>(size - (i >> 1));
                queryParts.add(queryGroup);
                queryGroup = new SqmQueryGroup(this.creationContext.getNodeBuilder(), operator, queryParts);
                this.setCurrentQueryPart(queryGroup);
            }
            try {
                List subChildren = simpleQueryCtx.children;
                if (subChildren.get(0) instanceof HqlParser.QueryContext) {
                    SqmQuerySpec querySpec = new SqmQuerySpec(this.creationContext.getNodeBuilder());
                    queryParts.add(querySpec);
                    this.visitQuerySpecExpression((HqlParser.QuerySpecExpressionContext)simpleQueryCtx);
                    continue;
                }
                try {
                    SqmSelectStatement selectStatement = new SqmSelectStatement(this.creationContext.getNodeBuilder());
                    this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
                    Object queryPart = this.visitNestedQueryExpression((HqlParser.NestedQueryExpressionContext)simpleQueryCtx);
                    queryParts.add(queryPart);
                    continue;
                }
                finally {
                    this.processingStateStack.pop();
                }
            }
            finally {
                this.processingStateStack.pop();
            }
        }
        this.processingStateStack.push(firstProcessingState);
        return queryGroup;
    }

    @Override
    public SetOperator visitSetOperator(HqlParser.SetOperatorContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        boolean all = ctx.getChildCount() == 2;
        switch (token.getType()) {
            case 185: {
                return all ? SetOperator.UNION_ALL : SetOperator.UNION;
            }
            case 106: {
                return all ? SetOperator.INTERSECT_ALL : SetOperator.INTERSECT;
            }
            case 81: {
                return all ? SetOperator.EXCEPT_ALL : SetOperator.EXCEPT;
            }
        }
        throw new SemanticException("Illegal set operator token: " + token.getText());
    }

    protected void visitQueryOrder(SqmQueryPart<?> sqmQueryPart, HqlParser.QueryOrderContext ctx) {
        SqmOrderByClause orderByClause;
        if (ctx == null) {
            return;
        }
        HqlParser.OrderByClauseContext orderByClauseContext = (HqlParser.OrderByClauseContext)ctx.getChild(0);
        if (orderByClauseContext != null) {
            if (this.creationOptions.useStrictJpaCompliance() && this.processingStateStack.depth() > 1) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SUBQUERY_ORDER_BY);
            }
            orderByClause = this.visitOrderByClause(orderByClauseContext);
            sqmQueryPart.setOrderByClause(orderByClause);
        } else {
            orderByClause = null;
        }
        int currentIndex = 1;
        HqlParser.LimitClauseContext limitClauseContext = currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.LimitClauseContext ? (HqlParser.LimitClauseContext)ctx.getChild(currentIndex++) : null;
        HqlParser.OffsetClauseContext offsetClauseContext = currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.OffsetClauseContext ? (HqlParser.OffsetClauseContext)ctx.getChild(currentIndex++) : null;
        HqlParser.FetchClauseContext fetchClauseContext = currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.FetchClauseContext ? (HqlParser.FetchClauseContext)ctx.getChild(currentIndex++) : null;
        if (currentIndex != 1) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.LIMIT_OFFSET_CLAUSE);
            }
            if (this.processingStateStack.depth() > 1 && orderByClause == null) {
                throw new SemanticException("limit, offset and fetch clause require an order-by clause when used in sub-query");
            }
            sqmQueryPart.setOffsetExpression((SqmExpression<?>)this.visitOffsetClause(offsetClauseContext));
            if (limitClauseContext == null) {
                sqmQueryPart.setFetchExpression((SqmExpression<?>)this.visitFetchClause(fetchClauseContext), this.visitFetchClauseType(fetchClauseContext));
            } else if (fetchClauseContext == null) {
                sqmQueryPart.setFetchExpression((SqmExpression<?>)this.visitLimitClause(limitClauseContext));
            } else {
                throw new SemanticException("Can't use both limit and fetch clause");
            }
        }
    }

    @Override
    public SqmQuerySpec<Object> visitQuery(HqlParser.QueryContext ctx) {
        SqmSelectClause selectClause;
        SqmQuerySpec<Object> sqmQuerySpec = this.currentQuerySpec();
        int fromIndex = ctx.getChild(0) instanceof HqlParser.FromClauseContext ? 0 : 1;
        this.visitFromClause((HqlParser.FromClauseContext)ctx.getChild(fromIndex));
        if (fromIndex == 1) {
            selectClause = this.visitSelectClause((HqlParser.SelectClauseContext)ctx.getChild(0));
        } else if (ctx.getChild(ctx.getChildCount() - 1) instanceof HqlParser.SelectClauseContext) {
            selectClause = this.visitSelectClause((HqlParser.SelectClauseContext)ctx.getChild(ctx.getChildCount() - 1));
        } else {
            if (this.creationOptions.useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("Encountered implicit select-clause, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.IMPLICIT_SELECT);
            }
            log.debugf("Encountered implicit select clause : %s", (Object)ctx.getText());
            selectClause = this.buildInferredSelectClause(sqmQuerySpec.getFromClause());
        }
        sqmQuerySpec.setSelectClause(selectClause);
        int currentIndex = fromIndex + 1;
        SqmWhereClause whereClause = new SqmWhereClause(this.creationContext.getNodeBuilder());
        if (currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.WhereClauseContext) {
            whereClause.setPredicate((SqmPredicate)ctx.getChild(currentIndex++).accept((ParseTreeVisitor)this));
        }
        sqmQuerySpec.setWhereClause(whereClause);
        if (currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.GroupByClauseContext) {
            sqmQuerySpec.setGroupByClauseExpressions((List<SqmExpression<?>>)this.visitGroupByClause((HqlParser.GroupByClauseContext)ctx.getChild(currentIndex++)));
        }
        if (currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.HavingClauseContext) {
            sqmQuerySpec.setHavingClausePredicate(this.visitHavingClause((HqlParser.HavingClauseContext)ctx.getChild(currentIndex)));
        }
        return sqmQuerySpec;
    }

    protected SqmSelectClause buildInferredSelectClause(SqmFromClause fromClause) {
        boolean expectingArray = this.expectedResultType != null && this.expectedResultType.isArray();
        SqmSelectClause selectClause = expectingArray ? new SqmSelectClause(false, this.creationContext.getNodeBuilder()) : new SqmSelectClause(false, fromClause.getNumberOfRoots(), this.creationContext.getNodeBuilder());
        fromClause.visitRoots(sqmRoot -> {
            selectClause.addSelection(new SqmSelection(sqmRoot, sqmRoot.getAlias(), this.creationContext.getNodeBuilder()));
            if (expectingArray) {
                this.applyJoinsToInferredSelectClause((SqmFrom<?, ?>)sqmRoot, selectClause);
            }
        });
        return selectClause;
    }

    private void applyJoinsToInferredSelectClause(SqmFrom<?, ?> sqm, SqmSelectClause selectClause) {
        sqm.visitSqmJoins(sqmJoin -> {
            selectClause.addSelection(new SqmSelection(sqmJoin, sqmJoin.getAlias(), this.creationContext.getNodeBuilder()));
            this.applyJoinsToInferredSelectClause((SqmFrom<?, ?>)sqmJoin, selectClause);
        });
    }

    @Override
    public SqmSelectClause visitSelectClause(HqlParser.SelectClauseContext ctx) {
        int selectionListIndex = ctx.getChild(1) instanceof HqlParser.SelectionListContext ? 1 : 2;
        SqmSelectClause selectClause = new SqmSelectClause(selectionListIndex == 2, this.creationContext.getNodeBuilder());
        HqlParser.SelectionListContext selectionListContext = (HqlParser.SelectionListContext)ctx.getChild(selectionListIndex);
        for (ParseTree subCtx : selectionListContext.children) {
            if (!(subCtx instanceof HqlParser.SelectionContext)) continue;
            selectClause.addSelection((SqmSelection<?>)this.visitSelection((HqlParser.SelectionContext)subCtx));
        }
        return selectClause;
    }

    @Override
    public SqmSelection<?> visitSelection(HqlParser.SelectionContext ctx) {
        String resultIdentifier = ctx.getChildCount() == 1 ? null : this.applyJpaCompliance(this.visitVariable((HqlParser.VariableContext)ctx.getChild(1)));
        SqmSelectableNode<?> selectableNode = this.visitSelectableNode(ctx);
        SqmSelection selection = new SqmSelection(selectableNode, resultIdentifier, this.creationContext.getNodeBuilder());
        if (!(selectableNode instanceof SqmDynamicInstantiation)) {
            this.getCurrentProcessingState().getPathRegistry().register(selection);
        }
        return selection;
    }

    private SqmSelectableNode<?> visitSelectableNode(HqlParser.SelectionContext ctx) {
        ParseTree subCtx = ctx.getChild(0).getChild(0);
        if (subCtx instanceof HqlParser.ExpressionOrPredicateContext) {
            SqmPath sqmPath;
            SqmExpression sqmExpression = (SqmExpression)subCtx.accept((ParseTreeVisitor)this);
            if (sqmExpression instanceof SqmPath && (sqmPath = (SqmPath)sqmExpression).getReferencedPathSource() instanceof PluralPersistentAttribute) {
                if (this.creationOptions.useStrictJpaCompliance()) {
                    SqmTreeCreationLogger.LOGGER.debugf("Raw selection of plural attribute not supported by JPA: %s.  Use `value(%s)` or `key(%s)` to indicate what part of the collection to select", (Object)sqmPath.getAlias(), (Object)sqmPath.getAlias(), (Object)sqmPath.getAlias());
                }
                SemanticPathPart elementPath = sqmPath.resolvePathPart(CollectionPart.Nature.ELEMENT.getName(), true, this);
                this.processingStateStack.getCurrent().getPathRegistry().register((SqmPath<?>)elementPath);
                return elementPath;
            }
            return sqmExpression;
        }
        return (SqmSelectableNode)subCtx.accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmDynamicInstantiation<?> visitInstantiation(HqlParser.InstantiationContext ctx) {
        SqmDynamicInstantiation<Object> dynamicInstantiation;
        ParseTree instantiationTarget = ctx.instantiationTarget().getChild(0);
        if (instantiationTarget instanceof HqlParser.SimplePathContext) {
            String className = instantiationTarget.getText();
            try {
                JavaType<?> jtd = this.resolveInstantiationTargetJtd(className);
                dynamicInstantiation = SqmDynamicInstantiation.forClassInstantiation(jtd, this.creationContext.getNodeBuilder());
            }
            catch (ClassLoadingException e) {
                throw new SemanticException("Could not resolve class '" + className + "' named for instantiation");
            }
        } else {
            TerminalNode terminalNode = (TerminalNode)instantiationTarget;
            switch (terminalNode.getSymbol().getType()) {
                case 122: {
                    dynamicInstantiation = SqmDynamicInstantiation.forMapInstantiation(this.mapJavaType, this.creationContext.getNodeBuilder());
                    break;
                }
                case 116: {
                    dynamicInstantiation = SqmDynamicInstantiation.forListInstantiation(this.listJavaType, this.creationContext.getNodeBuilder());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported instantiation target: " + terminalNode);
                }
            }
        }
        for (HqlParser.InstantiationArgumentContext arg : ctx.instantiationArguments().instantiationArgument()) {
            dynamicInstantiation.addArgument((SqmDynamicInstantiationArgument<?>)this.visitInstantiationArgument(arg));
        }
        return dynamicInstantiation;
    }

    private JavaType<?> resolveInstantiationTargetJtd(String className) {
        Class<?> targetJavaType = this.classForName(this.creationContext.getJpaMetamodel().qualifyImportableName(className));
        return this.creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(targetJavaType);
    }

    private Class<?> classForName(String className) {
        return this.creationContext.getServiceRegistry().getService(ClassLoaderService.class).classForName(className);
    }

    @Override
    public SqmDynamicInstantiationArgument<?> visitInstantiationArgument(HqlParser.InstantiationArgumentContext ctx) {
        String alias = ctx.getChildCount() > 1 ? this.visitVariable((HqlParser.VariableContext)ctx.getChild(ctx.getChildCount() - 1)) : null;
        SqmSelectableNode argExpression = (SqmSelectableNode)ctx.getChild(0).accept((ParseTreeVisitor)this);
        SqmDynamicInstantiationArgument argument = new SqmDynamicInstantiationArgument(argExpression, alias, this.creationContext.getNodeBuilder());
        if (!(argExpression instanceof SqmDynamicInstantiation)) {
            this.getCurrentProcessingState().getPathRegistry().register(argument);
        }
        return argument;
    }

    @Override
    public SqmPath<?> visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        String alias = ctx.getChild(2).getText();
        Object sqmFromByAlias = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias, true);
        if (sqmFromByAlias == null) {
            throw new SemanticException("Unable to resolve alias [" + alias + "] in selection [" + ctx.getText() + "]");
        }
        return sqmFromByAlias;
    }

    @Override
    public List<SqmExpression<?>> visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        int size = ctx.getChildCount();
        int estimateExpressionsCount = (size >> 1) - 1;
        ArrayList expressions = new ArrayList(estimateExpressionsCount);
        for (int i = 0; i < size; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (!(parseTree instanceof HqlParser.GroupByExpressionContext)) continue;
            expressions.add((SqmExpression)parseTree.accept((ParseTreeVisitor)this));
        }
        return expressions;
    }

    private SqmExpression<?> resolveOrderByOrGroupByExpression(ParseTree child, boolean definedCollate) {
        SqmCreationProcessingState processingState = this.getCurrentProcessingState();
        SqmQuery<?> processingQuery = processingState.getProcessingQuery();
        JpaQueryPart queryPart = processingQuery instanceof SqmInsertSelectStatement ? ((SqmInsertSelectStatement)processingQuery).getSelectQueryPart() : (processingQuery instanceof SqmSelectQuery ? ((SqmSelectQuery)processingQuery).getQueryPart() : null);
        if (child instanceof TerminalNode) {
            List<SqmSelection<?>> selections;
            if (definedCollate) {
                throw new ParsingException("COLLATE is not allowed for position based order-by or group-by items");
            }
            int position = Integer.parseInt(child.getText());
            SqmAliasedNode<Object> nodeByPosition = queryPart instanceof SqmQueryGroup ? (position <= (selections = ((SqmQueryPart)queryPart).getFirstQuerySpec().getSelectClause().getSelections()).size() ? (SqmAliasedNode)selections.get(position - 1) : null) : processingState.getPathRegistry().findAliasedNodeByPosition(position);
            if (nodeByPosition == null) {
                throw new ParsingException("Numeric literal '" + position + "' used in group-by does not match a registered select-item");
            }
            return new SqmAliasedNodeRef(position, this.integerDomainType, this.creationContext.getNodeBuilder());
        }
        if (child instanceof HqlParser.IdentifierContext) {
            String identifierText = this.visitIdentifier((HqlParser.IdentifierContext)child);
            if (queryPart instanceof SqmQueryGroup) {
                SqmPath found = null;
                int sqmPosition = 0;
                List<SqmSelection<?>> selections = ((SqmQueryPart)queryPart).getFirstQuerySpec().getSelectClause().getSelections();
                for (int i = 0; i < selections.size(); ++i) {
                    SqmPath path;
                    SqmSelection<?> sqmSelection = selections.get(i);
                    if (identifierText.equals(sqmSelection.getAlias())) {
                        return new SqmAliasedNodeRef(i + 1, this.creationContext.getNodeBuilder().getIntegerType(), this.creationContext.getNodeBuilder());
                    }
                    SqmSelectableNode<?> selectableNode = sqmSelection.getSelectableNode();
                    if (selectableNode instanceof SqmFrom) {
                        SqmFrom fromElement = (SqmFrom)selectableNode;
                        SqmPathSource pathSource = fromElement.getReferencedPathSource();
                        if (pathSource.findSubPathSource(identifierText) == null) continue;
                        if (sqmPosition != 0) {
                            throw new IllegalStateException("Multiple from-elements expose unqualified attribute : " + identifierText);
                        }
                        found = fromElement;
                        sqmPosition = i + 1;
                        continue;
                    }
                    if (!(selectableNode instanceof SqmPath) || !identifierText.equals((path = (SqmPath)selectableNode).getReferencedPathSource().getPathName())) continue;
                    if (sqmPosition != 0) {
                        throw new IllegalStateException("Multiple from-elements expose unqualified attribute : " + identifierText);
                    }
                    sqmPosition = i + 1;
                }
                if (found != null) {
                    return new SqmAliasedNodeRef(sqmPosition, found.get(identifierText).getNavigablePath(), this.creationContext.getNodeBuilder().getIntegerType(), this.creationContext.getNodeBuilder());
                }
                if (sqmPosition != 0) {
                    return new SqmAliasedNodeRef(sqmPosition, this.creationContext.getNodeBuilder().getIntegerType(), this.creationContext.getNodeBuilder());
                }
            } else {
                Integer correspondingPosition = processingState.getPathRegistry().findAliasedNodePosition(identifierText);
                if (correspondingPosition != null) {
                    if (definedCollate) {
                        throw new ParsingException("COLLATE is not allowed for alias based order-by or group-by items");
                    }
                    return new SqmAliasedNodeRef(correspondingPosition, this.integerDomainType, this.creationContext.getNodeBuilder());
                }
                Object sqmFrom = processingState.getPathRegistry().findFromByAlias(identifierText, true);
                if (sqmFrom != null) {
                    if (definedCollate) {
                        throw new ParsingException("COLLATE is not allowed for alias based order-by or group-by items");
                    }
                    return sqmFrom;
                }
                DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
                dotIdentifierConsumer.consumeIdentifier(identifierText, true, true);
                return (SqmExpression)((Object)dotIdentifierConsumer.getConsumedPart());
            }
        }
        return (SqmExpression)child.accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitGroupByExpression(HqlParser.GroupByExpressionContext ctx) {
        return this.resolveOrderByOrGroupByExpression(ctx.getChild(0), ctx.getChildCount() > 1);
    }

    @Override
    public SqmPredicate visitHavingClause(HqlParser.HavingClauseContext ctx) {
        return (SqmPredicate)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmOrderByClause visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        int size = ctx.getChildCount();
        int estimateExpressionsCount = (size >> 1) - 1;
        SqmOrderByClause orderByClause = new SqmOrderByClause(estimateExpressionsCount);
        for (int i = 0; i < size; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (!(parseTree instanceof HqlParser.SortSpecificationContext)) continue;
            orderByClause.addSortSpecification(this.visitSortSpecification((HqlParser.SortSpecificationContext)parseTree));
        }
        return orderByClause;
    }

    @Override
    public SqmSortSpecification visitSortSpecification(HqlParser.SortSpecificationContext ctx) {
        NullPrecedence nullPrecedence;
        SortOrder sortOrder;
        Object sortExpression;
        block14: {
            block12: {
                block13: {
                    int nextIndex;
                    sortExpression = this.visitSortExpression((HqlParser.SortExpressionContext)ctx.getChild(0));
                    if (sortExpression == null) {
                        throw new ParsingException("Could not resolve sort-expression : " + ctx.getChild(0).getText());
                    }
                    if (sortExpression instanceof SqmLiteral || sortExpression instanceof SqmParameter) {
                        HqlLogging.QUERY_LOGGER.debugf("Questionable sorting by constant value : %s", sortExpression);
                    }
                    if ((nextIndex = 1) >= ctx.getChildCount()) break block12;
                    ParseTree parseTree = ctx.getChild(nextIndex);
                    if (parseTree instanceof HqlParser.SortDirectionContext) {
                        switch (((TerminalNode)parseTree.getChild(0)).getSymbol().getType()) {
                            case 50: {
                                sortOrder = SortOrder.ASCENDING;
                                break;
                            }
                            case 70: {
                                sortOrder = SortOrder.DESCENDING;
                                break;
                            }
                            default: {
                                throw new SemanticException("Unrecognized sort ordering: " + parseTree.getText());
                            }
                        }
                        ++nextIndex;
                    } else {
                        sortOrder = null;
                    }
                    parseTree = ctx.getChild(nextIndex);
                    if (!(parseTree instanceof HqlParser.NullsPrecedenceContext)) break block13;
                    switch (((TerminalNode)parseTree.getChild(1)).getSymbol().getType()) {
                        case 87: {
                            nullPrecedence = NullPrecedence.FIRST;
                            break block14;
                        }
                        case 111: {
                            nullPrecedence = NullPrecedence.LAST;
                            break block14;
                        }
                        default: {
                            throw new SemanticException("Unrecognized null precedence: " + parseTree.getText());
                        }
                    }
                }
                nullPrecedence = null;
                break block14;
            }
            sortOrder = null;
            nullPrecedence = null;
        }
        return new SqmSortSpecification((SqmExpression)sortExpression, sortOrder, nullPrecedence);
    }

    @Override
    public SqmExpression<?> visitSortExpression(HqlParser.SortExpressionContext ctx) {
        return this.resolveOrderByOrGroupByExpression(ctx.getChild(0), ctx.getChildCount() > 1);
    }

    private SqmQuerySpec<?> currentQuerySpec() {
        SqmQuery<?> processingQuery = this.processingStateStack.getCurrent().getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            return ((SqmInsertSelectStatement)processingQuery).getSelectQueryPart().getLastQuerySpec();
        }
        return ((SqmQueryPart)((SqmSelectQuery)processingQuery).getQueryPart()).getLastQuerySpec();
    }

    private <X> void setCurrentQueryPart(SqmQueryPart<X> queryPart) {
        SqmQuery<?> processingQuery = this.processingStateStack.getCurrent().getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            ((SqmInsertSelectStatement)processingQuery).setSelectQueryPart(queryPart);
        } else {
            ((AbstractSqmSelectQuery)processingQuery).setQueryPart(queryPart);
        }
    }

    @Override
    public SqmExpression<?> visitLimitClause(HqlParser.LimitClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitOffsetClause(HqlParser.OffsetClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitFetchClause(HqlParser.FetchClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
    }

    private FetchClauseType visitFetchClauseType(HqlParser.FetchClauseContext ctx) {
        if (ctx == null) {
            return FetchClauseType.ROWS_ONLY;
        }
        int thirdSymbolType = ((TerminalNode)ctx.getChild(3)).getSymbol().getType();
        int lastSymbolType = ((TerminalNode)ctx.getChild(ctx.getChildCount() - 1)).getSymbol().getType();
        if (lastSymbolType == 174) {
            return thirdSymbolType == 155 ? FetchClauseType.PERCENT_WITH_TIES : FetchClauseType.ROWS_WITH_TIES;
        }
        return thirdSymbolType == 155 ? FetchClauseType.PERCENT_ONLY : FetchClauseType.ROWS_ONLY;
    }

    @Override
    public Object visitSyntacticPathExpression(HqlParser.SyntacticPathExpressionContext ctx) {
        SemanticPathPart part = this.visitSyntacticDomainPath((HqlParser.SyntacticDomainPathContext)ctx.getChild(0));
        if (ctx.getChildCount() == 2) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(part, this){

                @Override
                protected void reset() {
                }
            });
            try {
                part = (SemanticPathPart)ctx.getChild(1).accept((ParseTreeVisitor)this);
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        if (part instanceof DomainPathPart) {
            return ((DomainPathPart)part).getSqmExpression();
        }
        return part;
    }

    @Override
    public Object visitGeneralPathExpression(HqlParser.GeneralPathExpressionContext ctx) {
        SemanticPathPart part = this.visitGeneralPathFragment((HqlParser.GeneralPathFragmentContext)ctx.getChild(0));
        if (part instanceof DomainPathPart) {
            return ((DomainPathPart)part).getSqmExpression();
        }
        return part;
    }

    @Override
    public SqmExpression<?> visitFunctionExpression(HqlParser.FunctionExpressionContext ctx) {
        return (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitParameterOrIntegerLiteral(HqlParser.ParameterOrIntegerLiteralContext ctx) {
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof TerminalNode) {
            return this.integerLiteral(firstChild.getText());
        }
        return (SqmExpression)firstChild.accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.INTEGER_LITERAL().getText());
        }
        if (ctx.FLOAT_LITERAL() != null) {
            return this.floatLiteral(ctx.FLOAT_LITERAL().getText());
        }
        if (ctx.DOUBLE_LITERAL() != null) {
            return this.doubleLiteral(ctx.DOUBLE_LITERAL().getText());
        }
        if (ctx.parameter() != null) {
            return (SqmExpression)ctx.parameter().accept(this);
        }
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof TerminalNode) {
            switch (((TerminalNode)firstChild).getSymbol().getType()) {
                case 3: {
                    return this.integerLiteral(firstChild.getText());
                }
                case 5: {
                    return this.floatLiteral(firstChild.getText());
                }
                case 6: {
                    return this.doubleLiteral(firstChild.getText());
                }
            }
            throw new UnsupportedOperationException("Unsupported literal: " + firstChild.getText());
        }
        return (SqmExpression)firstChild.accept((ParseTreeVisitor)this);
    }

    public String getEntityName(HqlParser.EntityNameContext parserEntityName) {
        StringBuilder sb = new StringBuilder();
        int end = parserEntityName.getChildCount();
        sb.append(this.visitIdentifier((HqlParser.IdentifierContext)parserEntityName.getChild(0)));
        for (int i = 2; i < end; i += 2) {
            sb.append('.');
            sb.append(this.visitIdentifier((HqlParser.IdentifierContext)parserEntityName.getChild(i)));
        }
        return sb.toString();
    }

    @Override
    public String visitIdentifier(HqlParser.IdentifierContext ctx) {
        ParseTree child = ctx.getChild(0);
        if (child instanceof TerminalNode) {
            return child.getText();
        }
        return this.visitNakedIdentifier((HqlParser.NakedIdentifierContext)child);
    }

    @Override
    public String visitNakedIdentifier(HqlParser.NakedIdentifierContext ctx) {
        TerminalNode node = (TerminalNode)ctx.getChild(0);
        if (node.getSymbol().getType() == 200) {
            return QuotingHelper.unquoteIdentifier(node.getText());
        }
        return node.getText();
    }

    @Override
    public EntityDomainType<?> visitEntityName(HqlParser.EntityNameContext parserEntityName) {
        String entityName = this.getEntityName(parserEntityName);
        EntityDomainType entityReference = this.getCreationContext().getJpaMetamodel().getHqlEntityReference(entityName);
        if (entityReference == null) {
            throw new UnknownEntityException("Could not resolve target entity '" + entityName + "'", entityName);
        }
        this.checkFQNEntityNameJpaComplianceViolationIfNeeded(entityName, entityReference);
        if (entityReference instanceof SqmPolymorphicRootDescriptor && this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered the use of a non entity name [" + entityName + "], but strict JPQL compliance was requested which doesn't allow this", StrictJpaComplianceViolation.Type.NON_ENTITY_NAME);
        }
        return entityReference;
    }

    @Override
    public SqmFromClause visitFromClause(HqlParser.FromClauseContext parserFromClause) {
        SqmFromClause fromClause;
        if (parserFromClause == null) {
            fromClause = new SqmFromClause();
            this.currentQuerySpec().setFromClause(fromClause);
        } else {
            int size = parserFromClause.getChildCount();
            int estimatedSize = size >> 1;
            fromClause = new SqmFromClause(estimatedSize);
            this.currentQuerySpec().setFromClause(fromClause);
            for (int i = 0; i < size; ++i) {
                ParseTree parseTree = parserFromClause.getChild(i);
                if (!(parseTree instanceof HqlParser.EntityWithJoinsContext)) continue;
                this.visitEntityWithJoins((HqlParser.EntityWithJoinsContext)parseTree);
            }
        }
        return fromClause;
    }

    @Override
    public SqmRoot<?> visitEntityWithJoins(HqlParser.EntityWithJoinsContext parserSpace) {
        Object sqmRoot = this.visitRootEntity((HqlParser.RootEntityContext)parserSpace.getChild(0));
        SqmFromClause fromClause = this.currentQuerySpec().getFromClause();
        if (!(sqmRoot instanceof SqmCorrelation)) {
            fromClause.addRoot((SqmRoot<?>)sqmRoot);
        }
        int size = parserSpace.getChildCount();
        for (int i = 1; i < size; ++i) {
            ParseTree parseTree = parserSpace.getChild(i);
            if (parseTree instanceof HqlParser.CrossJoinContext) {
                this.consumeCrossJoin((HqlParser.CrossJoinContext)parseTree, (SqmRoot)sqmRoot);
                continue;
            }
            if (parseTree instanceof HqlParser.JoinContext) {
                this.consumeJoin((HqlParser.JoinContext)parseTree, (SqmRoot)sqmRoot);
                continue;
            }
            if (!(parseTree instanceof HqlParser.JpaCollectionJoinContext)) continue;
            this.consumeJpaCollectionJoin((HqlParser.JpaCollectionJoinContext)parseTree, (SqmRoot<?>)sqmRoot);
        }
        return sqmRoot;
    }

    @Override
    public SqmRoot<?> visitRootEntity(HqlParser.RootEntityContext ctx) {
        HqlParser.EntityNameContext entityNameContext = (HqlParser.EntityNameContext)ctx.getChild(0);
        List entityNameParseTreeChildren = entityNameContext.children;
        String name = this.getEntityName(entityNameContext);
        log.debugf("Handling root path - %s", (Object)name);
        EntityDomainType entityDescriptor = this.getCreationContext().getJpaMetamodel().getHqlEntityReference(name);
        HqlParser.VariableContext identificationVariableDefContext = ctx.getChildCount() > 1 ? (HqlParser.VariableContext)ctx.getChild(1) : null;
        String alias = this.applyJpaCompliance(this.visitVariable(identificationVariableDefContext));
        SqmCreationProcessingState processingState = this.processingStateStack.getCurrent();
        SqmPathRegistry pathRegistry = processingState.getPathRegistry();
        if (entityDescriptor == null) {
            int size = entityNameParseTreeChildren.size();
            if (this.processingStateStack.depth() > 1 && size > 2) {
                String parentAlias = ((ParseTree)entityNameParseTreeChildren.get(0)).getText();
                AbstractSqmFrom correlation = (AbstractSqmFrom)processingState.getPathRegistry().findFromByAlias(parentAlias, true);
                if (correlation instanceof SqmCorrelation) {
                    QualifiedJoinPathConsumer dotIdentifierConsumer = new QualifiedJoinPathConsumer(correlation, SqmJoinType.INNER, false, alias, (SqmCreationState)this);
                    int lastIdx = size - 1;
                    for (int i = 2; i != lastIdx; i += 2) {
                        dotIdentifierConsumer.consumeIdentifier(((ParseTree)entityNameParseTreeChildren.get(i)).getText(), false, false);
                    }
                    dotIdentifierConsumer.consumeIdentifier(((ParseTree)entityNameParseTreeChildren.get(lastIdx)).getText(), false, true);
                    return ((SqmCorrelation)((Object)correlation)).getCorrelatedRoot();
                }
                throw new SemanticException("Could not resolve entity or correlation path '" + name + "'");
            }
            throw new UnknownEntityException("Could not resolve root entity '" + name + "'", name);
        }
        this.checkFQNEntityNameJpaComplianceViolationIfNeeded(name, entityDescriptor);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("Encountered unmapped polymorphic reference [" + entityDescriptor.getHibernateEntityName() + "], but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.UNMAPPED_POLYMORPHISM);
            }
            if (this.processingStateStack.depth() > 1) {
                throw new SemanticException("Illegal implicit-polymorphic domain path in subquery '" + entityDescriptor.getName() + "'");
            }
        }
        SqmRoot sqmRoot = new SqmRoot(entityDescriptor, alias, true, this.creationContext.getNodeBuilder());
        pathRegistry.register(sqmRoot);
        return sqmRoot;
    }

    @Override
    public String visitVariable(HqlParser.VariableContext ctx) {
        Token identificationVariableToken;
        if (ctx == null) {
            return null;
        }
        ParseTree lastChild = ctx.getChild(ctx.getChildCount() - 1);
        if (lastChild instanceof HqlParser.IdentifierContext) {
            Token identificationVariableToken2;
            HqlParser.IdentifierContext identifierContext = (HqlParser.IdentifierContext)lastChild;
            if (this.getCreationOptions().useStrictJpaCompliance() && (identificationVariableToken2 = identifierContext.getStart()).getType() != 199) {
                throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), identificationVariableToken2.getText()), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
            }
            return this.visitIdentifier(identifierContext);
        }
        HqlParser.NakedIdentifierContext identifierContext = (HqlParser.NakedIdentifierContext)lastChild;
        if (this.getCreationOptions().useStrictJpaCompliance() && (identificationVariableToken = identifierContext.getStart()).getType() != 199) {
            throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), identificationVariableToken.getText()), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
        }
        return this.visitNakedIdentifier(identifierContext);
    }

    private String applyJpaCompliance(String text) {
        if (text == null) {
            return null;
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            return text.toLowerCase(Locale.getDefault());
        }
        return text;
    }

    @Override
    public final SqmCrossJoin<?> visitCrossJoin(HqlParser.CrossJoinContext ctx) {
        throw new UnsupportedOperationException("Unexpected call to #visitCrossJoin, see #consumeCrossJoin");
    }

    private <T> void consumeCrossJoin(HqlParser.CrossJoinContext parserJoin, SqmRoot<T> sqmRoot) {
        HqlParser.EntityNameContext entityNameContext = (HqlParser.EntityNameContext)parserJoin.getChild(2);
        String name = this.getEntityName(entityNameContext);
        SqmTreeCreationLogger.LOGGER.debugf("Handling root path - %s", (Object)name);
        EntityDomainType entityDescriptor = this.getCreationContext().getJpaMetamodel().resolveHqlEntityReference(name);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException("Unmapped polymorphic reference cannot be used as a CROSS JOIN target");
        }
        HqlParser.VariableContext identificationVariableDefContext = parserJoin.getChildCount() > 3 ? (HqlParser.VariableContext)parserJoin.getChild(3) : null;
        SqmCrossJoin join = new SqmCrossJoin(entityDescriptor, this.visitVariable(identificationVariableDefContext), sqmRoot);
        this.processingStateStack.getCurrent().getPathRegistry().register(join);
        sqmRoot.addSqmJoin((SqmJoin<T, ?>)join);
    }

    @Override
    public final SqmJoin<?, ?> visitJoin(HqlParser.JoinContext parserJoin) {
        throw new UnsupportedOperationException("Unexpected call to #visitJoin, see #consumeJoin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <X> void consumeJoin(HqlParser.JoinContext parserJoin, SqmRoot<X> sqmRoot) {
        block17: {
            SqmJoinType joinType;
            int firstJoinTypeSymbolType = parserJoin.getChild(0) instanceof HqlParser.JoinTypeContext && parserJoin.getChild(0).getChildCount() != 0 ? ((TerminalNode)parserJoin.getChild(0).getChild(0)).getSymbol().getType() : 103;
            switch (firstJoinTypeSymbolType) {
                case 92: {
                    joinType = SqmJoinType.FULL;
                    break;
                }
                case 162: {
                    joinType = SqmJoinType.RIGHT;
                    break;
                }
                case 113: 
                case 149: {
                    joinType = SqmJoinType.LEFT;
                    break;
                }
                default: {
                    joinType = SqmJoinType.INNER;
                }
            }
            HqlParser.JoinPathContext qualifiedJoinPathContext = parserJoin.joinPath();
            HqlParser.VariableContext identificationVariableDefContext = qualifiedJoinPathContext.getChildCount() > 1 ? (HqlParser.VariableContext)qualifiedJoinPathContext.getChild(1) : null;
            String alias = this.visitVariable(identificationVariableDefContext);
            boolean fetch = parserJoin.getChild(2) instanceof TerminalNode;
            if (fetch && this.processingStateStack.depth() > 1) {
                throw new SemanticException("fetch not allowed in subquery from-elements");
            }
            this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, joinType, fetch, alias, (SqmCreationState)this));
            try {
                SqmQualifiedJoin join = (SqmQualifiedJoin)qualifiedJoinPathContext.getChild(0).accept((ParseTreeVisitor)this);
                HqlParser.JoinRestrictionContext qualifiedJoinRestrictionContext = parserJoin.joinRestriction();
                if (join instanceof SqmEntityJoin) {
                    sqmRoot.addSqmJoin(join);
                } else if (join instanceof SqmAttributeJoin) {
                    SqmAttributeJoin attributeJoin = (SqmAttributeJoin)join;
                    if (this.getCreationOptions().useStrictJpaCompliance() && join.getExplicitAlias() != null && attributeJoin.isFetched()) {
                        throw new StrictJpaComplianceViolation("Encountered aliased fetch join, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.ALIASED_FETCH_JOIN);
                    }
                    if (qualifiedJoinRestrictionContext != null && attributeJoin.isFetched()) {
                        throw new SemanticException("with-clause not allowed on fetched associations; use filters");
                    }
                }
                if (qualifiedJoinRestrictionContext == null) break block17;
                this.dotIdentifierConsumerStack.push(new QualifiedJoinPredicatePathConsumer(join, (SqmCreationState)this));
                try {
                    join.setJoinPredicate((SqmPredicate)qualifiedJoinRestrictionContext.getChild(1).accept((ParseTreeVisitor)this));
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
    }

    @Override
    public SqmJoin<?, ?> visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx, SqmRoot<?> sqmRoot) {
        HqlParser.VariableContext identificationVariableDefContext = ctx.getChildCount() > 5 ? (HqlParser.VariableContext)ctx.getChild(5) : null;
        String alias = this.visitVariable(identificationVariableDefContext);
        this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, SqmJoinType.INNER, false, alias, (SqmCreationState)this));
        try {
            this.consumePluralAttributeReference((HqlParser.PathContext)ctx.getChild(3));
        }
        finally {
            this.dotIdentifierConsumerStack.pop();
        }
    }

    @Override
    public SqmPredicate visitWhereClause(HqlParser.WhereClauseContext ctx) {
        if (ctx == null || ctx.getChildCount() != 2) {
            return null;
        }
        return (SqmPredicate)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmGroupedPredicate visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        return new SqmGroupedPredicate((SqmPredicate)ctx.getChild(1).accept((ParseTreeVisitor)this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        return this.junction(Predicate.BooleanOperator.AND, (SqmPredicate)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmPredicate)ctx.getChild(2).accept((ParseTreeVisitor)this));
    }

    @Override
    public SqmPredicate visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        return this.junction(Predicate.BooleanOperator.OR, (SqmPredicate)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmPredicate)ctx.getChild(2).accept((ParseTreeVisitor)this));
    }

    private SqmPredicate junction(Predicate.BooleanOperator operator, SqmPredicate lhs, SqmPredicate rhs) {
        SqmJunctionPredicate junction;
        if (lhs instanceof SqmJunctionPredicate && (junction = (SqmJunctionPredicate)lhs).getOperator() == operator) {
            junction.getPredicates().add(rhs);
            return junction;
        }
        if (rhs instanceof SqmJunctionPredicate && (junction = (SqmJunctionPredicate)rhs).getOperator() == operator) {
            junction.getPredicates().add(0, lhs);
            return junction;
        }
        return new SqmJunctionPredicate(operator, lhs, rhs, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitNegatedPredicate(HqlParser.NegatedPredicateContext ctx) {
        SqmPredicate predicate = (SqmPredicate)ctx.getChild(1).accept((ParseTreeVisitor)this);
        if (predicate instanceof SqmNegatablePredicate) {
            ((SqmNegatablePredicate)predicate).negate();
            return predicate;
        }
        return new SqmNegatedPredicate(predicate, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmBetweenPredicate visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx) {
        boolean negated = ((TerminalNode)ctx.getChild(1)).getSymbol().getType() == 138;
        int startIndex = negated ? 3 : 2;
        return new SqmBetweenPredicate((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(startIndex).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(startIndex + 2).accept((ParseTreeVisitor)this), negated, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmNullnessPredicate visitIsNullPredicate(HqlParser.IsNullPredicateContext ctx) {
        boolean negated = ctx.getChildCount() == 4;
        return new SqmNullnessPredicate((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), negated, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmEmptinessPredicate visitIsEmptyPredicate(HqlParser.IsEmptyPredicateContext ctx) {
        boolean negated = ctx.getChildCount() == 4;
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)ctx.getChild(0).accept((ParseTreeVisitor)this), negated, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitComparisonOperator(HqlParser.ComparisonOperatorContext ctx) {
        TerminalNode firstToken = (TerminalNode)ctx.getChild(0);
        switch (firstToken.getSymbol().getType()) {
            case 15: {
                return ComparisonOperator.EQUAL;
            }
            case 16: {
                return ComparisonOperator.NOT_EQUAL;
            }
            case 19: {
                return ComparisonOperator.LESS_THAN;
            }
            case 20: {
                return ComparisonOperator.LESS_THAN_OR_EQUAL;
            }
            case 17: {
                return ComparisonOperator.GREATER_THAN;
            }
            case 18: {
                return ComparisonOperator.GREATER_THAN_OR_EQUAL;
            }
            case 108: {
                TerminalNode secondToken = (TerminalNode)ctx.getChild(1);
                return secondToken.getSymbol().getType() == 138 ? ComparisonOperator.NOT_DISTINCT_FROM : ComparisonOperator.DISTINCT_FROM;
            }
        }
        throw new QueryException("missing operator");
    }

    @Override
    public SqmPredicate visitComparisonPredicate(HqlParser.ComparisonPredicateContext ctx) {
        SqmExpression<?> left;
        SqmExpression<?> right;
        ComparisonOperator comparisonOperator = (ComparisonOperator)((Object)ctx.getChild(1).accept((ParseTreeVisitor)this));
        HqlParser.ExpressionContext leftExpressionContext = (HqlParser.ExpressionContext)ctx.getChild(0);
        HqlParser.ExpressionContext rightExpressionContext = (HqlParser.ExpressionContext)ctx.getChild(2);
        switch (comparisonOperator) {
            case EQUAL: 
            case NOT_EQUAL: 
            case DISTINCT_FROM: 
            case NOT_DISTINCT_FROM: {
                Map<Class<?>, Enum<?>> possibleEnumValues = this.getPossibleEnumValues(leftExpressionContext);
                if (possibleEnumValues != null) {
                    right = (SqmExpression)rightExpressionContext.accept(this);
                    left = this.resolveEnumShorthandLiteral(leftExpressionContext, possibleEnumValues, right.getJavaType());
                    break;
                }
                possibleEnumValues = this.getPossibleEnumValues(rightExpressionContext);
                if (possibleEnumValues != null) {
                    left = (SqmExpression)leftExpressionContext.accept(this);
                    right = this.resolveEnumShorthandLiteral(rightExpressionContext, possibleEnumValues, left.getJavaType());
                    break;
                }
                left = (SqmExpression)leftExpressionContext.accept(this);
                right = (SqmExpression)rightExpressionContext.accept(this);
                if (left instanceof SqmLiteralNull) {
                    return new SqmNullnessPredicate(right, comparisonOperator == ComparisonOperator.NOT_EQUAL || comparisonOperator == ComparisonOperator.DISTINCT_FROM, this.creationContext.getNodeBuilder());
                }
                if (!(right instanceof SqmLiteralNull)) break;
                return new SqmNullnessPredicate(left, comparisonOperator == ComparisonOperator.NOT_EQUAL || comparisonOperator == ComparisonOperator.DISTINCT_FROM, this.creationContext.getNodeBuilder());
            }
            default: {
                left = (SqmExpression<?>)leftExpressionContext.accept(this);
                right = (SqmExpression<?>)rightExpressionContext.accept(this);
            }
        }
        return new SqmComparisonPredicate(left, comparisonOperator, right, this.creationContext.getNodeBuilder());
    }

    private SqmExpression<?> resolveEnumShorthandLiteral(HqlParser.ExpressionContext expressionContext, Map<Class<?>, Enum<?>> possibleEnumValues, Class<?> enumType) {
        Enum<?> enumValue;
        if (possibleEnumValues != null && (enumValue = possibleEnumValues.get(enumType)) != null) {
            DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
            dotIdentifierConsumer.consumeIdentifier(enumValue.getClass().getCanonicalName(), true, false);
            dotIdentifierConsumer.consumeIdentifier(enumValue.name(), false, true);
            return (SqmExpression)((Object)this.dotIdentifierConsumerStack.getCurrent().getConsumedPart());
        }
        return (SqmExpression)expressionContext.accept(this);
    }

    private Map<Class<?>, Enum<?>> getPossibleEnumValues(HqlParser.ExpressionContext expressionContext) {
        if (expressionContext instanceof HqlParser.BarePrimaryExpressionContext && expressionContext.getChildCount() == 1) {
            ParseTree ctx = expressionContext.getChild(0);
            while (ctx instanceof HqlParser.PrimaryExpressionContext && ctx.getChildCount() == 1) {
                ctx = ctx.getChild(0);
            }
            if (ctx instanceof HqlParser.GeneralPathFragmentContext && ctx.getChildCount() == 1 && (ctx = ctx.getChild(0)) instanceof HqlParser.SimplePathContext) {
                return this.creationContext.getJpaMetamodel().getAllowedEnumLiteralTexts().get(ctx.getText());
            }
        }
        return null;
    }

    @Override
    public SqmPredicate visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        boolean caseSensitive;
        boolean negated = ((TerminalNode)ctx.getChild(1)).getSymbol().getType() == 138;
        int startIndex = negated ? 3 : 2;
        boolean bl = caseSensitive = ((TerminalNode)ctx.getChild(negated ? 2 : 1)).getSymbol().getType() == 114;
        if (ctx.getChildCount() == startIndex + 2) {
            return new SqmLikePredicate((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(startIndex).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(startIndex + 1).getChild(1).accept((ParseTreeVisitor)this), negated, caseSensitive, this.creationContext.getNodeBuilder());
        }
        return new SqmLikePredicate((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(startIndex).accept((ParseTreeVisitor)this), negated, caseSensitive, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx) {
        boolean negated = ctx.NOT() != null;
        SqmPath sqmPluralPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(ctx.getChildCount() - 1));
        if (sqmPluralPath.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            return new SqmMemberOfPredicate((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), sqmPluralPath, negated, this.creationContext.getNodeBuilder());
        }
        throw new SemanticException("Path argument to MEMBER OF must be a plural attribute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPredicate visitInPredicate(HqlParser.InPredicateContext ctx) {
        boolean negated = ctx.getChildCount() == 4;
        SqmExpression testExpression = (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this);
        HqlParser.InListContext inListContext = (HqlParser.InListContext)ctx.getChild(ctx.getChildCount() - 1);
        if (inListContext instanceof HqlParser.ExplicitTupleInListContext) {
            HqlParser.ExplicitTupleInListContext tupleExpressionListContext = (HqlParser.ExplicitTupleInListContext)inListContext;
            int size = tupleExpressionListContext.getChildCount();
            int estimatedSize = size >> 1;
            Class testExpressionJavaType = testExpression.getJavaType();
            boolean isEnum = testExpressionJavaType != null && testExpressionJavaType.isEnum();
            this.parameterDeclarationContextStack.push(() -> size == 3);
            try {
                ArrayList<SqmExpression> listExpressions = new ArrayList<SqmExpression>(estimatedSize);
                for (int i = 1; i < size; ++i) {
                    HqlParser.ExpressionContext expressionContext;
                    Map<Class<?>, Enum<?>> possibleEnumValues;
                    ParseTree parseTree = tupleExpressionListContext.getChild(i);
                    if (!(parseTree instanceof HqlParser.ExpressionOrPredicateContext)) continue;
                    ParseTree child = parseTree.getChild(0);
                    if (isEnum && child instanceof HqlParser.ExpressionContext && (possibleEnumValues = this.getPossibleEnumValues(expressionContext = (HqlParser.ExpressionContext)child)) != null) {
                        listExpressions.add(this.resolveEnumShorthandLiteral(expressionContext, possibleEnumValues, testExpressionJavaType));
                        continue;
                    }
                    listExpressions.add((SqmExpression)child.accept((ParseTreeVisitor)this));
                }
                SqmInListPredicate sqmInListPredicate = new SqmInListPredicate(testExpression, listExpressions, negated, this.creationContext.getNodeBuilder());
                return sqmInListPredicate;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (inListContext instanceof HqlParser.ParamInListContext) {
            HqlParser.ParamInListContext tupleExpressionListContext = (HqlParser.ParamInListContext)inListContext;
            this.parameterDeclarationContextStack.push(() -> true);
            try {
                SqmInListPredicate sqmInListPredicate = new SqmInListPredicate(testExpression, Collections.singletonList(tupleExpressionListContext.getChild(0).accept((ParseTreeVisitor)this)), negated, this.creationContext.getNodeBuilder());
                return sqmInListPredicate;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (inListContext instanceof HqlParser.SubqueryInListContext) {
            HqlParser.SubqueryInListContext subQueryOrParamInListContext = (HqlParser.SubqueryInListContext)inListContext;
            return new SqmInSubQueryPredicate(testExpression, this.visitSubquery((HqlParser.SubqueryContext)subQueryOrParamInListContext.getChild(1)), negated, this.creationContext.getNodeBuilder());
        }
        if (inListContext instanceof HqlParser.PersistentCollectionReferenceInListContext) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
            }
            HqlParser.PersistentCollectionReferenceInListContext collectionReferenceInListContext = (HqlParser.PersistentCollectionReferenceInListContext)inListContext;
            return new SqmInSubQueryPredicate(testExpression, this.createCollectionReferenceSubQuery((HqlParser.SimplePathContext)collectionReferenceInListContext.getChild(2), (TerminalNode)collectionReferenceInListContext.getChild(0)), negated, this.creationContext.getNodeBuilder());
        }
        throw new ParsingException("Unexpected IN predicate type [" + ((Object)((Object)ctx)).getClass().getSimpleName() + "] : " + ctx.getText());
    }

    @Override
    public SqmPredicate visitExistsCollectionPartPredicate(HqlParser.ExistsCollectionPartPredicateContext ctx) {
        SqmSubQuery subQuery = this.createCollectionReferenceSubQuery((HqlParser.SimplePathContext)ctx.getChild(3), null);
        return new SqmExistsPredicate(subQuery, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitExistsPredicate(HqlParser.ExistsPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this);
        return new SqmExistsPredicate(expression, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitBooleanExpressionPredicate(HqlParser.BooleanExpressionPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        if (expression.getJavaType() != Boolean.class) {
            throw new SemanticException("Non-boolean expression used in predicate context: " + ctx.getText());
        }
        return new SqmBooleanExpressionPredicate(expression, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitEntityTypeExpression(HqlParser.EntityTypeExpressionContext ctx) {
        ParseTree pathOrParameter = ctx.getChild(0).getChild(2);
        if (pathOrParameter instanceof HqlParser.ParameterContext) {
            return new SqmParameterizedEntityType((SqmParameter)pathOrParameter.accept((ParseTreeVisitor)this), this.creationContext.getNodeBuilder());
        }
        if (pathOrParameter instanceof HqlParser.PathContext) {
            return ((SqmPath)pathOrParameter.accept((ParseTreeVisitor)this)).type();
        }
        throw new ParsingException("Could not interpret grammar context as 'entity type' expression : " + ctx.getText());
    }

    @Override
    public SqmExpression<?> visitEntityIdExpression(HqlParser.EntityIdExpressionContext ctx) {
        return this.visitEntityIdReference((HqlParser.EntityIdReferenceContext)ctx.getChild(0));
    }

    @Override
    public SqmPath<?> visitEntityIdReference(HqlParser.EntityIdReferenceContext ctx) {
        SqmPath sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        DomainType<?> sqmPathType = sqmPath.getReferencedPathSource().getSqmPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            SqmPathSource<?> identifierDescriptor = ((IdentifiableDomainType)sqmPathType).getIdentifierDescriptor();
            JpaPath idPath = sqmPath.get(identifierDescriptor.getPathName());
            if (ctx.getChildCount() != 5) {
                return idPath;
            }
            HqlParser.PathContinuationContext pathContinuationContext = (HqlParser.PathContinuationContext)ctx.getChild(4);
            throw new NotYetImplementedFor6Exception("Path continuation from `id()` reference not yet implemented");
        }
        throw new SemanticException("Path does not resolve to an entity type '" + sqmPath.getNavigablePath() + "'");
    }

    @Override
    public SqmExpression<?> visitEntityVersionExpression(HqlParser.EntityVersionExpressionContext ctx) {
        return this.visitEntityVersionReference((HqlParser.EntityVersionReferenceContext)ctx.getChild(0));
    }

    @Override
    public SqmPath<?> visitEntityVersionReference(HqlParser.EntityVersionReferenceContext ctx) {
        SqmPath sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        DomainType<?> sqmPathType = sqmPath.getReferencedPathSource().getSqmPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableType = (IdentifiableDomainType)sqmPathType;
            SingularPersistentAttribute versionAttribute = identifiableType.findVersionAttribute();
            if (versionAttribute == null) {
                throw new SemanticException(String.format("Path '%s' resolved to entity type '%s' which does not define a version", sqmPath.getNavigablePath(), identifiableType.getTypeName()));
            }
            return sqmPath.get(versionAttribute);
        }
        throw new SemanticException("Path does not resolve to an entity type '" + sqmPath.getNavigablePath() + "'");
    }

    @Override
    public SqmPath<?> visitEntityNaturalIdExpression(HqlParser.EntityNaturalIdExpressionContext ctx) {
        return this.visitEntityNaturalIdReference((HqlParser.EntityNaturalIdReferenceContext)ctx.getChild(0));
    }

    @Override
    public SqmPath<?> visitEntityNaturalIdReference(HqlParser.EntityNaturalIdReferenceContext ctx) {
        SqmPath sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        DomainType<?> sqmPathType = sqmPath.getReferencedPathSource().getSqmPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableType = (IdentifiableDomainType)sqmPathType;
            List attributes = identifiableType.findNaturalIdAttributes();
            if (attributes == null) {
                throw new SemanticException(String.format("Path '%s' resolved to entity type '%s' which does not define a natural id", sqmPath.getNavigablePath(), identifiableType.getTypeName()));
            }
            if (attributes.size() > 1) {
                throw new SemanticException(String.format("Path '%s' resolved to entity type '%s' which defines multiple natural ids", sqmPath.getNavigablePath(), identifiableType.getTypeName()));
            }
            SingularAttribute naturalIdAttribute = (SingularAttribute)attributes.get(0);
            return sqmPath.get(naturalIdAttribute);
        }
        throw new SemanticException("Path does not resolve to an entity type '" + sqmPath.getNavigablePath() + "'");
    }

    @Override
    public Object visitToOneFkExpression(HqlParser.ToOneFkExpressionContext ctx) {
        return this.visitToOneFkReference((HqlParser.ToOneFkReferenceContext)ctx.getChild(0));
    }

    @Override
    public SqmFkExpression<?> visitToOneFkReference(HqlParser.ToOneFkReferenceContext ctx) {
        boolean validToOneRef;
        SqmPath sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        SqmPathSource<?> toOneReference = sqmPath.getReferencedPathSource();
        boolean bl = validToOneRef = toOneReference.getBindableType() == Bindable.BindableType.SINGULAR_ATTRIBUTE && toOneReference instanceof EntitySqmPathSource;
        if (!validToOneRef) {
            throw new SemanticException(String.format(Locale.ROOT, "`%s` used in `fk()` only supported for to-one mappings, but found `%s`", sqmPath.getNavigablePath(), toOneReference));
        }
        return new SqmFkExpression((SqmEntityValuedSimplePath)sqmPath, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmMapEntryReference<?, ?> visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        return new SqmMapEntryReference(this.consumePluralAttributeReference((HqlParser.PathContext)ctx.getChild(2)), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitConcatenationExpression(HqlParser.ConcatenationExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new ParsingException("Expecting 2 operands to the concat operator");
        }
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this)), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitSignOperator(HqlParser.SignOperatorContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 29: {
                return UnaryArithmeticOperator.UNARY_PLUS;
            }
            case 30: {
                return UnaryArithmeticOperator.UNARY_MINUS;
            }
        }
        throw new QueryException("missing operator");
    }

    @Override
    public Object visitAdditiveOperator(HqlParser.AdditiveOperatorContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 29: {
                return BinaryArithmeticOperator.ADD;
            }
            case 30: {
                return BinaryArithmeticOperator.SUBTRACT;
            }
        }
        throw new QueryException("missing operator");
    }

    @Override
    public Object visitMultiplicativeOperator(HqlParser.MultiplicativeOperatorContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 31: {
                return BinaryArithmeticOperator.MULTIPLY;
            }
            case 32: {
                return BinaryArithmeticOperator.DIVIDE;
            }
            case 33: {
                return BinaryArithmeticOperator.MODULO;
            }
        }
        throw new QueryException("missing operator");
    }

    @Override
    public Object visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new ParsingException("Expecting 2 operands to the additive operator");
        }
        return new SqmBinaryArithmetic((BinaryArithmeticOperator)((Object)ctx.getChild(1).accept((ParseTreeVisitor)this)), (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this), this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new ParsingException("Expecting 2 operands to the multiplicative operator");
        }
        SqmExpression left = (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this);
        SqmExpression right = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        BinaryArithmeticOperator operator = (BinaryArithmeticOperator)((Object)ctx.getChild(1).accept((ParseTreeVisitor)this));
        if (operator == BinaryArithmeticOperator.MODULO) {
            return this.getFunctionDescriptor("mod").generateSqmExpression(Arrays.asList(left, right), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
        }
        return new SqmBinaryArithmetic(operator, left, right, this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitToDurationExpression(HqlParser.ToDurationExpressionContext ctx) {
        return new SqmToDuration<Duration>((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), this.toDurationUnit((SqmExtractUnit)ctx.getChild(1).accept((ParseTreeVisitor)this)), this.resolveExpressibleTypeBasic(Duration.class), this.creationContext.getNodeBuilder());
    }

    private SqmDurationUnit<Long> toDurationUnit(SqmExtractUnit<?> extractUnit) {
        return new SqmDurationUnit<Long>(extractUnit.getUnit(), this.resolveExpressibleTypeBasic(Long.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitFromDurationExpression(HqlParser.FromDurationExpressionContext ctx) {
        return new SqmByUnit(this.toDurationUnit((SqmExtractUnit)ctx.getChild(2).accept((ParseTreeVisitor)this)), (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), this.resolveExpressibleTypeBasic(Long.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmUnaryOperation<?> visitUnaryExpression(HqlParser.UnaryExpressionContext ctx) {
        return new SqmUnaryOperation((UnaryArithmeticOperator)((Object)ctx.getChild(0).accept((ParseTreeVisitor)this)), (SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this));
    }

    @Override
    public Object visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitCollateFunction(HqlParser.CollateFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.COLLATIONS);
        }
        SqmExpression expressionToCollate = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmCollation castTargetExpression = (SqmCollation)ctx.getChild(4).accept((ParseTreeVisitor)this);
        return this.getFunctionDescriptor("collate").generateSqmExpression(Arrays.asList(expressionToCollate, castTargetExpression), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitCollation(HqlParser.CollationContext ctx) {
        return new SqmCollation(ctx.getChild(0).getText(), null, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitTupleExpression(HqlParser.TupleExpressionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.TUPLES);
        }
        List<SqmExpression<?>> expressions = this.visitExpressions(ctx);
        return new SqmTuple(expressions, this.creationContext.getNodeBuilder());
    }

    private List<SqmExpression<?>> visitExpressions(ParserRuleContext parentContext) {
        int size = parentContext.getChildCount();
        int estimateExpressionsCount = (size >> 1) - 1;
        ArrayList expressions = new ArrayList(estimateExpressionsCount);
        for (int i = 0; i < size; ++i) {
            ParseTree parseTree = parentContext.getChild(i);
            if (!(parseTree instanceof HqlParser.ExpressionOrPredicateContext)) continue;
            expressions.add((SqmExpression)parseTree.accept((ParseTreeVisitor)this));
        }
        return expressions;
    }

    @Override
    public Object visitCaseExpression(HqlParser.CaseExpressionContext ctx) {
        return ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmCaseSimple<?, ?> visitSimpleCaseList(HqlParser.SimpleCaseListContext ctx) {
        int size = ctx.getChildCount();
        SqmCaseSimple caseExpression = new SqmCaseSimple((SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this), null, size - 3, this.creationContext.getNodeBuilder());
        for (int i = 2; i < size; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (!(parseTree instanceof HqlParser.SimpleCaseWhenContext)) continue;
            caseExpression.when((SqmExpression)parseTree.getChild(1).accept((ParseTreeVisitor)this), (SqmExpression)parseTree.getChild(3).accept((ParseTreeVisitor)this));
        }
        ParseTree lastChild = ctx.getChild(ctx.getChildCount() - 2);
        if (lastChild instanceof HqlParser.CaseOtherwiseContext) {
            caseExpression.otherwise((SqmExpression)lastChild.getChild(1).accept((ParseTreeVisitor)this));
        }
        return caseExpression;
    }

    @Override
    public SqmCaseSearched<?> visitSearchedCaseList(HqlParser.SearchedCaseListContext ctx) {
        int size = ctx.getChildCount();
        SqmCaseSearched caseExpression = new SqmCaseSearched(null, size - 2, this.creationContext.getNodeBuilder());
        for (int i = 1; i < size; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (!(parseTree instanceof HqlParser.SearchedCaseWhenContext)) continue;
            caseExpression.when((SqmPredicate)parseTree.getChild(1).accept((ParseTreeVisitor)this), (SqmExpression)parseTree.getChild(3).accept((ParseTreeVisitor)this));
        }
        ParseTree lastChild = ctx.getChild(ctx.getChildCount() - 2);
        if (lastChild instanceof HqlParser.CaseOtherwiseContext) {
            caseExpression.otherwise((SqmExpression)lastChild.getChild(1).accept((ParseTreeVisitor)this));
        }
        return caseExpression;
    }

    @Override
    public SqmExpression<?> visitCurrentDateFunction(HqlParser.CurrentDateFunctionContext ctx) {
        return this.getFunctionDescriptor("current_date").generateSqmExpression(this.resolveExpressibleTypeBasic(Date.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitCurrentTimeFunction(HqlParser.CurrentTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("current_time").generateSqmExpression(this.resolveExpressibleTypeBasic(Time.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitCurrentTimestampFunction(HqlParser.CurrentTimestampFunctionContext ctx) {
        return this.getFunctionDescriptor("current_timestamp").generateSqmExpression(this.resolveExpressibleTypeBasic(Timestamp.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitInstantFunction(HqlParser.InstantFunctionContext ctx) {
        return this.getFunctionDescriptor("instant").generateSqmExpression(this.resolveExpressibleTypeBasic(Instant.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLocalDateFunction(HqlParser.LocalDateFunctionContext ctx) {
        return this.getFunctionDescriptor("local_date").generateSqmExpression(this.resolveExpressibleTypeBasic(LocalDate.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLocalTimeFunction(HqlParser.LocalTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("local_time").generateSqmExpression(this.resolveExpressibleTypeBasic(LocalTime.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLocalDateTimeFunction(HqlParser.LocalDateTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("local_datetime").generateSqmExpression(this.resolveExpressibleTypeBasic(LocalDateTime.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitOffsetDateTimeFunction(HqlParser.OffsetDateTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("offset_datetime").generateSqmExpression(this.resolveExpressibleTypeBasic(OffsetDateTime.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        return (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitUnaryNumericLiteralExpression(HqlParser.UnaryNumericLiteralExpressionContext ctx) {
        TerminalNode node = (TerminalNode)ctx.getChild(1).getChild(0);
        Object text = ((TerminalNode)ctx.getChild(0).getChild(0)).getSymbol().getType() == 30 ? "-" + node.getText() : node.getText();
        switch (node.getSymbol().getType()) {
            case 3: {
                return this.integerOrLongLiteral((String)text);
            }
            case 4: {
                return this.longLiteral((String)text);
            }
            case 7: {
                return this.bigIntegerLiteral((String)text);
            }
            case 9: {
                return this.hexLiteral((String)text);
            }
            case 5: {
                return this.floatLiteral((String)text);
            }
            case 6: {
                return this.doubleLiteral((String)text);
            }
            case 8: {
                return this.bigDecimalLiteral((String)text);
            }
        }
        throw new ParsingException("Unexpected terminal node [" + (String)text + "]");
    }

    @Override
    public Object visitBinaryLiteral(HqlParser.BinaryLiteralContext ctx) {
        TerminalNode firstNode = (TerminalNode)ctx.getChild(0);
        if (firstNode.getSymbol().getType() == 11) {
            return this.binaryLiteral(firstNode.getText());
        }
        StringBuilder text = new StringBuilder("x'");
        int size = ctx.getChildCount();
        for (int i = 0; i < size; ++i) {
            TerminalNode hex = (TerminalNode)ctx.getChild(i);
            if (hex.getSymbol().getType() != 9) continue;
            String hexText = hex.getText();
            if (hexText.length() != 4) {
                throw new LiteralNumberFormatException("not a byte: " + hexText);
            }
            text.append(hexText, 2, hexText.length());
        }
        return this.binaryLiteral(text.append("'").toString());
    }

    @Override
    public Object visitGeneralizedLiteral(HqlParser.GeneralizedLiteralContext ctx) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    public SqmExpression<?> visitTerminal(TerminalNode node) {
        if (node.getSymbol().getType() == -1) {
            return null;
        }
        switch (node.getSymbol().getType()) {
            case 10: {
                return this.stringLiteral(node.getText());
            }
            case 3: {
                return this.integerOrLongLiteral(node.getText());
            }
            case 4: {
                return this.longLiteral(node.getText());
            }
            case 7: {
                return this.bigIntegerLiteral(node.getText());
            }
            case 9: {
                return this.hexLiteral(node.getText());
            }
            case 5: {
                return this.floatLiteral(node.getText());
            }
            case 6: {
                return this.doubleLiteral(node.getText());
            }
            case 8: {
                return this.bigDecimalLiteral(node.getText());
            }
            case 197: {
                return this.booleanLiteral(false);
            }
            case 196: {
                return this.booleanLiteral(true);
            }
            case 198: {
                return new SqmLiteralNull(this.creationContext.getQueryEngine().getCriteriaBuilder());
            }
            case 11: {
                return this.binaryLiteral(node.getText());
            }
        }
        throw new ParsingException("Unexpected terminal node [" + node.getText() + "]");
    }

    @Override
    public Object visitDateTimeLiteral(HqlParser.DateTimeLiteralContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitDateLiteral(HqlParser.DateLiteralContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitTimeLiteral(HqlParser.TimeLiteralContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitJdbcTimestampLiteral(HqlParser.JdbcTimestampLiteralContext ctx) {
        ParseTree parseTree = ctx.getChild(1);
        if (parseTree instanceof HqlParser.DateTimeContext) {
            return parseTree.accept((ParseTreeVisitor)this);
        }
        return this.sqlTimestampLiteralFrom(parseTree.getText());
    }

    @Override
    public Object visitJdbcDateLiteral(HqlParser.JdbcDateLiteralContext ctx) {
        ParseTree parseTree = ctx.getChild(1);
        if (parseTree instanceof HqlParser.DateContext) {
            return parseTree.accept((ParseTreeVisitor)this);
        }
        return this.sqlDateLiteralFrom(parseTree.getText());
    }

    @Override
    public Object visitJdbcTimeLiteral(HqlParser.JdbcTimeLiteralContext ctx) {
        ParseTree parseTree = ctx.getChild(1);
        if (parseTree instanceof HqlParser.TimeContext) {
            return parseTree.accept((ParseTreeVisitor)this);
        }
        return this.sqlTimeLiteralFrom(parseTree.getText());
    }

    @Override
    public Object visitDateTime(HqlParser.DateTimeContext ctx) {
        ParseTree parseTree = ctx.getChild(2);
        if (parseTree instanceof HqlParser.ZoneIdContext || parseTree == null) {
            return this.dateTimeLiteralFrom((HqlParser.DateContext)ctx.getChild(0), (HqlParser.TimeContext)ctx.getChild(1), (HqlParser.ZoneIdContext)parseTree);
        }
        return this.offsetDatetimeLiteralFrom((HqlParser.DateContext)ctx.getChild(0), (HqlParser.TimeContext)ctx.getChild(1), (HqlParser.OffsetContext)parseTree);
    }

    private SqmLiteral<?> dateTimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.ZoneIdContext timezone) {
        if (timezone == null) {
            return new SqmLiteral<LocalDateTime>(LocalDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time)), this.resolveExpressibleTypeBasic(LocalDateTime.class), this.creationContext.getNodeBuilder());
        }
        ZoneId zoneId = this.visitZoneId(timezone);
        return new SqmLiteral<ZonedDateTime>(ZonedDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), zoneId), this.resolveExpressibleTypeBasic(ZonedDateTime.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public ZoneId visitZoneId(HqlParser.ZoneIdContext ctx) {
        TerminalNode firstChild = (TerminalNode)ctx.getChild(0);
        String timezoneText = firstChild.getSymbol().getType() == 10 ? QuotingHelper.unquoteStringLiteral(ctx.getText()) : ctx.getText();
        String timezoneFullName = ZoneId.SHORT_IDS.get(timezoneText);
        if (timezoneFullName == null) {
            return ZoneId.of(timezoneText);
        }
        return ZoneId.of(timezoneFullName);
    }

    private SqmLiteral<?> offsetDatetimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.OffsetContext offset) {
        return new SqmLiteral<OffsetDateTime>(OffsetDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), SemanticQueryBuilder.zoneOffset(offset)), this.resolveExpressibleTypeBasic(OffsetDateTime.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitDate(HqlParser.DateContext ctx) {
        return new SqmLiteral<LocalDate>(SemanticQueryBuilder.localDate(ctx), this.resolveExpressibleTypeBasic(LocalDate.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitTime(HqlParser.TimeContext ctx) {
        return new SqmLiteral<LocalTime>(SemanticQueryBuilder.localTime(ctx), this.resolveExpressibleTypeBasic(LocalTime.class), this.creationContext.getNodeBuilder());
    }

    private static LocalTime localTime(HqlParser.TimeContext ctx) {
        int hour = Integer.parseInt(ctx.getChild(0).getText());
        int minute = Integer.parseInt(ctx.getChild(2).getText());
        if (ctx.getChildCount() == 5) {
            String secondText = ctx.getChild(4).getText();
            int index = secondText.indexOf(46);
            if (index < 0) {
                return LocalTime.of(hour, minute, Integer.parseInt(secondText));
            }
            return LocalTime.of(hour, minute, Integer.parseInt(secondText.substring(0, index)), Integer.parseInt(secondText.substring(index + 1)));
        }
        return LocalTime.of(hour, minute);
    }

    private static LocalDate localDate(HqlParser.DateContext ctx) {
        return LocalDate.of(Integer.parseInt(ctx.getChild(0).getText()), Integer.parseInt(ctx.getChild(2).getText()), Integer.parseInt(ctx.getChild(4).getText()));
    }

    private static ZoneOffset zoneOffset(HqlParser.OffsetContext offset) {
        int factor = ((TerminalNode)offset.getChild(0)).getSymbol().getType() == 29 ? 1 : -1;
        int hour = factor * Integer.parseInt(offset.getChild(1).getText());
        if (offset.getChildCount() == 2) {
            return ZoneOffset.ofHours(hour);
        }
        return ZoneOffset.ofHoursMinutes(hour, factor * Integer.parseInt(offset.getChild(3).getText()));
    }

    private SqmLiteral<?> sqlTimestampLiteralFrom(String literalText) {
        TemporalAccessor parsed = DateTimeUtils.DATE_TIME.parse(literalText.subSequence(1, literalText.length() - 1));
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.from(parsed);
            GregorianCalendar literal = GregorianCalendar.from(zonedDateTime);
            return new SqmLiteral<Calendar>(literal, this.resolveExpressibleTypeBasic(Calendar.class), this.creationContext.getNodeBuilder());
        }
        catch (DateTimeException dte) {
            LocalDateTime localDateTime = LocalDateTime.from(parsed);
            Timestamp literal = Timestamp.valueOf(localDateTime);
            return new SqmLiteral<Timestamp>(literal, this.resolveExpressibleTypeBasic(Timestamp.class), this.creationContext.getNodeBuilder());
        }
    }

    private SqmLiteral<Date> sqlDateLiteralFrom(String literalText) {
        LocalDate localDate = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(literalText.subSequence(1, literalText.length() - 1)));
        Date literal = Date.valueOf(localDate);
        return new SqmLiteral<Date>(literal, this.resolveExpressibleTypeBasic(Date.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<Time> sqlTimeLiteralFrom(String literalText) {
        LocalTime localTime = LocalTime.from(DateTimeFormatter.ISO_LOCAL_TIME.parse(literalText.subSequence(1, literalText.length() - 1)));
        Time literal = Time.valueOf(localTime);
        return new SqmLiteral<Time>(literal, this.resolveExpressibleTypeBasic(Time.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<Boolean> booleanLiteral(boolean value) {
        return new SqmLiteral<Boolean>(value, this.resolveExpressibleTypeBasic(Boolean.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<String> stringLiteral(String text) {
        return new SqmLiteral<String>(QuotingHelper.unquoteStringLiteral(text), this.resolveExpressibleTypeBasic(String.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<byte[]> binaryLiteral(String text) {
        return new SqmLiteral<byte[]>(PrimitiveByteArrayJavaType.INSTANCE.fromString(CharSequenceHelper.subSequence(text, 2, text.length() - 1)), this.resolveExpressibleTypeBasic(byte[].class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<? extends Number> integerOrLongLiteral(String text) {
        try {
            Integer value = Integer.valueOf(text);
            return new SqmLiteral<Integer>(value, this.resolveExpressibleTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            try {
                Long value = Long.valueOf(text);
                return new SqmLiteral<Long>(value, this.resolveExpressibleTypeBasic(Long.class), this.creationContext.getNodeBuilder());
            }
            catch (NumberFormatException e2) {
                e.addSuppressed(e2);
                throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Integer", e);
            }
        }
    }

    private SqmLiteral<Integer> integerLiteral(String text) {
        try {
            Integer value = Integer.valueOf(text);
            return new SqmLiteral<Integer>(value, this.resolveExpressibleTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Integer", e);
        }
    }

    private SqmLiteral<Long> longLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("l") || text.endsWith("L")) {
                text = text.substring(0, text.length() - 1);
            }
            Long value = Long.valueOf(text);
            return new SqmLiteral<Long>(value, this.resolveExpressibleTypeBasic(Long.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to Long", e);
        }
    }

    private SqmLiteral<? extends Number> hexLiteral(String text) {
        String originalText = text;
        text = text.substring(2);
        try {
            BasicType<Number> type;
            Number value;
            if (text.endsWith("l") || text.endsWith("L")) {
                text = text.substring(0, text.length() - 1);
                value = Long.parseUnsignedLong(text, 16);
                type = this.resolveExpressibleTypeBasic(Long.class);
            } else {
                value = Integer.parseUnsignedInt(text, 16);
                type = this.resolveExpressibleTypeBasic(Integer.class);
            }
            return new SqmLiteral<Integer>((Integer)value, (SqmExpressible<Integer>)type, this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "]", e);
        }
    }

    private SqmLiteral<BigInteger> bigIntegerLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("bi") || text.endsWith("BI")) {
                text = text.substring(0, text.length() - 2);
            }
            return new SqmLiteral<BigInteger>(new BigInteger(text), this.resolveExpressibleTypeBasic(BigInteger.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to BigInteger", e);
        }
    }

    private SqmLiteral<Float> floatLiteral(String text) {
        try {
            return new SqmLiteral<Float>(Float.valueOf(text), this.resolveExpressibleTypeBasic(Float.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Float", e);
        }
    }

    private SqmLiteral<Double> doubleLiteral(String text) {
        try {
            return new SqmLiteral<Double>(Double.valueOf(text), this.resolveExpressibleTypeBasic(Double.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Double", e);
        }
    }

    private SqmLiteral<BigDecimal> bigDecimalLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("bd") || text.endsWith("BD")) {
                text = text.substring(0, text.length() - 2);
            }
            return new SqmLiteral<BigDecimal>(new BigDecimal(text), this.resolveExpressibleTypeBasic(BigDecimal.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to BigDecimal", e);
        }
    }

    private <J> BasicType<J> resolveExpressibleTypeBasic(Class<J> javaType) {
        return this.creationContext.getJpaMetamodel().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
    }

    @Override
    public Object visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmNamedParameter<?> visitNamedParameter(HqlParser.NamedParameterContext ctx) {
        this.parameterStyle = this.parameterStyle.withNamed();
        SqmNamedParameter param = new SqmNamedParameter(ctx.getChild(1).getText(), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), this.creationContext.getNodeBuilder());
        this.parameterCollector.addParameter(param);
        return param;
    }

    @Override
    public SqmPositionalParameter<?> visitPositionalParameter(HqlParser.PositionalParameterContext ctx) {
        if (ctx.getChildCount() == 1) {
            throw new SemanticException("Unlabeled ordinal parameter ('?' rather than ?1)");
        }
        this.parameterStyle = this.parameterStyle.withPositional();
        SqmPositionalParameter param = new SqmPositionalParameter(Integer.parseInt(ctx.getChild(1).getText()), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), this.creationContext.getNodeBuilder());
        this.parameterCollector.addParameter(param);
        return param;
    }

    @Override
    public SqmExpression<?> visitJpaNonstandardFunction(HqlParser.JpaNonstandardFunctionContext ctx) {
        String functionName = QuotingHelper.unquoteStringLiteral(ctx.getChild(2).getText()).toLowerCase();
        List functionArguments = ctx.getChildCount() > 4 ? (List)ctx.getChild(4).accept((ParseTreeVisitor)this) : Collections.emptyList();
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            functionTemplate = new NamedSqmFunctionDescriptor(functionName, true, null, StandardFunctionReturnTypeResolvers.invariant(this.resolveExpressibleTypeBasic(Object.class)), null);
        }
        return functionTemplate.generateSqmExpression(functionArguments, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public String visitGenericFunctionName(HqlParser.GenericFunctionNameContext ctx) {
        StringBuilder functionName = new StringBuilder(this.visitIdentifier(ctx.simplePath().identifier()));
        for (HqlParser.SimplePathElementContext sp : ctx.simplePath().simplePathElement()) {
            functionName.append('.').append(this.visitIdentifier(sp.identifier()));
        }
        return functionName.toString();
    }

    @Override
    public Object visitGenericFunction(HqlParser.GenericFunctionContext ctx) {
        SelfRenderingSqmFunction function;
        String originalFunctionName = this.visitGenericFunctionName(ctx.genericFunctionName());
        String functionName = originalFunctionName.toLowerCase();
        if (this.creationOptions.useStrictJpaCompliance() && !JPA_STANDARD_FUNCTIONS.contains(functionName)) {
            throw new StrictJpaComplianceViolation("Encountered non-compliant non-standard function call [" + originalFunctionName + "], but strict JPA compliance was requested; use JPA's FUNCTION(functionName[,...]) syntax name instead", StrictJpaComplianceViolation.Type.FUNCTION_CALL);
        }
        ParseTree argumentChild = ctx.getChild(2);
        List<Object> functionArguments = argumentChild instanceof HqlParser.GenericFunctionArgumentsContext ? (List)argumentChild.accept((ParseTreeVisitor)this) : ("*".equals(argumentChild.getText()) ? Collections.singletonList(new SqmStar(this.getCreationContext().getNodeBuilder())) : Collections.emptyList());
        Boolean fromFirst = this.getFromFirst((ParseTree)ctx);
        Boolean respectNulls = this.getRespectNullsClause((ParseTree)ctx);
        SqmOrderByClause withinGroup = this.getWithinGroup((ParseTree)ctx);
        SqmPredicate filterExpression = this.getFilterExpression((ParseTree)ctx);
        boolean hasOverClause = ctx.getChild(ctx.getChildCount() - 1) instanceof HqlParser.OverClauseContext;
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            Object functionKind = FunctionKind.NORMAL;
            if (withinGroup != null) {
                functionKind = FunctionKind.ORDERED_SET_AGGREGATE;
            } else if (hasOverClause) {
                functionKind = FunctionKind.WINDOW;
            } else if (filterExpression != null) {
                functionKind = FunctionKind.AGGREGATE;
            }
            functionTemplate = new NamedSqmFunctionDescriptor(functionName, true, null, StandardFunctionReturnTypeResolvers.invariant(this.resolveExpressibleTypeBasic(Object.class)), null, functionName, (FunctionKind)((Object)functionKind), null, SqlAstNodeRenderingMode.DEFAULT);
        } else {
            if (hasOverClause && functionTemplate.getFunctionKind() == FunctionKind.NORMAL) {
                throw new SemanticException("OVER clause is illegal for normal function: " + functionName);
            }
            if (!hasOverClause && functionTemplate.getFunctionKind() == FunctionKind.WINDOW) {
                throw new SemanticException("OVER clause is mandatory for window-only function: " + functionName);
            }
            if (respectNulls != null) {
                switch (functionName) {
                    case "lag": 
                    case "lead": 
                    case "first_value": 
                    case "last_value": 
                    case "nth_value": {
                        break;
                    }
                    default: {
                        throw new SemanticException("RESPECT/IGNORE NULLS is illegal for function: " + functionName);
                    }
                }
            }
            if (fromFirst != null && !"nth_value".equals(functionName)) {
                throw new SemanticException("FROM FIRST/LAST is illegal for function: " + functionName);
            }
        }
        switch (functionTemplate.getFunctionKind()) {
            case ORDERED_SET_AGGREGATE: {
                function = functionTemplate.generateOrderedSetAggregateSqmExpression(functionArguments, filterExpression, withinGroup, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
                break;
            }
            case AGGREGATE: {
                function = functionTemplate.generateAggregateSqmExpression(functionArguments, filterExpression, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
                break;
            }
            case WINDOW: {
                function = functionTemplate.generateWindowSqmExpression(functionArguments, filterExpression, null, null, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
                break;
            }
            default: {
                if (filterExpression != null) {
                    throw new ParsingException("Illegal use of a FILTER clause for non-aggregate function: " + originalFunctionName);
                }
                function = functionTemplate.generateSqmExpression(functionArguments, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
            }
        }
        return this.applyOverClause((ParseTree)ctx, function);
    }

    @Override
    public Object visitListaggFunction(HqlParser.ListaggFunctionContext ctx) {
        int argumentStartIndex;
        boolean distinct;
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered non-compliant non-standard function call [listagg], but strict JPA compliance was requested; use JPA's FUNCTION(functionName[,...]) syntax name instead", StrictJpaComplianceViolation.Type.FUNCTION_CALL);
        }
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor("listagg");
        if (functionTemplate == null) {
            throw new SemanticException("The listagg function was not registered for the dialect!");
        }
        ParseTree thirdChild = ctx.getChild(2);
        if (thirdChild instanceof TerminalNode) {
            distinct = true;
            argumentStartIndex = 3;
        } else {
            distinct = false;
            argumentStartIndex = 2;
        }
        SqmExpression firstArgument = (SqmExpression)ctx.getChild(argumentStartIndex).accept((ParseTreeVisitor)this);
        SqmExpression secondArgument = (SqmExpression)ctx.getChild(argumentStartIndex + 2).accept((ParseTreeVisitor)this);
        ParseTree overflowCtx = ctx.getChild(argumentStartIndex + 3);
        ArrayList functionArguments = new ArrayList(3);
        if (distinct) {
            functionArguments.add(new SqmDistinct(firstArgument, this.creationContext.getNodeBuilder()));
        } else {
            functionArguments.add(firstArgument);
        }
        if (overflowCtx instanceof HqlParser.OnOverflowClauseContext) {
            if (overflowCtx.getChildCount() > 3) {
                TerminalNode countNode = (TerminalNode)overflowCtx.getChild(overflowCtx.getChildCount() - 2);
                boolean withCount = countNode.getSymbol().getType() == 192;
                SqmLiteral<String> fillerExpression = overflowCtx.getChildCount() == 6 ? (SqmLiteral<String>)overflowCtx.getChild(3).accept((ParseTreeVisitor)this) : new SqmLiteral<String>("...", secondArgument.getNodeType(), secondArgument.nodeBuilder());
                functionArguments.add(new SqmOverflow<String>(secondArgument, fillerExpression, withCount));
            } else {
                functionArguments.add(new SqmOverflow(secondArgument, null, false));
            }
        } else {
            functionArguments.add(secondArgument);
        }
        SqmOrderByClause withinGroup = this.getWithinGroup((ParseTree)ctx);
        SqmPredicate filterExpression = this.getFilterExpression((ParseTree)ctx);
        return this.applyOverClause((ParseTree)ctx, functionTemplate.generateOrderedSetAggregateSqmExpression(functionArguments, filterExpression, withinGroup, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration()));
    }

    @Override
    public List<SqmTypedNode<?>> visitGenericFunctionArguments(HqlParser.GenericFunctionArgumentsContext ctx) {
        int size = ctx.getChildCount();
        int lastIndex = size - 1;
        int estimateArgumentCount = size >> 1;
        ArrayList arguments = new ArrayList(estimateArgumentCount);
        int i = 0;
        boolean distinct = false;
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof HqlParser.DatetimeFieldContext) {
            arguments.add(this.toDurationUnit((SqmExtractUnit)firstChild.accept((ParseTreeVisitor)this)));
            i += 2;
        } else if (firstChild instanceof TerminalNode) {
            distinct = true;
            ++i;
        }
        while (i < size) {
            if (i == lastIndex) {
                arguments.add(this.visitFinalFunctionArgument(ctx.getChild(i)));
            } else {
                arguments.add((SqmTypedNode)ctx.getChild(i).accept((ParseTreeVisitor)this));
            }
            i += 2;
        }
        if (distinct) {
            NodeBuilder nodeBuilder = this.getCreationContext().getNodeBuilder();
            if (arguments.size() == 1) {
                arguments.set(0, new SqmDistinct((SqmExpression)arguments.get(0), nodeBuilder));
            } else {
                ArrayList newArguments = new ArrayList(1);
                newArguments.add(new SqmDistinct(new SqmTuple(arguments, nodeBuilder), nodeBuilder));
                return newArguments;
            }
        }
        return arguments;
    }

    private SqmExpression<?> visitFinalFunctionArgument(ParseTree expression) {
        this.parameterDeclarationContextStack.push(() -> !this.creationOptions.useStrictJpaCompliance());
        try {
            SqmExpression sqmExpression = (SqmExpression)expression.accept((ParseTreeVisitor)this);
            return sqmExpression;
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
    }

    private SqmFunctionDescriptor getFunctionDescriptor(String name) {
        return this.creationContext.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(name);
    }

    @Override
    public SqmExtractUnit<?> visitDatetimeField(HqlParser.DatetimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 68: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 133: {
                return new SqmExtractUnit<Integer>(TemporalUnit.MONTH, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 195: {
                return new SqmExtractUnit<Integer>(TemporalUnit.YEAR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 97: {
                return new SqmExtractUnit<Integer>(TemporalUnit.HOUR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 132: {
                return new SqmExtractUnit<Integer>(TemporalUnit.MINUTE, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 166: {
                return new SqmExtractUnit<Float>(TemporalUnit.SECOND, this.resolveExpressibleTypeBasic(Float.class), nodeBuilder);
            }
            case 134: {
                return new SqmExtractUnit<Long>(TemporalUnit.NANOSECOND, this.resolveExpressibleTypeBasic(Long.class), nodeBuilder);
            }
            case 189: {
                return new SqmExtractUnit<Integer>(TemporalUnit.WEEK, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 159: {
                return new SqmExtractUnit<Integer>(TemporalUnit.QUARTER, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported datetime field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitDayField(HqlParser.DayFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(2)).getSymbol().getType()) {
            case 133: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_MONTH, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 189: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_WEEK, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 195: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_YEAR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported day field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitWeekField(HqlParser.WeekFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(2)).getSymbol().getType()) {
            case 133: {
                return new SqmExtractUnit<Integer>(TemporalUnit.WEEK_OF_MONTH, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 195: {
                return new SqmExtractUnit<Integer>(TemporalUnit.WEEK_OF_YEAR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported week field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitDateOrTimeField(HqlParser.DateOrTimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 66: {
                return this.isExtractingJdbcTemporalType ? new SqmExtractUnit<Date>(TemporalUnit.DATE, this.resolveExpressibleTypeBasic(Date.class), nodeBuilder) : new SqmExtractUnit<LocalDate>(TemporalUnit.DATE, this.resolveExpressibleTypeBasic(LocalDate.class), nodeBuilder);
            }
            case 175: {
                return this.isExtractingJdbcTemporalType ? new SqmExtractUnit<Time>(TemporalUnit.TIME, this.resolveExpressibleTypeBasic(Time.class), nodeBuilder) : new SqmExtractUnit<LocalTime>(TemporalUnit.TIME, this.resolveExpressibleTypeBasic(LocalTime.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported date or time field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitTimeZoneField(HqlParser.TimeZoneFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(ctx.getChildCount() - 1)).getSymbol().getType()) {
            case 177: {
                return new SqmExtractUnit<Integer>(TemporalUnit.TIMEZONE_HOUR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 178: {
                return new SqmExtractUnit<Integer>(TemporalUnit.TIMEZONE_MINUTE, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
        }
        return new SqmExtractUnit<ZoneOffset>(TemporalUnit.OFFSET, this.resolveExpressibleTypeBasic(ZoneOffset.class), nodeBuilder);
    }

    @Override
    public Object visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        SqmExpression expressionToExtract = (SqmExpression)ctx.getChild(ctx.getChildCount() - 2).accept((ParseTreeVisitor)this);
        this.isExtractingJdbcTemporalType = TypeConfiguration.isJdbcTemporalType(expressionToExtract.getNodeType());
        SqmExtractUnit extractFieldExpression = ctx.getChild(0) instanceof TerminalNode ? (SqmExtractUnit)ctx.getChild(2).accept((ParseTreeVisitor)this) : (SqmExtractUnit)ctx.getChild(0).accept((ParseTreeVisitor)this);
        return this.getFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(extractFieldExpression, expressionToExtract), extractFieldExpression.getType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitFormat(HqlParser.FormatContext ctx) {
        String format = QuotingHelper.unquoteStringLiteral(ctx.getChild(0).getText());
        return new SqmFormat(format, (SqmExpressible<String>)this.resolveExpressibleTypeBasic(String.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitFormatFunction(HqlParser.FormatFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmLiteral format = (SqmLiteral)ctx.getChild(4).accept((ParseTreeVisitor)this);
        return this.getFunctionDescriptor("format").generateSqmExpression(Arrays.asList(expressionToCast, format), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitCastFunction(HqlParser.CastFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmCastTarget castTargetExpression = (SqmCastTarget)ctx.getChild(4).accept((ParseTreeVisitor)this);
        return this.getFunctionDescriptor("cast").generateSqmExpression(Arrays.asList(expressionToCast, castTargetExpression), castTargetExpression.getType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmCastTarget<?> visitCastTarget(HqlParser.CastTargetContext castTargetContext) {
        HqlParser.CastTargetTypeContext castTargetTypeContext = (HqlParser.CastTargetTypeContext)castTargetContext.getChild(0);
        String targetName = castTargetTypeContext.fullTargetName;
        Long length = null;
        Integer precision = null;
        Integer scale = null;
        switch (castTargetTypeContext.getChildCount()) {
            case 6: {
                scale = Integer.valueOf(castTargetTypeContext.getChild(4).getText());
            }
            case 4: {
                length = Long.valueOf(castTargetTypeContext.getChild(2).getText());
                precision = length.intValue();
            }
        }
        return new SqmCastTarget((ReturnableType)((Object)this.creationContext.getJpaMetamodel().getTypeConfiguration().resolveCastTargetType(targetName)), length, precision, scale, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitPositionFunction(HqlParser.PositionFunctionContext ctx) {
        SqmExpression pattern = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmExpression string = (SqmExpression)ctx.getChild(4).accept((ParseTreeVisitor)this);
        return this.getFunctionDescriptor("position").generateSqmExpression(Arrays.asList(pattern, string), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitOverlayFunction(HqlParser.OverlayFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmExpression replacement = (SqmExpression)ctx.getChild(4).accept((ParseTreeVisitor)this);
        SqmExpression start = (SqmExpression)ctx.getChild(6).accept((ParseTreeVisitor)this);
        SqmExpression length = ctx.getChildCount() == 10 ? (SqmExpression)ctx.getChild(8).accept((ParseTreeVisitor)this) : null;
        return this.getFunctionDescriptor("overlay").generateSqmExpression(length == null ? Arrays.asList(string, replacement, start) : Arrays.asList(string, replacement, start, length), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitEveryFunction(HqlParser.EveryFunctionContext ctx) {
        SqmPredicate filterExpression = this.getFilterExpression((ParseTree)ctx);
        ParseTree argumentChild = ctx.getChild(2);
        if (argumentChild instanceof HqlParser.SubqueryContext) {
            SqmSubQuery subquery = (SqmSubQuery)argumentChild.accept((ParseTreeVisitor)this);
            return new SqmEvery(subquery, this.creationContext.getNodeBuilder());
        }
        if (argumentChild instanceof HqlParser.PredicateContext) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.FUNCTION_CALL);
            }
            SqmExpression argument = (SqmExpression)argumentChild.accept((ParseTreeVisitor)this);
            return this.applyOverClause((ParseTree)ctx, this.getFunctionDescriptor("every").generateAggregateSqmExpression(Collections.singletonList(argument), filterExpression, this.resolveExpressibleTypeBasic(Boolean.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration()));
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmEvery(this.createCollectionReferenceSubQuery((HqlParser.SimplePathContext)ctx.getChild(3), (TerminalNode)ctx.getChild(1)), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitAnyFunction(HqlParser.AnyFunctionContext ctx) {
        SqmPredicate filterExpression = this.getFilterExpression((ParseTree)ctx);
        ParseTree argumentChild = ctx.getChild(2);
        if (argumentChild instanceof HqlParser.SubqueryContext) {
            SqmSubQuery subquery = (SqmSubQuery)argumentChild.accept((ParseTreeVisitor)this);
            return new SqmAny(subquery, this.creationContext.getNodeBuilder());
        }
        if (argumentChild instanceof HqlParser.PredicateContext) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.FUNCTION_CALL);
            }
            SqmExpression argument = (SqmExpression)argumentChild.accept((ParseTreeVisitor)this);
            return this.applyOverClause((ParseTree)ctx, this.getFunctionDescriptor("any").generateAggregateSqmExpression(Collections.singletonList(argument), filterExpression, this.resolveExpressibleTypeBasic(Boolean.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration()));
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmAny(this.createCollectionReferenceSubQuery((HqlParser.SimplePathContext)ctx.getChild(3), (TerminalNode)ctx.getChild(1)), this.creationContext.getNodeBuilder());
    }

    private <X> SqmSubQuery<X> createCollectionReferenceSubQuery(HqlParser.SimplePathContext pathCtx, TerminalNode collectionReferenceCtx) {
        Join correlation;
        SqmPath<?> pluralAttributePath = this.consumeDomainPath(pathCtx);
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new PathException("Path is not a plural path '" + pluralAttributePath.getNavigablePath() + "'");
        }
        SqmSubQuery subQuery = new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.creationContext.getNodeBuilder());
        SqmSelectClause selectClause = new SqmSelectClause(false, 1, this.creationContext.getNodeBuilder());
        SqmFromClause fromClause = new SqmFromClause(1);
        JpaPath lhs = pluralAttributePath.getLhs();
        ArrayList<String> implicitJoinPaths = new ArrayList<String>();
        while (!(lhs instanceof AbstractSqmFrom)) {
            implicitJoinPaths.add(lhs.getNavigablePath().getLocalName());
            lhs = lhs.getLhs();
        }
        AbstractSqmFrom correlationBase = (AbstractSqmFrom)lhs;
        Join joinBase = correlation = correlationBase.createCorrelation();
        for (int i = implicitJoinPaths.size() - 1; i >= 0; --i) {
            joinBase = joinBase.join((String)implicitJoinPaths.get(i));
        }
        Join collectionJoin = joinBase.join(pluralAttributePath.getNavigablePath().getLocalName());
        fromClause.addRoot(correlation.getCorrelatedRoot());
        if (collectionReferenceCtx == null) {
            SqmLiteral<Integer> literal = new SqmLiteral<Integer>(1, this.creationContext.getNodeBuilder().getIntegerType(), this.creationContext.getNodeBuilder());
            subQuery.applyInferableType(literal.getNodeType());
            selectClause.setSelection(literal);
        } else {
            String partName;
            switch (collectionReferenceCtx.getSymbol().getType()) {
                case 73: {
                    partName = CollectionPart.Nature.ELEMENT.getName();
                    break;
                }
                case 102: {
                    partName = CollectionPart.Nature.INDEX.getName();
                    break;
                }
                default: {
                    throw new ParsingException("Unexpected collection reference : " + collectionReferenceCtx.getText());
                }
            }
            SemanticPathPart path = collectionJoin.resolvePathPart(partName, true, this);
            subQuery.applyInferableType(path.getNodeType());
            selectClause.setSelection((SqmSelectableNode<?>)((Object)path));
        }
        JpaQueryStructure querySpec = subQuery.getQuerySpec();
        ((SqmQuerySpec)querySpec).setFromClause(fromClause);
        ((SqmQuerySpec)querySpec).setSelectClause(selectClause);
        return subQuery;
    }

    private SqmOrderByClause getWithinGroup(ParseTree functionCtx) {
        HqlParser.WithinGroupClauseContext ctx = null;
        for (int i = functionCtx.getChildCount() - 3; i < functionCtx.getChildCount(); ++i) {
            ParseTree child = functionCtx.getChild(i);
            if (!(child instanceof HqlParser.WithinGroupClauseContext)) continue;
            ctx = (HqlParser.WithinGroupClauseContext)child;
            break;
        }
        if (ctx != null) {
            return this.visitOrderByClause((HqlParser.OrderByClauseContext)ctx.getChild(3));
        }
        return null;
    }

    private Boolean getFromFirst(ParseTree functionCtx) {
        int end = Math.min(functionCtx.getChildCount(), 5);
        for (int i = 3; i < end; ++i) {
            ParseTree child = functionCtx.getChild(i);
            if (!(child instanceof HqlParser.NthSideClauseContext)) continue;
            HqlParser.NthSideClauseContext subCtx = (HqlParser.NthSideClauseContext)child.getChild(6);
            return ((TerminalNode)subCtx.getChild(1)).getSymbol().getType() == 87;
        }
        return null;
    }

    private Boolean getRespectNullsClause(ParseTree functionCtx) {
        for (int i = functionCtx.getChildCount() - 3; i < functionCtx.getChildCount(); ++i) {
            ParseTree child = functionCtx.getChild(i);
            if (!(child instanceof HqlParser.NullsClauseContext)) continue;
            return ((TerminalNode)child.getChild(0)).getSymbol().getType() == 161;
        }
        return null;
    }

    private SqmPredicate getFilterExpression(ParseTree functionCtx) {
        for (int i = functionCtx.getChildCount() - 2; i < functionCtx.getChildCount(); ++i) {
            ParseTree child = functionCtx.getChild(i);
            if (!(child instanceof HqlParser.FilterClauseContext)) continue;
            return (SqmPredicate)child.getChild(2).getChild(1).accept((ParseTreeVisitor)this);
        }
        return null;
    }

    private SqmExpression<?> applyOverClause(ParseTree functionCtx, SqmFunction<?> function) {
        ParseTree lastChild = functionCtx.getChild(functionCtx.getChildCount() - 1);
        if (lastChild instanceof HqlParser.OverClauseContext) {
            return this.applyOverClause((HqlParser.OverClauseContext)lastChild, function);
        }
        return function;
    }

    private SqmExpression<?> applyOverClause(HqlParser.OverClauseContext ctx, SqmFunction<?> function) {
        FrameExclusion exclusion;
        SqmExpression startExpression;
        FrameKind startKind;
        SqmExpression endExpression;
        FrameKind endKind;
        FrameMode mode;
        List<SqmSortSpecification> orderList;
        List<SqmExpression<?>> partitions;
        block20: {
            block18: {
                block19: {
                    int frameStartIndex;
                    int index = 2;
                    if (ctx.getChild(index) instanceof HqlParser.PartitionClauseContext) {
                        ParseTree subCtx = ctx.getChild(index);
                        partitions = new ArrayList((subCtx.getChildCount() >> 1) - 1);
                        for (int i = 2; i < subCtx.getChildCount(); i += 2) {
                            partitions.add((SqmExpression)subCtx.getChild(i).accept((ParseTreeVisitor)this));
                        }
                        ++index;
                    } else {
                        partitions = Collections.emptyList();
                    }
                    if (index < ctx.getChildCount() && ctx.getChild(index) instanceof HqlParser.OrderByClauseContext) {
                        orderList = this.visitOrderByClause((HqlParser.OrderByClauseContext)ctx.getChild(index)).getSortSpecifications();
                        ++index;
                    } else {
                        orderList = Collections.emptyList();
                    }
                    if (index >= ctx.getChildCount() || !(ctx.getChild(index) instanceof HqlParser.FrameClauseContext)) break block18;
                    ParseTree frameCtx = ctx.getChild(index);
                    switch (((TerminalNode)frameCtx.getChild(0)).getSymbol().getType()) {
                        case 160: {
                            mode = FrameMode.RANGE;
                            break;
                        }
                        case 165: {
                            mode = FrameMode.ROWS;
                            break;
                        }
                        case 95: {
                            mode = FrameMode.GROUPS;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected frame mode: " + frameCtx.getChild(0));
                        }
                    }
                    if (frameCtx.getChild(1) instanceof TerminalNode) {
                        frameStartIndex = 2;
                        endKind = this.getFrameKind(frameCtx.getChild(4));
                        endExpression = endKind == FrameKind.OFFSET_FOLLOWING || endKind == FrameKind.OFFSET_PRECEDING ? (SqmExpression)frameCtx.getChild(4).getChild(0).accept((ParseTreeVisitor)this) : null;
                    } else {
                        frameStartIndex = 1;
                        endKind = FrameKind.CURRENT_ROW;
                        endExpression = null;
                    }
                    startKind = this.getFrameKind(frameCtx.getChild(frameStartIndex));
                    startExpression = startKind == FrameKind.OFFSET_FOLLOWING || startKind == FrameKind.OFFSET_PRECEDING ? (SqmExpression)frameCtx.getChild(frameStartIndex).getChild(0).accept((ParseTreeVisitor)this) : null;
                    ParseTree lastChild = frameCtx.getChild(frameCtx.getChildCount() - 1);
                    if (!(lastChild instanceof HqlParser.FrameExclusionContext)) break block19;
                    switch (((TerminalNode)lastChild.getChild(1)).getSymbol().getType()) {
                        case 61: {
                            exclusion = FrameExclusion.CURRENT_ROW;
                            break block20;
                        }
                        case 94: {
                            exclusion = FrameExclusion.GROUP;
                            break block20;
                        }
                        case 174: {
                            exclusion = FrameExclusion.TIES;
                            break block20;
                        }
                        case 137: {
                            exclusion = FrameExclusion.NO_OTHERS;
                            break block20;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected frame exclusion: " + lastChild);
                        }
                    }
                }
                exclusion = FrameExclusion.NO_OTHERS;
                break block20;
            }
            mode = FrameMode.ROWS;
            startKind = FrameKind.UNBOUNDED_PRECEDING;
            startExpression = null;
            endKind = FrameKind.CURRENT_ROW;
            endExpression = null;
            exclusion = FrameExclusion.NO_OTHERS;
        }
        return new SqmOver(function, partitions, orderList, mode, startKind, startExpression, endKind, endExpression, exclusion);
    }

    private FrameKind getFrameKind(ParseTree child) {
        switch (((TerminalNode)child.getChild(1)).getSymbol().getType()) {
            case 158: {
                if (child.getChild(0) instanceof TerminalNode) {
                    return FrameKind.UNBOUNDED_PRECEDING;
                }
                return FrameKind.OFFSET_PRECEDING;
            }
            case 88: {
                if (child.getChild(0) instanceof TerminalNode) {
                    return FrameKind.UNBOUNDED_FOLLOWING;
                }
                return FrameKind.OFFSET_FOLLOWING;
            }
            case 164: {
                return FrameKind.CURRENT_ROW;
            }
        }
        throw new IllegalArgumentException("Illegal frame kind: " + child);
    }

    @Override
    public SqmExpression<?> visitCube(HqlParser.CubeContext ctx) {
        return new SqmSummarization(SqmSummarization.Kind.CUBE, this.visitExpressions(ctx), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitRollup(HqlParser.RollupContext ctx) {
        return new SqmSummarization(SqmSummarization.Kind.ROLLUP, this.visitExpressions(ctx), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitSubstringFunction(HqlParser.SubstringFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmExpression start = (SqmExpression)ctx.getChild(4).accept((ParseTreeVisitor)this);
        SqmExpression length = ctx.getChildCount() == 8 ? (SqmExpression)ctx.getChild(6).accept((ParseTreeVisitor)this) : null;
        return this.getFunctionDescriptor("substring").generateSqmExpression(length == null ? Arrays.asList(source, start) : Arrays.asList(source, start, length), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitPadFunction(HqlParser.PadFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmExpression length = (SqmExpression)ctx.getChild(4).accept((ParseTreeVisitor)this);
        SqmTrimSpecification padSpec = this.visitPadSpecification((HqlParser.PadSpecificationContext)ctx.getChild(5));
        Object padChar = ctx.getChildCount() == 8 ? this.visitPadCharacter((HqlParser.PadCharacterContext)ctx.getChild(6)) : null;
        return this.getFunctionDescriptor("pad").generateSqmExpression(padChar != null ? Arrays.asList(source, length, padSpec, padChar) : Arrays.asList(source, length, padSpec), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmTrimSpecification visitPadSpecification(HqlParser.PadSpecificationContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 112: {
                return new SqmTrimSpecification(TrimSpec.LEADING, this.creationContext.getNodeBuilder());
            }
            case 179: {
                return new SqmTrimSpecification(TrimSpec.TRAILING, this.creationContext.getNodeBuilder());
            }
        }
        throw new ParsingException("Unsupported pad specification [" + ctx.getText() + "]");
    }

    @Override
    public SqmLiteral<Character> visitPadCharacter(HqlParser.PadCharacterContext ctx) {
        String padCharText = ctx.STRING_LITERAL().getText();
        if (padCharText.length() != 3) {
            throw new SemanticException("Pad character for pad() function must be single character, found '" + padCharText + "'");
        }
        return new SqmLiteral<Character>(Character.valueOf(padCharText.charAt(1)), this.resolveExpressibleTypeBasic(Character.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        SqmTrimSpecification trimSpec;
        SqmExpression source = (SqmExpression)ctx.getChild(ctx.getChildCount() - 2).accept((ParseTreeVisitor)this);
        int index = 2;
        ParseTree parseTree = ctx.getChild(index);
        if (parseTree instanceof HqlParser.TrimSpecificationContext) {
            trimSpec = this.visitTrimSpecification((HqlParser.TrimSpecificationContext)parseTree);
            index = 3;
        } else {
            trimSpec = this.visitTrimSpecification(null);
        }
        parseTree = ctx.getChild(index);
        Object trimChar = parseTree instanceof HqlParser.TrimCharacterContext ? this.visitTrimCharacter((HqlParser.TrimCharacterContext)parseTree) : this.visitTrimCharacter(null);
        return this.getFunctionDescriptor("trim").generateSqmExpression(Arrays.asList(trimSpec, trimChar, source), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmTrimSpecification visitTrimSpecification(HqlParser.TrimSpecificationContext ctx) {
        TrimSpec spec = TrimSpec.BOTH;
        if (ctx != null) {
            switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
                case 112: {
                    spec = TrimSpec.LEADING;
                    break;
                }
                case 179: {
                    spec = TrimSpec.TRAILING;
                }
            }
        }
        return new SqmTrimSpecification(spec, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmLiteral<Character> visitTrimCharacter(HqlParser.TrimCharacterContext ctx) {
        String trimCharText;
        String string = trimCharText = ctx != null ? QuotingHelper.unquoteStringLiteral(ctx.getText()) : " ";
        if (trimCharText.length() != 1) {
            throw new SemanticException("Trim character for trim() function must be single character, found '" + trimCharText + "'");
        }
        return new SqmLiteral<Character>(Character.valueOf(trimCharText.charAt(0)), this.resolveExpressibleTypeBasic(Character.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmCollectionSize visitCollectionSizeFunction(HqlParser.CollectionSizeFunctionContext ctx) {
        return new SqmCollectionSize(this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2)), this.resolveExpressibleTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
    }

    private boolean isIndexedPluralAttribute(SqmPath<?> path) {
        return path.getReferencedPathSource() instanceof PluralPersistentAttribute;
    }

    @Override
    public SqmPath<?> visitCollectionFunctionMisuse(HqlParser.CollectionFunctionMisuseContext ctx) {
        CollectionPart.Nature nature;
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath pluralAttributePath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        TerminalNode firstNode = (TerminalNode)ctx.getChild(0);
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new PathException(String.format("Argument of '%s' is not a plural path '%s'", firstNode.getSymbol().getText(), pluralAttributePath.getNavigablePath()));
        }
        switch (firstNode.getSymbol().getType()) {
            case 73: {
                nature = CollectionPart.Nature.ELEMENT;
                break;
            }
            case 102: {
                nature = CollectionPart.Nature.INDEX;
                break;
            }
            default: {
                throw new ParsingException("Impossible symbol");
            }
        }
        return pluralAttributePath.resolvePathPart(nature.getName(), true, this);
    }

    @Override
    public SqmElementAggregateFunction<?> visitElementAggregateFunction(HqlParser.ElementAggregateFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath<?> pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (!(pluralPath instanceof SqmPluralValuedSimplePath)) {
            throw new SemanticException("Path '" + ctx.path().getText() + "' did not resolve to a many-valued attribute");
        }
        String functionName = ctx.getChild(0).getText().substring(0, 3);
        return new SqmElementAggregateFunction(pluralPath, functionName);
    }

    @Override
    public SqmIndexAggregateFunction<?> visitIndexAggregateFunction(HqlParser.IndexAggregateFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath<?> pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (!(pluralPath instanceof SqmPluralValuedSimplePath)) {
            throw new SemanticException("Path '" + ctx.path().getText() + "' did not resolve to a many-valued attribute");
        }
        if (!this.isIndexedPluralAttribute(pluralPath)) {
            throw new SemanticException("maxindex() function can only be applied to path expressions which resolve to an indexed collection (list,map); specified path [" + ctx.path() + "] resolved to " + pluralPath.getReferencedPathSource());
        }
        String functionName = ctx.getChild(0).getText().substring(0, 3);
        return new SqmIndexAggregateFunction(pluralPath, functionName);
    }

    @Override
    public SqmSubQuery<?> visitSubqueryExpression(HqlParser.SubqueryExpressionContext ctx) {
        return this.visitSubquery((HqlParser.SubqueryContext)ctx.getChild(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSubQuery<?> visitSubquery(HqlParser.SubqueryContext ctx) {
        HqlParser.QueryExpressionContext queryExpressionContext = (HqlParser.QueryExpressionContext)ctx.getChild(0);
        SqmSubQuery subQuery = new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), subQuery, this));
        try {
            queryExpressionContext.accept(this);
            List<SqmSelection<?>> selections = ((SqmQuerySpec)subQuery.getQuerySpec()).getSelectClause().getSelections();
            if (selections.size() == 1) {
                subQuery.applyInferableType(selections.get(0).getNodeType());
            }
            SqmSubQuery sqmSubQuery = subQuery;
            return sqmSubQuery;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SemanticPathPart visitPath(HqlParser.PathContext ctx) {
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof HqlParser.SyntacticDomainPathContext) {
            SemanticPathPart syntacticNavigablePathResult = this.visitSyntacticDomainPath((HqlParser.SyntacticDomainPathContext)firstChild);
            if (ctx.getChildCount() == 2) {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(syntacticNavigablePathResult, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    SemanticPathPart semanticPathPart = (SemanticPathPart)ctx.getChild(1).accept((ParseTreeVisitor)this);
                    return semanticPathPart;
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            return syntacticNavigablePathResult;
        }
        if (firstChild instanceof HqlParser.GeneralPathFragmentContext) {
            return (SemanticPathPart)firstChild.accept((ParseTreeVisitor)this);
        }
        throw new ParsingException("Unrecognized `path` rule branch");
    }

    @Override
    public SemanticPathPart visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        return this.visitIndexedPathAccessFragment((HqlParser.SimplePathContext)ctx.getChild(0), ctx.getChildCount() == 1 ? null : (HqlParser.IndexedPathAccessFragmentContext)ctx.getChild(1));
    }

    @Override
    public SemanticPathPart visitSyntacticDomainPath(HqlParser.SyntacticDomainPathContext ctx) {
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof HqlParser.TreatedNavigablePathContext) {
            return this.visitTreatedNavigablePath((HqlParser.TreatedNavigablePathContext)firstChild);
        }
        if (firstChild instanceof HqlParser.CollectionValueNavigablePathContext) {
            return this.visitCollectionValueNavigablePath((HqlParser.CollectionValueNavigablePathContext)firstChild);
        }
        if (firstChild instanceof HqlParser.MapKeyNavigablePathContext) {
            return this.visitMapKeyNavigablePath((HqlParser.MapKeyNavigablePathContext)firstChild);
        }
        if (firstChild instanceof HqlParser.SimplePathContext && ctx.getChildCount() == 2) {
            return this.visitIndexedPathAccessFragment((HqlParser.SimplePathContext)firstChild, (HqlParser.IndexedPathAccessFragmentContext)ctx.getChild(1));
        }
        throw new ParsingException("Unsure how to process `syntacticDomainPath` over : " + ctx.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SemanticPathPart visitIndexedPathAccessFragment(HqlParser.SimplePathContext ctx, HqlParser.IndexedPathAccessFragmentContext idxCtx) {
        SemanticPathPart pathPart = this.visitSimplePath(ctx);
        if (idxCtx == null) {
            return pathPart;
        }
        SqmExpression indexExpression = (SqmExpression)idxCtx.getChild(1).accept((ParseTreeVisitor)this);
        boolean hasIndexContinuation = idxCtx.getChildCount() == 5;
        SqmPath<?> indexedPath = pathPart.resolveIndexedAccess(indexExpression, !hasIndexContinuation, this);
        if (hasIndexContinuation) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(indexedPath, this){

                @Override
                protected void reset() {
                }
            });
            try {
                SemanticPathPart semanticPathPart = (SemanticPathPart)idxCtx.getChild(4).accept((ParseTreeVisitor)this);
                return semanticPathPart;
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        return indexedPath;
    }

    @Override
    public SemanticPathPart visitIndexedPathAccessFragment(HqlParser.IndexedPathAccessFragmentContext idxCtx) {
        throw new UnsupportedOperationException("Should be handled by #visitIndexedPathAccessFragment");
    }

    @Override
    public SemanticPathPart visitSimplePath(HqlParser.SimplePathContext ctx) {
        int numberOfContinuations = ctx.getChildCount() - 1;
        boolean hasContinuations = numberOfContinuations != 0;
        DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
        HqlParser.IdentifierContext identifierContext = (HqlParser.IdentifierContext)ctx.getChild(0);
        assert (identifierContext.getChildCount() == 1);
        dotIdentifierConsumer.consumeIdentifier(this.visitIdentifier(identifierContext), true, !hasContinuations);
        if (hasContinuations) {
            for (int i = 1; i < ctx.getChildCount(); ++i) {
                HqlParser.SimplePathElementContext continuation = (HqlParser.SimplePathElementContext)ctx.getChild(i);
                HqlParser.IdentifierContext identifier = (HqlParser.IdentifierContext)continuation.getChild(1);
                assert (identifier.getChildCount() == 1);
                dotIdentifierConsumer.consumeIdentifier(this.visitIdentifier(identifier), false, i >= numberOfContinuations);
            }
        }
        return dotIdentifierConsumer.getConsumedPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx) {
        boolean madeNested;
        DotIdentifierConsumer consumer = this.dotIdentifierConsumerStack.getCurrent();
        if (consumer instanceof QualifiedJoinPathConsumer) {
            QualifiedJoinPathConsumer qualifiedJoinPathConsumer = (QualifiedJoinPathConsumer)consumer;
            boolean bl = madeNested = !qualifiedJoinPathConsumer.isNested();
            if (madeNested) {
                qualifiedJoinPathConsumer.setNested(true);
            }
        } else {
            madeNested = false;
        }
        this.consumeManagedTypeReference((HqlParser.PathContext)ctx.getChild(2));
        String treatTargetName = ctx.getChild(4).getText();
        String treatTargetEntityName = this.getCreationContext().getJpaMetamodel().qualifyImportableName(treatTargetName);
        boolean hasContinuation = ctx.getChildCount() == 7;
        consumer.consumeTreat(treatTargetEntityName, !hasContinuation);
        SqmPath<?> result = (SqmPath<?>)consumer.getConsumedPart();
        if (hasContinuation) {
            boolean addConsumer;
            if (madeNested) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            boolean bl = addConsumer = !(consumer instanceof QualifiedJoinPathConsumer);
            if (addConsumer) {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                    @Override
                    protected void reset() {
                    }
                });
            }
            try {
                result = this.consumeDomainPath((HqlParser.SimplePathContext)ctx.getChild(6).getChild(1));
            }
            finally {
                if (addConsumer) {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitCollectionValueNavigablePath(HqlParser.CollectionValueNavigablePathContext ctx) {
        SqmPath<?> result;
        PluralPersistentAttribute attribute;
        boolean madeNested;
        DotIdentifierConsumer consumer = this.dotIdentifierConsumerStack.getCurrent();
        if (consumer instanceof QualifiedJoinPathConsumer) {
            QualifiedJoinPathConsumer qualifiedJoinPathConsumer = (QualifiedJoinPathConsumer)consumer;
            boolean bl = madeNested = !qualifiedJoinPathConsumer.isNested();
            if (madeNested) {
                qualifiedJoinPathConsumer.setNested(true);
            }
        } else {
            madeNested = false;
        }
        SqmPath sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        boolean hasContinuation = ctx.getChildCount() == 5;
        SqmPathSource<?> referencedPathSource = sqmPath.getReferencedPathSource();
        TerminalNode firstNode = (TerminalNode)ctx.getChild(0);
        this.checkPluralPath(sqmPath, referencedPathSource, firstNode);
        if (this.getCreationOptions().useStrictJpaCompliance() && (attribute = (PluralPersistentAttribute)referencedPathSource).getCollectionClassification() != CollectionClassification.MAP && firstNode.getSymbol().getType() == 187) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.VALUE_FUNCTION_ON_NON_MAP);
        }
        if (consumer instanceof QualifiedJoinPathConsumer) {
            if (madeNested && !hasContinuation) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            consumer.consumeIdentifier(CollectionPart.Nature.ELEMENT.getName(), false, !hasContinuation);
            result = (SqmPath)consumer.getConsumedPart();
        } else {
            result = sqmPath.resolvePathPart(CollectionPart.Nature.ELEMENT.getName(), true, this);
        }
        if (hasContinuation) {
            if (madeNested) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            HqlParser.SimplePathContext identCtx = (HqlParser.SimplePathContext)ctx.getChild(4).getChild(1);
            if (consumer instanceof QualifiedJoinPathConsumer) {
                result = this.consumeDomainPath(identCtx);
            } else {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    result = this.consumeDomainPath(identCtx);
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitMapKeyNavigablePath(HqlParser.MapKeyNavigablePathContext ctx) {
        SqmPath<?> result;
        PluralPersistentAttribute attribute;
        boolean madeNested;
        DotIdentifierConsumer consumer = this.dotIdentifierConsumerStack.getCurrent();
        if (consumer instanceof QualifiedJoinPathConsumer) {
            QualifiedJoinPathConsumer qualifiedJoinPathConsumer = (QualifiedJoinPathConsumer)consumer;
            boolean bl = madeNested = !qualifiedJoinPathConsumer.isNested();
            if (madeNested) {
                qualifiedJoinPathConsumer.setNested(true);
            }
        } else {
            madeNested = false;
        }
        SqmPath sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        boolean hasContinuation = ctx.getChildCount() == 5;
        SqmPathSource<?> referencedPathSource = sqmPath.getReferencedPathSource();
        TerminalNode firstNode = (TerminalNode)ctx.getChild(0);
        this.checkPluralPath(sqmPath, referencedPathSource, firstNode);
        if (this.getCreationOptions().useStrictJpaCompliance() && (attribute = (PluralPersistentAttribute)referencedPathSource).getCollectionClassification() != CollectionClassification.MAP && firstNode.getSymbol().getType() == 110) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.KEY_FUNCTION_ON_NON_MAP);
        }
        if (sqmPath instanceof SqmMapJoin) {
            SqmMapJoin sqmMapJoin = (SqmMapJoin)sqmPath;
            if (consumer instanceof QualifiedJoinPathConsumer) {
                if (madeNested && !hasContinuation) {
                    ((QualifiedJoinPathConsumer)consumer).setNested(false);
                }
                consumer.consumeIdentifier(CollectionPart.Nature.INDEX.getName(), false, !hasContinuation);
                result = (SqmPath)consumer.getConsumedPart();
            } else {
                result = sqmMapJoin.key();
            }
        } else if (sqmPath instanceof SqmListJoin) {
            if (hasContinuation) {
                throw new SemanticException("list index may not be dereferenced");
            }
            SqmListJoin listJoin = (SqmListJoin)sqmPath;
            result = listJoin.resolvePathPart(CollectionPart.Nature.INDEX.getName(), true, this);
        } else {
            assert (sqmPath instanceof SqmPluralValuedSimplePath);
            SqmPluralValuedSimplePath mapPath = (SqmPluralValuedSimplePath)sqmPath;
            result = mapPath.resolvePathPart(CollectionPart.Nature.INDEX.getName(), !hasContinuation, this);
        }
        if (hasContinuation) {
            if (madeNested) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            HqlParser.SimplePathContext identCtx = (HqlParser.SimplePathContext)ctx.getChild(4).getChild(1);
            if (consumer instanceof QualifiedJoinPathConsumer) {
                result = this.consumeDomainPath(identCtx);
            } else {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    result = this.consumeDomainPath(identCtx);
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
        }
        return result;
    }

    private void checkPluralPath(SqmPath<?> pluralAttributePath, SqmPathSource<?> referencedPathSource, TerminalNode firstNode) {
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new PathException(String.format("Argument of '%s' is not a plural path '%s'", firstNode.getSymbol().getText(), pluralAttributePath.getNavigablePath()));
        }
    }

    private <X> SqmPath<X> consumeDomainPath(HqlParser.PathContext parserPath) {
        SemanticPathPart consumedPart = (SemanticPathPart)parserPath.accept(this);
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new SemanticException("Expecting domain-model path, but found : " + consumedPart);
    }

    private SqmPath<?> consumeDomainPath(HqlParser.SimplePathContext sequence) {
        SemanticPathPart consumedPart = (SemanticPathPart)sequence.accept(this);
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new SemanticException("Expecting domain-model path, but found : " + consumedPart);
    }

    private SqmPath<?> consumeManagedTypeReference(HqlParser.PathContext parserPath) {
        SqmPath sqmPath = this.consumeDomainPath(parserPath);
        SqmPathSource<?> pathSource = sqmPath.getReferencedPathSource();
        if (pathSource.getSqmPathType() instanceof ManagedDomainType) {
            return sqmPath;
        }
        throw new SemanticException("Expecting ManagedType valued path [" + sqmPath.getNavigablePath() + "], but found : " + pathSource.getSqmPathType());
    }

    private SqmPath<?> consumePluralAttributeReference(HqlParser.PathContext parserPath) {
        SqmPath sqmPath = this.consumeDomainPath(parserPath);
        if (sqmPath.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            return sqmPath;
        }
        throw new SemanticException("Expecting plural attribute valued path [" + sqmPath.getNavigablePath() + "], but found : " + sqmPath.getReferencedPathSource().getSqmPathType());
    }

    private void checkFQNEntityNameJpaComplianceViolationIfNeeded(String name, EntityDomainType<?> entityDescriptor) {
        if (this.getCreationOptions().useStrictJpaCompliance() && !name.equals(entityDescriptor.getName())) {
            throw new StrictJpaComplianceViolation("Encountered FQN entity name [" + name + "], but strict JPQL compliance was requested ( [" + entityDescriptor.getName() + "] should be used instead )", StrictJpaComplianceViolation.Type.FQN_ENTITY_NAME);
        }
    }

    static {
        HashSet<String> jpaStandardFunctions = new HashSet<String>();
        jpaStandardFunctions.add("avg");
        jpaStandardFunctions.add("max");
        jpaStandardFunctions.add("min");
        jpaStandardFunctions.add("sum");
        jpaStandardFunctions.add("count");
        jpaStandardFunctions.add("length");
        jpaStandardFunctions.add("locate");
        jpaStandardFunctions.add("abs");
        jpaStandardFunctions.add("sqrt");
        jpaStandardFunctions.add("mod");
        jpaStandardFunctions.add("size");
        jpaStandardFunctions.add("index");
        jpaStandardFunctions.add("current_date");
        jpaStandardFunctions.add("current_time");
        jpaStandardFunctions.add("current_timestamp");
        jpaStandardFunctions.add("concat");
        jpaStandardFunctions.add("substring");
        jpaStandardFunctions.add("trim");
        jpaStandardFunctions.add("lower");
        jpaStandardFunctions.add("upper");
        jpaStandardFunctions.add("coalesce");
        jpaStandardFunctions.add("nullif");
        JPA_STANDARD_FUNCTIONS = jpaStandardFunctions;
    }

    private static enum ParameterStyle {
        UNKNOWN{

            @Override
            ParameterStyle withNamed() {
                return NAMED;
            }

            @Override
            ParameterStyle withPositional() {
                return POSITIONAL;
            }
        }
        ,
        NAMED{

            @Override
            ParameterStyle withNamed() {
                return NAMED;
            }

            @Override
            ParameterStyle withPositional() {
                throw new StrictJpaComplianceViolation("Cannot mix ordinal and named parameters", StrictJpaComplianceViolation.Type.MIXED_POSITIONAL_NAMED_PARAMETERS);
            }
        }
        ,
        POSITIONAL{

            @Override
            ParameterStyle withNamed() {
                throw new StrictJpaComplianceViolation("Cannot mix positional and named parameters", StrictJpaComplianceViolation.Type.MIXED_POSITIONAL_NAMED_PARAMETERS);
            }

            @Override
            ParameterStyle withPositional() {
                return POSITIONAL;
            }
        }
        ,
        MIXED{

            @Override
            ParameterStyle withNamed() {
                return MIXED;
            }

            @Override
            ParameterStyle withPositional() {
                return MIXED;
            }
        };


        abstract ParameterStyle withNamed();

        abstract ParameterStyle withPositional();
    }
}

