/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmEmptinessPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmPluralValuedSimplePath<?> pluralPath;

    public SqmEmptinessPredicate(SqmPluralValuedSimplePath pluralPath, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.pluralPath = pluralPath;
    }

    @Override
    public SqmEmptinessPredicate copy(SqmCopyContext context) {
        SqmEmptinessPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmEmptinessPredicate predicate = context.registerCopy(this, new SqmEmptinessPredicate((SqmPluralValuedSimplePath)this.pluralPath.copy(context), this.isNegated(), this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmPluralValuedSimplePath<?> getPluralPath() {
        return this.pluralPath;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitIsEmptyPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.pluralPath.appendHqlString(sb);
        if (this.isNegated()) {
            sb.append(" is not empty");
        } else {
            sb.append(" is empty");
        }
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmEmptinessPredicate(this.pluralPath, !this.isNegated(), this.nodeBuilder());
    }
}

