/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.usertype.UserType;

public class StaticUserTypeSupport<T>
implements UserType<T> {
    private final BasicJavaType<T> javaType;
    private final JdbcType jdbcType;
    private final MutabilityPlan<T> mutabilityPlan;
    private final BasicValueConverter<T, Object> valueConverter;
    private final ValueExtractor<Object> jdbcValueExtractor;
    private final ValueBinder<Object> jdbcValueBinder;

    public StaticUserTypeSupport(BasicJavaType<T> javaType, JdbcType jdbcType) {
        this(javaType, jdbcType, javaType.getMutabilityPlan());
    }

    public StaticUserTypeSupport(BasicJavaType<T> javaType, JdbcType jdbcType, MutabilityPlan<T> mutabilityPlan) {
        this(javaType, jdbcType, mutabilityPlan, null);
    }

    public StaticUserTypeSupport(BasicJavaType<T> javaType, JdbcType jdbcType, BasicValueConverter<T, Object> valueConverter) {
        this(javaType, jdbcType, javaType.getMutabilityPlan(), valueConverter);
    }

    public StaticUserTypeSupport(BasicJavaType<T> javaType, JdbcType jdbcType, MutabilityPlan<T> mutabilityPlan, BasicValueConverter<T, Object> valueConverter) {
        this.javaType = javaType;
        this.jdbcType = jdbcType;
        this.mutabilityPlan = mutabilityPlan;
        this.valueConverter = valueConverter;
        this.jdbcValueExtractor = jdbcType.getExtractor(javaType);
        this.jdbcValueBinder = jdbcType.getBinder(javaType);
    }

    public BasicJavaType<T> getJavaType() {
        return this.javaType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public MutabilityPlan<T> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public BasicValueConverter<T, Object> getValueConverter() {
        return this.valueConverter;
    }

    public ValueExtractor<Object> getJdbcValueExtractor() {
        return this.jdbcValueExtractor;
    }

    public ValueBinder<Object> getJdbcValueBinder() {
        return this.jdbcValueBinder;
    }

    @Override
    public int getSqlType() {
        return this.jdbcType.getDefaultSqlTypeCode();
    }

    @Override
    public Class<T> returnedClass() {
        return this.javaType.getJavaTypeClass();
    }

    @Override
    public boolean equals(T x, T y) throws HibernateException {
        return this.javaType.areEqual(x, y);
    }

    @Override
    public int hashCode(T x) throws HibernateException {
        return this.javaType.extractHashCode(x);
    }

    @Override
    public T nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        Object extracted = this.jdbcValueExtractor.extract(rs, position, (WrapperOptions)session);
        if (this.valueConverter != null) {
            return this.valueConverter.toDomainValue(extracted);
        }
        return (T)extracted;
    }

    @Override
    public void nullSafeSet(PreparedStatement st, T value, int index, SharedSessionContractImplementor session) throws SQLException {
        Object valueToBind = this.valueConverter != null ? this.valueConverter.toRelationalValue(value) : value;
        this.jdbcValueBinder.bind(st, valueToBind, index, (WrapperOptions)session);
    }

    @Override
    public T deepCopy(T value) throws HibernateException {
        return this.javaType.getMutabilityPlan().deepCopy(value);
    }

    @Override
    public boolean isMutable() {
        return this.javaType.getMutabilityPlan().isMutable();
    }

    @Override
    public Serializable disassemble(T value) throws HibernateException {
        return this.javaType.getMutabilityPlan().disassemble(value, null);
    }

    @Override
    public T assemble(Serializable cached, Object owner) throws HibernateException {
        return this.javaType.getMutabilityPlan().assemble(cached, null);
    }

    @Override
    public T replace(T original, T target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }
}

