/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.star.resource;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jbossts.star.provider.HttpResponseException;
import org.jboss.jbossts.star.util.TxStatus;
import org.jboss.jbossts.star.util.TxSupport;
import org.jboss.logging.Logger;

public class RESTRecord
extends AbstractRecord
implements Comparable {
    protected static final Logger log = Logger.getLogger(RESTRecord.class);
    private String participantURI;
    private String terminateURI;
    String commitURI;
    String prepareURI;
    String rollbackURI;
    String commitOnePhaseURI;
    private String coordinatorURI;
    private String coordinatorID;
    private TxStatus status;
    private String txId;
    private boolean prepared;
    private String recoveryURI;
    private long age = System.currentTimeMillis();
    Fault fault = Fault.none;

    public RESTRecord() {
        this.status = TxStatus.TransactionStatusUnknown;
    }

    public RESTRecord(String txId, String coordinatorURI, String participantURI, String terminateURI) {
        super(new Uid());
        if (log.isTraceEnabled()) {
            log.tracef("RESTRecord(%s, %s, %s, %s)", new Object[]{coordinatorURI, participantURI, terminateURI, txId});
        }
        this.participantURI = participantURI;
        this.rollbackURI = this.commitOnePhaseURI = terminateURI;
        this.commitURI = this.commitOnePhaseURI;
        this.prepareURI = this.commitOnePhaseURI;
        this.terminateURI = this.commitOnePhaseURI;
        this.coordinatorURI = coordinatorURI;
        this.txId = txId;
        this.coordinatorID = this.get_uid().fileStringForm();
        this.status = TxStatus.TransactionActive;
        this.recoveryURI = "";
    }

    public RESTRecord(String txId, String coordinatorURI, String participantURI, String commitURI, String prepareURI, String rollbackURI, String commitOnePhaseURI) {
        this(txId, coordinatorURI, participantURI, null);
        if (log.isTraceEnabled()) {
            log.tracef("RESTRecord(%s, %s, %s, %s)", new Object[]{commitURI, prepareURI, rollbackURI, commitOnePhaseURI});
        }
        this.commitURI = commitURI;
        this.prepareURI = prepareURI;
        this.rollbackURI = rollbackURI;
        this.commitOnePhaseURI = commitOnePhaseURI;
    }

    public String getCoordinatorURI() {
        return this.coordinatorURI;
    }

    public String getTxId() {
        return this.txId;
    }

    public String getRecoveryURI() {
        return this.recoveryURI;
    }

    protected String getParticipantURI() {
        return this.participantURI;
    }

    public int typeIs() {
        return 165;
    }

    public Object value() {
        return this.status.name();
    }

    public String getStatus() {
        return this.status.name();
    }

    public long getAge() {
        return this.age;
    }

    public void setValue(Object o) {
    }

    public int nestedAbort() {
        return 7;
    }

    public int nestedCommit() {
        return 7;
    }

    public int nestedPrepare() {
        return 0;
    }

    private void check_suspend(Fault f) {
        if (this.fault.equals((Object)f)) {
            try {
                log.infof("%s: for 10 seconds", (Object)f);
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void check_halt(Fault f) {
        if (this.fault.equals((Object)f)) {
            log.infof("%s: halt VM", (Object)f);
            Runtime.getRuntime().halt(1);
        }
    }

    private int statusToOutcome() {
        return this.statusToOutcome(this.status);
    }

    private int statusToOutcome(TxStatus status) {
        block3: {
            try {
                if (!status.equals((Object)TxStatus.TransactionStatusUnknown)) {
                    return status.twoPhaseOutcome();
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)"Participant returned unknown status");
            }
        }
        return 8;
    }

    public boolean forgetHeuristic() {
        if (log.isTraceEnabled()) {
            log.tracef("forgetting heuristic for %s", (Object)this.participantURI);
        }
        try {
            new TxSupport().httpRequest(new int[]{200, 204}, this.participantURI, "DELETE", null);
            this.status = TxStatus.TransactionStatusUnknown;
        }
        catch (HttpResponseException e) {
            return false;
        }
        return super.forgetHeuristic();
    }

    public int topLevelPrepare() {
        if (log.isTraceEnabled()) {
            log.tracef("prepare %s", (Object)this.prepareURI);
        }
        this.check_halt(Fault.prepare_halt);
        this.check_suspend(Fault.prepare_suspend);
        if (this.fault.equals((Object)Fault.h_hazard)) {
            return 6;
        }
        if (this.prepareURI == null || this.txId == null) {
            return 2;
        }
        try {
            String body = new TxSupport().httpRequest(new int[]{200}, this.prepareURI, "PUT", "application/txstatus", TxSupport.toStatusContent((String)TxStatus.TransactionPrepared.name()));
            this.status = body.isEmpty() ? TxStatus.TransactionPrepared : TxStatus.fromStatus((String)TxSupport.getStatus((String)body));
            this.prepared = true;
            int outcome = this.statusToOutcome();
            if (outcome != 8) {
                return outcome;
            }
        }
        catch (HttpResponseException e) {
            if (this.checkFinishError(e.getActualResponse(), TxStatus.TransactionPrepared)) {
                this.status = TxStatus.TransactionPrepared;
                return 0;
            }
            this.status = TxStatus.TransactionRolledBack;
        }
        return 1;
    }

    public int topLevelAbort() {
        block4: {
            if (log.isTraceEnabled()) {
                log.debugf("trace %s", (Object)this.rollbackURI);
            }
            this.check_halt(Fault.abort_halt);
            this.check_suspend(Fault.abort_suspend);
            if (this.rollbackURI == null || this.txId == null) {
                return 8;
            }
            try {
                String body = new TxSupport().httpRequest(new int[]{200}, this.rollbackURI, "PUT", "application/txstatus", TxSupport.toStatusContent((String)TxStatus.TransactionRolledBack.name()));
                this.status = body.isEmpty() ? TxStatus.TransactionRolledBack : TxStatus.fromStatus((String)TxSupport.getStatus((String)body));
            }
            catch (HttpResponseException e) {
                if (!this.checkFinishError(e.getActualResponse(), TxStatus.TransactionRolledBack)) break block4;
                return 7;
            }
        }
        return this.statusToOutcome();
    }

    public int topLevelCommit() {
        if (log.isTraceEnabled()) {
            log.tracef("commit %s", (Object)this.commitURI);
        }
        if (this.commitURI == null || this.txId == null) {
            return 2;
        }
        if (!this.prepared) {
            return 9;
        }
        return this.doCommit(TxStatus.TransactionCommitted);
    }

    public int nestedOnePhaseCommit() {
        return 8;
    }

    public int topLevelOnePhaseCommit() {
        return this.doCommit(TxStatus.TransactionCommittedOnePhase);
    }

    private int doCommit(TxStatus nextState) {
        TxSupport txs = new TxSupport();
        this.check_halt(Fault.commit_halt);
        this.check_suspend(Fault.commit_suspend);
        if (this.txId == null) {
            return 8;
        }
        String commitUri = nextState == TxStatus.TransactionCommittedOnePhase && this.commitOnePhaseURI != null ? this.commitOnePhaseURI : this.commitURI;
        try {
            if (log.isTraceEnabled()) {
                log.tracef("committing %s", (Object)commitUri);
            }
            if (!TxStatus.TransactionReadOnly.equals((Object)this.status)) {
                txs = new TxSupport();
                String body = txs.httpRequest(new int[]{200}, commitUri, "PUT", "application/txstatus", TxSupport.toStatusContent((String)nextState.name()));
                this.status = body.isEmpty() ? TxStatus.TransactionCommitted : TxStatus.fromStatus((String)TxSupport.getStatus((String)body));
                if (log.isTraceEnabled()) {
                    log.tracef("commit http status: %s RTS status: %s", txs.getStatus(), (Object)this.status);
                }
            } else {
                this.status = TxStatus.TransactionCommitted;
            }
            if (log.isTraceEnabled()) {
                log.tracef("COMMIT OK at commitURI: %s", (Object)commitUri);
            }
        }
        catch (HttpResponseException e) {
            if (log.isDebugEnabled()) {
                log.debugf((Throwable)e, "commit exception: HTTP code: %s body: %s", e.getActualResponse(), (Object)txs.getBody());
            }
            if (e.getActualResponse() == 503) {
                log.trace((Object)"Finishing with TwoPhaseOutcome.FINISH_ERROR");
                return 8;
            }
            this.checkFinishError(e.getActualResponse(), nextState);
            this.status = TxStatus.fromStatus((String)txs.getBody());
        }
        return this.statusToOutcome(this.status);
    }

    private boolean checkFinishError(int expected, TxStatus nextState) throws HttpResponseException {
        block14: {
            if (expected == 404 && this.hasParticipantMoved()) {
                String uri;
                if (log.isDebugEnabled()) {
                    log.debugf("participant has moved commit to new participantURI %s", (Object)this.participantURI);
                }
                if (nextState.isCommit()) {
                    uri = this.commitURI;
                } else if (nextState.isAbort()) {
                    uri = this.rollbackURI;
                } else if (nextState.isPrepare()) {
                    uri = this.prepareURI;
                } else if (nextState.isCommitOnePhase()) {
                    uri = this.commitOnePhaseURI;
                } else {
                    this.status = TxStatus.TransactionActive;
                    return false;
                }
                try {
                    TxSupport.getStatus((String)new TxSupport().httpRequest(new int[]{200}, uri, "PUT", "application/txstatus", TxSupport.toStatusContent((String)nextState.name())));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Finish OK at new participantURI: %s" + this.participantURI));
                    }
                    this.status = nextState;
                    return true;
                }
                catch (HttpResponseException e1) {
                    if (log.isTraceEnabled()) {
                        log.tracef((Throwable)e1, "Finish still failing at new URI: ", new Object[0]);
                    }
                    if (!log.isInfoEnabled()) break block14;
                    log.debugf("participant %s commit error: %s", (Object)this.participantURI, (Object)e1.getMessage());
                }
            }
        }
        this.status = TxStatus.TransactionActive;
        return false;
    }

    private boolean hasParticipantMoved() {
        block13: {
            try {
                if (log.isTraceEnabled()) {
                    log.tracef("seeing if participant has moved: %s  recoveryURI: %s", (Object)this.coordinatorID, (Object)this.recoveryURI);
                }
                if (this.recoveryURI.length() == 0) {
                    return false;
                }
                HashMap links = new HashMap();
                new TxSupport().httpRequest(new int[]{200}, this.recoveryURI, "GET", "text/plain", null, links);
                String terminateURI = (String)links.get("terminator");
                if (links.containsKey("terminator")) {
                    this.participantURI = (String)links.get("participant");
                }
                if (terminateURI == null) {
                    String commitURI = (String)links.get("commit");
                    String prepareURI = (String)links.get("prepare");
                    String rollbackURI = (String)links.get("rollback");
                    String commitOnePhaseURI = (String)links.get("commit-one-phase");
                    if (commitURI != null) {
                        this.commitURI = commitURI;
                    }
                    if (prepareURI != null) {
                        this.prepareURI = prepareURI;
                    }
                    if (rollbackURI != null) {
                        this.rollbackURI = rollbackURI;
                    }
                    if (commitOnePhaseURI != null) {
                        this.commitOnePhaseURI = commitOnePhaseURI;
                    }
                    if (log.isTraceEnabled()) {
                        log.tracef("... yes it has - new terminate URIs (commit, prepare, rollback and commit one phase) are %s %s %s %s", new Object[]{commitURI != null ? commitURI : "", prepareURI != null ? prepareURI : "", rollbackURI != null ? rollbackURI : "", commitOnePhaseURI != null ? commitOnePhaseURI : ""});
                    }
                    if (this.commitURI != null && this.prepareURI != null && this.rollbackURI != null) {
                        return true;
                    }
                    break block13;
                }
                this.rollbackURI = this.commitOnePhaseURI = terminateURI;
                this.commitURI = this.commitOnePhaseURI;
                this.prepareURI = this.commitOnePhaseURI;
                this.terminateURI = this.commitOnePhaseURI;
                if (log.isTraceEnabled()) {
                    log.tracef("... yes it has - new terminateURI is %s", (Object)terminateURI);
                }
                return true;
            }
            catch (HttpResponseException e) {
                if (!log.isTraceEnabled()) break block13;
                log.tracef((Throwable)e, "participant has not moved: %s", (Object)e.getMessage());
            }
        }
        return false;
    }

    public boolean save_state(OutputObjectState os, int t) {
        try {
            os.packString(this.txId);
            os.packBoolean(this.prepared);
            os.packString(this.participantURI);
            os.packString(this.coordinatorURI);
            os.packString(this.recoveryURI);
            os.packString(this.coordinatorID);
            os.packString(this.status.name());
            os.packString(this.terminateURI);
            os.packString(this.commitURI);
            os.packString(this.prepareURI);
            os.packString(this.rollbackURI);
            os.packString(this.commitOnePhaseURI);
            return super.save_state(os, t);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean restore_state(InputObjectState os, int t) {
        try {
            this.txId = os.unpackString();
            this.prepared = os.unpackBoolean();
            this.participantURI = os.unpackString();
            this.coordinatorURI = os.unpackString();
            this.recoveryURI = os.unpackString();
            this.coordinatorID = os.unpackString();
            this.status = TxStatus.fromStatus((String)os.unpackString());
            this.terminateURI = os.unpackString();
            this.commitURI = os.unpackString();
            this.prepareURI = os.unpackString();
            this.rollbackURI = os.unpackString();
            this.commitOnePhaseURI = os.unpackString();
            if (this.commitURI == null) {
                this.rollbackURI = this.commitOnePhaseURI = this.terminateURI;
                this.commitURI = this.commitOnePhaseURI;
                this.prepareURI = this.commitOnePhaseURI;
            }
            if (log.isInfoEnabled()) {
                log.infof("restore_state %s", (Object)this.terminateURI);
            }
            return super.restore_state(os, t);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String type() {
        return RESTRecord.typeName();
    }

    public static String typeName() {
        return "/StateManager/AbstractRecord/RESTRecord";
    }

    public boolean doSave() {
        return true;
    }

    public void merge(AbstractRecord a) {
    }

    public void alter(AbstractRecord a) {
    }

    public boolean shouldAdd(AbstractRecord a) {
        return a.typeIs() == this.typeIs();
    }

    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    public void setRecoveryURI(String recoveryURI) {
        this.recoveryURI = recoveryURI;
    }

    public void setFault(String name) {
        for (Fault f : Fault.values()) {
            if (!f.name().equals(name)) continue;
            log.tracef("setFault: %s participantURI: %s", (Object)f, (Object)this.participantURI);
            this.fault = f;
            return;
        }
        this.fault = Fault.none;
    }

    public int compareTo(Object o) {
        AbstractRecord other = (AbstractRecord)o;
        if (this.lessThan(other)) {
            return -1;
        }
        if (this.greaterThan(other)) {
            return 1;
        }
        return 0;
    }

    public String httpRequest(int[] expect, String url, String method, String mediaType, String content, Map<String, String> linkHeaders, Map<String, String> reqHeaders) {
        return new TxSupport().httpRequest(expect, url, method, mediaType, content, linkHeaders, reqHeaders);
    }

    static enum Fault {
        abort_halt,
        abort_suspend,
        prepare_halt,
        prepare_suspend,
        commit_halt,
        commit_suspend,
        h_commit,
        h_rollback,
        h_hazard,
        h_mixed,
        none;

    }
}

