/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.messaging.Terminus;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.engine.Receiver;
import org.junit.Assert;
import org.junit.Test;

public class AmqpNonDurableReceiverTest
extends AmqpClientTestSupport {
    @Test(timeout=60000L)
    public void testLinkDetachReleasesResources() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.connect();
        AmqpSession session = connection.createSession();
        SimpleString simpleTopicName = SimpleString.toSimpleString((String)this.getTopicName());
        int bindingsBefore = this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().size();
        AmqpReceiver receiver = session.createReceiver(this.getTopicName());
        final AtomicBoolean remoteLinkClosed = new AtomicBoolean();
        AmqpNonDurableReceiverTest.assertEquals((String)"Unexpected source expiry policy", (Object)TerminusExpiryPolicy.LINK_DETACH, (Object)((Terminus)((Receiver)receiver.getEndpoint()).getSource()).getExpiryPolicy());
        receiver.setStateInspector(new AmqpValidator(){

            public void inspectDetachedResource(Receiver receiver) {
                super.inspectDetachedResource(receiver);
                Assert.fail((String)"Remote link detached in unexpected manner");
            }

            public void inspectClosedResource(Receiver receiver) {
                super.inspectClosedResource(receiver);
                remoteLinkClosed.set(true);
            }
        });
        AmqpNonDurableReceiverTest.assertEquals((String)"Unexpected number of bindings before attach", (long)(bindingsBefore + 1), (long)this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().size());
        receiver.detach();
        AmqpNonDurableReceiverTest.assertEquals((String)"Unexpected number of bindings after detach", (long)bindingsBefore, (long)this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().size());
        AmqpNonDurableReceiverTest.assertTrue((String)"Remote link was not closed", (boolean)remoteLinkClosed.get());
        receiver.getStateInspector().assertValid();
    }
}

