/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.junit.Assert;
import org.junit.Test;

public class AmqpSessionTest
extends AmqpClientTestSupport {
    @Test(timeout=60000L)
    public void testCreateSession() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSessionTest.assertNotNull((Object)session);
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSessionClosedDoesNotGetReceiverDetachFromRemote() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpSessionTest.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            public void inspectClosedResource(Session session) {
                AmqpSessionTest.this.instanceLog.debug((Object)("Session closed: " + session.getContext()));
            }

            public void inspectDetachedResource(Receiver receiver) {
                this.markAsInvalid("Broker should not detach receiver linked to closed session.");
            }

            public void inspectClosedResource(Receiver receiver) {
                this.markAsInvalid("Broker should not close receiver linked to closed session.");
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSessionTest.assertNotNull((Object)connection);
        AmqpSession session = connection.createSession();
        AmqpSessionTest.assertNotNull((Object)session);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        AmqpSessionTest.assertNotNull((Object)receiver);
        session.close();
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testCreateSessionProducerConsumerDoesNotLeakClosable() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSessionTest.assertNotNull((Object)session);
        for (int i = 0; i < 10; ++i) {
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            AmqpSender sender = session.createSender(this.getQueueName());
            receiver.close();
            sender.close();
        }
        AmqpSessionTest.assertEquals((long)1L, (long)this.server.getSessions().size());
        for (ServerSession serverSession : this.server.getSessions()) {
            Assert.assertNull((Object)((ServerSessionImpl)serverSession).getCloseables());
        }
        connection.close();
    }
}

