/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URI;
import java.util.Date;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Test;

public class JMSConnectionWithSecurityTest
extends JMSClientTestSupport {
    @Override
    protected boolean isSecurityEnabled() {
        return true;
    }

    @Override
    protected String getJmsConnectionURIOptions() {
        return "amqp.saslMechanisms=PLAIN";
    }

    @Test(timeout=10000L)
    public void testNoUserOrPassword() throws Exception {
        try (Connection connection = null;){
            connection = this.createConnection("", "", null, false);
            connection.start();
            JMSConnectionWithSecurityTest.fail((String)"Expected JMSException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testNoUserOrPasswordWithoutSaslRestrictions() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(new URI("amqp://localhost:5672"));
        try (Connection connection = null;){
            connection = factory.createConnection();
            connection.start();
            JMSConnectionWithSecurityTest.fail((String)"Expected Exception");
        }
    }

    @Test(timeout=10000L)
    public void testUnknownUser() throws Exception {
        try (Connection connection = null;){
            connection = this.createConnection("nosuchuser", "blah", null, false);
            connection.start();
            JMSConnectionWithSecurityTest.fail((String)"Expected JMSException");
        }
    }

    @Test(timeout=10000L)
    public void testKnownUserWrongPassword() throws Exception {
        try (Connection connection = null;){
            connection = this.createConnection(this.fullUser, "wrongPassword", null, false);
            connection.start();
            JMSConnectionWithSecurityTest.fail((String)"Expected JMSException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRepeatedWrongPasswordAttempts() throws Exception {
        for (int i = 0; i < 25; ++i) {
            try (Connection connection = null;){
                connection = this.createConnection(this.fullUser, "wrongPassword", null, false);
                connection.start();
                JMSConnectionWithSecurityTest.fail((String)"Expected JMSException");
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSendReceive() throws Exception {
        try (Connection connection = this.createConnection(this.fullUser, this.fullPass);){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            MessageProducer p = session.createProducer((Destination)queue);
            TextMessage message = null;
            message = session.createTextMessage();
            String messageText = "hello  sent at " + new Date().toString();
            message.setText(messageText);
            p.send((Message)message);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            Message msg = consumer.receive(5000L);
            JMSConnectionWithSecurityTest.assertNotNull((Object)msg);
            JMSConnectionWithSecurityTest.assertTrue((boolean)(msg instanceof TextMessage));
            TextMessage textMessage = (TextMessage)msg;
            JMSConnectionWithSecurityTest.assertEquals((Object)messageText, (Object)textMessage.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testConsumerNotAuthorized() throws Exception {
        try (Connection connection = this.createConnection(this.noprivUser, this.noprivPass);){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            try {
                session.createConsumer((Destination)queue);
                JMSConnectionWithSecurityTest.fail((String)"Should not be able to consume here.");
            }
            catch (JMSSecurityException jmsSE) {
                this.instanceLog.debug((Object)"Caught expected exception");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testBrowserNotAuthorized() throws Exception {
        try (Connection connection = this.createConnection(this.noprivUser, this.noprivPass);){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            try {
                QueueBrowser browser = session.createBrowser(queue);
                browser.getEnumeration();
                JMSConnectionWithSecurityTest.fail((String)"Should not be able to consume here.");
            }
            catch (JMSSecurityException jmsSE) {
                this.instanceLog.debug((Object)"Caught expected exception");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testConsumerNotAuthorizedToCreateQueues() throws Exception {
        try (Connection connection = this.createConnection(this.noprivUser, this.noprivPass);){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName(this.getPrecreatedQueueSize() + 1));
            try {
                session.createConsumer((Destination)queue);
                JMSConnectionWithSecurityTest.fail((String)"Should not be able to consume here.");
            }
            catch (JMSSecurityException jmsSE) {
                this.instanceLog.debug((Object)"Caught expected exception");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testProducerNotAuthorized() throws Exception {
        try (Connection connection = this.createConnection(this.guestUser, this.guestPass);){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            try {
                session.createProducer((Destination)queue);
                JMSConnectionWithSecurityTest.fail((String)"Should not be able to produce here.");
            }
            catch (JMSSecurityException jmsSE) {
                this.instanceLog.debug((Object)"Caught expected exception");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAnonymousProducerNotAuthorized() throws Exception {
        try (Connection connection = this.createConnection(this.guestUser, this.guestPass);){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer(null);
            try {
                producer.send((Destination)queue, (Message)session.createTextMessage());
                JMSConnectionWithSecurityTest.fail((String)"Should not be able to produce here.");
            }
            catch (JMSSecurityException jmsSE) {
                this.instanceLog.debug((Object)"Caught expected exception");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCreateTemporaryQueueNotAuthorized() throws JMSException {
        try (Connection connection = this.createConnection(this.guestUser, this.guestPass);){
            Session session = connection.createSession(false, 1);
            try {
                session.createTemporaryQueue();
            }
            catch (JMSSecurityException jmsse) {
                this.instanceLog.debug((Object)"Client should have thrown a JMSSecurityException but only threw JMSException");
            }
            JMSConnectionWithSecurityTest.assertNotNull((Object)connection.createSession(false, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCreateTemporaryTopicNotAuthorized() throws JMSException {
        try (Connection connection = this.createConnection(this.guestUser, this.guestPass);){
            Session session = connection.createSession(false, 1);
            try {
                session.createTemporaryTopic();
            }
            catch (JMSSecurityException jmsse) {
                this.instanceLog.debug((Object)"Client should have thrown a JMSSecurityException but only threw JMSException");
            }
            JMSConnectionWithSecurityTest.assertNotNull((Object)connection.createSession(false, 1));
        }
    }
}

