/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.largemessages;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQPLargeMessageOverCoreBridgeTest
extends AmqpClientTestSupport {
    private ActiveMQServer server2;

    @Before
    public void setServers() throws Exception {
        this.server.setIdentity("server1");
        this.server.getConfiguration().addAcceptorConfiguration("flow", "tcp://localhost:6666?protocols=CORE");
        this.server.start();
        this.createAddressAndQueues(this.server);
        this.server2 = this.createServer(5673, false);
        this.server2.start();
        this.createAddressAndQueues(this.server2);
    }

    private void receiveTextMessages(int port, String queue, String text, int numberOfMessages) throws Exception {
        AmqpClient client = this.createAmqpClient(new URI("tcp://localhost:" + port));
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(queue);
        receiver.flow(numberOfMessages + 1);
        for (int i = 0; i < numberOfMessages; ++i) {
            AmqpMessage message = receiver.receive(10L, TimeUnit.SECONDS);
            AMQPLargeMessageOverCoreBridgeTest.assertNotNull((Object)message);
            Assert.assertEquals((Object)text, (Object)message.getText());
            message.accept();
        }
        Assert.assertNull((Object)receiver.receiveNoWait());
        receiver.close();
        connection.close();
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTextMessages(int port, String destinationName, String text, int count) throws Exception {
        AmqpClient client = this.createAmqpClient(new URI("tcp://localhost:" + port));
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(destinationName);
            for (int i = 0; i < count; ++i) {
                AmqpMessage message = new AmqpMessage();
                message.setMessageId("MessageID:" + i);
                message.setDurable(true);
                message.setText(text);
                sender.send(message);
            }
        }
    }

    @Test(timeout=60000L)
    public void testCoreBridgeDivert() throws Exception {
        this.internalTest(true);
    }

    @Test(timeout=60000L)
    public void testCoreBridgeNoDivert() throws Exception {
        this.internalTest(false);
    }

    private void internalTest(boolean useDivert) throws Exception {
        this.server2.getConfiguration().addConnectorConfiguration("otherside", "tcp://localhost:6666");
        if (useDivert) {
            DivertConfiguration divertConf = new DivertConfiguration().setName("divert1").setRoutingName("divert1").setAddress(this.getQueueName(0)).setForwardingAddress(this.getQueueName(1));
            this.server2.deployDivert(divertConf);
        }
        this.server2.deployBridge(new BridgeConfiguration().setName(this.getTestName()).setQueueName(this.getQueueName(1)).setForwardingAddress(this.getQueueName(2)).setConfirmationWindowSize(10).setStaticConnectors(Arrays.asList("otherside")));
        StringBuffer largeText = new StringBuffer();
        while (largeText.length() < 307200) {
            largeText.append("Some large stuff ");
        }
        this.sendTextMessages(5673, this.getQueueName(useDivert ? 0 : 1), largeText.toString(), 10);
        this.receiveTextMessages(5672, this.getQueueName(2), largeText.toString(), 10);
        if (useDivert) {
            this.receiveTextMessages(5673, this.getQueueName(0), largeText.toString(), 10);
        } else {
            this.receiveTextMessages(5673, this.getQueueName(0), largeText.toString(), 0);
        }
        this.receiveTextMessages(5673, this.getQueueName(1), largeText.toString(), 0);
    }
}

