/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeTestAccessor;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AutoCreateTest
extends ActiveMQTestBase {
    private static final Logger logger = Logger.getLogger(AutoCreateTest.class);
    public final SimpleString addressA = new SimpleString("addressA");
    public final SimpleString queueA = new SimpleString("queueA");
    private ActiveMQServer server;

    @After
    public void clearLogg() {
        AssertionLoggerHandler.stopCapture();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        AddressSettings settings = new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true)).setAutoDeleteQueues(Boolean.valueOf(true));
        this.server.getConfiguration().getAddressesSettings().clear();
        this.server.getConfiguration().getAddressesSettings().put("#", settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCreateDeleteRecreate() throws Exception {
        Assert.assertEquals((String)"Supposed to use default configuration on this test", (long)ActiveMQDefaultConfiguration.getDefaultAddressQueueScanPeriod(), (long)this.server.getConfiguration().getAddressQueueScanPeriod());
        this.server.start();
        int THREADS = 40;
        ExecutorService executor = Executors.newFixedThreadPool(THREADS);
        try {
            String QUEUE_NAME = this.getName();
            AtomicInteger errors = new AtomicInteger(0);
            for (int i = 0; i < 50; ++i) {
                ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
                logger.debug((Object)"*******************************************************************************************************************************");
                logger.debug((Object)("run " + i));
                CyclicBarrier barrier = new CyclicBarrier(THREADS + 1);
                CountDownLatch done = new CountDownLatch(THREADS);
                Runnable consumerThread = () -> {
                    try (Connection connection = cf.createConnection();){
                        Session session = connection.createSession(false, 1);
                        barrier.await(10L, TimeUnit.SECONDS);
                        jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
                        MessageConsumer consumer = session.createConsumer((Destination)queue);
                        connection.start();
                    }
                    catch (Throwable e) {
                        logger.warn((Object)e.getMessage(), e);
                        errors.incrementAndGet();
                    }
                    finally {
                        done.countDown();
                    }
                };
                for (int t = 0; t < THREADS; ++t) {
                    executor.execute(consumerThread);
                }
                barrier.await(10L, TimeUnit.SECONDS);
                Assert.assertTrue((boolean)done.await(10L, TimeUnit.SECONDS));
                Assert.assertEquals((long)0L, (long)errors.get());
                try (Connection connection = cf.createConnection();){
                    Session session = connection.createSession(false, 1);
                    jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
                    MessageConsumer consumer = session.createConsumer((Destination)queue);
                    connection.start();
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.send((Message)session.createTextMessage("hello"));
                    Assert.assertNotNull((Object)consumer.receive(5000L));
                    continue;
                }
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testSweep() throws Exception {
        AssertionLoggerHandler.startCapture();
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        this.server.start();
        String QUEUE_NAME = "autoCreateAndRecreate";
        ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
        }
        connection = cf.createConnection();
        var4_4 = null;
        try {
            Queue serverQueue = this.server.locateQueue(QUEUE_NAME);
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
            Assert.assertTrue((boolean)serverQueue.isSwept());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Wait.assertFalse(() -> ((Queue)serverQueue).isSwept());
            connection.start();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var4_4 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
        AddressInfo info = this.server.getPostOffice().getAddressInfo(SimpleString.toSimpleString((String)QUEUE_NAME));
        Assert.assertNotNull((Object)info);
        Assert.assertTrue((boolean)info.isAutoCreated());
        PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224112"}));
        PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224112"}));
        Assert.assertTrue((String)"Queue name should be mentioned on logs", (boolean)AssertionLoggerHandler.findText((String[])new String[]{QUEUE_NAME}));
        PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224113"}));
    }

    @Test
    public void testSweepAddress() throws Exception {
        AssertionLoggerHandler.startCapture();
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        AddressSettings settings = new AddressSettings().setAutoDeleteQueues(Boolean.valueOf(true)).setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoDeleteAddressesDelay(10L).setAutoDeleteQueuesDelay(10L);
        this.server.getConfiguration().getAddressesSettings().clear();
        this.server.getConfiguration().getAddressesSettings().put("#", settings);
        this.server.start();
        String ADDRESS_NAME = this.getName();
        AddressInfo info = new AddressInfo(ADDRESS_NAME).addRoutingType(RoutingType.MULTICAST).setAutoCreated(true);
        this.server.getPostOffice().addAddressInfo(info);
        info = this.server.getPostOffice().getAddressInfo(SimpleString.toSimpleString((String)ADDRESS_NAME));
        ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(ADDRESS_NAME);
            session.createConsumer((Destination)topic);
        }
        AddressInfo infoRef = info;
        Wait.assertTrue(() -> infoRef.getBindingRemovedTimestamp() != -1L);
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224113"}));
        Thread.sleep(50L);
        Assert.assertFalse((boolean)info.isSwept());
        PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224113"}));
        Assert.assertTrue((boolean)info.isSwept());
        PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224113"}));
    }

    @Test
    public void testNegativeSweepAddress() throws Exception {
        Topic topic;
        Session session;
        AssertionLoggerHandler.startCapture();
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        AddressSettings settings = new AddressSettings().setAutoDeleteQueues(Boolean.valueOf(true)).setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoDeleteAddressesDelay(10L).setAutoDeleteQueuesDelay(10L);
        this.server.getConfiguration().getAddressesSettings().clear();
        this.server.getConfiguration().getAddressesSettings().put("#", settings);
        this.server.start();
        String ADDRESS_NAME = this.getName();
        AddressInfo info = new AddressInfo(ADDRESS_NAME).addRoutingType(RoutingType.MULTICAST).setAutoCreated(true);
        this.server.getPostOffice().addAddressInfo(info);
        info = this.server.getPostOffice().getAddressInfo(SimpleString.toSimpleString((String)ADDRESS_NAME));
        ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            session = connection.createSession(false, 1);
            topic = session.createTopic(ADDRESS_NAME);
            session.createConsumer((Destination)topic);
        }
        AddressInfo infoRef = info;
        Wait.assertTrue(() -> infoRef.getBindingRemovedTimestamp() != -1L);
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224113"}));
        Thread.sleep(50L);
        PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224113"}));
        Assert.assertTrue((boolean)info.isSwept());
        connection = cf.createConnection();
        var6_6 = null;
        try {
            session = connection.createSession(false, 1);
            topic = session.createTopic(ADDRESS_NAME);
            session.createConsumer((Destination)topic);
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224113"}));
            Assert.assertFalse((boolean)info.isSwept());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var6_6 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }

    @Test
    public void testNegativeSweepBecauseOfConsumer() throws Exception {
        AssertionLoggerHandler.startCapture();
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        this.server.start();
        String QUEUE_NAME = this.getName();
        ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
        }
        AddressInfo info = this.server.getPostOffice().getAddressInfo(SimpleString.toSimpleString((String)QUEUE_NAME));
        Assert.assertNotNull((Object)info);
        Assert.assertTrue((boolean)info.isAutoCreated());
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
            Queue serverQueue = this.server.locateQueue(QUEUE_NAME);
            Assert.assertTrue((boolean)serverQueue.isSwept());
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224112"}));
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
            Assert.assertFalse((boolean)serverQueue.isSwept());
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224113"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224112"}));
        }
    }

    @Test
    public void testNegativeSweepBecauseOfSend() throws Exception {
        AssertionLoggerHandler.startCapture();
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        this.server.start();
        String QUEUE_NAME = this.getName();
        ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
        }
        AddressInfo info = this.server.getPostOffice().getAddressInfo(SimpleString.toSimpleString((String)QUEUE_NAME));
        Assert.assertNotNull((Object)info);
        Assert.assertTrue((boolean)info.isAutoCreated());
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
            Queue serverQueue = this.server.locateQueue(QUEUE_NAME);
            Assert.assertTrue((boolean)serverQueue.isSwept());
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224112"}));
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("hello"));
            Wait.assertEquals((long)1L, () -> ((Queue)serverQueue).getMessageCount());
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
            Assert.assertFalse((boolean)serverQueue.isSwept());
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)((PostOfficeImpl)this.server.getPostOffice()));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224113"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224112"}));
        }
    }
}

