/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Before;
import org.junit.Test;

public class AMQPMessageRedistributionTest
extends ClusterTestBase {
    final String queue = "exampleQueue";
    final String broker0 = "amqp://localhost:61616";
    final String broker1 = "amqp://localhost:61617";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.start();
    }

    private void start() throws Exception {
        this.setupServers();
        this.setRedistributionDelay(0L);
    }

    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testMessageRedistributionWithoutDupAMQP() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "exampleQueue", "exampleQueue", null, true, null, null, RoutingType.ANYCAST);
        this.createQueue(1, "exampleQueue", "exampleQueue", null, true, null, null, RoutingType.ANYCAST);
        this.waitForBindings(0, "exampleQueue", 1, 0, true);
        this.waitForBindings(1, "exampleQueue", 1, 0, true);
        this.waitForBindings(0, "exampleQueue", 1, 0, false);
        this.waitForBindings(1, "exampleQueue", 1, 0, false);
        int NUMBER_OF_MESSAGES = 20;
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue("exampleQueue"));
        for (int i = 0; i < 20; ++i) {
            producer.send((Message)session.createTextMessage("hello " + i));
        }
        connection.close();
        this.receiveOnBothNodes(20);
    }

    private void receiveOnBothNodes(int NUMBER_OF_MESSAGES) throws Exception {
        this.receiveBroker("amqp://localhost:61617", 1);
        this.receiveBroker("amqp://localhost:61616", 1);
        this.receiveBrokerAll("amqp://localhost:61617", NUMBER_OF_MESSAGES - 2);
    }

    private void receiveBrokerAll(String brokerurl, int num) throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(brokerurl);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("exampleQueue"));
        connection.start();
        for (int i = 0; i < num; ++i) {
            TextMessage msg = (TextMessage)consumer.receive(5000L);
            AMQPMessageRedistributionTest.assertNotNull((Object)msg);
        }
        Message msg = consumer.receiveNoWait();
        AMQPMessageRedistributionTest.assertNull((Object)msg);
        connection.close();
    }

    private void receiveBroker(String brokerurl, int num) throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(brokerurl);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("exampleQueue"));
        connection.start();
        for (int i = 0; i < num; ++i) {
            Message msg = consumer.receive(5000L);
            AMQPMessageRedistributionTest.assertNotNull((Object)msg);
        }
        connection.close();
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "exampleQueue", messageLoadBalancingType, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "exampleQueue", messageLoadBalancingType, 1, this.isNetty(), 1, 0);
    }

    protected void setRedistributionDelay(long delay) {
        AddressSettings as = new AddressSettings().setRedistributionDelay(delay);
        this.getServer(0).getAddressSettingsRepository().addMatch("*", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("*", (Object)as);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.servers[0].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
        this.servers[1].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1);
        this.clearServer(0, 1);
    }
}

