/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AutomaticColocatedQuorumVoteTest
extends ActiveMQTestBase {
    private final boolean replicated;

    @Parameterized.Parameters(name="replicated={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public AutomaticColocatedQuorumVoteTest(boolean replicated) {
        this.replicated = replicated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleDistributionBackupStrategyFull() throws Exception {
        ActiveMQServer server0 = this.createServer(0, 1, false);
        ActiveMQServer server1 = this.createServer(1, 0, false);
        TransportConfiguration liveConnector0 = this.getConnectorTransportConfiguration("liveConnector0", 0);
        TransportConfiguration liveConnector1 = this.getConnectorTransportConfiguration("liveConnector1", 1);
        try (ServerLocator serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{liveConnector0});){
            server0.start();
            server1.start();
            ClientSessionFactory sessionFactory0 = serverLocator.createSessionFactory(liveConnector0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup((ClientSessionFactory)sessionFactory0, (int)10);
            ClientSessionFactory sessionFactory1 = serverLocator.createSessionFactory(liveConnector1);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup((ClientSessionFactory)sessionFactory1, (int)10);
            Topology topology = serverLocator.getTopology();
            Collection members = topology.getMembers();
            Assert.assertEquals((long)members.size(), (long)2L);
            Map backupServers0 = server0.getClusterManager().getHAManager().getBackupServers();
            Assert.assertEquals((long)backupServers0.size(), (long)1L);
            Map backupServers1 = server1.getClusterManager().getHAManager().getBackupServers();
            Assert.assertEquals((long)backupServers1.size(), (long)1L);
            ActiveMQServer backupServer0 = (ActiveMQServer)backupServers0.values().iterator().next();
            ActiveMQServer backupServer1 = (ActiveMQServer)backupServers1.values().iterator().next();
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization((ActiveMQServer)backupServer0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization((ActiveMQServer)backupServer1);
            Assert.assertEquals((Object)server0.getNodeID(), (Object)backupServer1.getNodeID());
            Assert.assertEquals((Object)server1.getNodeID(), (Object)backupServer0.getNodeID());
            Set backupAcceptors0 = backupServer0.getConfiguration().getAcceptorConfigurations();
            Assert.assertEquals((long)1L, (long)backupAcceptors0.size());
            Assert.assertEquals((Object)"61716", ((TransportConfiguration)backupAcceptors0.iterator().next()).getParams().get("port"));
            Set backupAcceptors1 = backupServer1.getConfiguration().getAcceptorConfigurations();
            Assert.assertEquals((long)1L, (long)backupAcceptors1.size());
            Assert.assertEquals((Object)"61717", ((TransportConfiguration)backupAcceptors1.iterator().next()).getParams().get("port"));
            Map connectorConfigurations0 = backupServer0.getConfiguration().getConnectorConfigurations();
            Assert.assertEquals((long)2L, (long)connectorConfigurations0.size());
            Assert.assertEquals((Object)"61716", ((TransportConfiguration)connectorConfigurations0.get("liveConnector0")).getParams().get("port"));
            Assert.assertEquals((Object)"61617", ((TransportConfiguration)connectorConfigurations0.get("remoteConnector0")).getParams().get("port"));
            Map connectorConfigurations1 = backupServer1.getConfiguration().getConnectorConfigurations();
            Assert.assertEquals((long)2L, (long)connectorConfigurations1.size());
            Assert.assertEquals((Object)"61717", ((TransportConfiguration)connectorConfigurations1.get("liveConnector1")).getParams().get("port"));
            Assert.assertEquals((Object)"61616", ((TransportConfiguration)connectorConfigurations1.get("remoteConnector1")).getParams().get("port"));
            if (!this.replicated) {
                Assert.assertEquals((Object)server0.getConfiguration().getJournalDirectory(), (Object)backupServer1.getConfiguration().getJournalDirectory());
                Assert.assertEquals((Object)server0.getConfiguration().getBindingsDirectory(), (Object)backupServer1.getConfiguration().getBindingsDirectory());
                Assert.assertEquals((Object)server0.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer1.getConfiguration().getLargeMessagesDirectory());
                Assert.assertEquals((Object)server0.getConfiguration().getPagingDirectory(), (Object)backupServer1.getConfiguration().getPagingDirectory());
                Assert.assertEquals((Object)server1.getConfiguration().getJournalDirectory(), (Object)backupServer0.getConfiguration().getJournalDirectory());
                Assert.assertEquals((Object)server1.getConfiguration().getBindingsDirectory(), (Object)backupServer0.getConfiguration().getBindingsDirectory());
                Assert.assertEquals((Object)server1.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer0.getConfiguration().getLargeMessagesDirectory());
                Assert.assertEquals((Object)server1.getConfiguration().getPagingDirectory(), (Object)backupServer0.getConfiguration().getPagingDirectory());
            } else {
                Assert.assertNotEquals((Object)server0.getConfiguration().getJournalDirectory(), (Object)backupServer1.getConfiguration().getJournalDirectory());
                Assert.assertNotEquals((Object)server0.getConfiguration().getBindingsDirectory(), (Object)backupServer1.getConfiguration().getBindingsDirectory());
                Assert.assertNotEquals((Object)server0.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer1.getConfiguration().getLargeMessagesDirectory());
                Assert.assertNotEquals((Object)server0.getConfiguration().getPagingDirectory(), (Object)backupServer1.getConfiguration().getPagingDirectory());
                Assert.assertNotEquals((Object)server1.getConfiguration().getJournalDirectory(), (Object)backupServer0.getConfiguration().getJournalDirectory());
                Assert.assertNotEquals((Object)server1.getConfiguration().getBindingsDirectory(), (Object)backupServer0.getConfiguration().getBindingsDirectory());
                Assert.assertNotEquals((Object)server1.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer0.getConfiguration().getLargeMessagesDirectory());
                Assert.assertNotEquals((Object)server1.getConfiguration().getPagingDirectory(), (Object)backupServer0.getConfiguration().getPagingDirectory());
            }
        }
        finally {
            try {
                server0.stop();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleDistributionBackupStrategyScaleDown() throws Exception {
        ActiveMQServer server0 = this.createServer(0, 1, true);
        ActiveMQServer server1 = this.createServer(1, 0, true);
        TransportConfiguration liveConnector0 = this.getConnectorTransportConfiguration("liveConnector0", 0);
        TransportConfiguration liveConnector1 = this.getConnectorTransportConfiguration("liveConnector1", 1);
        try (ServerLocator serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{liveConnector0});){
            server0.start();
            server1.start();
            ClientSessionFactory sessionFactory0 = serverLocator.createSessionFactory(liveConnector0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup((ClientSessionFactory)sessionFactory0, (int)10);
            ClientSessionFactory sessionFactory1 = serverLocator.createSessionFactory(liveConnector1);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup((ClientSessionFactory)sessionFactory1, (int)10);
            Topology topology = serverLocator.getTopology();
            Collection members = topology.getMembers();
            Assert.assertEquals((long)members.size(), (long)2L);
            Map backupServers0 = server0.getClusterManager().getHAManager().getBackupServers();
            Assert.assertEquals((long)backupServers0.size(), (long)1L);
            Map backupServers1 = server1.getClusterManager().getHAManager().getBackupServers();
            Assert.assertEquals((long)backupServers1.size(), (long)1L);
            ActiveMQServer backupServer0 = (ActiveMQServer)backupServers0.values().iterator().next();
            ActiveMQServer backupServer1 = (ActiveMQServer)backupServers1.values().iterator().next();
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization((ActiveMQServer)backupServer0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization((ActiveMQServer)backupServer1);
            Assert.assertEquals((Object)server0.getNodeID(), (Object)backupServer1.getNodeID());
            Assert.assertEquals((Object)server1.getNodeID(), (Object)backupServer0.getNodeID());
            Set backupAcceptors0 = backupServer0.getConfiguration().getAcceptorConfigurations();
            Assert.assertEquals((long)0L, (long)backupAcceptors0.size());
            Set backupAcceptors1 = backupServer1.getConfiguration().getAcceptorConfigurations();
            Assert.assertEquals((long)0L, (long)backupAcceptors1.size());
            Map connectorConfigurations0 = backupServer0.getConfiguration().getConnectorConfigurations();
            Assert.assertEquals((long)2L, (long)connectorConfigurations0.size());
            Assert.assertEquals((Object)"61616", ((TransportConfiguration)connectorConfigurations0.get("liveConnector0")).getParams().get("port"));
            Assert.assertEquals((Object)"61617", ((TransportConfiguration)connectorConfigurations0.get("remoteConnector0")).getParams().get("port"));
            Map connectorConfigurations1 = backupServer1.getConfiguration().getConnectorConfigurations();
            Assert.assertEquals((long)2L, (long)connectorConfigurations1.size());
            Assert.assertEquals((Object)"61617", ((TransportConfiguration)connectorConfigurations1.get("liveConnector1")).getParams().get("port"));
            Assert.assertEquals((Object)"61616", ((TransportConfiguration)connectorConfigurations1.get("remoteConnector1")).getParams().get("port"));
            if (!this.replicated) {
                Assert.assertEquals((Object)server0.getConfiguration().getJournalDirectory(), (Object)backupServer1.getConfiguration().getJournalDirectory());
                Assert.assertEquals((Object)server0.getConfiguration().getBindingsDirectory(), (Object)backupServer1.getConfiguration().getBindingsDirectory());
                Assert.assertEquals((Object)server0.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer1.getConfiguration().getLargeMessagesDirectory());
                Assert.assertEquals((Object)server0.getConfiguration().getPagingDirectory(), (Object)backupServer1.getConfiguration().getPagingDirectory());
                Assert.assertEquals((Object)server1.getConfiguration().getJournalDirectory(), (Object)backupServer0.getConfiguration().getJournalDirectory());
                Assert.assertEquals((Object)server1.getConfiguration().getBindingsDirectory(), (Object)backupServer0.getConfiguration().getBindingsDirectory());
                Assert.assertEquals((Object)server1.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer0.getConfiguration().getLargeMessagesDirectory());
                Assert.assertEquals((Object)server1.getConfiguration().getPagingDirectory(), (Object)backupServer0.getConfiguration().getPagingDirectory());
            } else {
                Assert.assertNotEquals((Object)server0.getConfiguration().getJournalDirectory(), (Object)backupServer1.getConfiguration().getJournalDirectory());
                Assert.assertNotEquals((Object)server0.getConfiguration().getBindingsDirectory(), (Object)backupServer1.getConfiguration().getBindingsDirectory());
                Assert.assertNotEquals((Object)server0.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer1.getConfiguration().getLargeMessagesDirectory());
                Assert.assertNotEquals((Object)server0.getConfiguration().getPagingDirectory(), (Object)backupServer1.getConfiguration().getPagingDirectory());
                Assert.assertNotEquals((Object)server1.getConfiguration().getJournalDirectory(), (Object)backupServer0.getConfiguration().getJournalDirectory());
                Assert.assertNotEquals((Object)server1.getConfiguration().getBindingsDirectory(), (Object)backupServer0.getConfiguration().getBindingsDirectory());
                Assert.assertNotEquals((Object)server1.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer0.getConfiguration().getLargeMessagesDirectory());
                Assert.assertNotEquals((Object)server1.getConfiguration().getPagingDirectory(), (Object)backupServer0.getConfiguration().getPagingDirectory());
            }
        }
        finally {
            try {
                server0.stop();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleDistributionOfBackupsMaxBackupsExceeded() throws Exception {
        ActiveMQServer server0 = this.createServer(0, 1, false);
        ActiveMQServer server1 = this.createServer(1, 0, false);
        ActiveMQServer server2 = this.createServer(2, 0, false);
        ActiveMQServer server3 = this.createServer(3, 0, false);
        TransportConfiguration liveConnector0 = this.getConnectorTransportConfiguration("liveConnector0", 0);
        TransportConfiguration liveConnector1 = this.getConnectorTransportConfiguration("liveConnector1", 1);
        TransportConfiguration liveConnector2 = this.getConnectorTransportConfiguration("liveConnector2", 2);
        TransportConfiguration liveConnector3 = this.getConnectorTransportConfiguration("liveConnector3", 3);
        try (ServerLocator serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{liveConnector0});){
            server0.start();
            server1.start();
            ClientSessionFactory sessionFactory0 = serverLocator.createSessionFactory(liveConnector0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup((ClientSessionFactory)sessionFactory0, (int)10);
            ClientSessionFactory sessionFactory1 = serverLocator.createSessionFactory(liveConnector1);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup((ClientSessionFactory)sessionFactory1, (int)10);
            Topology topology = serverLocator.getTopology();
            Collection members = topology.getMembers();
            Assert.assertEquals((long)members.size(), (long)2L);
            Map backupServers0 = server0.getClusterManager().getHAManager().getBackupServers();
            Assert.assertEquals((long)backupServers0.size(), (long)1L);
            Map backupServers1 = server1.getClusterManager().getHAManager().getBackupServers();
            Assert.assertEquals((long)backupServers1.size(), (long)1L);
            ActiveMQServer backupServer0 = (ActiveMQServer)backupServers0.values().iterator().next();
            ActiveMQServer backupServer1 = (ActiveMQServer)backupServers1.values().iterator().next();
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization((ActiveMQServer)backupServer0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization((ActiveMQServer)backupServer1);
            Assert.assertEquals((Object)server0.getNodeID(), (Object)backupServer1.getNodeID());
            Assert.assertEquals((Object)server1.getNodeID(), (Object)backupServer0.getNodeID());
            server2.start();
            ClientSessionFactory sessionFactory2 = serverLocator.createSessionFactory(liveConnector2);
            server3.start();
            ClientSessionFactory sessionFactory3 = serverLocator.createSessionFactory(liveConnector3);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup((ClientSessionFactory)sessionFactory2, (int)10);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup((ClientSessionFactory)sessionFactory3, (int)10);
            Assert.assertEquals((long)members.size(), (long)2L);
            Map backupServers2 = server2.getClusterManager().getHAManager().getBackupServers();
            Assert.assertEquals((long)backupServers2.size(), (long)1L);
            Map backupServers3 = server3.getClusterManager().getHAManager().getBackupServers();
            Assert.assertEquals((long)backupServers3.size(), (long)1L);
            ActiveMQServer backupServer2 = (ActiveMQServer)backupServers2.values().iterator().next();
            ActiveMQServer backupServer3 = (ActiveMQServer)backupServers3.values().iterator().next();
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization((ActiveMQServer)backupServer2);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization((ActiveMQServer)backupServer3);
            Assert.assertEquals((Object)server0.getNodeID(), (Object)backupServer1.getNodeID());
            Assert.assertEquals((Object)server1.getNodeID(), (Object)backupServer0.getNodeID());
            Assert.assertEquals((Object)server2.getNodeID(), (Object)backupServer3.getNodeID());
            Assert.assertEquals((Object)server3.getNodeID(), (Object)backupServer2.getNodeID());
        }
        finally {
            server0.stop();
            server1.stop();
            server2.stop();
            server3.stop();
        }
    }

    private ActiveMQServer createServer(int node, int remoteNode, boolean scaleDown) throws Exception {
        TransportConfiguration liveConnector = this.getConnectorTransportConfiguration("liveConnector" + node, node);
        TransportConfiguration remoteConnector = this.getConnectorTransportConfiguration("remoteConnector" + node, remoteNode);
        TransportConfiguration liveAcceptor = this.getAcceptorTransportConfiguration(node);
        Configuration liveConfiguration = this.getConfiguration("server" + node, scaleDown, liveConnector, liveAcceptor, remoteConnector);
        ActiveMQServerImpl server = new ActiveMQServerImpl(liveConfiguration);
        server.setIdentity("server" + node);
        return server;
    }

    private Configuration getConfiguration(String identity, boolean scaleDown, TransportConfiguration liveConnector, TransportConfiguration liveAcceptor, TransportConfiguration ... otherLiveNodes) throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(liveAcceptor).addConnectorConfiguration(liveConnector.getName(), liveConnector).setJournalDirectory(this.getJournalDir() + identity).setBindingsDirectory(this.getBindingsDir() + identity).setLargeMessagesDirectory(this.getLargeMessagesDir() + identity).setPagingDirectory(this.getPageDir() + identity).addQueueConfiguration(new QueueConfiguration("testQueue"));
        ArrayList<String> transportConfigurationList = new ArrayList<String>();
        ColocatedPolicyConfiguration haPolicy = new ColocatedPolicyConfiguration();
        for (TransportConfiguration otherLiveNode : otherLiveNodes) {
            configuration.addConnectorConfiguration(otherLiveNode.getName(), otherLiveNode);
            transportConfigurationList.add(otherLiveNode.getName());
            haPolicy.getExcludedConnectors().add(otherLiveNode.getName());
        }
        String[] input = new String[transportConfigurationList.size()];
        transportConfigurationList.toArray(input);
        configuration.addClusterConfiguration(AutomaticColocatedQuorumVoteTest.basicClusterConnectionConfig((String)liveConnector.getName(), (String[])input));
        haPolicy.setBackupPortOffset(100);
        haPolicy.setBackupRequestRetries(-1);
        haPolicy.setBackupRequestRetryInterval(500L);
        haPolicy.setMaxBackups(1);
        haPolicy.setRequestBackup(true);
        configuration.setHAPolicyConfiguration((HAPolicyConfiguration)haPolicy);
        if (!this.replicated) {
            SharedStoreMasterPolicyConfiguration ssmc = new SharedStoreMasterPolicyConfiguration();
            SharedStoreSlavePolicyConfiguration sssc = new SharedStoreSlavePolicyConfiguration();
            haPolicy.setLiveConfig((HAPolicyConfiguration)ssmc);
            haPolicy.setBackupConfig((HAPolicyConfiguration)sssc);
            if (scaleDown) {
                sssc.setScaleDownConfiguration(new ScaleDownConfiguration());
            }
        } else {
            ReplicatedPolicyConfiguration rpc = new ReplicatedPolicyConfiguration();
            ReplicaPolicyConfiguration rpc2 = new ReplicaPolicyConfiguration();
            haPolicy.setLiveConfig((HAPolicyConfiguration)rpc);
            haPolicy.setBackupConfig((HAPolicyConfiguration)rpc2);
            if (scaleDown) {
                rpc2.setScaleDownConfiguration(new ScaleDownConfiguration());
            }
        }
        return configuration;
    }

    private TransportConfiguration getAcceptorTransportConfiguration(int node) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("port", "" + (61616 + node));
        return new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params);
    }

    private TransportConfiguration getConnectorTransportConfiguration(String name, int node) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("port", "" + (61616 + node));
        return new TransportConfiguration(NETTY_CONNECTOR_FACTORY, params, name);
    }
}

