/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.tests.integration.cluster.failover.StaticClusterWithBackupFailoverTest;
import org.apache.activemq.artemis.utils.RetryMethod;
import org.apache.activemq.artemis.utils.RetryRule;
import org.junit.Rule;
import org.junit.Test;

public class QuorumResultWaitTest
extends StaticClusterWithBackupFailoverTest {
    @Rule
    public RetryRule retryRule = new RetryRule(0);
    public static final int QUORUM_VOTE_WAIT_CONFIGURED_TIME_SEC = 12;

    @Override
    protected void setupServers() throws Exception {
        super.setupServers();
        ((ReplicatedPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration()).setGroupName("group0");
        ((ReplicatedPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
        ((ReplicatedPolicyConfiguration)this.servers[2].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
        ((ReplicaPolicyConfiguration)this.servers[4].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
        ((ReplicaPolicyConfiguration)this.servers[5].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
        ReplicatedPolicyConfiguration replicatedPolicyConf = new ReplicatedPolicyConfiguration().setQuorumVoteWait(12);
        replicatedPolicyConf.setGroupName("group0");
        replicatedPolicyConf.setVoteRetries(5);
        replicatedPolicyConf.setVoteRetryWait(100L);
        this.servers[3].getConfiguration().setHAPolicyConfiguration((HAPolicyConfiguration)replicatedPolicyConf);
    }

    @RetryMethod(retries=2)
    @Test
    public void testQuorumVotingResultWait() throws Exception {
        this.setupCluster();
        try {
            this.startServers(0, 1, 2);
            this.startServers(3, 4, 5);
            QuorumResultWaitTest.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultQuorumVoteWait(), (long)((ReplicatedPolicy)this.servers[0].getHAPolicy()).getQuorumVoteWait());
            QuorumResultWaitTest.assertEquals((long)12L, (long)((ReplicatedPolicy)this.servers[3].getHAPolicy()).getQuorumVoteWait());
        }
        catch (Throwable throwable) {
            this.stopServers(0, 1, 2, 3, 4, 5);
            throw throwable;
        }
        this.stopServers(0, 1, 2, 3, 4, 5);
    }

    @Override
    protected boolean isSharedStorage() {
        return false;
    }
}

