/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.karaf;

import jakarta.inject.Inject;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueRequestor;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.log4j.Logger;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

@RunWith(value=PaxExam.class)
public class ArtemisFeatureTest
extends Assert {
    private static Logger log = Logger.getLogger((String)ArtemisFeatureTest.class.getName());
    @Inject
    BundleContext bundleContext;
    @Inject
    SessionFactory sessionFactory;
    ExecutorService executor = Executors.newCachedThreadPool();
    public static final long ASSERTION_TIMEOUT = 30000L;
    public static final long COMMAND_TIMEOUT = 30000L;
    public static final String USER = "artemis";
    public static final String PASSWORD = "artemis";

    @ProbeBuilder
    public TestProbeBuilder probeConfiguration(TestProbeBuilder probe) {
        probe.setHeader("DynamicImport-Package", "*,org.ops4j.pax.exam.options.*,org.apache.felix.service.*;status=provisional");
        return probe;
    }

    @Configuration
    public static Option[] configure() {
        return ArtemisFeatureTest.configure("artemis");
    }

    public static Option[] configure(String ... features) {
        ArrayList<String> f = new ArrayList<String>();
        f.addAll(Arrays.asList(features));
        Option[] options = new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("tar.gz").versionAsInProject()).unpackDirectory(new File("target/paxexam/unpack/")), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), KarafDistributionOption.editConfigurationFilePut((String)"etc/config.properties", (String)"karaf.startlevel.bundle", (Object)"50"), KarafDistributionOption.editConfigurationFilePut((String)"etc/users.properties", (String)"artemis", (Object)"artemis,manager"), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.url.mvn.cfg", (String)"org.ops4j.pax.url.mvn.repositories", (Object)"https://repo1.maven.org/maven2@id=central, https://repository.apache.org/content/groups/snapshots-group@id=apache@snapshots@noreleases, https://oss.sonatype.org/content/repositories/ops4j-snapshots@id=ops4j.sonatype.snapshots.deploy@snapshots@noreleases"), KarafDistributionOption.features((UrlReference)ArtemisFeatureTest.getArtemisMQKarafFeatureUrl(), (String[])f.toArray(new String[f.size()]))};
        return options;
    }

    public static UrlReference getArtemisMQKarafFeatureUrl() {
        String type = "xml/features";
        MavenArtifactProvisionOption urlReference = CoreOptions.mavenBundle().groupId("org.apache.activemq").artifactId("artemis-features").versionAsInProject().type(type);
        log.debug((Object)("FeatureURL: " + urlReference.getURL()));
        return urlReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void test() throws Throwable {
        this.executeCommand("bundle:list");
        this.withinReason(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Assert.assertTrue((String)"artemis bundle installed", (boolean)ArtemisFeatureTest.this.verifyBundleInstalled("artemis-server-osgi"));
                return true;
            }
        });
        Object service = this.waitForService("(objectClass=org.apache.activemq.artemis.core.server.ActiveMQServer)", 30000L);
        ArtemisFeatureTest.assertNotNull((Object)service);
        log.debug((Object)("have service " + service));
        this.executeCommand("service:list -n");
        try (Connection connection = null;){
            JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:5672");
            connection = factory.createConnection("artemis", "artemis");
            connection.start();
            QueueSession sess = (QueueSession)connection.createSession(false, 1);
            Queue queue = sess.createQueue("exampleQueue");
            MessageProducer producer = sess.createProducer((Destination)queue);
            producer.send((Message)sess.createTextMessage("TEST"));
            try (QueueBrowser browser = sess.createBrowser(queue);){
                Enumeration messages = browser.getEnumeration();
                while (messages.hasMoreElements()) {
                    messages.nextElement();
                }
            }
            Queue managementQueue = sess.createQueue("activemq.management");
            QueueRequestor requestor = new QueueRequestor(sess, managementQueue);
            connection.start();
            TextMessage m = sess.createTextMessage();
            m.setStringProperty("_AMQ_ResourceName", "broker");
            m.setStringProperty("_AMQ_OperationName", "getQueueNames");
            m.setText("[\"ANYCAST\"]");
            Message reply = requestor.request((Message)m);
            String json = ((TextMessage)reply).getText();
            JsonArray array = Json.createReader((Reader)new StringReader(json)).readArray();
            List queues = (List)array.get(0);
            ArtemisFeatureTest.assertNotNull((Object)queues);
            ArtemisFeatureTest.assertFalse((boolean)queues.isEmpty());
            MessageConsumer consumer = sess.createConsumer((Destination)queue);
            Message msg = consumer.receive(5000L);
            ArtemisFeatureTest.assertNotNull((Object)msg);
        }
    }

    protected String executeCommand(final String command, Long timeout, final Boolean silent) {
        String response;
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final PrintStream printStream = new PrintStream(byteArrayOutputStream);
        final Session commandSession = this.sessionFactory.create(System.in, printStream, printStream);
        commandSession.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
        FutureTask<String> commandFuture = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() {
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)new UserPrincipal("admin"));
                subject.getPrincipals().add((Principal)new RolePrincipal("admin"));
                subject.getPrincipals().add((Principal)new RolePrincipal("manager"));
                subject.getPrincipals().add((Principal)new RolePrincipal("viewer"));
                return Subject.doAs(subject, new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        try {
                            if (!silent.booleanValue()) {
                                System.out.println(command);
                                System.out.flush();
                            }
                            commandSession.execute((CharSequence)command);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        printStream.flush();
                        return byteArrayOutputStream.toString();
                    }
                });
            }
        });
        try {
            this.executor.submit(commandFuture);
            response = commandFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            response = "SHELL COMMAND TIMED OUT: ";
        }
        log.debug((Object)("Execute: " + command + " - Response:" + response));
        return response;
    }

    protected String executeCommand(String command) {
        return this.executeCommand(command, 30000L, false);
    }

    protected boolean withinReason(Callable<Boolean> callable) throws Throwable {
        long max = System.currentTimeMillis() + 30000L;
        while (true) {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                if (System.currentTimeMillis() < max) {
                    TimeUnit.SECONDS.sleep(1L);
                    continue;
                }
                throw t;
            }
            break;
        }
    }

    public boolean verifyBundleInstalled(String bundleName) throws Exception {
        boolean found = false;
        for (Bundle bundle : this.bundleContext.getBundles()) {
            log.debug((Object)("Checking: " + bundle.getSymbolicName()));
            if (!bundle.getSymbolicName().contains(bundleName)) continue;
            found = true;
            break;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object waitForService(String filter, long timeout) throws InvalidSyntaxException, InterruptedException {
        try (ServiceTracker st = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(filter), null);){
            st.open();
            Object object = st.waitForService(timeout);
            return object;
        }
    }
}

