/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.Before;
import org.junit.Test;

public class CompositeDestinationTest
extends BasicOpenWireTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AddressInfo addressInfo = new AddressInfo(new SimpleString("p.IN"), RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        addressInfo = new AddressInfo(new SimpleString("q.IN"), RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDurableSub() throws Exception {
        try (Connection conn = this.factory.createConnection();){
            conn.setClientID("my-client");
            conn.start();
            Session session = conn.createSession(false, 1);
            Topic topic = session.createTopic("p.IN,q.IN");
            TopicSubscriber sub1 = session.createDurableSubscriber(topic, "durable1", null, false);
            MessageProducer producer = session.createProducer((Destination)topic);
            int num = 10;
            for (int i = 0; i < 10; ++i) {
                producer.send((Message)session.createTextMessage("msg" + i));
            }
            int count = 0;
            TextMessage msg = (TextMessage)sub1.receive(2000L);
            while (msg != null) {
                ++count;
                msg = (TextMessage)sub1.receive(2000L);
            }
            CompositeDestinationTest.assertEquals((String)"Consumer should receive all messages from every topic", (long)20L, (long)count);
        }
    }
}

