/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCursorProviderImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryDatabase;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.AckDescribe;
import org.apache.activemq.artemis.core.persistence.impl.journal.DescribeJournal;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManagerImpl;
import org.apache.activemq.artemis.tests.integration.paging.PagingSendTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RetryRule;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PagingTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(PagingTest.class);
    @Rule
    public RetryRule retryMethod = new RetryRule(1);
    private static final Logger logger = Logger.getLogger(PagingTest.class);
    protected ServerLocator locator;
    protected ActiveMQServer server;
    protected ClientSessionFactory sf;
    static final int MESSAGE_SIZE = 1024;
    static final int LARGE_MESSAGE_SIZE = 102400;
    protected static final int RECEIVE_TIMEOUT = 5000;
    protected static final int PAGE_MAX = 102400;
    protected static final int PAGE_SIZE = 10240;
    protected final boolean mapped;
    protected final StoreConfiguration.StoreType storeType;
    static final SimpleString ADDRESS = new SimpleString("SimpleAddress");

    public PagingTest(StoreConfiguration.StoreType storeType, boolean mapped) {
        this.storeType = storeType;
        this.mapped = mapped;
    }

    @Parameterized.Parameters(name="storeType={0}, mapped={1}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{StoreConfiguration.StoreType.FILE, false}, {StoreConfiguration.StoreType.FILE, true}, {StoreConfiguration.StoreType.DATABASE, false}};
        return Arrays.asList(params);
    }

    @Before
    public void checkLoggerStart() throws Exception {
        AssertionLoggerHandler.startCapture();
    }

    @After
    public void checkLoggerEnd() throws Exception {
        try {
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"222214"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"222215"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testTooLongPageStoreTableNamePrefix() throws Exception {
        if (this.storeType == StoreConfiguration.StoreType.DATABASE) {
            Configuration config = this.createDefaultInVMConfig();
            DatabaseStorageConfiguration storageConfiguration = (DatabaseStorageConfiguration)config.getStoreConfiguration();
            storageConfiguration.setPageStoreTableName("PAGE_STORE_");
            int PAGE_MAX = 20480;
            int PAGE_SIZE = 10240;
            ActiveMQServer server = this.createServer(true, config, 10240, 20480L);
            server.start();
            Assert.assertNull((Object)server.getPagingManager());
            server.stop();
        }
    }

    @Test
    public void testPageOnLargeMessageMultipleQueues() throws Exception {
        this.internaltestOnLargetMessageMultipleQueues(1024, true);
    }

    @Test
    public void testPageOnLargeMessageMultipleQueuesNoPersistence() throws Exception {
        this.internaltestOnLargetMessageMultipleQueues(102400, false);
    }

    private void internaltestOnLargetMessageMultipleQueues(int messageSize, boolean enablePersistence) throws Exception, ActiveMQException {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        int PAGE_MAX = 20480;
        int PAGE_SIZE = 10240;
        ActiveMQServer server = this.createServer(enablePersistence, config, 10240, 20480L);
        server.start();
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        ClientSession session = sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS.concat("-0")).setAddress(ADDRESS));
        session.createQueue(new QueueConfiguration(ADDRESS.concat("-1")).setAddress(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        for (int i = 0; i < 201; ++i) {
            message = session.createMessage(true);
            message.getBodyBuffer().writerIndex(0);
            message.getBodyBuffer().writeBytes(new byte[messageSize]);
            for (int j = 1; j <= messageSize; ++j) {
                message.getBodyBuffer().writeInt(j);
            }
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.close();
        for (int ad = 0; ad < 2; ++ad) {
            ClientMessage message2;
            int i;
            session = sf.createSession(false, false, false);
            ClientConsumer consumer = session.createConsumer(ADDRESS.concat("-" + ad));
            session.start();
            for (i = 0; i < 201; ++i) {
                message2 = consumer.receive(10000L);
                Assert.assertNotNull((Object)message2);
                message2.acknowledge();
                Assert.assertNotNull((Object)message2);
            }
            if (ad > -1) {
                session.commit();
            } else {
                session.rollback();
                for (i = 0; i < 100; ++i) {
                    message2 = consumer.receive(10000L);
                    Assert.assertNotNull((Object)message2);
                    message2.acknowledge();
                    Assert.assertNotNull((Object)message2);
                }
                session.commit();
            }
            consumer.close();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageTX() throws Exception {
        AssertionLoggerHandler.startCapture();
        try {
            Configuration config = this.createDefaultInVMConfig();
            int PAGE_MAX = 20480;
            int PAGE_SIZE = 10240;
            ActiveMQServer server = this.createServer(true, config, 10240, 20480L);
            server.start();
            int numberOfBytes = 1024;
            this.locator.setBlockOnNonDurableSend(false).setBlockOnDurableSend(false).setBlockOnAcknowledge(false);
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
            ClientSession session = sf.createSession(null, null, false, false, false, false, 0);
            session.createQueue(new QueueConfiguration(ADDRESS.concat("-0")).setAddress(ADDRESS));
            server.getPagingManager().getPageStore(ADDRESS).forceAnotherPage();
            server.getPagingManager().getPageStore(ADDRESS).disableCleanup();
            session.start();
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientConsumer browserConsumer = session.createConsumer(ADDRESS.concat("-0"), true);
            ClientMessage message = null;
            for (int i = 0; i < 201; ++i) {
                message = session.createMessage(true);
                message.getBodyBuffer().writerIndex(0);
                message.getBodyBuffer().writeBytes(new byte[1024]);
                for (int j = 1; j <= 1024; ++j) {
                    message.getBodyBuffer().writeInt(j);
                }
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
                session.commit();
            }
            ClientConsumer consumer = session.createConsumer(ADDRESS.concat("-0"));
            session.start();
            for (int i = 0; i < 201; ++i) {
                ClientMessage message2 = consumer.receive(10000L);
                Assert.assertNotNull((Object)message2);
                message2.acknowledge();
                Assert.assertNotNull((Object)message2);
                session.commit();
            }
            consumer.close();
            org.apache.activemq.artemis.core.server.Queue queue = server.locateQueue(ADDRESS.concat("-0"));
            PagingStore store = server.getPagingManager().getPageStore(ADDRESS);
            PageCursorProvider provider = store.getCursorProvider();
            PageSubscription cursorSubscription = provider.getSubscription(queue.getID().longValue());
            PageIterator iterator = cursorSubscription.iterator();
            for (int i = 0; i < 5; ++i) {
                Assert.assertFalse((boolean)iterator.hasNext());
                Assert.assertNull((Object)browserConsumer.receiveImmediate());
            }
            session.close();
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"Could not locate page"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222029"}));
            server.getPagingManager().getPageStore(ADDRESS).enableCleanup();
            Wait.assertFalse(() -> ((PagingStore)server.getPagingManager().getPageStore(ADDRESS)).isPaging());
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    @Test
    public void testPageCleanup() throws Exception {
        ActiveMQBuffer bodyLocal;
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 5000;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (i = 0; i < 5000; ++i) {
            message = session.createMessage(true);
            bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        session.close();
        session = this.sf.createSession(false, false, false);
        producer = session.createProducer(ADDRESS);
        producer.send((org.apache.activemq.artemis.api.core.Message)session.createMessage(true));
        session.rollback();
        producer.close();
        session.close();
        session = this.sf.createSession(false, false, false);
        producer = session.createProducer(ADDRESS);
        for (i = 0; i < 5000; ++i) {
            message = session.createMessage(true);
            bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        session.close();
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        session = this.sf.createSession(false, false, false);
        session.start();
        Wait.assertEquals((long)10000L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        ClientMessage msg = null;
        for (int i2 = 0; i2 < 10000; ++i2) {
            msg = consumer.receive(1000L);
            PagingTest.assertNotNull((Object)msg);
            msg.acknowledge();
            if (i2 % 500 != 0) continue;
            session.commit();
        }
        session.commit();
        consumer.close();
        session.close();
        this.sf.close();
        this.locator.close();
        Wait.assertEquals((long)0L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        this.waitForNotPaging(queue);
        this.server.stop();
    }

    @Test
    public void testPageReload() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultConfig(true).setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(this.getName()).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(this.getName()).setRoutingType(RoutingType.ANYCAST));
        org.apache.activemq.artemis.core.server.Queue serverQueue = this.server.locateQueue(this.getName());
        ConnectionFactory factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue jmsQueue = session.createQueue(this.getName());
            serverQueue.getPagingStore().startPaging();
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 10; ++j) {
                    producer.send(session.createMessage());
                }
                serverQueue.getPagingStore().forceAnotherPage();
            }
        }
        long tx = this.server.getStorageManager().generateID();
        this.server.getStorageManager().storePageCompleteTransactional(tx, serverQueue.getID().longValue(), (PagePosition)new PagePositionImpl(1L, 10));
        this.server.getStorageManager().commit(tx);
        this.server.getStorageManager().storeCursorAcknowledge(serverQueue.getID().longValue(), (PagePosition)new PagePositionImpl(1L, 0));
        this.server.stop();
        this.server.start();
        org.apache.activemq.artemis.core.server.Queue serverQueueAfterRestart = this.server.locateQueue(this.getName());
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue jmsQueue = session.createQueue(this.getName());
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
            for (int i = 0; i < 90; ++i) {
                Message message = consumer.receive(1000L);
                Assert.assertNotNull((Object)message);
            }
            Assert.assertNull((Object)consumer.receiveNoWait());
            Wait.assertFalse(() -> ((PagingStore)serverQueueAfterRestart.getPagingStore()).isPaging());
        }
    }

    @Test
    public void testQueueRemoveAll() throws Exception {
        ActiveMQBuffer bodyLocal;
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 5000;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (i = 0; i < 5000; ++i) {
            message = session.createMessage(true);
            bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        session.close();
        session = this.sf.createSession(false, false, false);
        producer = session.createProducer(ADDRESS);
        producer.send((org.apache.activemq.artemis.api.core.Message)session.createMessage(true));
        session.rollback();
        producer.close();
        session.close();
        session = this.sf.createSession(false, false, false);
        producer = session.createProducer(ADDRESS);
        for (i = 0; i < 5000; ++i) {
            message = session.createMessage(true);
            bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        session.close();
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        Wait.assertEquals((long)10000L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        QueueControl queueControl = (QueueControl)this.server.getManagementService().getResource("queue." + PagingSendTest.ADDRESS);
        int removedMessages = queueControl.removeAllMessages();
        Assert.assertEquals((long)10000L, (long)removedMessages);
    }

    @Test
    public void testPageCleanupWithInvalidData() throws Exception {
        int i;
        Assume.assumeTrue((this.storeType != StoreConfiguration.StoreType.DATABASE ? (byte)1 : 0) != 0);
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 100;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[10];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 10; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        queue.getPagingStore().startPaging();
        queue.getPagingStore().forceAnotherPage();
        for (int i2 = 0; i2 < 100; ++i2) {
            if (i2 % 10 == 0 && i2 > 0) {
                queue.getPagingStore().forceAnotherPage();
            }
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty("i", i2);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        queue.getPagingStore().getCursorProvider().disableCleanup();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i3 = 0; i3 < 11; ++i3) {
            ClientMessage msgRec = consumer.receive(1000L);
            Assert.assertNotNull((Object)msgRec);
            msgRec.acknowledge();
        }
        session.commit();
        consumer.close();
        consumer = session.createConsumer(ADDRESS, SimpleString.toSimpleString((String)"i=29"));
        message = consumer.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        session.commit();
        File folder = queue.getPagingStore().getFolder();
        for (int f = 2; f <= 3; ++f) {
            String fileName = ((PagingStoreImpl)queue.getPagingStore()).createFileName(f);
            File file = new File(folder, fileName);
            file.delete();
            file.createNewFile();
        }
        this.sf.close();
        this.server.getStorageManager().getMessageJournal().scheduleCompactAndBlock(5000);
        Page page4 = queue.getPagingStore().createPage(4);
        page4.open();
        List messagesRead = page4.read(this.server.getStorageManager());
        Assert.assertEquals((long)10L, (long)messagesRead.size());
        page4.close(false);
        page4.delete(null);
        page4.open();
        for (i = 0; i < 9; ++i) {
            page4.write((PagedMessage)messagesRead.get(i));
        }
        page4.close(false);
        this.server.stop();
        this.server.start();
        queue = this.server.locateQueue(ADDRESS);
        Assert.assertTrue((boolean)queue.getPagingStore().isPaging());
        queue.getPageSubscription().enableAutoCleanup();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, true, true);
        consumer = session.createConsumer(ADDRESS);
        session.start();
        for (i = 20; i < 100; ++i) {
            if (i == 29) continue;
            ClientMessage msgClient = consumer.receive(1000L);
            Assert.assertNotNull((Object)msgClient);
            Assert.assertEquals((long)i, (long)msgClient.getIntProperty("i").intValue());
            msgClient.acknowledge();
        }
        ClientMessage msgClient = consumer.receiveImmediate();
        Assert.assertNull((Object)msgClient);
        session.commit();
        Wait.assertFalse(() -> ((PagingStore)queue.getPagingStore()).isPaging());
    }

    @Test
    public void testQueueRetryMessages() throws Exception {
        ActiveMQBuffer bodyLocal;
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 500;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS + "Queue").setAddress(ADDRESS));
        session.createQueue(new QueueConfiguration(ADDRESS + "QueueOriginal").setAddress(ADDRESS + "Original"));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (i = 0; i < 500; ++i) {
            message = session.createMessage(true);
            bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            message.putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_ADDRESS, ADDRESS + "Original");
            message.putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_QUEUE, ADDRESS + "QueueOriginal");
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        session.close();
        session = this.sf.createSession(false, false, false);
        producer = session.createProducer(ADDRESS);
        producer.send((org.apache.activemq.artemis.api.core.Message)session.createMessage(true));
        session.rollback();
        producer.close();
        session.close();
        session = this.sf.createSession(false, false, false);
        producer = session.createProducer(ADDRESS);
        for (i = 0; i < 500; ++i) {
            message = session.createMessage(true);
            bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            message.putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_ADDRESS, ADDRESS + "Original");
            message.putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_QUEUE, ADDRESS + "QueueOriginal");
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        session.close();
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(new SimpleString(ADDRESS + "Queue"));
        org.apache.activemq.artemis.core.server.Queue originalQueue = this.server.locateQueue(new SimpleString(ADDRESS + "QueueOriginal"));
        Wait.assertEquals((long)2000L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((org.apache.activemq.artemis.core.server.Queue)originalQueue).getMessageCount());
        QueueControl queueControl = (QueueControl)this.server.getManagementService().getResource("queue." + PagingSendTest.ADDRESS + "Queue");
        QueueControl originalQueueControl = (QueueControl)this.server.getManagementService().getResource("queue." + PagingSendTest.ADDRESS + "QueueOriginal");
        queueControl.retryMessages();
        Wait.assertEquals((long)1000L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount(), (long)5000L);
        Wait.assertEquals((long)1000L, () -> ((org.apache.activemq.artemis.core.server.Queue)originalQueue).getMessageCount(), (long)5000L);
    }

    @Test
    public void testEmptyAddress() throws Exception {
        if (this.storeType == StoreConfiguration.StoreType.FILE) {
            this.clearDataRecreateServerDirs();
            Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
            this.server = this.createServer(true, config, 10240, 102400L);
            this.server.start();
            int numberOfMessages = 5000;
            this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            this.sf = this.createSessionFactory(this.locator);
            ClientSession session = this.sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
            ClientProducer producer = session.createProducer(ADDRESS);
            byte[] body = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(body);
            for (int j = 1; j <= 1024; ++j) {
                bb.put(PagingTest.getSamplebyte((long)j));
            }
            for (int i = 0; i < 5000; ++i) {
                ClientMessage message = session.createMessage(true);
                message.getBodyBuffer().writeBytes(body);
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
                if (i % 1000 != 0) continue;
                session.commit();
            }
            session.commit();
            producer.close();
            session.close();
            String addressTxt = this.server.getPagingManager().getPageStore(ADDRESS).getFolder().getAbsolutePath() + File.separator + "address.txt";
            this.server.stop();
            new PrintWriter(addressTxt).close();
            AtomicBoolean activationFailures = new AtomicBoolean();
            this.server.registerActivationFailureListener(exception -> activationFailures.set(true));
            this.server.start();
            this.server.stop();
            PagingTest.assertFalse((boolean)activationFailures.get());
        }
    }

    @Test
    public void testPurge() throws Exception {
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultNettyConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        SimpleString queue = new SimpleString("testPurge:" + RandomUtil.randomString());
        this.server.addAddressInfo(new AddressInfo(queue, RoutingType.ANYCAST));
        QueueImpl purgeQueue = (QueueImpl)this.server.createQueue(new QueueConfiguration(queue).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(false)));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
        Connection connection = cf.createConnection();
        Session session = connection.createSession(true, 0);
        Queue jmsQueue = session.createQueue(queue.toString());
        MessageProducer producer = session.createProducer((Destination)jmsQueue);
        for (int i2 = 0; i2 < 100; ++i2) {
            producer.send((Message)session.createTextMessage("hello" + i2));
        }
        session.commit();
        Wait.assertEquals((long)0L, () -> ((QueueImpl)purgeQueue).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((PagingStore)purgeQueue.getPageSubscription().getPagingStore()).getAddressSize());
        MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
        for (i = 0; i < 100; ++i) {
            producer.send((Message)session.createTextMessage("hello" + i));
            if (i != 10) continue;
            purgeQueue.getPageSubscription().getPagingStore().startPaging();
        }
        session.commit();
        consumer.close();
        Wait.assertEquals((long)0L, () -> ((QueueImpl)purgeQueue).getMessageCount());
        Wait.assertFalse(() -> ((PageSubscription)purgeQueue.getPageSubscription()).isPaging());
        Wait.assertEquals((long)0L, () -> ((PagingStore)purgeQueue.getPageSubscription().getPagingStore()).getAddressSize());
        consumer = session.createConsumer((Destination)jmsQueue);
        for (i = 0; i < 100; ++i) {
            purgeQueue.getPageSubscription().getPagingStore().startPaging();
            Assert.assertTrue((boolean)purgeQueue.getPageSubscription().isPaging());
            producer.send((Message)session.createTextMessage("hello" + i));
            if (i % 2 != 0) continue;
            session.commit();
        }
        session.commit();
        Wait.assertTrue(() -> ((PageSubscription)purgeQueue.getPageSubscription()).isPaging());
        connection.start();
        this.server.getStorageManager().getMessageJournal().scheduleCompactAndBlock(50000);
        Assert.assertNotNull((Object)consumer.receive(5000L));
        session.commit();
        consumer.close();
        Wait.assertEquals((long)0L, () -> ((QueueImpl)purgeQueue).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((PagingStore)purgeQueue.getPageSubscription().getPagingStore()).getAddressSize());
        Wait.assertFalse(() -> ((PageSubscription)purgeQueue.getPageSubscription()).isPaging());
        StorageManager sm = this.server.getStorageManager();
        for (int i3 = 0; i3 < 1000; ++i3) {
            long tx = sm.generateID();
            PageTransactionInfoImpl txinfo = new PageTransactionInfoImpl(tx);
            sm.storePageTransaction(tx, (PageTransactionInfo)txinfo);
            sm.commit(tx);
            tx = sm.generateID();
            sm.updatePageTransaction(tx, (PageTransactionInfo)txinfo, 1);
            sm.commit(tx);
        }
        this.server.stop();
        this.server.start();
        Wait.assertEquals((int)0, () -> this.server.getPagingManager().getTransactions().size());
    }

    @Test
    public void testFirstPageCompleteNotDeleted() throws Exception {
        ClientMessage msg;
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 20;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        this.server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        org.apache.activemq.artemis.core.server.Queue queue = this.server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        queue.getPageSubscription().getPagingStore().startPaging();
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int i2 = 0; i2 < 20; ++i2) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty("count", i2);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if ((i2 + 1) % 5 != 0) continue;
            session.commit();
            queue.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        session.commit();
        producer.close();
        session.close();
        queue.getPageSubscription().getPagingStore().disableCleanup();
        session = this.sf.createSession(false, false, false);
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (i = 0; i < 5; ++i) {
            msg = consumer.receive(2000L);
            PagingTest.assertNotNull((Object)msg);
            PagingTest.assertEquals((long)i, (long)msg.getIntProperty("count").intValue());
            msg.individualAcknowledge();
        }
        session.commit();
        session.close();
        this.server.stop();
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, false, false);
        consumer = session.createConsumer(ADDRESS);
        session.start();
        for (i = 5; i < 20; ++i) {
            msg = consumer.receive(2000L);
            PagingTest.assertNotNull((Object)msg);
            PagingTest.assertEquals((long)i, (long)msg.getIntProperty("count").intValue());
            msg.acknowledge();
        }
        PagingTest.assertNull((Object)consumer.receiveImmediate());
        session.commit();
        session.close();
        this.sf.close();
        this.locator.close();
    }

    @Test
    public void testPreparedACKAndRestart() throws Exception {
        ClientMessage message;
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 50;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setAckBatchSize(0);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(ADDRESS));
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        ClientProducer producer = session.createProducer(ADDRESS);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        queue.getPageSubscription().getPagingStore().startPaging();
        this.forcePage(queue);
        for (int i2 = 0; i2 < 50; ++i2) {
            ClientMessage message2 = session.createMessage(true);
            message2.putIntProperty("count", i2);
            ActiveMQBuffer bodyLocal = message2.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
            if ((i2 + 1) % 5 != 0) continue;
            session.commit();
            queue.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        session.close();
        session = this.sf.createSession(true, false, false);
        XidImpl xidConsumeNoCommit = this.newXID();
        session.start((Xid)xidConsumeNoCommit, 0);
        ClientConsumer cons = session.createConsumer(ADDRESS);
        session.start();
        ClientMessage firstMessageConsumed = cons.receive(5000L);
        PagingTest.assertNotNull((Object)firstMessageConsumed);
        firstMessageConsumed.acknowledge();
        session.end((Xid)xidConsumeNoCommit, 0x4000000);
        session.prepare((Xid)xidConsumeNoCommit);
        XidImpl xidConsumeCommit = this.newXID();
        session.start((Xid)xidConsumeCommit, 0);
        XidImpl neverCommittedXID = this.newXID();
        for (i = 1; i < 50; ++i) {
            if (i == 20) {
                session.end((Xid)xidConsumeCommit, 0x4000000);
                session.commit((Xid)xidConsumeCommit, true);
                session.start((Xid)neverCommittedXID, 0);
            }
            message = cons.receive(5000L);
            PagingTest.assertNotNull((Object)message);
            message.acknowledge();
            PagingTest.assertEquals((long)i, (long)message.getIntProperty("count").intValue());
            if (i != 20) continue;
            session.end((Xid)neverCommittedXID, 0x4000000);
            session.prepare((Xid)neverCommittedXID);
            xidConsumeCommit = this.newXID();
            session.start((Xid)xidConsumeCommit, 0);
        }
        session.end((Xid)xidConsumeCommit, 0x4000000);
        session.commit((Xid)xidConsumeCommit, true);
        session.close();
        this.sf.close();
        this.server.stop();
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, true, true);
        queue = this.server.locateQueue(ADDRESS);
        PagingTest.assertTrue((boolean)queue.getPageSubscription().getPagingStore().isPaging());
        producer = session.createProducer(ADDRESS);
        for (i = 50; i < 100; ++i) {
            message = session.createMessage(true);
            message.putIntProperty("count", i);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if ((i + 1) % 5 != 0) continue;
            session.commit();
            queue.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        cons = session.createConsumer(ADDRESS);
        session.start();
        for (i = 50; i < 100; ++i) {
            message = cons.receive(5000L);
            PagingTest.assertNotNull((Object)message);
            PagingTest.assertEquals((long)i, (long)message.getIntProperty("count").intValue());
            message.acknowledge();
        }
        PagingTest.assertNull((Object)cons.receiveImmediate());
        session.commit();
        session.commit();
        session.close();
        session = this.sf.createSession(true, false, false);
        session.rollback((Xid)xidConsumeNoCommit);
        session.start();
        xidConsumeCommit = this.newXID();
        session.start((Xid)xidConsumeCommit, 0);
        cons = session.createConsumer(ADDRESS);
        session.start();
        ClientMessage message3 = cons.receive(5000L);
        PagingTest.assertNotNull((Object)message3);
        message3.acknowledge();
        session.end((Xid)xidConsumeCommit, 0x4000000);
        session.commit((Xid)xidConsumeCommit, true);
        session.close();
    }

    private void forcePage(org.apache.activemq.artemis.core.server.Queue queue) throws InterruptedException {
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis() && !queue.getPageSubscription().getPagingStore().isPaging()) {
            Thread.sleep(10L);
        }
        PagingTest.assertTrue((boolean)queue.getPageSubscription().getPagingStore().isPaging());
    }

    @Test
    public void testMoveExpire() throws Exception {
        ClientMessage message;
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalDirectory(this.getJournalDir()).setJournalSyncNonTransactional(false).setJournalCompactMinFiles(0).setMessageExpiryScanPeriod(500L);
        this.server = this.createServer(true, config, 10240, 102400L);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(102400L).setExpiryAddress(new SimpleString("EXP")).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        this.server.getAddressSettingsRepository().clear();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        int numberOfMessages = 5000;
        this.locator = this.createInVMNonHALocator().setConsumerWindowSize(0xA00000).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory sf = this.locator.createSessionFactory();
        ClientSession session = sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        session.createQueue(new QueueConfiguration("EXP"));
        org.apache.activemq.artemis.core.server.Queue queue1 = this.server.locateQueue(ADDRESS);
        org.apache.activemq.artemis.core.server.Queue qEXP = this.server.locateQueue(new SimpleString("EXP"));
        ClientProducer producer = session.createProducer(ADDRESS);
        int MESSAGE_SIZE = 1024;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int i2 = 0; i2 < 5000; ++i2) {
            ClientMessage message2 = session.createMessage(true);
            if (i2 < 1000) {
                message2.setExpiration(System.currentTimeMillis() + 100L);
            }
            message2.putIntProperty("tst-count", i2);
            ActiveMQBuffer bodyLocal = message2.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
            if (i2 % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        Wait.assertEquals((long)1000L, () -> ((org.apache.activemq.artemis.core.server.Queue)qEXP).getMessageCount());
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        for (i = 0; i < 4000; ++i) {
            message = consumer.receive(5000L);
            PagingTest.assertNotNull((Object)message);
            message.acknowledge();
            PagingTest.assertTrue((message.getIntProperty("tst-count") >= 1000 ? (byte)1 : 0) != 0);
        }
        session.commit();
        PagingTest.assertNull((Object)consumer.receiveImmediate());
        Wait.assertEquals((long)0L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue1).getMessageCount());
        consumer.close();
        consumer = session.createConsumer("EXP");
        for (i = 0; i < 1000; ++i) {
            message = consumer.receive(5000L);
            PagingTest.assertNotNull((Object)message);
            message.acknowledge();
            PagingTest.assertTrue((message.getIntProperty("tst-count") < 1000 ? (byte)1 : 0) != 0);
        }
        PagingTest.assertNull((Object)consumer.receiveImmediate());
        ClientConsumerInternal cons = (ClientConsumerInternal)session.createConsumer(ADDRESS);
        session.commit();
        producer.close();
        session.close();
        this.server.stop();
    }

    @Test
    public void testDeleteQueueRestart() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalDirectory(this.getJournalDir()).setJournalSyncNonTransactional(false).setJournalCompactMinFiles(0);
        ActiveMQServer server = this.createServer(true, config, 10240, 102400L);
        server.start();
        int numberOfMessages = 5000;
        this.locator = this.createInVMNonHALocator().setConsumerWindowSize(0xA00000).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        SimpleString QUEUE2 = ADDRESS.concat("-2");
        ClientSessionFactory sf = this.locator.createSessionFactory();
        ClientSession session = sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        session.createQueue(new QueueConfiguration(QUEUE2).setAddress(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientConsumerInternal cons = (ClientConsumerInternal)session.createConsumer(ADDRESS);
        ClientConsumerInternal cons2 = (ClientConsumerInternal)session.createConsumer(QUEUE2);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int i = 0; i < 5000; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        session.start();
        long timeout = System.currentTimeMillis() + 30000L;
        while (System.currentTimeMillis() < timeout && (cons.getBufferSize() < 1000 || cons2.getBufferSize() < 1000)) {
            Thread.sleep(100L);
        }
        PagingTest.assertTrue((cons.getBufferSize() >= 1000 ? (byte)1 : 0) != 0);
        PagingTest.assertTrue((cons2.getBufferSize() >= 1000 ? (byte)1 : 0) != 0);
        session.close();
        org.apache.activemq.artemis.core.server.Queue queue = server.locateQueue(QUEUE2);
        long deletedQueueID = queue.getID();
        server.destroyQueue(QUEUE2);
        sf.close();
        this.locator.close();
        this.locator = null;
        sf = null;
        server.stop();
        HashMap recordsType = this.countJournal(config);
        PagingTest.assertNull((String)"The system is acking page records instead of just delete data", recordsType.get(39));
        Pair journalData = this.loadMessageJournal(config);
        HashSet<Long> deletedQueueReferences = new HashSet<Long>();
        for (RecordInfo info : (List)journalData.getA()) {
            DescribeJournal.ReferenceDescribe ref;
            if (info.getUserRecordType() == 32) {
                ref = (DescribeJournal.ReferenceDescribe)DescribeJournal.newObjectEncoding((RecordInfo)info);
                if (ref.refEncoding.queueID != deletedQueueID) continue;
                deletedQueueReferences.add(info.id);
                continue;
            }
            if (info.getUserRecordType() != 33) continue;
            ref = (AckDescribe)DescribeJournal.newObjectEncoding((RecordInfo)info);
            if (ref.refEncoding.queueID != deletedQueueID) continue;
            deletedQueueReferences.remove(info.id);
        }
        if (!deletedQueueReferences.isEmpty()) {
            for (Long value : deletedQueueReferences) {
                this.instanceLog.warn((Object)("Deleted Queue still has a reference:" + value));
            }
            PagingTest.fail((String)"Deleted queue still have references");
        }
        server.start();
        this.locator = this.createInVMNonHALocator();
        this.locator.setConsumerWindowSize(0xA00000);
        sf = this.locator.createSessionFactory();
        session = sf.createSession(false, false, false);
        cons = (ClientConsumerInternal)session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 5000; ++i) {
            message = cons.receive(5000L);
            PagingTest.assertNotNull((Object)message);
            message.acknowledge();
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        session.close();
        queue = server.locateQueue(ADDRESS);
        Wait.assertEquals((long)0L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        timeout = System.currentTimeMillis() + 10000L;
        while (timeout > System.currentTimeMillis() && queue.getPageSubscription().getPagingStore().isPaging()) {
            Thread.sleep(100L);
        }
        PagingTest.assertFalse((boolean)queue.getPageSubscription().getPagingStore().isPaging());
        server.stop();
    }

    @Test
    public void testPreparePersistent() throws Exception {
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 500;
        int numberOfTX = 10;
        int messagesPerTX = 50;
        this.locator = this.createInVMNonHALocator();
        this.locator.setBlockOnNonDurableSend(false).setBlockOnDurableSend(false).setBlockOnAcknowledge(false);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int i2 = 0; i2 < 500; ++i2) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i2);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i2 % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.close();
        session = null;
        this.sf.close();
        this.locator.close();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        Wait.assertEquals((long)500L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        LinkedList<XidImpl> xids = new LinkedList<XidImpl>();
        int msgReceived = 0;
        for (int i3 = 0; i3 < 10; ++i3) {
            ClientSession sessionConsumer = this.sf.createSession(true, false, false);
            XidImpl xid = this.newXID();
            xids.add(xid);
            sessionConsumer.start((Xid)xid, 0);
            sessionConsumer.start();
            ClientConsumer consumer = sessionConsumer.createConsumer(ADDRESS);
            for (int msgCount = 0; msgCount < 50 && msgReceived != 500; ++msgReceived, ++msgCount) {
                ClientMessage msg = consumer.receive(10000L);
                PagingTest.assertNotNull((Object)msg);
                msg.acknowledge();
            }
            sessionConsumer.end((Xid)xid, 0x4000000);
            sessionConsumer.prepare((Xid)xid);
            sessionConsumer.close();
        }
        ClientSession sessionCheck = this.sf.createSession(true, true);
        ClientConsumer consumer = sessionCheck.createConsumer(ADDRESS);
        PagingTest.assertNull((Object)consumer.receiveImmediate());
        sessionCheck.close();
        Wait.assertEquals((long)500L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        this.sf.close();
        this.locator.close();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.waitForServerToStart(this.server);
        queue = this.server.locateQueue(ADDRESS);
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(true, false, false);
        consumer = session.createConsumer(ADDRESS);
        session.start();
        Wait.assertEquals((long)500L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        ClientMessage msg = consumer.receiveImmediate();
        if (msg != null) {
            ClientMessage msg2;
            while ((msg2 = consumer.receive(1000L)) != null) {
            }
        }
        PagingTest.assertNull((Object)msg);
        for (i = xids.size() - 1; i >= 0; --i) {
            Xid xid = (Xid)xids.get(i);
            session.rollback(xid);
        }
        xids.clear();
        session.close();
        session = this.sf.createSession(false, false, false);
        session.start();
        consumer = session.createConsumer(ADDRESS);
        for (i = 0; i < 500; ++i) {
            msg = consumer.receive(1000L);
            PagingTest.assertNotNull((Object)msg);
            msg.acknowledge();
            PagingTest.assertEquals((long)i, (long)msg.getIntProperty("id").intValue());
            if (i % 500 != 0) continue;
            session.commit();
        }
        session.commit();
        session.close();
        this.sf.close();
        this.locator.close();
        Wait.assertEquals((long)0L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        this.waitForNotPaging(queue);
    }

    @Test
    public void testSendOverBlockingNoFlowControl() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("#")).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        this.server.start();
        int biggerMessageSize = 10240;
        int numberOfMessages = 500;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setProducerWindowSize(-1).setMinLargeMessageSize(0x100000);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[10240];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 10240; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int i = 0; i < 500; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 10 != 0) continue;
            session.commit();
        }
        session.commit();
        session.start();
        ClientConsumer cons = session.createConsumer(ADDRESS);
        for (int i = 0; i < 500; ++i) {
            message = cons.receive(5000L);
            PagingTest.assertNotNull((Object)message);
            message.acknowledge();
            if (i % 10 != 0) continue;
            session.commit();
        }
        session.commit();
    }

    @Test
    public void testReceiveImmediate() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 1000;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int i = 0; i < 1000; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.close();
        session = null;
        this.sf.close();
        this.locator.close();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        Wait.assertEquals((long)1000L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        int msgReceived = 0;
        ClientSession sessionConsumer = this.sf.createSession(false, false, false);
        sessionConsumer.start();
        ClientConsumer consumer = sessionConsumer.createConsumer(ADDRESS);
        for (int msgCount = 0; msgCount < 1000; ++msgCount) {
            log.debug((Object)("Received " + msgCount));
            ++msgReceived;
            ClientMessage msg = consumer.receiveImmediate();
            if (msg == null) {
                log.debug((Object)"It's null. leaving now");
                sessionConsumer.commit();
                PagingTest.fail((String)"Didn't receive a message");
            }
            msg.acknowledge();
            if (msgCount % 5 != 0) continue;
            log.debug((Object)"commit");
            sessionConsumer.commit();
        }
        sessionConsumer.commit();
        sessionConsumer.close();
        this.sf.close();
        this.locator.close();
        Wait.assertEquals((long)0L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis() && queue.getPageSubscription().getPagingStore().isPaging()) {
            Thread.sleep(100L);
        }
        PagingTest.assertFalse((boolean)queue.getPageSubscription().getPagingStore().isPaging());
    }

    @Test
    public void testInabilityToCreateDirectoryDuringPaging() throws Exception {
        Assume.assumeTrue((this.storeType == StoreConfiguration.StoreType.FILE ? (byte)1 : 0) != 0);
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false).setPagingDirectory("/" + UUID.randomUUID().toString());
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 100;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int i = 0; i < 100; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            try {
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PagingTest.assertTrue((boolean)Wait.waitFor(() -> this.server.getState() == ActiveMQServer.SERVER_STATE.STOPPED, (long)5000L, (long)200L));
        session.close();
        this.sf.close();
        this.locator.close();
    }

    @Test
    public void testDeletePhysicalPages() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setPersistDeliveryCountBeforeDelivery(true);
        config.setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 1000;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int i = 0; i < 1000; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.close();
        session = null;
        this.sf.close();
        this.locator.close();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        Wait.assertEquals((long)1000L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        int msgReceived = 0;
        ClientSession sessionConsumer = this.sf.createSession(false, false, false);
        sessionConsumer.start();
        ClientConsumer consumer = sessionConsumer.createConsumer(ADDRESS);
        for (int msgCount = 0; msgCount < 1000; ++msgCount) {
            log.debug((Object)("Received " + msgCount));
            ++msgReceived;
            ClientMessage msg = consumer.receiveImmediate();
            if (msg == null) {
                log.debug((Object)"It's null. leaving now");
                sessionConsumer.commit();
                PagingTest.fail((String)"Didn't receive a message");
            }
            msg.acknowledge();
            if (msgCount % 5 != 0) continue;
            log.debug((Object)"commit");
            sessionConsumer.commit();
        }
        sessionConsumer.commit();
        sessionConsumer.close();
        this.sf.close();
        this.locator.close();
        Wait.assertEquals((long)0L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis() && queue.getPageSubscription().getPagingStore().isPaging()) {
            Thread.sleep(100L);
        }
        PagingTest.assertFalse((boolean)queue.getPageSubscription().getPagingStore().isPaging());
        this.server.stop();
        PagingTest.deleteDirectory((File)new File(this.getPageDir()));
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        queue = this.server.locateQueue(ADDRESS);
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, false, false);
        producer = session.createProducer(ADDRESS);
        for (int i = 0; i < 2000; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("theid"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        msgReceived = 0;
        sessionConsumer = this.sf.createSession(false, false, false);
        sessionConsumer.start();
        consumer = sessionConsumer.createConsumer(ADDRESS);
        for (int msgCount = 0; msgCount < 1000; ++msgCount) {
            log.debug((Object)("Received " + msgCount));
            ++msgReceived;
            ClientMessage msg = consumer.receive(5000L);
            if (msg == null) {
                log.debug((Object)"It's null. leaving now");
                sessionConsumer.commit();
                PagingTest.fail((String)"Didn't receive a message");
            }
            msg.acknowledge();
            if (msgCount % 5 != 0) continue;
            log.debug((Object)"commit");
            sessionConsumer.commit();
        }
        sessionConsumer.commit();
        sessionConsumer.close();
    }

    @Test
    public void testRestartWithCompleteAndDeletedPhysicalPage() throws Exception {
        int i;
        ClientMessage message;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        final AtomicBoolean mainCleanup = new AtomicBoolean(true);
        this.server = new ActiveMQServerImpl(config, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)new ActiveMQSecurityManagerImpl()){

            protected PagingStoreFactoryNIO getPagingStoreFactory() {
                return new PagingStoreFactoryNIO(this.getStorageManager(), this.getConfiguration().getPagingLocation(), this.getConfiguration().getJournalBufferTimeout_NIO(), this.getScheduledPool(), this.getExecutorFactory(), this.getConfiguration().isJournalSyncNonTransactional(), null){

                    public PageCursorProvider newCursorProvider(PagingStore store, StorageManager storageManager, AddressSettings addressSettings, ArtemisExecutor executor) {
                        class InterruptedCursorProvider
                        extends PageCursorProviderImpl {
                            final /* synthetic */ AtomicBoolean val$mainCleanup;

                            InterruptedCursorProvider(PagingStore pagingStore, StorageManager storageManager, ArtemisExecutor executor, int maxCacheSize) {
                                this.val$mainCleanup = atomicBoolean;
                                super(pagingStore, storageManager, executor, maxCacheSize);
                            }

                            public void cleanup() {
                                if (this.val$mainCleanup.get()) {
                                    super.cleanup();
                                } else {
                                    try {
                                        this.pagingStore.unlock();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        return new InterruptedCursorProvider(PagingTest.this, store, storageManager, executor, addressSettings.getPageCacheMaxSize(), mainCleanup);
                    }
                };
            }
        };
        this.addServer(this.server);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(1024).setMaxSizeBytes(2048L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(true, true, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        ClientProducer producer = session.createProducer(ADDRESS);
        for (int i2 = 0; i2 < 4; ++i2) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(new byte[1024]);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            session.commit();
            if (i2 != 3) continue;
            queue.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        Wait.assertEquals((int)3, () -> ((PagingStore)queue.getPageSubscription().getPagingStore()).getCurrentWritingPage());
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (i = 0; i < 4; ++i) {
            message = consumer.receive(5000L);
            Assert.assertNotNull((String)("Before restart - message " + i + " is empty."), (Object)message);
            message.acknowledge();
        }
        this.server.stop();
        mainCleanup.set(false);
        PagingTest.deleteDirectory((File)new File(this.getPageDir()));
        logger.trace((Object)"Server restart");
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(null, null, false, false, true, false, 0);
        producer = session.createProducer(ADDRESS);
        for (i = 0; i < 4; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(new byte[1024]);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        mainCleanup.set(true);
        queue = this.server.locateQueue(ADDRESS);
        queue.getPageSubscription().cleanupEntries(false);
        queue.getPageSubscription().getPagingStore().getCursorProvider().cleanup();
        consumer = session.createConsumer(ADDRESS);
        session.start();
        for (i = 0; i < 4; ++i) {
            message = consumer.receive(5000L);
            Assert.assertNotNull((String)("After restart - message " + i + " is empty."), (Object)message);
            message.acknowledge();
        }
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingTXEverythingAcked() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 5000;
        int numberOfTX = 10;
        int messagesPerTX = 500;
        try {
            this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            this.sf = this.createSessionFactory(this.locator);
            ClientSession session = this.sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration("q1").setAddress(ADDRESS.toString()));
            session.createQueue(new QueueConfiguration("q2").setAddress(ADDRESS.toString()));
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = null;
            byte[] body = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(body);
            for (int j = 1; j <= 1024; ++j) {
                bb.put(PagingTest.getSamplebyte((long)j));
            }
            for (int i = 0; i < 5000; ++i) {
                message = session.createMessage(true);
                ActiveMQBuffer bodyLocal = message.getBodyBuffer();
                bodyLocal.writeBytes(body);
                message.putIntProperty(new SimpleString("id"), i);
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
                if (i % 500 != 0) continue;
                session.commit();
            }
            session.commit();
            session.close();
            ArrayList records = new ArrayList();
            ArrayList list = new ArrayList();
            this.server.getStorageManager().getMessageJournal().stop();
            Journal jrn = this.server.getStorageManager().getMessageJournal();
            jrn.start();
            jrn.load(records, list, null);
            for (RecordInfo info : records) {
                if (info.isUpdate || info.getUserRecordType() == 40 || info.getUserRecordType() == 41 || info.getUserRecordType() == 42) continue;
                jrn.appendDeleteRecord(info.id, false);
            }
            jrn.stop();
        }
        finally {
            try {
                this.server.stop();
            }
            catch (Throwable session) {}
        }
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        ClientSessionFactory csf = this.createSessionFactory(this.locator);
        ClientSession sess = csf.createSession();
        sess.start();
        ClientConsumer cons = sess.createConsumer("q1");
        PagingTest.assertNull((Object)cons.receiveImmediate());
        ClientConsumer cons2 = sess.createConsumer("q2");
        PagingTest.assertNull((Object)cons2.receiveImmediate());
        org.apache.activemq.artemis.core.server.Queue q1 = this.server.locateQueue(new SimpleString("q1"));
        org.apache.activemq.artemis.core.server.Queue q2 = this.server.locateQueue(new SimpleString("q2"));
        q1.getPageSubscription().cleanupEntries(false);
        q2.getPageSubscription().cleanupEntries(false);
        PageCursorProvider provider = q1.getPageSubscription().getPagingStore().getCursorProvider();
        provider.cleanup();
        this.waitForNotPaging(q1);
        sess.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingTXEverythingAcked2() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 6;
        int numberOfTX = 2;
        int messagesPerTX = 3;
        try {
            int i;
            this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            this.sf = this.createSessionFactory(this.locator);
            ClientSession session = this.sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration("q1").setAddress(ADDRESS.toString()));
            session.createQueue(new QueueConfiguration("q2").setAddress(ADDRESS.toString()));
            this.server.getPagingManager().getPageStore(ADDRESS).startPaging();
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = null;
            byte[] body = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(body);
            for (int j = 1; j <= 1024; ++j) {
                bb.put(PagingTest.getSamplebyte((long)j));
            }
            for (i = 0; i < 6; ++i) {
                message = session.createMessage(true);
                ActiveMQBuffer bodyLocal = message.getBodyBuffer();
                bodyLocal.writeBytes(body);
                message.putStringProperty("id", "str-" + i);
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
                if ((i + 1) % 3 != 0) continue;
                session.commit();
            }
            session.commit();
            session.start();
            for (i = 1; i <= 2; ++i) {
                ClientConsumer cons = session.createConsumer("q" + i);
                for (int j = 0; j < 3; ++j) {
                    ClientMessage msg = cons.receive(5000L);
                    PagingTest.assertNotNull((Object)msg);
                    PagingTest.assertEquals((Object)("str-" + j), (Object)msg.getStringProperty("id"));
                    msg.acknowledge();
                }
                session.commit();
            }
            session.close();
        }
        finally {
            this.locator.close();
            try {
                this.server.stop();
            }
            catch (Throwable session) {}
        }
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory csf = this.createSessionFactory(this.locator);
        ClientSession session = csf.createSession();
        session.start();
        for (int i = 1; i <= 2; ++i) {
            ClientConsumer cons = session.createConsumer("q" + i);
            for (int j = 3; j < 6; ++j) {
                ClientMessage msg = cons.receive(5000L);
                PagingTest.assertNotNull((Object)msg);
                PagingTest.assertEquals((Object)("str-" + j), (Object)msg.getStringProperty("id"));
                msg.acknowledge();
            }
            session.commit();
            PagingTest.assertNull((Object)cons.receive(500L));
        }
        session.close();
        long timeout = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < timeout && this.server.getPagingManager().getPageStore(ADDRESS).isPaging()) {
            Thread.sleep(100L);
        }
    }

    @Test
    public void testTwoQueuesOneNoRouting() throws Exception {
        boolean persistentMessages = true;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 1000;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        session.createQueue(new QueueConfiguration(ADDRESS.concat("-invalid")).setAddress(ADDRESS).setFilterString(new SimpleString("__AMQX=-1")));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        for (int i = 0; i < 1000; ++i) {
            message = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        for (int i = 0; i < 1000; ++i) {
            message = consumer.receive(5000L);
            PagingTest.assertNotNull((Object)message);
            message.acknowledge();
            PagingTest.assertEquals((long)i, (long)message.getIntProperty("id").intValue());
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.commit();
        session.commit();
        PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
        store.getCursorProvider().cleanup();
        long timeout = System.currentTimeMillis() + 5000L;
        while (store.isPaging() && timeout > System.currentTimeMillis()) {
            Thread.sleep(100L);
        }
        PagingTest.assertFalse((boolean)this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
    }

    @Test
    public void testSendReceivePagingPersistent() throws Exception {
        this.internaltestSendReceivePaging(true);
    }

    @Test
    public void testSendReceivePagingNonPersistent() throws Exception {
        this.internaltestSendReceivePaging(false);
    }

    @Test
    public void testWithDiverts() throws Exception {
        this.internalMultiQueuesTest(true);
    }

    @Test
    public void testWithMultiQueues() throws Exception {
        this.internalMultiQueuesTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalMultiQueuesTest(boolean divert) throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        if (divert) {
            DivertConfiguration divert1 = new DivertConfiguration().setName("dv1").setRoutingName("nm1").setAddress(ADDRESS.toString()).setForwardingAddress(ADDRESS.toString() + "-1").setExclusive(true);
            config.addDivertConfiguration(divert1);
            DivertConfiguration divert2 = new DivertConfiguration().setName("dv2").setRoutingName("nm2").setAddress(ADDRESS.toString()).setForwardingAddress(ADDRESS.toString() + "-2").setExclusive(true);
            config.addDivertConfiguration(divert2);
        }
        this.server.start();
        int numberOfMessages = 3000;
        final byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread tcount1 = null;
        Thread tcount2 = null;
        try {
            int i;
            this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            this.sf = this.createSessionFactory(this.locator);
            ClientSession session = this.sf.createSession(false, false, false);
            if (divert) {
                session.createQueue(new QueueConfiguration(ADDRESS + "-1"));
                session.createQueue(new QueueConfiguration(ADDRESS + "-2"));
            } else {
                session.createQueue(new QueueConfiguration(ADDRESS + "-1").setAddress(ADDRESS));
                session.createQueue(new QueueConfiguration(ADDRESS + "-2").setAddress(ADDRESS));
            }
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = null;
            for (int i2 = 0; i2 < 3000; ++i2) {
                if (i2 % 500 == 0) {
                    log.debug((Object)("Sent " + i2 + " messages"));
                    session.commit();
                }
                message = session.createMessage(true);
                ActiveMQBuffer bodyLocal = message.getBodyBuffer();
                bodyLocal.writeBytes(body);
                message.putIntProperty(new SimpleString("id"), i2);
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
            }
            session.commit();
            session.close();
            this.server.stop();
            this.sf.close();
            this.locator.close();
            this.server = this.createServer(true, config, 10240, 102400L);
            this.server.start();
            org.apache.activemq.artemis.core.server.Queue queue1 = this.server.locateQueue(ADDRESS.concat("-1"));
            org.apache.activemq.artemis.core.server.Queue queue2 = this.server.locateQueue(ADDRESS.concat("-2"));
            PagingTest.assertNotNull((Object)queue1);
            PagingTest.assertNotNull((Object)queue2);
            PagingTest.assertNotSame((Object)queue1, (Object)queue2);
            class TCount
            extends Thread {
                org.apache.activemq.artemis.core.server.Queue queue;

                TCount(org.apache.activemq.artemis.core.server.Queue queue) {
                    this.queue = queue;
                }

                @Override
                public void run() {
                    try {
                        while (running.get()) {
                            PagingTest.this.getMessagesAdded(this.queue);
                            PagingTest.this.getMessageCount(this.queue);
                            Thread.sleep(10L);
                        }
                    }
                    catch (InterruptedException e) {
                        log.debug((Object)"Thread interrupted");
                    }
                }
            }
            tcount1 = new TCount(queue1);
            tcount2 = new TCount(queue2);
            tcount1.start();
            tcount2.start();
            this.locator = this.createInVMNonHALocator();
            final ClientSessionFactory sf2 = this.createSessionFactory(this.locator);
            final AtomicInteger errors = new AtomicInteger(0);
            Thread[] threads = new Thread[2];
            for (int start = 1; start <= 2; ++start) {
                final String addressToSubscribe = ADDRESS + "-" + start;
                threads[start - 1] = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ClientSession session = sf2.createSession(null, null, false, true, true, false, 0);
                            ClientConsumer consumer = session.createConsumer(addressToSubscribe);
                            session.start();
                            for (int i = 0; i < 3000; ++i) {
                                ClientMessage message2 = consumer.receive(5000L);
                                Assert.assertNotNull((Object)message2);
                                Assert.assertEquals((long)i, (long)message2.getIntProperty("id").intValue());
                                message2.acknowledge();
                                Assert.assertNotNull((Object)message2);
                                if (i % 100 == 0) {
                                    if (i % 5000 == 0) {
                                        log.debug((Object)(addressToSubscribe + " consumed " + i + " messages"));
                                    }
                                    session.commit();
                                }
                                try {
                                    PagingTest.this.assertBodiesEqual(body, message2.getBodyBuffer());
                                    continue;
                                }
                                catch (AssertionError e) {
                                    log.debug((Object)("Expected buffer:" + ActiveMQTestBase.dumpBytesHex((byte[])body, (int)40)));
                                    log.debug((Object)("Arriving buffer:" + ActiveMQTestBase.dumpBytesHex((byte[])message2.getBodyBuffer().toByteBuffer().array(), (int)40)));
                                    throw e;
                                }
                            }
                            session.commit();
                            consumer.close();
                            session.close();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            errors.incrementAndGet();
                        }
                    }
                };
            }
            for (i = 0; i < 2; ++i) {
                threads[i].start();
            }
            for (i = 0; i < 2; ++i) {
                threads[i].join();
            }
            sf2.close();
            this.locator.close();
            PagingTest.assertEquals((long)0L, (long)errors.get());
            for (i = 0; i < 20 && this.server.getPagingManager().getTransactions().size() != 0; ++i) {
                if (this.server.getPagingManager().getTransactions().size() == 0) continue;
                Thread.sleep(500L);
            }
            Wait.assertEquals((int)0, () -> this.server.getPagingManager().getTransactions().size());
        }
        finally {
            running.set(false);
            if (tcount1 != null) {
                tcount1.interrupt();
                tcount1.join();
            }
            if (tcount2 != null) {
                tcount2.interrupt();
                tcount2.join();
            }
            try {
                this.server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    @Test
    public void testMultiQueuesNonPersistentAndPersistent() throws Exception {
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 3000;
        final byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        this.locator = this.createInVMNonHALocator();
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS + "-1").setAddress(ADDRESS));
        session.createQueue(new QueueConfiguration(ADDRESS + "-2").setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        for (int i2 = 0; i2 < 3000; ++i2) {
            if (i2 % 500 == 0) {
                session.commit();
            }
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i2);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        session.close();
        this.server.stop();
        this.sf.close();
        this.locator.close();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        ServerLocator locator1 = this.createInVMNonHALocator();
        final ClientSessionFactory sf2 = locator1.createSessionFactory();
        final AtomicInteger errors = new AtomicInteger(0);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ClientSession session = sf2.createSession(null, null, false, true, true, false, 0);
                    ClientConsumer consumer = session.createConsumer(ADDRESS + "-1");
                    session.start();
                    for (int i = 0; i < 3000; ++i) {
                        ClientMessage message2 = consumer.receive(5000L);
                        Assert.assertNotNull((Object)message2);
                        Assert.assertEquals((long)i, (long)message2.getIntProperty("id").intValue());
                        message2.acknowledge();
                        Assert.assertNotNull((Object)message2);
                        if (i % 1000 == 0) {
                            session.commit();
                        }
                        try {
                            PagingTest.this.assertBodiesEqual(body, message2.getBodyBuffer());
                            continue;
                        }
                        catch (AssertionError e) {
                            log.debug((Object)("Expected buffer:" + ActiveMQTestBase.dumpBytesHex((byte[])body, (int)40)));
                            log.debug((Object)("Arriving buffer:" + ActiveMQTestBase.dumpBytesHex((byte[])message2.getBodyBuffer().toByteBuffer().array(), (int)40)));
                            throw e;
                        }
                    }
                    session.commit();
                    consumer.close();
                    session.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        };
        t.start();
        t.join();
        PagingTest.assertEquals((long)0L, (long)errors.get());
        for (i = 0; i < 20 && this.server.getPagingManager().getPageStore(ADDRESS).isPaging(); ++i) {
            Thread.sleep(500L);
        }
        PagingTest.assertFalse((boolean)this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
        for (i = 0; i < 20 && this.server.getPagingManager().getTransactions().size() != 0; ++i) {
            Thread.sleep(500L);
        }
        Wait.assertEquals((int)0, () -> this.server.getPagingManager().getTransactions().size());
    }

    private void internaltestSendReceivePaging(boolean persistentMessages) throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfIntegers = 256;
        int numberOfMessages = 1000;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        queue.getPageSubscription().getPagingStore().startPaging();
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 256; ++j) {
            bb.putInt(j);
        }
        for (int i = 0; i < 1000; ++i) {
            message = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.close();
        this.sf.close();
        this.locator.close();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(null, null, false, true, true, false, 0);
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message2 = consumer.receive(5000L);
            Assert.assertNotNull((Object)message2);
            Assert.assertEquals((long)i, (long)message2.getIntProperty("id").intValue());
            PagingTest.assertEquals((long)body.length, (long)message2.getBodySize());
            message2.acknowledge();
            Assert.assertNotNull((Object)message2);
            if (i % 1000 == 0) {
                session.commit();
            }
            try {
                this.assertBodiesEqual(body, message2.getBodyBuffer());
                continue;
            }
            catch (AssertionError e) {
                log.debug((Object)("Expected buffer:" + ActiveMQTestBase.dumpBytesHex((byte[])body, (int)40)));
                log.debug((Object)("Arriving buffer:" + ActiveMQTestBase.dumpBytesHex((byte[])message2.getBodyBuffer().toByteBuffer().array(), (int)40)));
                throw e;
            }
        }
        consumer.close();
        session.close();
    }

    private void assertBodiesEqual(byte[] body, ActiveMQBuffer buffer) {
        byte[] other = new byte[body.length];
        buffer.readBytes(other);
        ActiveMQTestBase.assertEqualsByteArrays((byte[])body, (byte[])other);
    }

    @Test
    public void testDepageDuringTransaction() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        byte[] body = new byte[1024];
        ClientMessage message = null;
        int numberOfMessages = 0;
        while (true) {
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            if (this.server.getPagingManager().getPageStore(ADDRESS).isPaging()) break;
            Assert.assertTrue((String)"something is not letting the system to enter page mode, the test became invalid", (++numberOfMessages < 2000 ? (byte)1 : 0) != 0);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        Assert.assertTrue((boolean)this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
        session.start();
        ClientSession sessionTransacted = this.sf.createSession(null, null, false, false, false, false, 0);
        ClientProducer producerTransacted = sessionTransacted.createProducer(ADDRESS);
        for (int i = 0; i < 10; ++i) {
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            if (i == 5) {
                ClientConsumer consumer = session.createConsumer(ADDRESS);
                for (int j = 0; j < numberOfMessages; ++j) {
                    ClientMessage msg = consumer.receive(5000L);
                    msg.acknowledge();
                    Assert.assertNotNull((Object)msg);
                }
                Assert.assertNull((Object)consumer.receiveImmediate());
                consumer.close();
            }
            Integer messageID = (Integer)message.getObjectProperty(new SimpleString("id"));
            Assert.assertNotNull((Object)messageID);
            Assert.assertEquals((long)messageID.intValue(), (long)i);
            producerTransacted.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        Assert.assertNull((Object)consumer.receiveImmediate());
        sessionTransacted.commit();
        sessionTransacted.close();
        for (int i = 0; i < 10; ++i) {
            message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            Integer messageID = (Integer)message.getObjectProperty(new SimpleString("id"));
            Assert.assertNotNull((Object)messageID);
            Assert.assertEquals((String)"message received out of order", (long)messageID.intValue(), (long)i);
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer.receiveImmediate());
        consumer.close();
        session.close();
    }

    @Test
    public void testDepageDuringTransaction2() throws Exception {
        boolean IS_DURABLE_MESSAGE = true;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        byte[] body = new byte[1024];
        ClientSession sessionTransacted = this.sf.createSession(null, null, false, false, false, false, 0);
        ClientProducer producerTransacted = sessionTransacted.createProducer(ADDRESS);
        ClientSession session = this.sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientMessage firstMessage = sessionTransacted.createMessage(IS_DURABLE_MESSAGE);
        firstMessage.getBodyBuffer().writeBytes(body);
        firstMessage.putIntProperty(new SimpleString("id"), 0);
        producerTransacted.send((org.apache.activemq.artemis.api.core.Message)firstMessage);
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        int numberOfMessages = 0;
        while (true) {
            message = session.createMessage(IS_DURABLE_MESSAGE);
            message.getBodyBuffer().writeBytes(body);
            message.putIntProperty("id", numberOfMessages);
            message.putBooleanProperty("new", false);
            if (this.server.getPagingManager().getPageStore(ADDRESS).isPaging()) break;
            ++numberOfMessages;
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        Assert.assertTrue((boolean)this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
        session.start();
        for (int i = 1; i < 10; ++i) {
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            if (i == 5) {
                ClientConsumer consumer = session.createConsumer(ADDRESS);
                for (int j = 0; j < numberOfMessages; ++j) {
                    ClientMessage msg = consumer.receive(5000L);
                    msg.acknowledge();
                    PagingTest.assertEquals((long)j, (long)msg.getIntProperty("id").intValue());
                    PagingTest.assertFalse((boolean)msg.getBooleanProperty("new"));
                    Assert.assertNotNull((Object)msg);
                }
                ClientMessage msgReceived = consumer.receiveImmediate();
                Assert.assertNull((Object)msgReceived);
                consumer.close();
            }
            Integer messageID = (Integer)message.getObjectProperty(new SimpleString("id"));
            Assert.assertNotNull((Object)messageID);
            Assert.assertEquals((long)messageID.intValue(), (long)i);
            producerTransacted.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        Assert.assertNull((Object)consumer.receiveImmediate());
        sessionTransacted.commit();
        sessionTransacted.close();
        for (int i = 0; i < 10; ++i) {
            message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            Integer messageID = (Integer)message.getObjectProperty(new SimpleString("id"));
            Assert.assertNotNull((Object)messageID);
            Assert.assertEquals((String)"message received out of order", (long)i, (long)messageID.intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer.receiveImmediate());
        consumer.close();
        session.close();
    }

    @Test
    public void testDepageDuringTransaction3() throws Exception {
        ClientMessage msgReceived;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        byte[] body = new byte[1024];
        ClientSession sessionTransacted = this.sf.createSession(null, null, false, false, false, false, 0);
        ClientProducer producerTransacted = sessionTransacted.createProducer(ADDRESS);
        ClientSession sessionNonTX = this.sf.createSession(true, true, 0);
        sessionNonTX.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producerNonTransacted = sessionNonTX.createProducer(ADDRESS);
        sessionNonTX.start();
        for (int i = 0; i < 50; ++i) {
            ClientMessage message = sessionNonTX.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            message.putStringProperty(new SimpleString("tst"), new SimpleString("i=" + i));
            producerTransacted.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 2 == 0) {
                for (int j = 0; j < 20; ++j) {
                    ClientMessage msgSend = sessionNonTX.createMessage(true);
                    msgSend.putStringProperty(new SimpleString("tst"), new SimpleString("i=" + i + ", j=" + j));
                    msgSend.getBodyBuffer().writeBytes(new byte[10240]);
                    producerNonTransacted.send((org.apache.activemq.artemis.api.core.Message)msgSend);
                }
                PagingTest.assertTrue((boolean)this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
                continue;
            }
            ClientConsumer consumer = sessionNonTX.createConsumer(ADDRESS);
            for (int j = 0; j < 20; ++j) {
                ClientMessage msgReceived2 = consumer.receive(10000L);
                PagingTest.assertNotNull((Object)msgReceived2);
                msgReceived2.acknowledge();
            }
            consumer.close();
        }
        ClientConsumer consumerNonTX = sessionNonTX.createConsumer(ADDRESS);
        while ((msgReceived = consumerNonTX.receive(1000L)) != null) {
            msgReceived.acknowledge();
        }
        consumerNonTX.close();
        ClientConsumer consumer = sessionNonTX.createConsumer(ADDRESS);
        Assert.assertNull((Object)consumer.receiveImmediate());
        sessionTransacted.commit();
        sessionTransacted.close();
        for (int i = 0; i < 50; ++i) {
            ClientMessage message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            Integer messageID = (Integer)message.getObjectProperty(new SimpleString("id"));
            Assert.assertNotNull((Object)messageID);
            Assert.assertEquals((String)"message received out of order", (long)i, (long)messageID.intValue());
            message.acknowledge();
        }
        Assert.assertNull((Object)consumer.receiveImmediate());
        consumer.close();
        sessionNonTX.close();
    }

    @Test
    public void testDepageDuringTransaction4() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false).setJournalSyncTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        final AtomicInteger errors = new AtomicInteger(0);
        int numberOfMessages = 10000;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(false);
        this.sf = this.createSessionFactory(this.locator);
        final byte[] body = new byte[1024];
        Thread producerThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClientSession sessionProducer = null;
                try {
                    sessionProducer = PagingTest.this.sf.createSession(false, false);
                    ClientProducer producer = sessionProducer.createProducer(ADDRESS);
                    for (int i = 0; i < 10000; ++i) {
                        ClientMessage msg = sessionProducer.createMessage(true);
                        msg.getBodyBuffer().writeBytes(body);
                        msg.putIntProperty("count", i);
                        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
                        if (i % 100 != 0 || i == 0) continue;
                        sessionProducer.commit();
                    }
                    sessionProducer.commit();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    try {
                        if (sessionProducer != null) {
                            sessionProducer.close();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                }
            }
        };
        ClientSession session = this.sf.createSession(true, true, 0);
        session.start();
        session.createQueue(new QueueConfiguration(ADDRESS));
        producerThread.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        for (int i = 0; i < 10000; ++i) {
            ClientMessage msg = consumer.receive(5000L);
            PagingTest.assertNotNull((Object)msg);
            PagingTest.assertEquals((long)i, (long)msg.getIntProperty("count").intValue());
            msg.acknowledge();
            if (i <= 0 || i % 10 != 0) continue;
            session.commit();
        }
        session.commit();
        session.close();
        producerThread.join();
        this.locator.close();
        this.sf.close();
        PagingTest.assertEquals((long)0L, (long)errors.get());
    }

    @Test
    public void testOrderingNonTX() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false).setJournalSyncTransactional(false);
        this.server = this.createServer(true, config, 10240, 20480L);
        this.server.getConfiguration();
        this.server.getConfiguration();
        this.server.start();
        final AtomicInteger errors = new AtomicInteger(0);
        int numberOfMessages = 2000;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        final CountDownLatch ready = new CountDownLatch(1);
        final byte[] body = new byte[1024];
        Thread producerThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClientSession sessionProducer = null;
                try {
                    sessionProducer = PagingTest.this.sf.createSession(true, true);
                    ClientProducer producer = sessionProducer.createProducer(ADDRESS);
                    for (int i = 0; i < 2000; ++i) {
                        ClientMessage msg = sessionProducer.createMessage(true);
                        msg.getBodyBuffer().writeBytes(body);
                        msg.putIntProperty("count", i);
                        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
                        if (i != 1000) continue;
                        sessionProducer.commit();
                        Assert.assertTrue((boolean)PagingTest.this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
                        ready.countDown();
                    }
                    sessionProducer.commit();
                    log.debug((Object)"Producer gone");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    try {
                        if (sessionProducer != null) {
                            sessionProducer.close();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                }
            }
        };
        ClientSession session = this.sf.createSession(true, true, 0);
        session.start();
        session.createQueue(new QueueConfiguration(ADDRESS));
        producerThread.start();
        PagingTest.assertTrue((boolean)ready.await(100L, TimeUnit.SECONDS));
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        for (int i = 0; i < 2000; ++i) {
            ClientMessage msg = consumer.receive(5000L);
            PagingTest.assertNotNull((Object)msg);
            if (i != msg.getIntProperty("count")) {
                log.debug((Object)("Received " + i + " with property = " + msg.getIntProperty("count")));
                log.debug((Object)"###### different");
            }
            msg.acknowledge();
        }
        session.close();
        producerThread.join();
        PagingTest.assertEquals((long)0L, (long)errors.get());
    }

    @Test
    public void testPageOnSchedulingNoRestart() throws Exception {
        this.internalTestPageOnScheduling(false);
    }

    @Test
    public void testPageOnSchedulingRestart() throws Exception {
        this.internalTestPageOnScheduling(true);
    }

    public void internalTestPageOnScheduling(boolean restart) throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 1000;
        int numberOfBytes = 1024;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        for (int j = 0; j < 1024; ++j) {
            body[j] = ActiveMQTestBase.getSamplebyte((long)j);
        }
        long scheduledTime = System.currentTimeMillis() + 5000L;
        for (int i = 0; i < 1000; ++i) {
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            if (store.getCurrentPage() != null) {
                message.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, scheduledTime);
            }
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        if (restart) {
            session.close();
            this.server.stop();
            this.server = this.createServer(true, config, 10240, 102400L);
            this.server.start();
            this.sf = this.createSessionFactory(this.locator);
            session = this.sf.createSession(null, null, false, true, true, false, 0);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message2 = consumer.receive(5000L);
            Assert.assertNotNull((Object)message2);
            message2.acknowledge();
            Assert.assertNotNull((Object)message2);
            Long scheduled = (Long)message2.getObjectProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME);
            if (scheduled != null) {
                Assert.assertTrue((String)"Scheduling didn't work", (System.currentTimeMillis() >= scheduledTime ? (byte)1 : 0) != 0);
            }
            try {
                this.assertBodiesEqual(body, message2.getBodyBuffer());
                continue;
            }
            catch (AssertionError e) {
                log.debug((Object)("Expected buffer:" + ActiveMQTestBase.dumpBytesHex((byte[])body, (int)40)));
                log.debug((Object)("Arriving buffer:" + ActiveMQTestBase.dumpBytesHex((byte[])message2.getBodyBuffer().toByteBuffer().array(), (int)40)));
                throw e;
            }
        }
        consumer.close();
        session.close();
    }

    @Test
    public void testRollbackOnSend() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfIntegers = 256;
        int numberOfMessages = 10;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(null, null, false, false, true, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        for (int i = 0; i < 10; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            for (int j = 1; j <= 256; ++j) {
                bodyLocal.writeInt(j);
            }
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.rollback();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    @Test
    public void testRollbackOnSendThenSendMore() throws Exception {
        ActiveMQBuffer bodyLocal;
        ClientMessage message;
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(null, null, false, false, true, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        queue.getPageSubscription().getPagingStore().startPaging();
        ClientProducer producer = session.createProducer(ADDRESS);
        for (i = 0; i < 20; ++i) {
            message = session.createMessage(true);
            bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(new byte[400]);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            session.commit();
            queue.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        for (i = 20; i < 24; ++i) {
            message = session.createMessage(true);
            bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(new byte[400]);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.rollback();
        ClientSession consumerSession = this.sf.createSession(false, false);
        queue.getPageSubscription().getPagingStore().disableCleanup();
        queue.getPageSubscription().getPagingStore().getCursorProvider().cleanup();
        consumerSession.start();
        ClientConsumer consumer = consumerSession.createConsumer(ADDRESS, SimpleString.toSimpleString((String)"id > 0"));
        for (int i2 = 0; i2 < 19; ++i2) {
            ClientMessage messageRec = consumer.receive(5000L);
            System.err.println("msg::" + messageRec);
            Assert.assertNotNull((Object)messageRec);
            messageRec.acknowledge();
            consumerSession.commit();
            queue.getPageSubscription().getPagingStore().getCursorProvider().cleanup();
        }
        queue.getPageSubscription().getPagingStore().enableCleanup();
        consumerSession.close();
        session.close();
        this.sf.close();
        this.server.stop();
    }

    @Test
    public void testRestartWithComplete() throws Exception {
        ClientMessage message;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        final AtomicBoolean mainCleanup = new AtomicBoolean(true);
        this.server = new ActiveMQServerImpl(config, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)new ActiveMQSecurityManagerImpl()){

            protected PagingStoreFactoryNIO getPagingStoreFactory() {
                return new PagingStoreFactoryNIO(this.getStorageManager(), this.getConfiguration().getPagingLocation(), this.getConfiguration().getJournalBufferTimeout_NIO(), this.getScheduledPool(), this.getExecutorFactory(), this.getConfiguration().isJournalSyncNonTransactional(), null){

                    public PageCursorProvider newCursorProvider(PagingStore store, StorageManager storageManager, AddressSettings addressSettings, ArtemisExecutor executor) {
                        class InterruptedCursorProvider
                        extends PageCursorProviderImpl {
                            final /* synthetic */ AtomicBoolean val$mainCleanup;

                            InterruptedCursorProvider(PagingStore pagingStore, StorageManager storageManager, ArtemisExecutor executor, int maxCacheSize) {
                                this.val$mainCleanup = atomicBoolean;
                                super(pagingStore, storageManager, executor, maxCacheSize);
                            }

                            public void cleanup() {
                                if (this.val$mainCleanup.get()) {
                                    super.cleanup();
                                } else {
                                    try {
                                        this.pagingStore.unlock();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        return new InterruptedCursorProvider(PagingTest.this, store, storageManager, executor, addressSettings.getPageCacheMaxSize(), mainCleanup);
                    }
                };
            }
        };
        this.addServer(this.server);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(102400L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(true, true, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        org.apache.activemq.artemis.core.server.Queue queue1 = this.server.locateQueue(ADDRESS);
        queue1.getPageSubscription().getPagingStore().startPaging();
        ClientProducer producer = session.createProducer(ADDRESS);
        for (int i = 0; i < 20; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(new byte[400]);
            message.putIntProperty(new SimpleString("idi"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            session.commit();
            if (i >= 19) continue;
            queue1.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        Wait.assertEquals((int)20, () -> queue1.getPageSubscription().getPagingStore().getCurrentWritingPage());
        long tx = this.server.getStorageManager().generateID();
        for (int i = 1; i <= 20; ++i) {
            this.server.getStorageManager().storePageCompleteTransactional(tx, queue1.getID().longValue(), (PagePosition)new PagePositionImpl((long)i, 1));
        }
        this.server.getStorageManager().commit(tx);
        session.close();
        this.sf.close();
        this.server.stop();
        mainCleanup.set(false);
        logger.trace((Object)"Server restart");
        this.server.start();
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(null, null, false, false, true, false, 0);
        producer = session.createProducer(ADDRESS);
        for (int i = 0; i < 10; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(new byte[400]);
            message.putIntProperty(new SimpleString("newid"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            session.commit();
            if (i != 5) continue;
            queue.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        mainCleanup.set(true);
        queue = this.server.locateQueue(ADDRESS);
        queue.getPageSubscription().cleanupEntries(false);
        queue.getPageSubscription().getPagingStore().getCursorProvider().cleanup();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 10; ++i) {
            message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)i, (long)message.getIntProperty("newid").intValue());
            message.acknowledge();
        }
        this.server.stop();
    }

    @Test
    public void testCommitOnSend() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfIntegers = 10;
        int numberOfMessages = 500;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(null, null, false, false, false, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        for (int i = 0; i < 500; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            for (int j = 1; j <= 10; ++j) {
                bodyLocal.writeInt(j);
            }
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        session.close();
        this.locator.close();
        this.locator = this.createInVMNonHALocator();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(null, null, false, false, false, false, 0);
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 500; ++i) {
            ClientMessage msg = consumer.receive(5000L);
            Assert.assertNotNull((Object)msg);
            msg.acknowledge();
            session.commit();
        }
        session.close();
    }

    @Test
    public void testParialConsume() throws Exception {
        ClientMessage msg;
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 1000;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(null, null, false, false, false, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        for (int i2 = 0; i2 < 1000; ++i2) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(new byte[1024]);
            message.putIntProperty(new SimpleString("id"), i2);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        session.close();
        this.locator.close();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(null, null, false, false, false, false, 0);
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (i = 0; i < 347; ++i) {
            msg = consumer.receive(5000L);
            PagingTest.assertEquals((long)i, (long)msg.getIntProperty("id").intValue());
            Assert.assertNotNull((Object)msg);
            msg.acknowledge();
            session.commit();
        }
        session.close();
        this.locator.close();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(null, null, false, false, false, false, 0);
        consumer = session.createConsumer(ADDRESS);
        session.start();
        for (i = 347; i < 1000; ++i) {
            msg = consumer.receive(5000L);
            PagingTest.assertEquals((long)i, (long)msg.getIntProperty("id").intValue());
            Assert.assertNotNull((Object)msg);
            msg.acknowledge();
            session.commit();
        }
        session.close();
    }

    @Test
    public void testPageMultipleDestinations() throws Exception {
        this.internalTestPageMultipleDestinations(false);
    }

    @Test
    public void testPageMultipleDestinationsTransacted() throws Exception {
        this.internalTestPageMultipleDestinations(true);
    }

    @Test
    public void testDropMessagesPersistent() throws Exception {
        this.testDropMessages(true);
    }

    @Test
    public void testDropMessagesNonPersistent() throws Exception {
        this.testDropMessages(false);
    }

    public void testDropMessages(boolean persistent) throws Exception {
        byte[] body;
        ClientMessage message2;
        int i;
        this.clearDataRecreateServerDirs();
        HashMap<String, AddressSettings> settings = new HashMap<String, AddressSettings>();
        AddressSettings set = new AddressSettings();
        set.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        settings.put(ADDRESS.toString(), set);
        this.server = this.createServer(persistent, this.createDefaultInVMConfig(), 1024, 10240L, settings);
        this.server.start();
        int numberOfMessages = 1000;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        for (int i2 = 0; i2 < 1000; ++i2) {
            byte[] body2 = new byte[2048];
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(body2);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (i = 0; i < 5; ++i) {
            message2 = consumer.receive(5000L);
            Assert.assertNotNull((Object)message2);
            message2.acknowledge();
        }
        Assert.assertNull((Object)consumer.receiveImmediate());
        Wait.assertEquals((long)0L, () -> this.server.getPagingManager().getPageStore(ADDRESS).getAddressSize());
        for (i = 0; i < 1000; ++i) {
            body = new byte[2048];
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        for (i = 0; i < 5; ++i) {
            message2 = consumer.receive(5000L);
            Assert.assertNotNull((Object)message2);
            message2.acknowledge();
        }
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
        session = this.sf.createSession(false, true, true);
        producer = session.createProducer(ADDRESS);
        for (i = 0; i < 1000; ++i) {
            body = new byte[2048];
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        consumer = session.createConsumer(ADDRESS);
        session.start();
        for (i = 0; i < 5; ++i) {
            message2 = consumer.receive(5000L);
            Assert.assertNotNull((Object)message2);
            message2.acknowledge();
        }
        session.commit();
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
        Wait.assertEquals((long)0L, () -> this.server.getPagingManager().getPageStore(ADDRESS).getAddressSize());
    }

    @Test
    public void testDropMessagesExpiring() throws Exception {
        this.clearDataRecreateServerDirs();
        HashMap<String, AddressSettings> settings = new HashMap<String, AddressSettings>();
        AddressSettings set = new AddressSettings();
        set.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        settings.put(ADDRESS.toString(), set);
        this.server = this.createServer(true, this.createDefaultInVMConfig(), 1024, 0x100000L, settings);
        this.server.start();
        int numberOfMessages = 30000;
        this.locator.setAckBatchSize(0);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession sessionProducer = this.sf.createSession();
        sessionProducer.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = sessionProducer.createProducer(ADDRESS);
        ClientMessage message = null;
        ClientSession sessionConsumer = this.sf.createSession();
        ClientConsumer consumer = sessionConsumer.createConsumer(ADDRESS);
        sessionConsumer.start();
        class MyHandler
        implements MessageHandler {
            int count;

            MyHandler() {
            }

            public void onMessage(ClientMessage message1) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++this.count;
                if (this.count % 1000 == 0) {
                    log.debug((Object)("received " + this.count));
                }
                try {
                    message1.acknowledge();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        consumer.setMessageHandler((MessageHandler)new MyHandler());
        for (int i = 0; i < 30000; ++i) {
            byte[] body = new byte[1024];
            message = sessionProducer.createMessage(false);
            message.getBodyBuffer().writeBytes(body);
            message.setExpiration(System.currentTimeMillis() + 100L);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        sessionProducer.close();
        sessionConsumer.close();
    }

    private void internalTestPageMultipleDestinations(boolean transacted) throws Exception {
        int i;
        Configuration config = this.createDefaultInVMConfig();
        int NUMBER_OF_BINDINGS = 100;
        int NUMBER_OF_MESSAGES = 2;
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(null, null, false, !transacted, true, false, 0);
        for (int i2 = 0; i2 < 100; ++i2) {
            session.createQueue(new QueueConfiguration(new SimpleString("someQueue" + i2)).setAddress(ADDRESS).setDurable(Boolean.valueOf(true)));
        }
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(body);
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (!transacted) continue;
            session.commit();
        }
        session.close();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        sf = this.createSessionFactory(this.locator);
        session = sf.createSession(null, null, false, true, true, false, 0);
        session.start();
        for (int msg = 0; msg < NUMBER_OF_MESSAGES; ++msg) {
            for (int i3 = 0; i3 < 100; ++i3) {
                ClientConsumer consumer = session.createConsumer(new SimpleString("someQueue" + i3));
                ClientMessage message2 = consumer.receive(5000L);
                Assert.assertNotNull((Object)message2);
                message2.acknowledge();
                Assert.assertNotNull((Object)message2);
                consumer.close();
            }
        }
        session.close();
        for (i = 0; i < 100; ++i) {
            org.apache.activemq.artemis.core.server.Queue queue = (org.apache.activemq.artemis.core.server.Queue)this.server.getPostOffice().getBinding(new SimpleString("someQueue" + i)).getBindable();
            Assert.assertEquals((String)("Queue someQueue" + i + " was supposed to be empty"), (long)0L, (long)this.getMessageCount(queue));
            Assert.assertEquals((String)("Queue someQueue" + i + " was supposed to be empty"), (long)0L, (long)queue.getDeliveringCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncPage() throws Exception {
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        try {
            this.server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
            this.server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
            CountDownLatch pageUp = new CountDownLatch(0);
            CountDownLatch pageDone = new CountDownLatch(1);
            DummyOperationContext ctx = new DummyOperationContext(pageUp, pageDone);
            OperationContextImpl.setContext((OperationContext)ctx);
            PagingManager paging = this.server.getPagingManager();
            PagingStore store = paging.getPageStore(ADDRESS);
            store.sync();
            PagingTest.assertTrue((boolean)pageUp.await(10L, TimeUnit.SECONDS));
            PagingTest.assertTrue((boolean)pageDone.await(10L, TimeUnit.SECONDS));
            this.server.stop();
        }
        finally {
            try {
                this.server.stop();
            }
            catch (Throwable throwable) {}
            OperationContextImpl.clearContext();
        }
    }

    @Test
    public void testSyncPageTX() throws Exception {
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        CountDownLatch pageUp = new CountDownLatch(0);
        CountDownLatch pageDone = new CountDownLatch(1);
        DummyOperationContext ctx = new DummyOperationContext(pageUp, pageDone);
        OperationContextImpl.setContext((OperationContext)ctx);
        PagingManager paging = this.server.getPagingManager();
        PagingStore store = paging.getPageStore(ADDRESS);
        store.sync();
        PagingTest.assertTrue((boolean)pageUp.await(10L, TimeUnit.SECONDS));
        PagingTest.assertTrue((boolean)pageDone.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testPagingOneDestinationOnly() throws Exception {
        SimpleString PAGED_ADDRESS = new SimpleString("paged");
        SimpleString NON_PAGED_ADDRESS = new SimpleString("non-paged");
        Configuration configuration = this.createDefaultInVMConfig();
        HashMap<String, AddressSettings> addresses = new HashMap<String, AddressSettings>();
        addresses.put("#", new AddressSettings());
        AddressSettings pagedDestination = new AddressSettings().setPageSizeBytes(1024).setMaxSizeBytes(10240L);
        addresses.put(PAGED_ADDRESS.toString(), pagedDestination);
        this.server = this.createServer(true, configuration, -1, -1L, addresses);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(PAGED_ADDRESS));
        session.createQueue(new QueueConfiguration(NON_PAGED_ADDRESS));
        ClientProducer producerPaged = session.createProducer(PAGED_ADDRESS);
        ClientProducer producerNonPaged = session.createProducer(NON_PAGED_ADDRESS);
        int NUMBER_OF_MESSAGES = 100;
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.getBodyBuffer().writeBytes(new byte[512]);
            producerPaged.send((org.apache.activemq.artemis.api.core.Message)msg);
            producerNonPaged.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        session.close();
        Assert.assertTrue((boolean)this.server.getPagingManager().getPageStore(PAGED_ADDRESS).isPaging());
        Assert.assertFalse((boolean)this.server.getPagingManager().getPageStore(NON_PAGED_ADDRESS).isPaging());
        session = this.sf.createSession(false, true, false);
        session.start();
        ClientConsumer consumerNonPaged = session.createConsumer(NON_PAGED_ADDRESS);
        ClientConsumer consumerPaged = session.createConsumer(PAGED_ADDRESS);
        ClientMessage[] ackList = new ClientMessage[NUMBER_OF_MESSAGES];
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            ClientMessage msg = consumerNonPaged.receive(5000L);
            Assert.assertNotNull((Object)msg);
            ackList[i] = msg;
        }
        Assert.assertNull((Object)consumerNonPaged.receiveImmediate());
        for (ClientMessage ack : ackList) {
            ack.acknowledge();
        }
        consumerNonPaged.close();
        session.commit();
        ackList = null;
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            ClientMessage msg = consumerPaged.receive(5000L);
            Assert.assertNotNull((Object)msg);
            msg.acknowledge();
            session.commit();
        }
        Assert.assertNull((Object)consumerPaged.receiveImmediate());
        session.close();
    }

    @Test
    public void testPagingDifferentSizes() throws Exception {
        ClientMessage msg;
        int i;
        ClientMessage msg2;
        int i2;
        SimpleString PAGED_ADDRESS_A = new SimpleString("paged-a");
        SimpleString PAGED_ADDRESS_B = new SimpleString("paged-b");
        Configuration configuration = this.createDefaultInVMConfig();
        HashMap<String, AddressSettings> addresses = new HashMap<String, AddressSettings>();
        addresses.put("#", new AddressSettings());
        AddressSettings pagedDestinationA = new AddressSettings().setPageSizeBytes(1024).setMaxSizeBytes(10240L);
        int NUMBER_MESSAGES_BEFORE_PAGING = 11;
        addresses.put(PAGED_ADDRESS_A.toString(), pagedDestinationA);
        AddressSettings pagedDestinationB = new AddressSettings().setPageSizeBytes(2024).setMaxSizeBytes(20480L);
        addresses.put(PAGED_ADDRESS_B.toString(), pagedDestinationB);
        this.server = this.createServer(true, configuration, -1, -1L, addresses);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(PAGED_ADDRESS_A));
        session.createQueue(new QueueConfiguration(PAGED_ADDRESS_B));
        ClientProducer producerA = session.createProducer(PAGED_ADDRESS_A);
        ClientProducer producerB = session.createProducer(PAGED_ADDRESS_B);
        int NUMBER_OF_MESSAGES = 100;
        for (i2 = 0; i2 < NUMBER_MESSAGES_BEFORE_PAGING; ++i2) {
            msg2 = session.createMessage(true);
            msg2.getBodyBuffer().writeBytes(new byte[896]);
            producerA.send((org.apache.activemq.artemis.api.core.Message)msg2);
            producerB.send((org.apache.activemq.artemis.api.core.Message)msg2);
        }
        session.commit();
        Assert.assertTrue((boolean)this.server.getPagingManager().getPageStore(PAGED_ADDRESS_A).isPaging());
        Assert.assertFalse((boolean)this.server.getPagingManager().getPageStore(PAGED_ADDRESS_B).isPaging());
        for (i2 = 0; i2 < NUMBER_MESSAGES_BEFORE_PAGING; ++i2) {
            msg2 = session.createMessage(true);
            msg2.getBodyBuffer().writeBytes(new byte[896]);
            producerA.send((org.apache.activemq.artemis.api.core.Message)msg2);
            producerB.send((org.apache.activemq.artemis.api.core.Message)msg2);
        }
        session.commit();
        Assert.assertTrue((boolean)this.server.getPagingManager().getPageStore(PAGED_ADDRESS_A).isPaging());
        Assert.assertTrue((boolean)this.server.getPagingManager().getPageStore(PAGED_ADDRESS_B).isPaging());
        for (i2 = NUMBER_MESSAGES_BEFORE_PAGING * 2; i2 < NUMBER_OF_MESSAGES; ++i2) {
            msg2 = session.createMessage(true);
            msg2.getBodyBuffer().writeBytes(new byte[896]);
            producerA.send((org.apache.activemq.artemis.api.core.Message)msg2);
            producerB.send((org.apache.activemq.artemis.api.core.Message)msg2);
        }
        session.close();
        Assert.assertTrue((boolean)this.server.getPagingManager().getPageStore(PAGED_ADDRESS_A).isPaging());
        Assert.assertTrue((boolean)this.server.getPagingManager().getPageStore(PAGED_ADDRESS_B).isPaging());
        session = this.sf.createSession(null, null, false, true, true, false, 0);
        session.start();
        ClientConsumer consumerA = session.createConsumer(PAGED_ADDRESS_A);
        ClientConsumer consumerB = session.createConsumer(PAGED_ADDRESS_B);
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            msg = consumerA.receive(5000L);
            Assert.assertNotNull((String)("Couldn't receive a message on consumerA, iteration = " + i), (Object)msg);
            msg.acknowledge();
        }
        Assert.assertNull((Object)consumerA.receiveImmediate());
        consumerA.close();
        Assert.assertTrue((boolean)this.server.getPagingManager().getPageStore(PAGED_ADDRESS_B).isPaging());
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            msg = consumerB.receive(5000L);
            Assert.assertNotNull((Object)msg);
            msg.acknowledge();
            session.commit();
        }
        Assert.assertNull((Object)consumerB.receiveImmediate());
        consumerB.close();
        session.close();
    }

    @Test
    public void testPageAndDepageRapidly() throws Exception {
        boolean persistentMessages = true;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false).setJournalFileSize(0xA00000);
        this.server = this.createServer(true, config, 102400, 524288L);
        this.server.start();
        int messageSize = 51527;
        int numberOfMessages = 200;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(true, true);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        final AtomicInteger errors = new AtomicInteger(0);
        Thread consumeThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClientSession sessionConsumer = null;
                try {
                    sessionConsumer = PagingTest.this.sf.createSession(false, false);
                    sessionConsumer.start();
                    ClientConsumer cons = sessionConsumer.createConsumer(ADDRESS);
                    for (int i = 0; i < 200; ++i) {
                        ClientMessage msg = cons.receive(5000L);
                        Assert.assertNotNull((Object)msg);
                        msg.acknowledge();
                        if (i % 20 != 0) continue;
                        sessionConsumer.commit();
                    }
                    sessionConsumer.commit();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    try {
                        sessionConsumer.close();
                    }
                    catch (ActiveMQException e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                }
            }
        };
        consumeThread.start();
        ClientMessage message = null;
        byte[] body = new byte[51527];
        for (int i = 0; i < 200; ++i) {
            message = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            Thread.sleep(50L);
        }
        consumeThread.join();
        PagingTest.assertEquals((long)0L, (long)errors.get());
        long timeout = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < timeout && (this.server.getPagingManager().getPageStore(ADDRESS).isPaging() || this.server.getPagingManager().getPageStore(ADDRESS).getNumberOfPages() != 1)) {
            Thread.sleep(1L);
        }
        PagingTest.assertFalse((boolean)this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
        Wait.assertEquals((int)0, () -> this.server.getPagingManager().getPageStore(ADDRESS).getNumberOfPages());
    }

    @Test
    public void testTwoQueuesDifferentFilters() throws Exception {
        boolean persistentMessages = true;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 200;
        this.locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(120000L).setConnectionTTL(5000000L).setCallTimeout(120000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        int NQUEUES = 2;
        for (int i = 0; i < NQUEUES; ++i) {
            session.createQueue(new QueueConfiguration(ADDRESS.concat("=" + i)).setAddress(ADDRESS).setFilterString(new SimpleString("propTest=" + i)).setDurable(Boolean.valueOf(true)));
        }
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        for (int i = 0; i < 200; ++i) {
            message = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty("propTest", i % NQUEUES);
            message.putIntProperty("id", i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.start();
        for (int nqueue = 0; nqueue < NQUEUES; ++nqueue) {
            ClientConsumer consumer = session.createConsumer(ADDRESS.concat("=" + nqueue));
            for (int i = 0; i < 200 / NQUEUES; ++i) {
                message = consumer.receive(500000L);
                PagingTest.assertNotNull((Object)message);
                message.acknowledge();
                PagingTest.assertEquals((long)nqueue, (long)message.getIntProperty("propTest").intValue());
            }
            PagingTest.assertNull((Object)consumer.receiveImmediate());
            consumer.close();
            session.commit();
        }
        PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
        store.getCursorProvider().cleanup();
        long timeout = System.currentTimeMillis() + 5000L;
        while (store.isPaging() && timeout > System.currentTimeMillis()) {
            Thread.sleep(100L);
        }
        PagingTest.assertFalse((boolean)this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoQueues() throws Exception {
        boolean persistentMessages = true;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int messageSize = 1024;
        int numberOfMessages = 1000;
        try {
            ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(120000L).setConnectionTTL(5000000L).setCallTimeout(120000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration(ADDRESS.concat("=1")).setAddress(ADDRESS));
            session.createQueue(new QueueConfiguration(ADDRESS.concat("=2")).setAddress(ADDRESS));
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = null;
            byte[] body = new byte[1024];
            for (int i = 0; i < 1000; ++i) {
                message = session.createMessage(persistentMessages);
                ActiveMQBuffer bodyLocal = message.getBodyBuffer();
                bodyLocal.writeBytes(body);
                message.putIntProperty("propTest", i % 2 == 0 ? 1 : 2);
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
                if (i % 1000 != 0) continue;
                session.commit();
            }
            session.commit();
            session.start();
            for (int msg = 1; msg <= 2; ++msg) {
                ClientConsumer consumer = session.createConsumer(ADDRESS.concat("=" + msg));
                for (int i = 0; i < 1000; ++i) {
                    message = consumer.receive(5000L);
                    PagingTest.assertNotNull((Object)message);
                    message.acknowledge();
                }
                session.commit();
                PagingTest.assertNull((Object)consumer.receiveImmediate());
                consumer.close();
            }
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            store.getCursorProvider().cleanup();
            long timeout = System.currentTimeMillis() + 5000L;
            while (store.isPaging() && timeout > System.currentTimeMillis()) {
                Thread.sleep(100L);
            }
            store.getCursorProvider().cleanup();
            this.waitForNotPaging(this.server.locateQueue(ADDRESS.concat("=1")));
            sf.close();
            locator.close();
        }
        finally {
            try {
                this.server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoQueuesAndOneInativeQueue() throws Exception {
        boolean persistentMessages = true;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        try {
            ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(120000L).setConnectionTTL(5000000L).setCallTimeout(120000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration(ADDRESS.concat("=1")).setAddress(ADDRESS));
            session.createQueue(new QueueConfiguration(ADDRESS.concat("=2")).setAddress(ADDRESS));
            session.createQueue(new QueueConfiguration(ADDRESS.concat("-3")).setAddress(ADDRESS).setFilterString(new SimpleString("nothing='something'")));
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS.concat("=1"));
            queue.getPageSubscription().getPagingStore().startPaging();
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(new byte[1024]);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            session.commit();
            session.start();
            for (int msg = 1; msg <= 2; ++msg) {
                ClientConsumer consumer = session.createConsumer(ADDRESS.concat("=" + msg));
                message = consumer.receive(5000L);
                PagingTest.assertNotNull((Object)message);
                message.acknowledge();
                PagingTest.assertNull((Object)consumer.receiveImmediate());
                consumer.close();
            }
            session.commit();
            session.close();
            store.getCursorProvider().cleanup();
            this.waitForNotPaging(this.server.locateQueue(ADDRESS.concat("=1")));
            sf.close();
            locator.close();
        }
        finally {
            try {
                this.server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoQueuesConsumeOneRestart() throws Exception {
        boolean persistentMessages = true;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int messageSize = 1024;
        int numberOfMessages = 1000;
        try {
            ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(120000L).setConnectionTTL(5000000L).setCallTimeout(120000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration(ADDRESS.concat("=1")).setAddress(ADDRESS));
            session.createQueue(new QueueConfiguration(ADDRESS.concat("=2")).setAddress(ADDRESS));
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = null;
            byte[] body = new byte[1024];
            for (int i = 0; i < 1000; ++i) {
                message = session.createMessage(persistentMessages);
                ActiveMQBuffer bodyLocal = message.getBodyBuffer();
                bodyLocal.writeBytes(body);
                message.putIntProperty("propTest", i % 2 == 0 ? 1 : 2);
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
                if (i % 1000 != 0) continue;
                session.commit();
            }
            session.commit();
            session.start();
            session.deleteQueue(ADDRESS.concat("=1"));
            sf = locator.createSessionFactory();
            session = sf.createSession(false, false, false);
            session.start();
            ClientConsumer consumer = session.createConsumer(ADDRESS.concat("=2"));
            for (int i = 0; i < 1000; ++i) {
                message = consumer.receive(5000L);
                PagingTest.assertNotNull((Object)message);
                message.acknowledge();
            }
            session.commit();
            PagingTest.assertNull((Object)consumer.receiveImmediate());
            consumer.close();
            long timeout = System.currentTimeMillis() + 10000L;
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            while (timeout > System.currentTimeMillis() && store.isPaging()) {
                Thread.sleep(100L);
            }
            PagingTest.assertFalse((boolean)this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
            this.server.stop();
            this.server.start();
            this.server.stop();
            this.server.start();
            sf.close();
            locator.close();
        }
        finally {
            try {
                this.server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDLAOnLargeMessageAndPaging() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setThreadPoolMaxSize(5).setJournalSyncNonTransactional(false);
        HashMap<String, AddressSettings> settings = new HashMap<String, AddressSettings>();
        AddressSettings dla = new AddressSettings().setMaxDeliveryAttempts(5).setDeadLetterAddress(new SimpleString("DLA")).setRedeliveryDelay(0L);
        settings.put(ADDRESS.toString(), dla);
        this.server = this.createServer(true, config, 10240, 102400L, settings);
        this.server.start();
        int messageSize = 1024;
        ServerLocator locator = null;
        ClientSessionFactory sf = null;
        ClientSession session = null;
        try {
            int i;
            int msgNr;
            locator = this.createInVMNonHALocator();
            locator.setBlockOnNonDurableSend(true);
            locator.setBlockOnDurableSend(true);
            sf = locator.createSessionFactory();
            session = sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration(ADDRESS));
            session.createQueue(new QueueConfiguration("DLA"));
            org.apache.activemq.artemis.core.server.Queue serverQueue = this.server.locateQueue(ADDRESS);
            org.apache.activemq.artemis.core.server.Queue serverQueueDLA = this.server.locateQueue(SimpleString.toSimpleString((String)"DLA"));
            PagingStore pgStoreAddress = this.server.getPagingManager().getPageStore(ADDRESS);
            pgStoreAddress.startPaging();
            PagingStore pgStoreDLA = this.server.getPagingManager().getPageStore(new SimpleString("DLA"));
            ClientProducer producer = session.createProducer(ADDRESS);
            for (int i2 = 0; i2 < 100; ++i2) {
                log.debug((Object)("send message #" + i2));
                ClientMessage message = session.createMessage(true);
                message.putStringProperty("id", "str" + i2);
                message.setBodyInputStream(PagingTest.createFakeLargeStream((long)1024L));
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
                if ((i2 + 1) % 2 != 0) continue;
                session.commit();
            }
            session.commit();
            session.start();
            ClientConsumer cons = session.createConsumer(ADDRESS);
            for (msgNr = 0; msgNr < 2; ++msgNr) {
                for (int i3 = 0; i3 < 5; ++i3) {
                    ClientMessage msg = cons.receive(5000L);
                    PagingTest.assertNotNull((Object)msg);
                    msg.acknowledge();
                    for (int j = 0; j < 1024; ++j) {
                        PagingTest.assertEquals((long)PagingTest.getSamplebyte((long)j), (long)msg.getBodyBuffer().readByte());
                    }
                    session.rollback();
                }
                pgStoreDLA.startPaging();
            }
            for (i = 2; i < 100; ++i) {
                log.debug((Object)("Received message " + i));
                ClientMessage message = cons.receive(5000L);
                PagingTest.assertNotNull((String)("Message " + i + " wasn't received"), (Object)message);
                message.acknowledge();
                final AtomicInteger bytesOutput = new AtomicInteger(0);
                message.setOutputStream(new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        bytesOutput.incrementAndGet();
                    }
                });
                try {
                    if (message.waitOutputStreamCompletion(10000L)) continue;
                    log.debug((Object)PagingTest.threadDump((String)"dump"));
                    PagingTest.fail((String)"Couldn't finish large message receiving");
                    continue;
                }
                catch (Throwable e) {
                    log.debug((Object)("output bytes = " + bytesOutput));
                    log.debug((Object)PagingTest.threadDump((String)"dump"));
                    PagingTest.fail((String)("Couldn't finish large message receiving for id=" + message.getStringProperty("id") + " with messageID=" + message.getMessageID()));
                }
            }
            PagingTest.assertNull((Object)cons.receiveImmediate());
            cons.close();
            cons = session.createConsumer("DLA");
            for (i = 0; i < 2; ++i) {
                PagingTest.assertNotNull((Object)cons.receive(5000L));
            }
            sf.close();
            session.close();
            locator.close();
            this.server.stop();
            this.server.start();
            locator = this.createInVMNonHALocator();
            sf = locator.createSessionFactory();
            session = sf.createSession(false, false);
            session.start();
            cons = session.createConsumer(ADDRESS);
            for (i = 2; i < 100; ++i) {
                log.debug((Object)("Received message " + i));
                ClientMessage message = cons.receive(5000L);
                PagingTest.assertNotNull((Object)message);
                PagingTest.assertEquals((Object)("str" + i), (Object)message.getStringProperty("id"));
                message.acknowledge();
                message.setOutputStream(new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                    }
                });
                PagingTest.assertTrue((boolean)message.waitOutputStreamCompletion(5000L));
            }
            PagingTest.assertNull((Object)cons.receiveImmediate());
            cons.close();
            cons = session.createConsumer("DLA");
            for (msgNr = 0; msgNr < 2; ++msgNr) {
                ClientMessage msg = cons.receive(10000L);
                PagingTest.assertNotNull((Object)msg);
                PagingTest.assertEquals((Object)("str" + msgNr), (Object)msg.getStringProperty("id"));
                for (int i4 = 0; i4 < 1024; ++i4) {
                    PagingTest.assertEquals((long)PagingTest.getSamplebyte((long)i4), (long)msg.getBodyBuffer().readByte());
                }
                msg.acknowledge();
            }
            cons.close();
            cons = session.createConsumer(ADDRESS);
            session.commit();
            PagingTest.assertNull((Object)cons.receiveImmediate());
            long timeout = System.currentTimeMillis() + 5000L;
            pgStoreAddress = this.server.getPagingManager().getPageStore(ADDRESS);
            pgStoreAddress.getCursorProvider().getSubscription(serverQueue.getID().longValue()).cleanupEntries(false);
            pgStoreAddress.getCursorProvider().cleanup();
            while (timeout > System.currentTimeMillis() && pgStoreAddress.isPaging()) {
                Thread.sleep(50L);
            }
            PagingTest.assertFalse((boolean)pgStoreAddress.isPaging());
            session.commit();
        }
        finally {
            session.close();
            sf.close();
            locator.close();
            try {
                this.server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpireLargeMessageOnPaging() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setMessageExpiryScanPeriod(500L).setJournalSyncNonTransactional(false);
        HashMap<String, AddressSettings> settings = new HashMap<String, AddressSettings>();
        AddressSettings dla = new AddressSettings().setMaxDeliveryAttempts(5).setDeadLetterAddress(new SimpleString("DLA")).setExpiryAddress(new SimpleString("DLA"));
        settings.put(ADDRESS.toString(), dla);
        this.server = this.createServer(true, config, 10240, 102400L, settings);
        this.server.start();
        int messageSize = 20;
        try {
            ServerLocator locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration(ADDRESS));
            session.createQueue(new QueueConfiguration("DLA"));
            PagingStore pgStoreAddress = this.server.getPagingManager().getPageStore(ADDRESS);
            pgStoreAddress.startPaging();
            PagingStore pgStoreDLA = this.server.getPagingManager().getPageStore(new SimpleString("DLA"));
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = null;
            for (int i = 0; i < 500; ++i) {
                if (i % 100 == 0) {
                    log.debug((Object)("send message #" + i));
                }
                message = session.createMessage(true);
                message.putStringProperty("id", "str" + i);
                message.setExpiration(System.currentTimeMillis() + 2000L);
                if (i % 2 == 0) {
                    message.setBodyInputStream(PagingTest.createFakeLargeStream((long)20L));
                } else {
                    byte[] bytes = new byte[20];
                    for (int s = 0; s < bytes.length; ++s) {
                        bytes[s] = PagingTest.getSamplebyte((long)s);
                    }
                    message.getBodyBuffer().writeBytes(bytes);
                }
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
                if ((i + 1) % 2 != 0) continue;
                session.commit();
                if (i >= 400) continue;
                pgStoreAddress.forceAnotherPage();
            }
            session.commit();
            sf.close();
            locator.close();
            this.server.stop();
            Thread.sleep(3000L);
            this.server.start();
            locator = this.createInVMNonHALocator();
            sf = locator.createSessionFactory();
            session = sf.createSession(false, false);
            session.start();
            ClientConsumer consAddr = session.createConsumer(ADDRESS);
            PagingTest.assertNull((Object)consAddr.receive(1000L));
            ClientConsumer cons = session.createConsumer("DLA");
            for (int i = 0; i < 500; ++i) {
                log.debug((Object)("Received message " + i));
                message = cons.receive(10000L);
                PagingTest.assertNotNull((Object)message);
                message.acknowledge();
                message.saveToOutputStream(new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                    }
                });
            }
            PagingTest.assertNull((Object)cons.receiveImmediate());
            session.commit();
            cons.close();
            long timeout = System.currentTimeMillis() + 5000L;
            pgStoreAddress = this.server.getPagingManager().getPageStore(ADDRESS);
            while (timeout > System.currentTimeMillis() && pgStoreAddress.isPaging()) {
                Thread.sleep(50L);
            }
            PagingTest.assertFalse((boolean)pgStoreAddress.isPaging());
            session.close();
        }
        finally {
            this.locator.close();
            try {
                this.server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailMessagesNonDurable() throws Exception {
        AssertionLoggerHandler.startCapture();
        try {
            this.clearDataRecreateServerDirs();
            Configuration config = this.createDefaultInVMConfig();
            HashMap<String, AddressSettings> settings = new HashMap<String, AddressSettings>();
            AddressSettings set = new AddressSettings();
            set.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
            settings.put(ADDRESS.toString(), set);
            this.server = this.createServer(true, config, 1024, 5120L, settings);
            this.server.start();
            this.locator.setBlockOnNonDurableSend(false).setBlockOnDurableSend(false).setBlockOnAcknowledge(true);
            this.sf = this.createSessionFactory(this.locator);
            ClientSession session = this.sf.createSession(true, true, 0);
            session.createQueue(new QueueConfiguration(ADDRESS));
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = session.createMessage(false);
            int biggerMessageSize = 1024;
            byte[] body = new byte[biggerMessageSize];
            ByteBuffer bb = ByteBuffer.wrap(body);
            for (int j = 1; j <= biggerMessageSize; ++j) {
                bb.put(PagingTest.getSamplebyte((long)j));
            }
            message.getBodyBuffer().writeBytes(body);
            for (int i = 0; i < 32; ++i) {
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
            }
            Thread.sleep(100L);
            Assert.assertTrue((String)"Expected to find AMQ224016", (boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224016"}));
            ClientConsumer consumer = session.createConsumer(ADDRESS);
            session.start();
            for (int i = 0; i < 10; ++i) {
                this.validateExceptionOnSending(producer, message);
            }
            ClientMessage msgReceived = consumer.receive(5000L);
            PagingTest.assertNotNull((Object)msgReceived);
            msgReceived.acknowledge();
            session.commit();
            boolean exception = false;
            try {
                for (int i = 0; i < 1000; ++i) {
                    producer.send((org.apache.activemq.artemis.api.core.Message)message);
                }
            }
            catch (Exception e) {
                exception = true;
            }
            PagingTest.assertTrue((String)"Expected to throw an exception", (boolean)exception);
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    @Test
    public void testFailMessagesDurable() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        HashMap<String, AddressSettings> settings = new HashMap<String, AddressSettings>();
        AddressSettings set = new AddressSettings();
        set.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        settings.put(ADDRESS.toString(), set);
        this.server = this.createServer(true, config, 1024, 5120L, settings);
        this.server.start();
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(true, true, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = session.createMessage(true);
        int biggerMessageSize = 2048;
        byte[] body = new byte[biggerMessageSize];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= biggerMessageSize; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        message.getBodyBuffer().writeBytes(body);
        for (int i = 0; i < 50; ++i) {
            if (i > 2) {
                this.validateExceptionOnSending(producer, message);
                continue;
            }
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        ClientMessage msgReceived = consumer.receive(5000L);
        PagingTest.assertNotNull((Object)msgReceived);
        msgReceived.acknowledge();
        session.commit();
        boolean exception = false;
        try {
            for (int i = 0; i < 1000; ++i) {
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
            }
        }
        catch (Exception e) {
            exception = true;
        }
        PagingTest.assertTrue((String)"Expected to throw an exception", (boolean)exception);
    }

    @Test
    public void testFailMessagesDuplicates() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        HashMap<String, AddressSettings> settings = new HashMap<String, AddressSettings>();
        AddressSettings set = new AddressSettings();
        set.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        settings.put(ADDRESS.toString(), set);
        this.server = this.createServer(true, config, 1024, 5120L, settings);
        this.server.start();
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(this.sf.createSession(true, true, 0));
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = session.createMessage(true);
        int biggerMessageSize = 2048;
        byte[] body = new byte[biggerMessageSize];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= biggerMessageSize; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        message.getBodyBuffer().writeBytes(body);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        org.apache.activemq.artemis.core.server.Queue q = (org.apache.activemq.artemis.core.server.Queue)this.server.getPostOffice().getBinding(ADDRESS).getBindable();
        Wait.assertEquals((long)3L, () -> ((org.apache.activemq.artemis.core.server.Queue)q).getMessageCount());
        SimpleString dupID1 = new SimpleString("abcdefg");
        message.putBytesProperty(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID, dupID1.getData());
        message.putStringProperty("key", dupID1.toString());
        this.validateExceptionOnSending(producer, message);
        Wait.assertEquals((long)3L, () -> ((org.apache.activemq.artemis.core.server.Queue)q).getMessageCount());
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        ClientMessage msgReceived = consumer.receive(5000L);
        PagingTest.assertNotNull((Object)msgReceived);
        msgReceived.acknowledge();
        session.commit();
        consumer.close();
        Wait.assertEquals((long)2L, () -> ((org.apache.activemq.artemis.core.server.Queue)q).getMessageCount());
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Wait.assertEquals((long)3L, () -> ((org.apache.activemq.artemis.core.server.Queue)q).getMessageCount());
        consumer = session.createConsumer(ADDRESS);
        for (int i = 0; i < 3; ++i) {
            msgReceived = consumer.receive(5000L);
            PagingTest.assertNotNull((Object)msgReceived);
            msgReceived.acknowledge();
            session.commit();
        }
    }

    private void validateExceptionOnSending(ClientProducer producer, ClientMessage message) {
        ActiveMQException expected = null;
        try {
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        catch (ActiveMQException e) {
            expected = e;
        }
        PagingTest.assertNotNull((Object)((Object)expected));
        PagingTest.assertEquals((Object)ActiveMQExceptionType.ADDRESS_FULL, (Object)expected.getType());
    }

    @Test
    public void testSpreadMessagesWithFilterWithDeadConsumer() throws Exception {
        this.testSpreadMessagesWithFilter(true);
    }

    @Test
    public void testSpreadMessagesWithFilterWithoutDeadConsumer() throws Exception {
        this.testSpreadMessagesWithFilter(false);
    }

    @Test
    public void testRouteOnTopWithMultipleQueues() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnDurableSend(false);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, 0);
        session.createQueue(new QueueConfiguration("Q1").setAddress("Q").setFilterString("dest=1"));
        session.createQueue(new QueueConfiguration("Q2").setAddress("Q").setFilterString("dest=2"));
        session.createQueue(new QueueConfiguration("Q3").setAddress("Q").setFilterString("dest=3"));
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(new SimpleString("Q1"));
        queue.getPageSubscription().getPagingStore().startPaging();
        ClientProducer prod = session.createProducer("Q");
        ClientMessage msg = session.createMessage(true);
        msg.putIntProperty("dest", 1);
        prod.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.commit();
        msg = session.createMessage(true);
        msg.putIntProperty("dest", 2);
        prod.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.commit();
        session.start();
        ClientConsumer cons1 = session.createConsumer("Q1");
        msg = cons1.receive(5000L);
        PagingTest.assertNotNull((Object)msg);
        msg.acknowledge();
        ClientConsumer cons2 = session.createConsumer("Q2");
        msg = cons2.receive(5000L);
        PagingTest.assertNotNull((Object)msg);
        queue.getPageSubscription().getPagingStore().forceAnotherPage();
        msg = session.createMessage(true);
        msg.putIntProperty("dest", 1);
        prod.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.commit();
        msg = cons1.receive(5000L);
        PagingTest.assertNotNull((Object)msg);
        msg.acknowledge();
        queue.getPageSubscription().cleanupEntries(false);
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSpreadMessagesWithFilter(boolean deadConsumer) throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        try {
            ClientMessage m;
            int i;
            ClientMessage m2;
            int i2;
            ServerLocator locator = this.createInVMNonHALocator();
            locator.setBlockOnDurableSend(false);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(true, false);
            session.createQueue(new QueueConfiguration("Q1").setAddress(ADDRESS).setFilterString("destQ=1 or both=true"));
            session.createQueue(new QueueConfiguration("Q2").setAddress(ADDRESS).setFilterString("destQ=2 or both=true"));
            if (deadConsumer) {
                session.createQueue(new QueueConfiguration("Q3").setAddress(ADDRESS.toString()).setFilterString("destQ=3"));
            }
            session.createQueue(new QueueConfiguration("Q_initial").setAddress(ADDRESS.toString()).setFilterString("initialBurst=true"));
            ClientSession sessionConsumerQ3 = null;
            final AtomicInteger consumerQ3Msgs = new AtomicInteger(0);
            if (deadConsumer) {
                sessionConsumerQ3 = sf.createSession(true, true);
                ClientConsumer consumerQ3 = sessionConsumerQ3.createConsumer("Q3");
                consumerQ3.setMessageHandler(new MessageHandler(){

                    public void onMessage(ClientMessage message) {
                        consumerQ3Msgs.incrementAndGet();
                    }
                });
                sessionConsumerQ3.start();
            }
            int initialBurst = 100;
            int messagesSentAfterBurst = 100;
            int MESSAGE_SIZE = 300;
            byte[] bodyWrite = new byte[300];
            org.apache.activemq.artemis.core.server.Queue serverQueue = this.server.locateQueue(new SimpleString("Q1"));
            PagingStore pageStore = serverQueue.getPageSubscription().getPagingStore();
            ClientProducer producer = session.createProducer(ADDRESS);
            for (i2 = 0; i2 < 100; ++i2) {
                m2 = session.createMessage(true);
                m2.getBodyBuffer().writeBytes(bodyWrite);
                m2.putIntProperty("destQ", 1);
                m2.putBooleanProperty("both", false);
                m2.putBooleanProperty("initialBurst", true);
                producer.send((org.apache.activemq.artemis.api.core.Message)m2);
                if (i2 % 100 != 0) continue;
                session.commit();
            }
            session.commit();
            pageStore.forceAnotherPage();
            for (i2 = 0; i2 < 100; ++i2) {
                m2 = session.createMessage(true);
                m2.getBodyBuffer().writeBytes(bodyWrite);
                m2.putIntProperty("destQ", 1);
                m2.putBooleanProperty("initialBurst", false);
                m2.putIntProperty("i", i2);
                m2.putBooleanProperty("both", i2 % 10 == 0);
                producer.send((org.apache.activemq.artemis.api.core.Message)m2);
                if (i2 % 10 != 0) {
                    m2 = session.createMessage(true);
                    m2.getBodyBuffer().writeBytes(bodyWrite);
                    m2.putIntProperty("destQ", 2);
                    m2.putIntProperty("i", i2);
                    m2.putBooleanProperty("both", false);
                    m2.putBooleanProperty("initialBurst", false);
                    producer.send((org.apache.activemq.artemis.api.core.Message)m2);
                }
                if (i2 <= 0 || i2 % 10 != 0) continue;
                session.commit();
                if (i2 + 10 >= 100) continue;
                pageStore.forceAnotherPage();
            }
            session.commit();
            ClientConsumer consumerQ1 = session.createConsumer("Q1");
            ClientConsumer consumerQ2 = session.createConsumer("Q2");
            session.start();
            for (int i3 = 0; i3 < 100; ++i3) {
                ClientMessage m3 = consumerQ1.receive(5000L);
                PagingTest.assertNotNull((Object)m3);
                PagingTest.assertEquals((long)1L, (long)m3.getIntProperty("destQ").intValue());
                m3.acknowledge();
                session.commit();
            }
            ClientConsumer consumerInitial = session.createConsumer("Q_initial");
            for (i = 0; i < 100; ++i) {
                m = consumerInitial.receive(5000L);
                PagingTest.assertNotNull((Object)m);
                PagingTest.assertEquals((long)1L, (long)m.getIntProperty("destQ").intValue());
                m.acknowledge();
            }
            PagingTest.assertNull((Object)consumerInitial.receiveImmediate());
            session.commit();
            for (i = 0; i < 100; ++i) {
                m = consumerQ1.receive(5000L);
                PagingTest.assertNotNull((Object)m);
                if (!m.getBooleanProperty("both").booleanValue()) {
                    PagingTest.assertEquals((long)1L, (long)m.getIntProperty("destQ").intValue());
                }
                PagingTest.assertEquals((long)i, (long)m.getIntProperty("i").intValue());
                m.acknowledge();
                session.commit();
            }
            for (i = 0; i < 100; ++i) {
                m = consumerQ2.receive(5000L);
                PagingTest.assertNotNull((Object)m);
                if (!m.getBooleanProperty("both").booleanValue()) {
                    PagingTest.assertEquals((long)2L, (long)m.getIntProperty("destQ").intValue());
                }
                PagingTest.assertEquals((long)i, (long)m.getIntProperty("i").intValue());
                m.acknowledge();
                session.commit();
            }
            this.waitForNotPaging(serverQueue);
            if (sessionConsumerQ3 != null) {
                sessionConsumerQ3.close();
            }
            PagingTest.assertEquals((long)0L, (long)consumerQ3Msgs.intValue());
            session.close();
            locator.close();
        }
        finally {
            this.server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageHole() throws Throwable {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        try {
            ServerLocator locator = this.createInVMNonHALocator().setBlockOnDurableSend(true);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(true, true, 0);
            session.createQueue(new QueueConfiguration("Q1").setAddress(ADDRESS.toString()).setFilterString("dest=1"));
            session.createQueue(new QueueConfiguration("Q2").setAddress(ADDRESS.toString()).setFilterString("dest=2"));
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            store.startPaging();
            ClientProducer prod = session.createProducer(ADDRESS);
            ClientMessage msg = session.createMessage(true);
            msg.putIntProperty("dest", 1);
            prod.send((org.apache.activemq.artemis.api.core.Message)msg);
            for (int i = 0; i < 100; ++i) {
                msg = session.createMessage(true);
                msg.putIntProperty("dest", 2);
                prod.send((org.apache.activemq.artemis.api.core.Message)msg);
                if (i <= 0 || i % 10 != 0) continue;
                store.forceAnotherPage();
            }
            session.start();
            ClientConsumer cons1 = session.createConsumer("Q1");
            ClientMessage msgReceivedCons1 = cons1.receive(5000L);
            PagingTest.assertNotNull((Object)msgReceivedCons1);
            msgReceivedCons1.acknowledge();
            ClientConsumer cons2 = session.createConsumer("Q2");
            for (int i = 0; i < 100; ++i) {
                ClientMessage msgReceivedCons2 = cons2.receive(1000L);
                PagingTest.assertNotNull((Object)msgReceivedCons2);
                msgReceivedCons2.acknowledge();
                session.commit();
                if (i != 20) continue;
                long timeout = System.currentTimeMillis() + 5000L;
                while (timeout > System.currentTimeMillis() && store.checkPageFileExists(2)) {
                    Thread.sleep(10L);
                }
                msg = session.createMessage(true);
                msg.putIntProperty("dest", 1);
                prod.send((org.apache.activemq.artemis.api.core.Message)msg);
            }
            msgReceivedCons1 = cons1.receive(5000L);
            PagingTest.assertNotNull((Object)msgReceivedCons1);
            msgReceivedCons1.acknowledge();
            PagingTest.assertNull((Object)cons1.receiveImmediate());
            PagingTest.assertNull((Object)cons2.receiveImmediate());
            session.commit();
            session.close();
            this.waitForNotPaging(store);
        }
        finally {
            this.server.stop();
        }
    }

    @Test
    public void testMultiFiltersBrowsing() throws Throwable {
        this.internalTestMultiFilters(true);
    }

    @Test
    public void testMultiFiltersRegularConsumer() throws Throwable {
        this.internalTestMultiFilters(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageEmptyFile() throws Exception {
        boolean persistentMessages = true;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int messageSize = 1024;
        int numberOfMessages = 100;
        try {
            ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(120000L).setConnectionTTL(5000000L).setCallTimeout(120000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration(ADDRESS));
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            store.forceAnotherPage();
            store.forceAnotherPage();
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = null;
            byte[] body = new byte[1024];
            for (int i = 0; i < 100; ++i) {
                message = session.createMessage(persistentMessages);
                ActiveMQBuffer bodyLocal = message.getBodyBuffer();
                bodyLocal.writeBytes(body);
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
            }
            session.commit();
            org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
            Wait.assertEquals((long)100L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
            store.forceAnotherPage();
            session.start();
            ClientConsumer consumer = session.createConsumer(ADDRESS);
            for (int i = 0; i < 100; ++i) {
                message = consumer.receive(5000L);
                PagingTest.assertNotNull((Object)message);
                message.acknowledge();
            }
            session.commit();
            PagingTest.assertNull((Object)consumer.receiveImmediate());
            consumer.close();
            store.getCursorProvider().cleanup();
            Wait.assertEquals((long)0L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
            long timeout = System.currentTimeMillis() + 5000L;
            while (store.isPaging() && timeout > System.currentTimeMillis()) {
                Thread.sleep(100L);
            }
            store.getCursorProvider().cleanup();
            sf.close();
            locator.close();
            Wait.assertEquals((int)0, () -> ((PagingStore)store).getNumberOfPages());
        }
        finally {
            try {
                this.server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTestMultiFilters(boolean browsing) throws Throwable {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        try {
            int i;
            ServerLocator locator = this.createInVMNonHALocator().setBlockOnDurableSend(true);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(true, true, 0);
            session.createQueue(new QueueConfiguration("Q1").setAddress(ADDRESS.toString()));
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            ClientProducer prod = session.createProducer(ADDRESS);
            ClientMessage msg = null;
            store.startPaging();
            for (i = 0; i < 100; ++i) {
                msg = session.createMessage(true);
                msg.putStringProperty("color", "red");
                msg.putIntProperty("count", i);
                prod.send((org.apache.activemq.artemis.api.core.Message)msg);
                if (i <= 0 || i % 10 != 0) continue;
                store.startPaging();
                store.forceAnotherPage();
            }
            for (i = 0; i < 100; ++i) {
                msg = session.createMessage(true);
                msg.putStringProperty("color", "green");
                msg.putIntProperty("count", i);
                prod.send((org.apache.activemq.artemis.api.core.Message)msg);
                if (i <= 0 || i % 10 != 0) continue;
                store.startPaging();
                store.forceAnotherPage();
            }
            session.commit();
            session.close();
            session = sf.createSession(false, false, 0);
            session.start();
            ClientConsumer cons1 = browsing ? session.createConsumer("Q1", "color='green'", true) : session.createConsumer("Q1", "color='red'", false);
            for (int i2 = 0; i2 < 100; ++i2) {
                msg = cons1.receive(5000L);
                PagingTest.assertNotNull((Object)msg);
                if (browsing) continue;
                msg.acknowledge();
            }
            session.commit();
            session.close();
        }
        finally {
            this.server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPendingACKOutOfOrder() throws Throwable {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        try {
            ClientMessage msg;
            int i;
            ServerLocator locator = this.createInVMNonHALocator();
            locator.setBlockOnDurableSend(false);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(true, true, 0);
            session.createQueue(new QueueConfiguration("Q1").setAddress(ADDRESS.toString()));
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            store.startPaging();
            ClientProducer prod = session.createProducer(ADDRESS);
            for (int i2 = 0; i2 < 100; ++i2) {
                ClientMessage msg2 = session.createMessage(true);
                msg2.putIntProperty("count", i2);
                prod.send((org.apache.activemq.artemis.api.core.Message)msg2);
                session.commit();
                if ((i2 + 1) % 5 != 0 || i2 >= 50) continue;
                store.forceAnotherPage();
            }
            session.start();
            ClientConsumer cons1 = session.createConsumer("Q1");
            for (i = 0; i < 100; ++i) {
                msg = cons1.receive(5000L);
                PagingTest.assertNotNull((Object)msg);
                if (i != 13) continue;
                msg.individualAcknowledge();
            }
            session.close();
            locator.close();
            this.server.stop();
            this.server.start();
            store = this.server.getPagingManager().getPageStore(ADDRESS);
            locator = this.createInVMNonHALocator();
            sf = locator.createSessionFactory();
            session = sf.createSession(true, true, 0);
            cons1 = session.createConsumer("Q1");
            session.start();
            for (i = 0; i < 99; ++i) {
                msg = cons1.receive(5000L);
                PagingTest.assertNotNull((Object)msg);
                msg.acknowledge();
            }
            PagingTest.assertNull((Object)cons1.receiveImmediate());
            session.close();
            this.waitForNotPaging(store);
        }
        finally {
            this.server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageCompleteWasLive() throws Throwable {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        try {
            ServerLocator locator = this.createInVMNonHALocator();
            locator.setBlockOnDurableSend(false);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(true, true, 0);
            session.createQueue(new QueueConfiguration("Q1").setAddress(ADDRESS.toString()).setFilterString("dest=1"));
            session.createQueue(new QueueConfiguration("Q2").setAddress(ADDRESS.toString()).setFilterString("dest=2"));
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            store.startPaging();
            ClientProducer prod = session.createProducer(ADDRESS);
            ClientMessage msg = session.createMessage(true);
            msg.putIntProperty("dest", 1);
            prod.send((org.apache.activemq.artemis.api.core.Message)msg);
            msg = session.createMessage(true);
            msg.putIntProperty("dest", 2);
            prod.send((org.apache.activemq.artemis.api.core.Message)msg);
            session.start();
            ClientConsumer cons1 = session.createConsumer("Q1");
            ClientMessage msgReceivedCons1 = cons1.receive(1000L);
            PagingTest.assertNotNull((Object)msgReceivedCons1);
            ClientConsumer cons2 = session.createConsumer("Q2");
            ClientMessage msgReceivedCons2 = cons2.receive(1000L);
            PagingTest.assertNotNull((Object)msgReceivedCons2);
            store.forceAnotherPage();
            msg = session.createMessage(true);
            msg.putIntProperty("dest", 1);
            prod.send((org.apache.activemq.artemis.api.core.Message)msg);
            msgReceivedCons1.acknowledge();
            msgReceivedCons1 = cons1.receive(1000L);
            PagingTest.assertNotNull((Object)msgReceivedCons1);
            msgReceivedCons1.acknowledge();
            msgReceivedCons2.acknowledge();
            PagingTest.assertNull((Object)cons1.receiveImmediate());
            PagingTest.assertNull((Object)cons2.receiveImmediate());
            session.commit();
            session.close();
            this.waitForNotPaging(store);
        }
        finally {
            this.server.stop();
        }
    }

    @Test
    public void testNoCursors() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = locator.createSessionFactory();
        ClientSession session = sf.createSession();
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer prod = session.createProducer(ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.toCore().getBodyBuffer().writeBytes(new byte[1024]);
            prod.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        session.commit();
        session.deleteQueue(ADDRESS);
        session.close();
        sf.close();
        locator.close();
        this.server.stop();
        this.server.start();
        this.waitForNotPaging(this.server.getPagingManager().getPageStore(ADDRESS));
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveMessages() throws Throwable {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int LARGE_MESSAGE_SIZE = 0x100000;
        try {
            ClientMessage msg;
            int i;
            ServerLocator locator = this.createInVMNonHALocator();
            locator.setBlockOnDurableSend(false);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(true, true, 0);
            session.createQueue(new QueueConfiguration("Q1"));
            session.createQueue(new QueueConfiguration("Q2"));
            PagingStore store = this.server.getPagingManager().getPageStore(new SimpleString("Q1"));
            ClientProducer prod = session.createProducer("Q1");
            for (i = 0; i < 50; ++i) {
                msg = session.createMessage(true);
                msg.putIntProperty("count", i);
                if (i > 0 && i % 10 == 0) {
                    msg.setBodyInputStream(PagingTest.createFakeLargeStream((long)0x100000L));
                }
                prod.send((org.apache.activemq.artemis.api.core.Message)msg);
            }
            session.commit();
            store.startPaging();
            for (i = 50; i < 100; ++i) {
                msg = session.createMessage(true);
                msg.putIntProperty("count", i);
                if (i % 10 == 0) {
                    msg.setBodyInputStream(PagingTest.createFakeLargeStream((long)0x100000L));
                }
                prod.send((org.apache.activemq.artemis.api.core.Message)msg);
                if (i % 10 != 0) continue;
                session.commit();
                store.forceAnotherPage();
            }
            session.commit();
            org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(new SimpleString("Q1"));
            queue.moveReferences(10, (Filter)null, new SimpleString("Q2"), false, this.server.getPostOffice().getBinding(new SimpleString("Q2")));
            this.waitForNotPaging(store);
            session.close();
            locator.close();
            this.server.stop();
            this.server.start();
            locator = this.createInVMNonHALocator();
            locator.setBlockOnDurableSend(false);
            sf = locator.createSessionFactory();
            session = sf.createSession(true, true, 0);
            session.start();
            ClientConsumer cons = session.createConsumer("Q2");
            for (int i2 = 0; i2 < 100; ++i2) {
                ClientMessage msg2 = cons.receive(10000L);
                PagingTest.assertNotNull((Object)msg2);
                if (i2 > 0 && i2 % 10 == 0) {
                    byte[] largeMessageRead = new byte[0x100000];
                    msg2.getBodyBuffer().readBytes(largeMessageRead);
                    for (int j = 0; j < 0x100000; ++j) {
                        PagingTest.assertEquals((long)largeMessageRead[j], (long)PagingTest.getSamplebyte((long)j));
                    }
                }
                msg2.acknowledge();
                PagingTest.assertEquals((long)i2, (long)msg2.getIntProperty("count").intValue());
            }
            PagingTest.assertNull((Object)cons.receiveImmediate());
            this.waitForNotPaging(this.server.locateQueue(new SimpleString("Q2")));
            session.close();
            sf.close();
            locator.close();
        }
        finally {
            this.server.stop();
        }
    }

    @Test
    public void testOnlyOnePageOnServerCrash() throws Throwable {
        this.clearDataRecreateServerDirs();
        final Configuration config = this.createDefaultInVMConfig();
        this.server = this.storeType == StoreConfiguration.StoreType.DATABASE ? new ActiveMQServerImpl(config, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)new ActiveMQSecurityManagerImpl()){

            protected PagingStoreFactoryDatabase getPagingStoreFactory() throws Exception {
                return new PagingStoreFactoryDatabase((DatabaseStorageConfiguration)this.getConfiguration().getStoreConfiguration(), this.getStorageManager(), this.getConfiguration().getJournalBufferTimeout_NIO(), this.getScheduledPool(), this.getExecutorFactory(), this.getConfiguration().isJournalSyncNonTransactional(), null){

                    public synchronized PagingStore newStore(SimpleString address, AddressSettings settings) {
                        class NonStoppablePagingStoreImpl
                        extends PagingStoreImpl {
                            NonStoppablePagingStoreImpl(SimpleString address, ScheduledExecutorService scheduledExecutor, long syncTimeout, PagingManager pagingManager, StorageManager storageManager, SequentialFileFactory fileFactory, PagingStoreFactory storeFactory, SimpleString storeName, AddressSettings addressSettings, ArtemisExecutor executor, boolean syncNonTransactional) {
                                super(address, scheduledExecutor, syncTimeout, pagingManager, storageManager, fileFactory, storeFactory, storeName, addressSettings, executor, syncNonTransactional);
                            }

                            public synchronized void stop() throws Exception {
                            }
                        }
                        return new NonStoppablePagingStoreImpl(address, this.getScheduledExecutor(), config.getJournalBufferTimeout_NIO(), this.getPagingManager(), this.getStorageManager(), null, (PagingStoreFactory)this, address, settings, this.getExecutorFactory().getExecutor(), this.syncNonTransactional);
                    }
                };
            }
        } : new ActiveMQServerImpl(config, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)new ActiveMQSecurityManagerImpl()){

            protected PagingStoreFactoryNIO getPagingStoreFactory() {
                return new PagingStoreFactoryNIO(this.getStorageManager(), this.getConfiguration().getPagingLocation(), this.getConfiguration().getJournalBufferTimeout_NIO(), this.getScheduledPool(), this.getExecutorFactory(), this.getConfiguration().isJournalSyncNonTransactional(), null){

                    public synchronized PagingStore newStore(SimpleString address, AddressSettings settings) {
                        return new NonStoppablePagingStoreImpl(address, this.getScheduledExecutor(), config.getJournalBufferTimeout_NIO(), this.getPagingManager(), this.getStorageManager(), null, (PagingStoreFactory)this, address, settings, this.getExecutorFactory().getExecutor(), this.isSyncNonTransactional());
                    }
                };
            }
        };
        this.addServer(this.server);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(11264L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        int numberOfMessages = 12;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int i = 0; i < 12; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty("count", i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        producer.close();
        session.close();
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        Wait.assertEquals((long)12L, () -> ((org.apache.activemq.artemis.core.server.Queue)queue).getMessageCount());
        Wait.assertEquals((int)1, () -> this.server.getPagingManager().getPageStore(ADDRESS).getNumberOfPages());
        this.sf.close();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 11264L);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, false, false);
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 12; ++i) {
            ClientMessage msg = consumer.receive(1000L);
            PagingTest.assertNotNull((String)(i + "th msg is null"), (Object)msg);
            PagingTest.assertEquals((long)i, (long)msg.getIntProperty("count").intValue());
            msg.acknowledge();
        }
        PagingTest.assertNull((Object)consumer.receiveImmediate());
        session.commit();
        session.close();
        this.sf.close();
        this.locator.close();
        this.server.stop();
    }

    @Test
    public void testPagingStoreDestroyed() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 5000;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int i = 0; i < 5000; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        PagingTest.assertTrue((boolean)Arrays.asList(this.server.getPagingManager().getStoreNames()).contains(ADDRESS));
        PagingTest.assertTrue((boolean)this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
        session.deleteQueue(ADDRESS);
        session.close();
        this.sf.close();
        this.locator.close();
        this.locator = null;
        this.sf = null;
        Wait.assertFalse(() -> Arrays.asList(this.server.getPagingManager().getStoreNames()).contains(ADDRESS));
        this.server.getPagingManager().reloadStores();
        Wait.assertFalse(() -> Arrays.asList(this.server.getPagingManager().getStoreNames()).contains(ADDRESS));
        this.server.stop();
        this.server.start();
        PagingTest.assertFalse((boolean)Arrays.asList(this.server.getPagingManager().getStoreNames()).contains(ADDRESS));
        this.server.getPagingManager().reloadStores();
        PagingTest.assertFalse((boolean)Arrays.asList(this.server.getPagingManager().getStoreNames()).contains(ADDRESS));
        this.server.stop();
    }

    @Test
    public void testStopPagingWithoutConsumersIfTwoPages() throws Exception {
        this.testStopPagingWithoutConsumersOnOneQueue(true);
    }

    @Test
    public void testStopPagingWithoutConsumersIfOnePage() throws Exception {
        this.testStopPagingWithoutConsumersOnOneQueue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStopPagingWithoutConsumersOnOneQueue(boolean forceAnotherPage) throws Exception {
        boolean persistentMessages = true;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        try {
            ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(120000L).setConnectionTTL(5000000L).setCallTimeout(120000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration(ADDRESS.concat("=1")).setAddress(ADDRESS).setFilterString(SimpleString.toSimpleString((String)"destQ=1 or both=true")));
            session.createQueue(new QueueConfiguration(ADDRESS.concat("=2")).setAddress(ADDRESS).setFilterString(SimpleString.toSimpleString((String)"destQ=2 or both=true")));
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS.concat("=1"));
            queue.getPageSubscription().getPagingStore().startPaging();
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = session.createMessage(persistentMessages);
            message.putBooleanProperty("both", true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(new byte[1024]);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            session.commit();
            session.start();
            ClientConsumer consumer = session.createConsumer(ADDRESS.concat("=2"));
            message = consumer.receive(5000L);
            PagingTest.assertNotNull((Object)message);
            message.acknowledge();
            PagingTest.assertNull((Object)consumer.receiveImmediate());
            consumer.close();
            session.commit();
            if (forceAnotherPage) {
                queue.getPageSubscription().getPagingStore().forceAnotherPage();
            }
            message = session.createMessage(persistentMessages);
            message.putIntProperty("destQ", 1);
            bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(new byte[1024]);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            session.commit();
            consumer = session.createConsumer(ADDRESS.concat("=1"));
            for (int i = 0; i < 2; ++i) {
                message = consumer.receive(5000L);
                PagingTest.assertNotNull((Object)message);
                message.acknowledge();
                session.commit();
            }
            PagingTest.assertNull((Object)consumer.receiveImmediate());
            consumer.close();
            session.close();
            store.getCursorProvider().cleanup();
            this.waitForNotPaging(this.server.locateQueue(ADDRESS.concat("=1")));
            sf.close();
            locator.close();
        }
        finally {
            try {
                this.server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    @Test
    public void testStopPagingWithoutMsgsOnOneQueue() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 500;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration(ADDRESS.concat("=1")).setAddress(ADDRESS).setFilterString(SimpleString.toSimpleString((String)"destQ=1")));
        session.createQueue(new QueueConfiguration(ADDRESS.concat("=2")).setAddress(ADDRESS).setFilterString(SimpleString.toSimpleString((String)"destQ=2")));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientConsumer consumer1 = session.createConsumer(ADDRESS.concat("=1"));
        session.start();
        ClientSession session2 = this.sf.createSession(false, false, false);
        ClientConsumer consumer2 = session2.createConsumer(ADDRESS.concat("=2"));
        session2.start();
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingTest.getSamplebyte((long)j));
        }
        for (int x = 0; x < 2; ++x) {
            int i;
            for (i = 0; i < 500; ++i) {
                message = session.createMessage(true);
                message.putIntProperty("destQ", 1);
                ActiveMQBuffer bodyLocal = message.getBodyBuffer();
                bodyLocal.writeBytes(body);
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
                if (i % 1000 != 0) continue;
                session.commit();
            }
            session.commit();
            PagingTest.assertTrue((boolean)Arrays.asList(this.server.getPagingManager().getStoreNames()).contains(ADDRESS));
            PagingTest.assertTrue((boolean)this.server.getPagingManager().getPageStore(ADDRESS).isPaging());
            for (i = 0; i < 500; ++i) {
                ClientMessage msg = consumer1.receive(1000L);
                PagingTest.assertNotNull((Object)msg);
                msg.acknowledge();
                if (i % 500 != 0) continue;
                session.commit();
            }
            session.commit();
            PagingTest.assertNull((Object)consumer1.receiveImmediate());
            this.waitForNotPaging(this.server.locateQueue(ADDRESS.concat("=1")));
        }
        producer.close();
        consumer1.close();
        consumer2.close();
        session.close();
        session2.close();
        this.sf.close();
        this.locator.close();
        this.locator = null;
        this.sf = null;
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLivePageCacheEvicted() throws Throwable {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        try {
            ServerLocator locator = this.createInVMNonHALocator().setBlockOnDurableSend(true);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(true, true, 0);
            session.createQueue(new QueueConfiguration(ADDRESS));
            PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
            store.startPaging();
            ClientProducer prod = session.createProducer(ADDRESS);
            int num = 10;
            for (int i = 0; i < num; ++i) {
                ClientMessage msg = session.createMessage(true);
                msg.putIntProperty("index", i);
                prod.send((org.apache.activemq.artemis.api.core.Message)msg);
            }
            session.start();
            ClientConsumer cons = session.createConsumer(ADDRESS);
            ClientMessage msgReceivedCons = null;
            store.getCursorProvider().clearCache();
            for (int i = 0; i < num; ++i) {
                msgReceivedCons = cons.receive(1000L);
                PagingTest.assertNotNull((Object)msgReceivedCons);
                PagingTest.assertTrue((msgReceivedCons.getIntProperty("index") == i ? (byte)1 : 0) != 0);
                msgReceivedCons.acknowledge();
                session.commit();
                if (i != num / 2) continue;
                ClientMessage msg = session.createMessage(true);
                msg.putIntProperty("index", num);
                prod.send((org.apache.activemq.artemis.api.core.Message)msg);
            }
            msgReceivedCons = cons.receive(1000L);
            PagingTest.assertNotNull((Object)msgReceivedCons);
            PagingTest.assertTrue((msgReceivedCons.getIntProperty("index") == num ? (byte)1 : 0) != 0);
            msgReceivedCons.acknowledge();
            PagingTest.assertNull((Object)cons.receiveImmediate());
            session.commit();
            session.close();
            this.waitForNotPaging(store);
        }
        finally {
            this.server.stop();
        }
    }

    @Test
    public void testRollbackPageTransactionBeforeDelivery() throws Exception {
        this.testRollbackPageTransaction(true);
    }

    @Test
    public void testRollbackPageTransactionAfterDelivery() throws Exception {
        this.testRollbackPageTransaction(false);
    }

    private void testRollbackPageTransaction(boolean rollbackBeforeDelivery) throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 2;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(null, null, false, false, true, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(ADDRESS);
        queue.getPageSubscription().getPagingStore().startPaging();
        ClientProducer producer = session.createProducer(ADDRESS);
        if (rollbackBeforeDelivery) {
            this.sendMessages(session, producer, 2);
            session.rollback();
            PagingTest.assertEquals((long)this.server.getPagingManager().getTransactions().size(), (long)1L);
            PageTransactionInfo pageTransactionInfo = (PageTransactionInfo)this.server.getPagingManager().getTransactions().values().iterator().next();
            Wait.assertTrue(() -> pageTransactionInfo.isRollback(), (long)1000L, (long)100L);
            ClientConsumer consumer = session.createConsumer(ADDRESS);
            session.start();
            Assert.assertNull((Object)consumer.receiveImmediate());
            PagingTest.assertTrue((boolean)this.server.getPagingManager().getTransactions().isEmpty());
        } else {
            ClientConsumer consumer = session.createConsumer(ADDRESS);
            session.start();
            this.sendMessages(session, producer, 2);
            Assert.assertNull((Object)consumer.receiveImmediate());
            PagingTest.assertEquals((long)this.server.getPagingManager().getTransactions().size(), (long)1L);
            PageTransactionInfo pageTransactionInfo = (PageTransactionInfo)this.server.getPagingManager().getTransactions().values().iterator().next();
            session.rollback();
            Wait.assertTrue(() -> pageTransactionInfo.isRollback(), (long)1000L, (long)100L);
            PagingTest.assertTrue((boolean)this.server.getPagingManager().getTransactions().isEmpty());
        }
        session.close();
    }

    protected final ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize) {
        ActiveMQServer server = super.createServer(realFiles, configuration, pageSize, maxAddressSize);
        server.getConfiguration().setAddressQueueScanPeriod(100L);
        return server;
    }

    protected Configuration createDefaultConfig(int serverID, boolean netty) throws Exception {
        Configuration configuration = super.createDefaultConfig(serverID, netty);
        if (this.storeType == StoreConfiguration.StoreType.DATABASE) {
            this.setDBStoreType(configuration);
        } else if (this.mapped) {
            configuration.setJournalType(JournalType.MAPPED);
        }
        return configuration;
    }

    private static final class DummyOperationContext
    implements OperationContext {
        private final CountDownLatch pageUp;
        private final CountDownLatch pageDone;

        private DummyOperationContext(CountDownLatch pageUp, CountDownLatch pageDone) {
            this.pageDone = pageDone;
            this.pageUp = pageUp;
        }

        public void onError(int errorCode, String errorMessage) {
        }

        public void done() {
        }

        public void storeLineUp() {
        }

        public boolean waitCompletion(long timeout) throws Exception {
            return false;
        }

        public void waitCompletion() throws Exception {
        }

        public void replicationLineUp() {
        }

        public void replicationDone() {
        }

        public void pageSyncLineUp() {
            this.pageUp.countDown();
        }

        public void pageSyncDone() {
            this.pageDone.countDown();
        }

        public void executeOnCompletion(IOCallback runnable) {
            runnable.done();
        }

        public void executeOnCompletion(IOCallback runnable, boolean storeOnly) {
            runnable.done();
        }
    }
}

