/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.integration.plugin.MethodCalledVerifier;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpPluginTest
extends AmqpClientTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(AmqpPluginTest.class);
    private final Map<String, AtomicInteger> methodCalls = new ConcurrentHashMap<String, AtomicInteger>();
    private final MethodCalledVerifier verifier = new MethodCalledVerifier(this.methodCalls);

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        super.addConfiguration(server);
        server.registerBrokerPlugin((ActiveMQServerBasePlugin)this.verifier);
    }

    @Test(timeout=60000L)
    public void testQueueReceiverReadAndAckMessage() throws Exception {
        this.sendMessages(this.getQueueName(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpPluginTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        receiver.flow(1);
        AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpPluginTest.assertNotNull((Object)message);
        message.accept();
        receiver.close();
        connection.close();
        this.verifier.validatePluginMethodsEquals(0, "messageExpired", "beforeDeployBridge", "afterDeployBridge", "beforeRemoveBinding", "afterRemoveBinding");
        this.verifier.validatePluginMethodsAtLeast(1, "afterCreateConnection", "afterDestroyConnection", "beforeCreateSession", "afterCreateSession", "beforeCloseSession", "afterCloseSession", "beforeCreateConsumer", "afterCreateConsumer", "beforeCloseConsumer", "afterCloseConsumer", "beforeCreateQueue", "afterCreateQueue", "messageAcknowledged", "beforeSend", "afterSend", "beforeMessageRoute", "afterMessageRoute", "beforeDeliver", "afterDeliver", "beforeAddAddress", "afterAddAddress", "beforeAddBinding", "afterAddBinding");
    }

    @Test(timeout=60000L)
    public void testQueueReceiverAutoCreatedQueue() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver("autoCreated");
        receiver.close();
        connection.close();
        this.verifier.validatePluginMethodsAtLeast(1, "beforeAddAddress", "afterAddAddress");
        this.verifier.validatePluginMethodsEquals(1, "beforeRemoveAddress", "afterRemoveAddress");
    }

    @Override
    public void sendMessages(String destinationName, int count) throws Exception {
        this.sendMessages(destinationName, count, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessages(String destinationName, int count, RoutingType routingType) throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(destinationName);
            for (int i = 0; i < count; ++i) {
                AmqpMessage message = new AmqpMessage();
                message.setMessageId("MessageID:" + i);
                if (routingType != null) {
                    message.setMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE.toString(), (Object)routingType.getType());
                }
                sender.send(message);
            }
        }
    }
}

