/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.spi.core.security.ActiveMQBasicSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BasicSecurityManagerTest
extends ActiveMQTestBase {
    private ServerLocator locator;
    private boolean bootstrapProperties;

    public BasicSecurityManagerTest(boolean bootstrapProperties) {
        this.bootstrapProperties = bootstrapProperties;
    }

    @Parameterized.Parameters(name="bootstrapProperties={0}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{false}, {true}};
        return Arrays.asList(params);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
    }

    public ActiveMQServer initializeServer() throws Exception {
        HashMap<String, String> initProperties = new HashMap<String, String>();
        if (this.bootstrapProperties) {
            initProperties.put("bootstrapUserFile", "users.properties");
            initProperties.put("bootstrapRoleFile", "roles.properties");
        } else {
            initProperties.put("bootstrapUser", "first");
            initProperties.put("bootstrapPassword", "secret");
            initProperties.put("bootstrapRole", "programmers");
        }
        ActiveMQBasicSecurityManager securityManager = new ActiveMQBasicSecurityManager().init(initProperties);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)true));
        return server;
    }

    @Test
    public void testAuthenticationForBootstrapUser() throws Exception {
        ActiveMQServer server = this.initializeServer();
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession("first", "secret", false, true, true, false, 0);
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assert.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testAuthenticationForAddedUserHashed() throws Exception {
        this.internalTestAuthenticationForAddedUser(false);
    }

    @Test
    public void testAuthenticationForAddedUserPlainText() throws Exception {
        this.internalTestAuthenticationForAddedUser(true);
    }

    private void internalTestAuthenticationForAddedUser(boolean plaintext) throws Exception {
        ActiveMQServer server = this.initializeServer();
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        server.getActiveMQServerControl().addUser("foo", "bar", "baz", plaintext);
        try {
            ClientSession session = cf.createSession("foo", "bar", false, true, true, false, 0);
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assert.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testWithValidatedUser() throws Exception {
        ActiveMQServer server = this.initializeServer();
        server.getConfiguration().setPopulateValidatedUser(true);
        server.start();
        Role role = new Role("programmers", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        server.getSecurityRepository().addMatch("#", roles);
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession("first", "secret", false, true, true, false, 0);
            server.createQueue(new QueueConfiguration("queue").setAddress("address").setRoutingType(RoutingType.ANYCAST));
            ClientProducer producer = session.createProducer("address");
            producer.send((Message)session.createMessage(true));
            session.commit();
            producer.close();
            ClientConsumer consumer = session.createConsumer("queue");
            session.start();
            ClientMessage message = consumer.receive(1000L);
            BasicSecurityManagerTest.assertNotNull((Object)message);
            BasicSecurityManagerTest.assertEquals((Object)"first", (Object)message.getValidatedUserID());
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assert.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testAuthenticationBadPassword() throws Exception {
        ActiveMQServer server = this.initializeServer();
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            cf.createSession("first", "badpassword", false, true, true, false, 0);
            Assert.fail((String)"should throw exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAuthorizationNegative() throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = new SimpleString("address");
        SimpleString DURABLE_QUEUE = new SimpleString("durableQueue");
        SimpleString NON_DURABLE_QUEUE = new SimpleString("nonDurableQueue");
        ActiveMQServer server = this.initializeServer();
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", false, false, false, false, false, false, false, false, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(NON_DURABLE_QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(cf.createSession("first", "secret", false, true, true, false, 0));
        try {
            session.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            BasicSecurityManagerTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='CREATE_DURABLE_QUEUE' for queue durableQueue on address address"));
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            BasicSecurityManagerTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='DELETE_DURABLE_QUEUE' for queue durableQueue on address address"));
        }
        try {
            session.createQueue(new QueueConfiguration(NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            BasicSecurityManagerTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='CREATE_NON_DURABLE_QUEUE' for queue nonDurableQueue on address address"));
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            BasicSecurityManagerTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='DELETE_NON_DURABLE_QUEUE' for queue nonDurableQueue on address address"));
        }
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            BasicSecurityManagerTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='SEND' on address address"));
        }
        try {
            ClientConsumer consumer = session.createConsumer(DURABLE_QUEUE);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            BasicSecurityManagerTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='CONSUME' for queue durableQueue on address address"));
        }
        try {
            producer = session.createProducer(server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            BasicSecurityManagerTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='MANAGE' on address activemq.management"));
        }
        try {
            ClientConsumer browser = session.createConsumer(DURABLE_QUEUE, true);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            BasicSecurityManagerTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='BROWSE' for queue durableQueue on address address"));
        }
    }

    @Test
    public void testAuthorizationPositive() throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = new SimpleString("address");
        SimpleString DURABLE_QUEUE = new SimpleString("durableQueue");
        SimpleString NON_DURABLE_QUEUE = new SimpleString("nonDurableQueue");
        ActiveMQServer server = this.initializeServer();
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", true, true, true, true, true, true, true, true, true, true));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(cf.createSession("first", "secret", false, true, true, false, 0));
        try {
            session.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.createQueue(new QueueConfiguration(NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        session.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS));
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            producer = session.createProducer(server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE, true);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
    }
}

