/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.ra;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionFactoryPropertiesTest
extends ActiveMQTestBase {
    private static final SortedSet<String> UNSUPPORTED_CF_PROPERTIES = new TreeSet<String>();
    private static final SortedSet<String> UNSUPPORTED_RA_PROPERTIES;

    @Test
    public void testCompareConnectionFactoryAndResourceAdapterProperties() throws Exception {
        SortedSet<String> connectionFactoryProperties = this.findAllPropertyNames(ActiveMQConnectionFactory.class);
        Assert.assertTrue((boolean)connectionFactoryProperties.contains("useTopologyForLoadBalancing"));
        connectionFactoryProperties.removeAll(UNSUPPORTED_CF_PROPERTIES);
        SortedSet<String> raProperties = this.findAllPropertyNames(ActiveMQResourceAdapter.class);
        raProperties.removeAll(UNSUPPORTED_RA_PROPERTIES);
        ConnectionFactoryPropertiesTest.compare("ActiveMQ Connection Factory", connectionFactoryProperties, "ActiveMQ Resource Adapter", raProperties);
    }

    private static void compare(String name1, SortedSet<String> set1, String name2, SortedSet<String> set2) {
        TreeSet<String> onlyInSet1 = new TreeSet<String>(set1);
        onlyInSet1.removeAll(set2);
        TreeSet<String> onlyInSet2 = new TreeSet<String>(set2);
        onlyInSet2.removeAll(set1);
        if (!onlyInSet1.isEmpty() || !onlyInSet2.isEmpty()) {
            ConnectionFactoryPropertiesTest.fail((String)String.format("in %s only: %s\nin %s only: %s", name1, onlyInSet1, name2, onlyInSet2));
        }
        ConnectionFactoryPropertiesTest.assertEquals(set2, set1);
    }

    private SortedSet<String> findAllPropertyNames(Class<?> clazz) throws Exception {
        TreeSet<String> names = new TreeSet<String>();
        for (PropertyDescriptor propDesc : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            if (propDesc == null || propDesc.getWriteMethod() == null) continue;
            names.add(propDesc.getDisplayName());
        }
        return names;
    }

    @Test
    public void testEquality() throws Exception {
        ConnectionFactoryProperties cfp1 = new ConnectionFactoryProperties();
        ArrayList<String> connectorClassNames1 = new ArrayList<String>();
        connectorClassNames1.add("myConnector");
        cfp1.setParsedConnectorClassNames(connectorClassNames1);
        ArrayList connectionParameters1 = new ArrayList();
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("port", "0");
        connectionParameters1.add(params1);
        cfp1.setParsedConnectionParameters(connectionParameters1);
        cfp1.setAutoGroup(Boolean.valueOf(true));
        ConnectionFactoryProperties cfp2 = new ConnectionFactoryProperties();
        ArrayList<String> connectorClassNames2 = new ArrayList<String>();
        connectorClassNames2.add("myConnector");
        cfp2.setParsedConnectorClassNames(connectorClassNames2);
        ArrayList connectionParameters2 = new ArrayList();
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("port", "0");
        connectionParameters2.add(params2);
        cfp2.setParsedConnectionParameters(connectionParameters2);
        cfp2.setAutoGroup(Boolean.valueOf(true));
        ConnectionFactoryPropertiesTest.assertTrue((boolean)cfp1.equals((Object)cfp2));
    }

    @Test
    public void testInequality() throws Exception {
        ConnectionFactoryProperties cfp1 = new ConnectionFactoryProperties();
        ArrayList<String> connectorClassNames1 = new ArrayList<String>();
        connectorClassNames1.add("myConnector");
        cfp1.setParsedConnectorClassNames(connectorClassNames1);
        ArrayList connectionParameters1 = new ArrayList();
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("port", "0");
        connectionParameters1.add(params1);
        cfp1.setParsedConnectionParameters(connectionParameters1);
        cfp1.setAutoGroup(Boolean.valueOf(true));
        ConnectionFactoryProperties cfp2 = new ConnectionFactoryProperties();
        ArrayList<String> connectorClassNames2 = new ArrayList<String>();
        connectorClassNames2.add("myConnector");
        cfp2.setParsedConnectorClassNames(connectorClassNames2);
        ArrayList connectionParameters2 = new ArrayList();
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("port", "1");
        connectionParameters2.add(params2);
        cfp2.setParsedConnectionParameters(connectionParameters2);
        cfp2.setAutoGroup(Boolean.valueOf(true));
        ConnectionFactoryPropertiesTest.assertFalse((boolean)cfp1.equals((Object)cfp2));
    }

    @Test
    public void testInequality2() throws Exception {
        ConnectionFactoryProperties cfp1 = new ConnectionFactoryProperties();
        ArrayList<String> connectorClassNames1 = new ArrayList<String>();
        connectorClassNames1.add("myConnector");
        cfp1.setParsedConnectorClassNames(connectorClassNames1);
        ArrayList connectionParameters1 = new ArrayList();
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("port", "0");
        connectionParameters1.add(params1);
        cfp1.setParsedConnectionParameters(connectionParameters1);
        cfp1.setAutoGroup(Boolean.valueOf(true));
        ConnectionFactoryProperties cfp2 = new ConnectionFactoryProperties();
        ArrayList<String> connectorClassNames2 = new ArrayList<String>();
        connectorClassNames2.add("myConnector2");
        cfp2.setParsedConnectorClassNames(connectorClassNames2);
        ArrayList connectionParameters2 = new ArrayList();
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("port", "0");
        connectionParameters2.add(params2);
        cfp2.setParsedConnectionParameters(connectionParameters2);
        cfp2.setAutoGroup(Boolean.valueOf(true));
        ConnectionFactoryPropertiesTest.assertFalse((boolean)cfp1.equals((Object)cfp2));
    }

    static {
        UNSUPPORTED_CF_PROPERTIES.add("discoveryGroupName");
        UNSUPPORTED_CF_PROPERTIES.add("brokerURL");
        UNSUPPORTED_CF_PROPERTIES.add("incomingInterceptorList");
        UNSUPPORTED_CF_PROPERTIES.add("outgoingInterceptorList");
        UNSUPPORTED_CF_PROPERTIES.add("user");
        UNSUPPORTED_CF_PROPERTIES.add("userName");
        UNSUPPORTED_CF_PROPERTIES.add("password");
        UNSUPPORTED_CF_PROPERTIES.add("enableSharedClientID");
        UNSUPPORTED_RA_PROPERTIES = new TreeSet<String>();
        UNSUPPORTED_RA_PROPERTIES.add("HA");
        UNSUPPORTED_RA_PROPERTIES.add("jgroupsChannelName");
        UNSUPPORTED_RA_PROPERTIES.add("jgroupsFile");
        UNSUPPORTED_RA_PROPERTIES.add("discoveryAddress");
        UNSUPPORTED_RA_PROPERTIES.add("discoveryPort");
        UNSUPPORTED_RA_PROPERTIES.add("discoveryLocalBindAddress");
        UNSUPPORTED_RA_PROPERTIES.add("discoveryRefreshTimeout");
        UNSUPPORTED_RA_PROPERTIES.add("discoveryInitialWaitTimeout");
        UNSUPPORTED_RA_PROPERTIES.add("connectionParameters");
        UNSUPPORTED_RA_PROPERTIES.add("connectorClassName");
        UNSUPPORTED_RA_PROPERTIES.add("managedConnectionFactory");
        UNSUPPORTED_RA_PROPERTIES.add("jndiParams");
        UNSUPPORTED_RA_PROPERTIES.add("password");
        UNSUPPORTED_RA_PROPERTIES.add("passwordCodec");
        UNSUPPORTED_RA_PROPERTIES.add("useMaskedPassword");
        UNSUPPORTED_RA_PROPERTIES.add("useAutoRecovery");
        UNSUPPORTED_RA_PROPERTIES.add("useLocalTx");
        UNSUPPORTED_RA_PROPERTIES.add("user");
        UNSUPPORTED_RA_PROPERTIES.add("userName");
        UNSUPPORTED_RA_PROPERTIES.add("jgroupsChannelLocatorClass");
        UNSUPPORTED_RA_PROPERTIES.add("jgroupsChannelRefName");
        UNSUPPORTED_RA_PROPERTIES.add("entries");
        UNSUPPORTED_RA_PROPERTIES.add("connectionPoolName");
    }
}

