/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.RuntimeAnnotationHandler;
import com.sun.faces.el.ELUtils;
import com.sun.faces.util.RequestStateManager;
import jakarta.el.ValueExpression;
import jakarta.faces.application.Application;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ResourceDependencyHandler
implements RuntimeAnnotationHandler {
    private ResourceDependency[] dependencies;
    private Map<ResourceDependency, Expressions> expressionsMap;

    public ResourceDependencyHandler(ResourceDependency[] dependencies) {
        this.dependencies = dependencies;
        Map attrs = FacesContext.getCurrentInstance().getAttributes();
        this.expressionsMap = new HashMap<ResourceDependency, Expressions>(dependencies.length, 1.0f);
        for (ResourceDependency dep : dependencies) {
            String tgt;
            Expressions exprs = new Expressions();
            exprs.name = dep.name();
            String lib = dep.library();
            if (lib.length() > 0) {
                if ("this".equals(lib)) {
                    String thisLibrary = (String)attrs.get("com.sun.faces.composite.this.library");
                    assert (null != thisLibrary);
                    lib = thisLibrary;
                }
                exprs.library = lib;
            }
            if ((tgt = dep.target()).length() > 0) {
                exprs.target = tgt;
            }
            this.expressionsMap.put(dep, exprs);
        }
    }

    @Override
    public void apply(FacesContext ctx, Object ... params) {
        for (ResourceDependency dep : this.dependencies) {
            if (this.hasBeenProcessed(ctx, dep)) continue;
            this.pushResourceToRoot(ctx, this.createComponentResource(ctx, dep));
            this.markProcssed(ctx, dep);
        }
    }

    private void pushResourceToRoot(FacesContext ctx, UIComponent c) {
        ctx.getViewRoot().addComponentResource(ctx, c, (String)c.getAttributes().get("target"));
    }

    private boolean hasBeenProcessed(FacesContext ctx, ResourceDependency dep) {
        Set dependencies = (Set)RequestStateManager.get(ctx, "com.sun.faces.PROCESSED_RESOURCE_DEPENDENCIES");
        return dependencies != null && dependencies.contains(dep);
    }

    private UIComponent createComponentResource(FacesContext ctx, ResourceDependency dep) {
        Expressions exprs = this.expressionsMap.get(dep);
        Application app = ctx.getApplication();
        String resname = exprs.getName(ctx);
        UIComponent c = ctx.getApplication().createComponent("jakarta.faces.Output");
        c.setRendererType(app.getResourceHandler().getRendererTypeForResourceName(resname));
        Map attrs = c.getAttributes();
        attrs.put("name", resname);
        if (exprs.library != null) {
            attrs.put("library", exprs.getLibrary(ctx));
        }
        if (exprs.target != null) {
            attrs.put("target", exprs.getTarget(ctx));
        }
        return c;
    }

    private void markProcssed(FacesContext ctx, ResourceDependency dep) {
        HashSet<ResourceDependency> dependencies = (HashSet<ResourceDependency>)RequestStateManager.get(ctx, "com.sun.faces.PROCESSED_RESOURCE_DEPENDENCIES");
        if (dependencies == null) {
            dependencies = new HashSet<ResourceDependency>(6);
            RequestStateManager.set(ctx, "com.sun.faces.PROCESSED_RESOURCE_DEPENDENCIES", dependencies);
        }
        dependencies.add(dep);
    }

    private static final class Expressions {
        ValueExpression nameExpression;
        ValueExpression libraryExpression;
        ValueExpression targetExpression;
        String name;
        String library;
        String target;

        private Expressions() {
        }

        String getName(FacesContext ctx) {
            if (this.nameExpression == null) {
                this.nameExpression = ELUtils.createValueExpression(this.name, String.class);
            }
            return (String)this.nameExpression.getValue(ctx.getELContext());
        }

        String getLibrary(FacesContext ctx) {
            if (this.library != null) {
                if (this.libraryExpression == null) {
                    this.libraryExpression = ELUtils.createValueExpression(this.library, String.class);
                }
                return (String)this.libraryExpression.getValue(ctx.getELContext());
            }
            return null;
        }

        String getTarget(FacesContext ctx) {
            if (this.target != null) {
                if (this.targetExpression == null) {
                    this.targetExpression = ELUtils.createValueExpression(this.target, String.class);
                }
                return (String)this.targetExpression.getValue(ctx.getELContext());
            }
            return null;
        }
    }
}

