/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.impl.DefaultFacelet;
import com.sun.faces.facelets.impl.DefaultResourceResolver;
import com.sun.faces.facelets.impl.IdMapper;
import com.sun.faces.util.Cache;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.FactoryFinder;
import jakarta.faces.annotation.View;
import jakarta.faces.application.Application;
import jakarta.faces.component.Doctype;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.Facelet;
import jakarta.faces.view.facelets.FaceletCache;
import jakarta.faces.view.facelets.FaceletCacheFactory;
import jakarta.faces.view.facelets.FaceletHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DefaultFaceletFactory {
    protected static final Logger log = FacesLogger.FACELETS_FACTORY.getLogger();
    private Compiler compiler;
    private DefaultResourceResolver resolver;
    private URL baseUrl;
    private long refreshPeriod = -1L;
    private FaceletCache<DefaultFacelet> cache;
    private ConcurrentMap<String, FaceletCache<DefaultFacelet>> cachePerContract;
    Cache<String, IdMapper> idMappers;

    public final void init(FacesContext facesContext, Compiler compiler, DefaultResourceResolver resolver, long refreshPeriod, FaceletCache cache) {
        Util.notNull("compiler", compiler);
        Util.notNull("resolver", resolver);
        ExternalContext externalContext = facesContext.getExternalContext();
        WebConfiguration config = WebConfiguration.getInstance(externalContext);
        this.compiler = compiler;
        this.cachePerContract = new ConcurrentHashMap<String, FaceletCache<DefaultFacelet>>();
        this.resolver = resolver;
        this.baseUrl = resolver.resolveUrl("/");
        this.idMappers = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.UseFaceletsID) ? null : new Cache<String, IdMapper>(new IdMapperFactory());
        this.refreshPeriod = refreshPeriod = refreshPeriod >= 0L ? refreshPeriod * 1000L : -1L;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Using ResourceResolver: {0}", resolver);
            log.log(Level.FINE, "Using Refresh Period: {0}", refreshPeriod);
        }
        this.cache = this.initCache((FaceletCache<DefaultFacelet>)cache);
    }

    public DefaultResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public Facelet getMetadataFacelet(FacesContext context, String viewId) throws IOException {
        Facelet facelet = CdiUtils.getBeanReference(context, Facelet.class, new Annotation[]{View.Literal.of((String)viewId)});
        if (facelet == null) {
            facelet = this.getMetadataFacelet(context, this.resolveURL(viewId));
        }
        return facelet;
    }

    public Facelet getFacelet(FacesContext context, String viewId) throws IOException {
        Facelet facelet = CdiUtils.getBeanReference(context, Facelet.class, new Annotation[]{View.Literal.of((String)viewId)});
        if (facelet == null) {
            facelet = this.getFacelet(context, this.resolveURL(viewId));
        }
        return facelet;
    }

    public URL resolveURL(URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            URL url = this.resolver.resolveUrl(path);
            if (url == null) {
                throw new FacesFileNotFoundException(path + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        return new URL(source, path);
    }

    public Facelet getFacelet(FacesContext context, URL url) throws IOException {
        Facelet result = (Facelet)this.getCache(context).getFacelet(url);
        DefaultFacelet _facelet = null;
        if (result instanceof DefaultFacelet) {
            String xmlDecl;
            _facelet = (DefaultFacelet)result;
            Doctype doctype = _facelet.getSavedDoctype();
            if (doctype != null) {
                Util.saveDOCTYPEToFacesContextAttributes(doctype);
            }
            if ((xmlDecl = _facelet.getSavedXMLDecl()) != null) {
                Util.saveXMLDECLToFacesContextAttributes(xmlDecl);
            }
        }
        return result;
    }

    public Facelet getMetadataFacelet(FacesContext context, URL url) throws IOException {
        return (Facelet)this.getCache(context).getViewMetadataFacelet(url);
    }

    public boolean needsToBeRefreshed(URL url) {
        if (!this.cache.isFaceletCached(url)) {
            return true;
        }
        if (this.cachePerContract == null) {
            return false;
        }
        for (FaceletCache faceletCache : this.cachePerContract.values()) {
            if (faceletCache.isFaceletCached(url)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIComponent _createComponent(FacesContext context, String taglibURI, String tagName, Map<String, Object> attributes) {
        UIComponent result;
        block26: {
            result = null;
            Application app = context.getApplication();
            ExternalContext extContext = context.getExternalContext();
            File tmpDir = (File)extContext.getApplicationMap().get("jakarta.servlet.context.tempdir");
            File tempFile = null;
            OutputStreamWriter osw = null;
            try {
                String tempId;
                block24: {
                    tempFile = File.createTempFile("mojarra", ".tmp", tmpDir);
                    osw = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8");
                    osw.append("<?xml version='1.0' encoding='");
                    osw.append("UTF-8");
                    osw.append("' ?>");
                    osw.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
                    osw.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"\n");
                    osw.append("      xmlns:j=\"").append(taglibURI).append("\">");
                    osw.append("  <j:").append(tagName).append(" ");
                    if (!Util.isEmpty(attributes)) {
                        for (Map.Entry<String, Object> attr : attributes.entrySet()) {
                            osw.append(attr.getKey()).append("=\"").append(attr.getValue().toString()).append("\"").append(" ");
                        }
                    }
                    tempId = context.getViewRoot().createUniqueId(context, tagName);
                    osw.append(" id=\"").append(tempId).append("\" />");
                    osw.append("</html>");
                    try {
                        osw.flush();
                        osw.close();
                    }
                    catch (IOException ex) {
                        if (!log.isLoggable(Level.FINEST)) break block24;
                        log.log(Level.FINEST, "Flushing and closing stream", ex);
                    }
                }
                URL fabricatedFaceletPage = tempFile.toURI().toURL();
                DefaultFacelet fabricatedFacelet = this.createFacelet(fabricatedFaceletPage);
                UIComponent tmp = app.createComponent("jakarta.faces.NamingContainer");
                tmp.setId(context.getViewRoot().createUniqueId());
                fabricatedFacelet.apply(context, tmp);
                result = tmp.findComponent(tempId);
                tmp.getChildren().clear();
                osw = null;
            }
            catch (MalformedURLException mue) {
                log.log(Level.FINEST, "Invalid URL", mue);
            }
            catch (IOException ioe) {
                log.log(Level.FINEST, "I/O error", ioe);
            }
            finally {
                boolean successful;
                if (osw != null) {
                    try {
                        osw.close();
                    }
                    catch (IOException ioe) {
                        log.log(Level.FINEST, "Closing stream", ioe);
                    }
                }
                if (tempFile != null && !(successful = tempFile.delete()) && log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Unable to delete temporary file.");
                }
            }
            try {
                byte[] faceletPage = "facelet".getBytes("UTF-8");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(faceletPage);
            }
            catch (UnsupportedEncodingException uee) {
                if (!log.isLoggable(Level.SEVERE)) break block26;
                log.log(Level.SEVERE, "Unsupported encoding when creating component for " + tagName + " in " + taglibURI, uee);
            }
        }
        if (result != null) {
            result.setId(null);
        }
        return result;
    }

    private FaceletCache<DefaultFacelet> initCache(FaceletCache<DefaultFacelet> cache) {
        if (cache == null) {
            FaceletCacheFactory cacheFactory = (FaceletCacheFactory)FactoryFinder.getFactory((String)"jakarta.faces.view.facelets.FaceletCacheFactory");
            cache = cacheFactory.getFaceletCache();
        }
        FaceletCache.MemberFactory faceletFactory = key -> this.createFacelet(key);
        FaceletCache.MemberFactory metadataFaceletFactory = key -> this.createMetadataFacelet(key);
        cache.setCacheFactories(faceletFactory, metadataFaceletFactory);
        return cache;
    }

    private FaceletCache<DefaultFacelet> getCache(FacesContext context) {
        List contracts = context.getResourceLibraryContracts();
        if (!contracts.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < contracts.size(); ++i) {
                builder.append((String)contracts.get(i));
                if (i + 1 == contracts.size()) continue;
                builder.append(",");
            }
            String contractsKey = builder.toString();
            FaceletCache faceletCache = (FaceletCache)this.cachePerContract.get(contractsKey);
            if (faceletCache == null) {
                faceletCache = this.initCache(null);
                this.cachePerContract.putIfAbsent(contractsKey, faceletCache);
                faceletCache = (FaceletCache)this.cachePerContract.get(contractsKey);
            }
            return faceletCache;
        }
        return this.cache;
    }

    private URL resolveURL(String uri) throws IOException {
        URL url = this.resolveURL(this.baseUrl, uri);
        if (url == null) {
            throw new IOException("'" + uri + "' not found.");
        }
        return url;
    }

    private DefaultFacelet createFacelet(URL url) throws IOException {
        String escapedBaseURL = Pattern.quote(this.baseUrl.getFile());
        String alias = "/" + url.getFile().replaceFirst(escapedBaseURL, "");
        return this.createFacelet(url, alias);
    }

    private DefaultFacelet createFacelet(URL url, String alias) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + url);
        }
        try {
            FaceletHandler h = this.compiler.compile(url, alias);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    private DefaultFacelet createMetadataFacelet(URL url) throws IOException {
        log.fine(() -> "Creating Metadata Facelet for: " + url);
        String alias = "/" + url.getFile().replaceFirst(Pattern.quote(this.baseUrl.getFile()), "");
        try {
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, this.compiler.metadataCompile(url, alias));
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    private static final class IdMapperFactory
    implements Cache.Factory<String, IdMapper> {
        private IdMapperFactory() {
        }

        @Override
        public IdMapper newInstance(String arg) throws InterruptedException {
            return new IdMapper();
        }
    }
}

