/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.uuid;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.annotations.UuidGenerator;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.id.uuid.CustomVersionOneStrategy;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.type.descriptor.java.UUIDJavaType;

public class UuidGenerator
implements StandardGenerator {
    private final ValueGenerator generator;
    private final UUIDJavaType.ValueTransformer valueTransformer;

    public UuidGenerator(org.hibernate.annotations.UuidGenerator config, Member idMember, CustomIdGeneratorCreationContext creationContext) {
        this.generator = config.style() == UuidGenerator.Style.TIME ? new CustomVersionOneStrategy() : StandardRandomStrategy.INSTANCE;
        Class<?> propertyType = idMember instanceof Method ? ((Method)idMember).getReturnType() : ((Field)idMember).getType();
        if (UUID.class.isAssignableFrom(propertyType)) {
            this.valueTransformer = UUIDJavaType.PassThroughTransformer.INSTANCE;
        } else if (String.class.isAssignableFrom(propertyType)) {
            this.valueTransformer = UUIDJavaType.ToStringTransformer.INSTANCE;
        } else if (byte[].class.isAssignableFrom(propertyType)) {
            this.valueTransformer = UUIDJavaType.ToBytesTransformer.INSTANCE;
        } else {
            throw new HibernateException("Unanticipated return type [" + propertyType.getName() + "] for UUID conversion");
        }
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        return this.valueTransformer.transform(this.generator.generateUuid(session));
    }

    static interface ValueGenerator {
        public UUID generateUuid(SharedSessionContractImplementor var1);
    }
}

