/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class EntityValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements SqlTupleContainer,
Assignable {
    private final Expression sqlExpression;

    public static <T> EntityValuedPathInterpretation<T> from(SqmEntityValuedSimplePath<T> sqmPath, MappingModelExpressible<?> inferredMapping, SqmToSqlAstConverter sqlAstCreationState) {
        EntityAssociationMapping associationMapping;
        ModelPart keyTargetMatchPart;
        EntityValuedModelPart mapping;
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath());
        EntityValuedModelPart pathMapping = (EntityValuedModelPart)sqlAstCreationState.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath()).getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        if (inferredMapping instanceof EntityAssociationMapping) {
            ModelPart inferredTargetPart;
            EntityAssociationMapping pathAssociation;
            ModelPart pathTargetPart;
            EntityAssociationMapping inferredAssociation = (EntityAssociationMapping)inferredMapping;
            mapping = pathMapping instanceof EntityAssociationMapping && inferredMapping != pathMapping ? ((pathTargetPart = (pathAssociation = (EntityAssociationMapping)((Object)pathMapping)).getForeignKeyDescriptor().getPart(pathAssociation.getSideNature().inverse())) == (inferredTargetPart = inferredAssociation.getForeignKeyDescriptor().getPart(inferredAssociation.getSideNature().inverse())) ? pathMapping : pathMapping.getEntityMappingType()) : (EntityValuedModelPart)inferredMapping;
        } else {
            mapping = pathMapping;
        }
        ModelPart resultModelPart = mapping instanceof EntityAssociationMapping ? ((keyTargetMatchPart = (associationMapping = (EntityAssociationMapping)((Object)mapping)).getKeyTargetMatchPart()) instanceof ToOneAttributeMapping ? ((ToOneAttributeMapping)keyTargetMatchPart).getKeyTargetMatchPart() : keyTargetMatchPart) : mapping.getEntityMappingType().getIdentifierMapping();
        return EntityValuedPathInterpretation.from(sqmPath.getNavigablePath(), tableGroup, resultModelPart, mapping, mapping, sqlAstCreationState);
    }

    public static <T> EntityValuedPathInterpretation<T> from(NavigablePath navigablePath, TableGroup tableGroup, ModelPart resultModelPart, EntityValuedModelPart mapping, EntityValuedModelPart treatedMapping, SqmToSqlAstConverter sqlAstCreationState) {
        Expression sqlExpression;
        SqlExpressionResolver sqlExprResolver = sqlAstCreationState.getSqlExpressionResolver();
        SessionFactoryImplementor sessionFactory = sqlAstCreationState.getCreationContext().getSessionFactory();
        if (resultModelPart == null) {
            EntityMappingType entityMappingType = mapping.getEntityMappingType();
            EntityIdentifierMapping identifierMapping = entityMappingType.getIdentifierMapping();
            EntityDiscriminatorMapping discriminatorMapping = entityMappingType.getDiscriminatorMapping();
            ArrayList expressions = new ArrayList(entityMappingType.getJdbcTypeCount() + identifierMapping.getJdbcTypeCount() + (discriminatorMapping == null ? 0 : 1));
            TableGroup parentTableGroup = tableGroup;
            SelectableConsumer selectableConsumer = (selectionIndex, selectableMapping) -> {
                TableReference tableReference = parentTableGroup.resolveTableReference(navigablePath, selectableMapping.getContainingTableExpression(), false);
                expressions.add(sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping, sessionFactory)));
            };
            identifierMapping.forEachSelectable(selectableConsumer);
            if (discriminatorMapping != null) {
                discriminatorMapping.forEachSelectable(selectableConsumer);
            }
            entityMappingType.forEachSelectable(selectableConsumer);
            sqlExpression = new SqlTuple(expressions, entityMappingType);
        } else if (resultModelPart instanceof BasicValuedModelPart) {
            BasicValuedModelPart basicValuedModelPart = (BasicValuedModelPart)resultModelPart;
            TableReference tableReference = tableGroup.resolveTableReference(navigablePath, basicValuedModelPart.getContainingTableExpression());
            sqlExpression = sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, basicValuedModelPart.getSelectionExpression()), processingState -> new ColumnReference(tableReference, (SelectableMapping)basicValuedModelPart, sessionFactory));
        } else {
            ArrayList expressions = new ArrayList(resultModelPart.getJdbcTypeCount());
            resultModelPart.forEachSelectable((selectionIndex, selectableMapping) -> {
                TableReference tableReference = tableGroup.resolveTableReference(navigablePath, selectableMapping.getContainingTableExpression());
                expressions.add(sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping, sessionFactory)));
            });
            sqlExpression = new SqlTuple(expressions, resultModelPart);
        }
        return new EntityValuedPathInterpretation<T>(sqlExpression, navigablePath, tableGroup, treatedMapping);
    }

    public EntityValuedPathInterpretation(Expression sqlExpression, NavigablePath navigablePath, TableGroup tableGroup, EntityValuedModelPart mapping) {
        super(navigablePath, mapping, tableGroup);
        this.sqlExpression = sqlExpression;
    }

    @Override
    public Expression getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlExpression.accept(sqlTreeWalker);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        if (this.sqlExpression instanceof SqlTuple) {
            return ((SqlTuple)this.sqlExpression).getExpressions();
        }
        return Collections.singletonList((ColumnReference)this.sqlExpression);
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        if (this.sqlExpression instanceof SqlTuple) {
            for (Expression expression : ((SqlTuple)this.sqlExpression).getExpressions()) {
                columnReferenceConsumer.accept((ColumnReference)expression);
            }
        } else {
            columnReferenceConsumer.accept((ColumnReference)this.sqlExpression);
        }
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.sqlExpression instanceof SqlTuple ? (SqlTuple)this.sqlExpression : null;
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this.sqlExpression, this.getExpressionType().getJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    @Override
    public EntityValuedModelPart getExpressionType() {
        return (EntityValuedModelPart)super.getExpressionType();
    }
}

