/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;

public class SqmTupleInterpretation<T>
extends SqlTuple {
    private final SqmTuple<T> interpretedSqmTuple;

    public static <T> SqmTupleInterpretation<T> from(SqmTuple<T> sqmTuple, SemanticQueryWalker<?> walker, SqlAstCreationState sqlAstCreationState) {
        ArrayList<Expression> groupedSqlExpressions = new ArrayList<Expression>();
        for (SqmExpression<?> groupedExpression : sqmTuple.getGroupedExpressions()) {
            groupedSqlExpressions.add((Expression)groupedExpression.accept(walker));
        }
        return new SqmTupleInterpretation<T>(sqmTuple, groupedSqlExpressions, SqmMappingModelHelper.resolveMappingModelExpressible(sqmTuple, sqlAstCreationState.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel(), sqlAstCreationState.getFromClauseAccess()::findTableGroup));
    }

    public SqmTupleInterpretation(SqmTuple<T> sqmTuple, List<? extends Expression> expressions, MappingModelExpressible valueMapping) {
        super(expressions, valueMapping);
        this.interpretedSqmTuple = sqmTuple;
    }

    public SqmTuple<T> getInterpretedSqmTuple() {
        return this.interpretedSqmTuple;
    }
}

