/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.ChannelListenerManager;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolverManager;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public interface Channel
extends SessionHolder<Session>,
ChannelListenerManager,
PropertyResolver,
AttributeStore,
ChannelStreamWriterResolverManager,
Closeable {
    public static final String CHANNEL_EXEC = "exec";
    public static final String CHANNEL_SHELL = "shell";
    public static final String CHANNEL_SUBSYSTEM = "subsystem";

    public int getId();

    public int getRecipient();

    public Window getLocalWindow();

    public Window getRemoteWindow();

    public List<RequestHandler<Channel>> getRequestHandlers();

    public void addRequestHandler(RequestHandler<Channel> var1);

    default public void addRequestHandlers(Collection<? extends RequestHandler<Channel>> handlers) {
        GenericUtils.forEach(handlers, this::addRequestHandler);
    }

    public void removeRequestHandler(RequestHandler<Channel> var1);

    default public void removeRequestHandlers(Collection<? extends RequestHandler<Channel>> handlers) {
        GenericUtils.forEach(handlers, this::removeRequestHandler);
    }

    public void handleClose() throws IOException;

    public void handleWindowAdjust(Buffer var1) throws IOException;

    public void handleRequest(Buffer var1) throws IOException;

    public void handleData(Buffer var1) throws IOException;

    public void handleExtendedData(Buffer var1) throws IOException;

    public void handleEof() throws IOException;

    public void handleSuccess() throws IOException;

    public void handleFailure() throws IOException;

    public void init(ConnectionService var1, Session var2, int var3) throws IOException;

    public void handleChannelRegistrationResult(ConnectionService var1, Session var2, int var3, boolean var4);

    public void handleChannelUnregistration(ConnectionService var1);

    public boolean isInitialized();

    public boolean isEofSignalled();

    public OpenFuture open(int var1, long var2, long var4, Buffer var6);

    public void handleOpenSuccess(int var1, long var2, long var4, Buffer var6) throws IOException;

    public void handleOpenFailure(Buffer var1) throws IOException;

    default public <T> T resolveAttribute(AttributeRepository.AttributeKey<T> key) {
        return Channel.resolveAttribute(this, key);
    }

    public static <T> T resolveAttribute(Channel channel, AttributeRepository.AttributeKey<T> key) {
        Objects.requireNonNull(key, "No key");
        if (channel == null) {
            return null;
        }
        Object value = channel.getAttribute(key);
        return (T)(value != null ? value : Session.resolveAttribute(channel.getSession(), key));
    }

    public IoWriteFuture writePacket(Buffer var1) throws IOException;
}

