/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.rts.service;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import jakarta.servlet.ServletException;
import java.net.Inet4Address;
import java.util.Map;
import org.jboss.as.network.SocketBinding;
import org.jboss.jbossts.star.service.ContextListener;
import org.jboss.msc.value.InjectedValue;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.wildfly.extension.rts.logging.RTSLogger;
import org.wildfly.extension.rts.service.ParticipantService;
import org.wildfly.extension.undertow.Host;

public class AbstractRTSService {
    private InjectedValue<Host> injectedHost = new InjectedValue();
    private InjectedValue<SocketBinding> injectedSocketBinding = new InjectedValue();
    private volatile Deployment deployment = null;

    public InjectedValue<Host> getInjectedHost() {
        return this.injectedHost;
    }

    public InjectedValue<SocketBinding> getInjectedSocketBinding() {
        return this.injectedSocketBinding;
    }

    protected DeploymentInfo getDeploymentInfo(String name, String contextPath, Map<String, String> initialParameters) {
        DeploymentInfo deploymentInfo = new DeploymentInfo();
        deploymentInfo.setClassLoader(ParticipantService.class.getClassLoader());
        deploymentInfo.setContextPath(contextPath);
        deploymentInfo.setDeploymentName(name);
        deploymentInfo.addServlets(new ServletInfo[]{this.getResteasyServlet()});
        deploymentInfo.addListener(this.getResteasyListener());
        deploymentInfo.addListener(this.getRestATListener());
        for (Map.Entry<String, String> entry : initialParameters.entrySet()) {
            deploymentInfo.addInitParameter(entry.getKey(), entry.getValue());
        }
        return deploymentInfo;
    }

    protected void deployServlet(DeploymentInfo deploymentInfo) {
        DeploymentManager manager = ServletContainer.Factory.newInstance().addDeployment(deploymentInfo);
        manager.deploy();
        this.deployment = manager.getDeployment();
        try {
            ((Host)this.injectedHost.getValue()).registerDeployment(this.deployment, manager.start());
        }
        catch (ServletException e) {
            RTSLogger.ROOT_LOGGER.warn(e.getMessage(), e);
            this.deployment = null;
        }
    }

    protected void undeployServlet() {
        if (this.deployment != null) {
            ((Host)this.injectedHost.getValue()).unregisterDeployment(this.deployment);
            this.deployment = null;
        }
    }

    protected String getBaseUrl() {
        String address = ((SocketBinding)this.injectedSocketBinding.getValue()).getAddress().getHostAddress();
        int port = ((SocketBinding)this.injectedSocketBinding.getValue()).getAbsolutePort();
        if (((SocketBinding)this.injectedSocketBinding.getValue()).getAddress() instanceof Inet4Address) {
            return "http://" + address + ":" + port;
        }
        return "http://[" + address + "]:" + port;
    }

    private ServletInfo getResteasyServlet() {
        ServletInfo servletInfo = new ServletInfo("Resteasy", HttpServletDispatcher.class);
        servletInfo.addMapping("/*");
        return servletInfo;
    }

    private ListenerInfo getResteasyListener() {
        ListenerInfo listenerInfo = new ListenerInfo(ResteasyBootstrap.class);
        return listenerInfo;
    }

    private ListenerInfo getRestATListener() {
        ListenerInfo listenerInfo = new ListenerInfo(ContextListener.class);
        return listenerInfo;
    }
}

