/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.EnumSet;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.address.CreateAddress;
import org.apache.activemq.artemis.cli.commands.address.DeleteAddress;
import org.apache.activemq.artemis.cli.commands.address.ShowAddress;
import org.apache.activemq.artemis.cli.commands.address.UpdateAddress;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Before;
import org.junit.Test;

public class AddressCommandTest
extends JMSTestBase {
    private ByteArrayOutputStream output;
    private ByteArrayOutputStream error;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.output = new ByteArrayOutputStream(1024);
        this.error = new ByteArrayOutputStream(1024);
    }

    @Test
    public void testCreateAddress() throws Exception {
        String address = "address";
        CreateAddress command = new CreateAddress();
        command.setName(address);
        command.setAnycast(true);
        command.setMulticast(true);
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)command);
        AddressInfo addressInfo = this.server.getAddressInfo(new SimpleString(address));
        AddressCommandTest.assertNotNull((Object)addressInfo);
        AddressCommandTest.assertTrue((boolean)addressInfo.getRoutingTypes().contains(RoutingType.ANYCAST));
        AddressCommandTest.assertTrue((boolean)addressInfo.getRoutingTypes().contains(RoutingType.MULTICAST));
    }

    @Test
    public void testCreateAddressAlreadyExistsShowsError() throws Exception {
        String address = "address";
        CreateAddress command = new CreateAddress();
        command.setName(address);
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)command);
        AddressCommandTest.assertNotNull((Object)this.server.getAddressInfo(new SimpleString(address)));
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)command, "Address already exists");
    }

    @Test
    public void testDeleteAddress() throws Exception {
        String address = "address";
        CreateAddress command = new CreateAddress();
        command.setName(address);
        command.execute(new ActionContext());
        AddressCommandTest.assertNotNull((Object)this.server.getAddressInfo(new SimpleString(address)));
        DeleteAddress deleteAddress = new DeleteAddress();
        deleteAddress.setName(address);
        deleteAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)deleteAddress);
        AddressCommandTest.assertNull((Object)this.server.getAddressInfo(new SimpleString(address)));
    }

    @Test
    public void testDeleteAddressDoesNotExistsShowsError() throws Exception {
        String address = "address";
        DeleteAddress deleteAddress = new DeleteAddress();
        deleteAddress.setName(address);
        deleteAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)deleteAddress, "Address Does Not Exist");
    }

    @Test
    public void testFailDeleteAddressWhenExistsQueues() throws Exception {
        String addressName = "address";
        SimpleString addressSimpleString = new SimpleString("address");
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST));
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(new QueueConfiguration(new SimpleString("queue1")).setAddress(addressSimpleString).setRoutingType(RoutingType.MULTICAST));
        DeleteAddress deleteAddress = new DeleteAddress();
        deleteAddress.setName("address");
        deleteAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)deleteAddress, "Address address has bindings");
    }

    @Test
    public void testShowAddress() throws Exception {
        String address = "address";
        CreateAddress command = new CreateAddress();
        command.setName(address);
        command.execute(new ActionContext());
        AddressCommandTest.assertNotNull((Object)this.server.getAddressInfo(new SimpleString(address)));
        ShowAddress showAddress = new ShowAddress();
        showAddress.setName(address);
        showAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.instanceLog.debug((Object)this.output.toString());
    }

    @Test
    public void testShowAddressDoesNotExist() throws Exception {
        String address = "address";
        ShowAddress showAddress = new ShowAddress();
        showAddress.setName(address);
        showAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)showAddress, "Address Does Not Exist");
    }

    @Test
    public void testShowAddressBindings() throws Exception {
        SimpleString address = new SimpleString("address");
        this.server.addAddressInfo(new AddressInfo(address, RoutingType.MULTICAST));
        this.server.createQueue(new QueueConfiguration(new SimpleString("queue1")).setAddress(address).setRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(new QueueConfiguration(new SimpleString("queue2")).setAddress(address).setRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(new QueueConfiguration(new SimpleString("queue3")).setAddress(address).setRoutingType(RoutingType.MULTICAST));
        DivertConfiguration divertConfiguration = new DivertConfiguration();
        divertConfiguration.setName(address.toString());
        divertConfiguration.setAddress(address.toString());
        this.server.deployDivert(divertConfiguration);
        ShowAddress showAddress = new ShowAddress();
        showAddress.setName(address.toString());
        showAddress.setBindings(true);
        showAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.instanceLog.debug((Object)this.output.toString());
    }

    @Test
    public void testUpdateAddressRoutingTypes() throws Exception {
        String addressName = "address";
        SimpleString address = new SimpleString("address");
        this.server.addAddressInfo(new AddressInfo(address, RoutingType.ANYCAST));
        UpdateAddress updateAddress = new UpdateAddress();
        updateAddress.setName("address");
        updateAddress.setAnycast(true);
        updateAddress.setMulticast(true);
        updateAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)updateAddress);
        AddressInfo addressInfo = this.server.getAddressInfo(address);
        AddressCommandTest.assertNotNull((Object)addressInfo);
        AddressCommandTest.assertEquals(EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST), (Object)addressInfo.getRoutingTypes());
    }

    @Test
    public void testFailUpdateAddressDoesNotExist() throws Exception {
        String addressName = "address";
        UpdateAddress updateAddress = new UpdateAddress();
        updateAddress.setName("address");
        updateAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)updateAddress, "Address Does Not Exist");
    }

    @Test
    public void testFailUpdateAddressRoutingTypesWhenExistsQueues() throws Exception {
        String addressName = "address";
        SimpleString addressSimpleString = new SimpleString("address");
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST));
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(new QueueConfiguration(new SimpleString("queue1")).setAddress(addressSimpleString).setRoutingType(RoutingType.MULTICAST));
        UpdateAddress updateAddress = new UpdateAddress();
        updateAddress.setName("address");
        updateAddress.setAnycast(true);
        updateAddress.setMulticast(false);
        updateAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        String expectedErrorMessage = MessageFormat.format("Can''t remove routing type {0}, queues exists for address: {1}. Please delete queues before removing this routing type.", RoutingType.MULTICAST, "address");
        this.checkExecutionFailure((AbstractAction)updateAddress, expectedErrorMessage);
    }

    private void checkExecutionPassed(AbstractAction command) throws Exception {
        String fullMessage = this.output.toString();
        this.instanceLog.debug((Object)("output: " + fullMessage));
        AddressCommandTest.assertTrue((String)fullMessage, (boolean)fullMessage.contains("successfully"));
    }

    private void checkExecutionFailure(AbstractAction command, String message) throws Exception {
        String fullMessage = this.error.toString();
        this.instanceLog.debug((Object)("error: " + fullMessage));
        AddressCommandTest.assertTrue((String)fullMessage, (boolean)fullMessage.contains(message));
    }
}

