/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ForceDeleteQueue
extends ActiveMQTestBase {
    ActiveMQServer server;
    String protocol = "openwire";
    String uri = "tcp://localhost:61616";

    public ForceDeleteQueue(String protocol) {
        this.protocol = protocol;
    }

    @Parameterized.Parameters(name="protocol={0}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{"openwire"}, {"core"}, {"amqp"}};
        return Arrays.asList(params);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (this.protocol.equals("openwire")) {
            this.uri = "tcp://localhost:61616?jms.prefetchPolicy.all=5000";
        }
        this.server = this.createServer(true, true);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setMaxDeliveryAttempts(2));
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForceDelete() throws Exception {
        SimpleString queueName = SimpleString.toSimpleString((String)"testForceDelete");
        this.server.addAddressInfo(new AddressInfo(queueName, RoutingType.ANYCAST));
        this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, true, false);
        ConnectionFactory factory = CFUtil.createConnectionFactory(this.protocol, this.uri);
        Connection conn = factory.createConnection();
        AssertionLoggerHandler.startCapture();
        try {
            Session session = conn.createSession(true, 0);
            jakarta.jms.Queue queue = session.createQueue(queueName.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < 1000; ++i) {
                TextMessage message = session.createTextMessage("Text " + i);
                producer.send((Message)message);
            }
            session.commit();
            Queue serverQueue = this.server.locateQueue(queueName);
            Wait.assertEquals((long)1000L, () -> ((Queue)serverQueue).getMessageCount());
            conn.close();
            conn = factory.createConnection();
            session = conn.createSession(false, 1);
            conn.start();
            LinkedListIterator queueiterator = serverQueue.browserIterator();
            ArrayList<Long> listQueue = new ArrayList<Long>(1000);
            while (queueiterator.hasNext()) {
                MessageReference ref = (MessageReference)queueiterator.next();
                listQueue.add(ref.getMessageID());
            }
            queueiterator.close();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Wait.assertTrue(() -> serverQueue.getDeliveringCount() > 100);
            for (Long l : listQueue) {
                this.server.getStorageManager().deleteMessage(l.longValue());
            }
            this.server.destroyQueue(queueName, null, false);
            for (RemotingConnection connection : this.server.getRemotingService().getConnections()) {
                connection.fail(new ActiveMQException("failure"));
            }
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"Cannot find add info"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

