/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class TransactionDurabilityTest
extends ActiveMQTestBase {
    @Test
    public void testRolledBackAcknowledgeWithSameMessageAckedByOtherSession() throws Exception {
        SimpleString testAddress = new SimpleString("testAddress");
        SimpleString queue1 = new SimpleString("queue1");
        SimpleString queue2 = new SimpleString("queue2");
        ActiveMQServer server = this.createServer(true, this.createDefaultInVMConfig());
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session1 = this.addClientSession(sf.createSession(false, true, true));
        ClientSession session2 = this.addClientSession(sf.createSession(false, false, false));
        session1.createQueue(new QueueConfiguration(queue1).setAddress(testAddress));
        session1.createQueue(new QueueConfiguration(queue2).setAddress(testAddress));
        ClientProducer producer = session1.createProducer(testAddress);
        ClientMessage message = session1.createMessage(true);
        producer.send((Message)message);
        session1.start();
        session2.start();
        ClientConsumer consumer1 = session1.createConsumer(queue1);
        ClientConsumer consumer2 = session2.createConsumer(queue2);
        ClientMessage m1 = consumer1.receive(1000L);
        Assert.assertNotNull((Object)m1);
        ClientMessage m2 = consumer2.receive(1000L);
        Assert.assertNotNull((Object)m2);
        m2.acknowledge();
        m1.acknowledge();
        session2.rollback();
        session1.close();
        session2.close();
        server.stop();
        server.start();
        sf = this.createSessionFactory(locator);
        session1 = this.addClientSession(sf.createSession(false, true, true));
        session2 = this.addClientSession(sf.createSession(false, true, true));
        session1.start();
        session2.start();
        consumer1 = session1.createConsumer(queue1);
        consumer2 = session2.createConsumer(queue2);
        m1 = consumer1.receiveImmediate();
        Assert.assertNull((Object)m1);
        m2 = consumer2.receive(1000L);
        Assert.assertNotNull((Object)m2);
        m2.acknowledge();
        session1.close();
        session2.close();
        server.stop();
        server.start();
        sf = this.createSessionFactory(locator);
        session1 = this.addClientSession(sf.createSession(false, true, true));
        session2 = this.addClientSession(sf.createSession(false, true, true));
        session1.start();
        session2.start();
        consumer1 = session1.createConsumer(queue1);
        consumer2 = session2.createConsumer(queue2);
        m1 = consumer1.receiveImmediate();
        Assert.assertNull((Object)m1);
        m2 = consumer2.receiveImmediate();
        Assert.assertNull((Object)m2);
        session1.close();
        session2.close();
        locator.close();
        server.stop();
    }
}

