/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.topology;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.tests.integration.cluster.topology.HAClientTopologyWithDiscoveryTest;
import org.junit.Assert;
import org.junit.Test;

public class NettyHAClientTopologyWithDiscoveryTest
extends HAClientTopologyWithDiscoveryTest {
    @Override
    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testRecoveryBadUDPWithRetry() throws Exception {
        this.startServers(0);
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)this.createHAServerLocator();
        serverLocator.setInitialConnectAttempts(10);
        serverLocator.initialize();
        serverLocator.getDiscoveryGroup().stop();
        ClientSessionFactory factory = serverLocator.createSessionFactory();
        ClientSession session = factory.createSession();
        session.close();
    }

    @Test
    public void testRecoveryBadUDPWithoutRetry() throws Exception {
        ClientSession session;
        ClientSessionFactory factory;
        this.startServers(0);
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)this.createHAServerLocator();
        serverLocator.setInitialConnectAttempts(0);
        serverLocator.initialize();
        serverLocator.getDiscoveryGroup().stop();
        boolean failure = false;
        try {
            factory = serverLocator.createSessionFactory();
            session = factory.createSession();
            session.close();
            factory.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            failure = true;
        }
        Assert.assertTrue((boolean)failure);
        factory = serverLocator.createSessionFactory();
        session = factory.createSession();
        session.close();
        factory.close();
    }

    @Test
    public void testNoServer() {
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)new DiscoveryGroupConfiguration().setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.groupAddress).setGroupPort(this.groupPort)).setDiscoveryInitialWaitTimeout(10L)).setInitialConnectAttempts(0);
        this.addServerLocator((ServerLocator)serverLocator);
        serverLocator.setInitialConnectAttempts(3);
        try {
            serverLocator.createSessionFactory();
            Assert.fail((String)"Exception was expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectWithMultiThread() throws Exception {
        final AtomicInteger errors = new AtomicInteger(0);
        int NUMBER_OF_THREADS = 100;
        final CyclicBarrier barrier = new CyclicBarrier(NUMBER_OF_THREADS);
        final ServerLocatorImpl serverLocator = (ServerLocatorImpl)ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)new DiscoveryGroupConfiguration().setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.groupAddress).setGroupPort(this.groupPort)).setDiscoveryInitialWaitTimeout(1000L)).setInitialConnectAttempts(0);
        serverLocator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.addServerLocator((ServerLocator)serverLocator);
        this.startServers(0);
        try {
            serverLocator.setInitialConnectAttempts(0);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        barrier.await();
                        ClientSessionFactory factory = serverLocator.createSessionFactory();
                        ClientSession session = factory.createSession();
                        session.close();
                        factory.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                }
            };
            Thread[] threads = new Thread[NUMBER_OF_THREADS];
            for (int i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(runnable);
                threads[i].start();
            }
            for (Thread t : threads) {
                t.join();
            }
            Assert.assertEquals((long)0L, (long)errors.get());
            serverLocator.close();
            serverLocator.getDiscoveryGroup().stop();
        }
        catch (Throwable throwable) {
            this.stopServers(0);
            throw throwable;
        }
        this.stopServers(0);
    }
}

