/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.jms2client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.activemq.artemis.tests.integration.jms.jms2client.JmsContextTest;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Before;
import org.junit.Test;

public class InvalidDestinationTest
extends JMSTestBase {
    private JMSContext context;
    private Queue queue1;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context = this.createContext();
        this.queue1 = this.createQueue(JmsContextTest.class.getSimpleName() + "Queue");
    }

    @Test
    public void invalidDestinationRuntimeExceptionTests() throws Exception {
        JMSProducer producer = this.context.createProducer();
        Destination invalidDestination = null;
        Topic invalidTopic = null;
        String message = "hello world";
        byte[] bytesMsgSend = message.getBytes();
        HashMap<String, Object> mapMsgSend = new HashMap<String, Object>();
        mapMsgSend.put("s", "foo");
        mapMsgSend.put("b", true);
        mapMsgSend.put("i", 1);
        TextMessage expTextMessage = this.context.createTextMessage(message);
        try {
            producer.send(invalidDestination, (Message)expTextMessage);
        }
        catch (InvalidDestinationRuntimeException invalidDestinationRuntimeException) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            producer.send(invalidDestination, message);
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        ObjectMessage om = this.context.createObjectMessage();
        StringBuffer sb = new StringBuffer(message);
        om.setObject((Serializable)sb);
        try {
            producer.send(invalidDestination, (Message)om);
        }
        catch (InvalidDestinationRuntimeException invalidDestinationRuntimeException) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            producer.send(invalidDestination, bytesMsgSend);
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            producer.send(invalidDestination, mapMsgSend);
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            this.context.createConsumer(invalidDestination);
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            this.context.createConsumer(invalidDestination, "lastMessage = TRUE");
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            this.context.createConsumer(invalidDestination, "lastMessage = TRUE", false);
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            this.context.createDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException");
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            this.context.createDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException", "lastMessage = TRUE", false);
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            this.context.createSharedDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException");
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            this.context.createSharedDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException", "lastMessage = TRUE");
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            this.context.unsubscribe("InvalidSubscriptionName");
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            this.context.createSharedConsumer(invalidTopic, "InvalidDestinationRuntimeException");
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
        try {
            this.context.createSharedConsumer(invalidTopic, "InvalidDestinationRuntimeException", "lastMessage = TRUE");
        }
        catch (InvalidDestinationRuntimeException e) {
        }
        catch (Exception e) {
            InvalidDestinationTest.fail((String)("Expected InvalidDestinationRuntimeException, received " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void invalidDestinationExceptionTests() throws Exception {
        Object invalidDestination = null;
        Topic invalidTopic = null;
        try (Connection conn = this.cf.createConnection();){
            Session session = conn.createSession();
            try {
                session.createDurableSubscriber(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException invalidDestinationException) {
            }
            catch (Exception e) {
                InvalidDestinationTest.fail((String)("Expected InvalidDestinationException, received " + e));
            }
            try {
                session.createDurableSubscriber(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationException e) {
            }
            catch (Exception e) {
                InvalidDestinationTest.fail((String)("Expected InvalidDestinationException, received " + e));
            }
            try {
                session.createDurableConsumer(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
            }
            catch (Exception e) {
                InvalidDestinationTest.fail((String)("Expected InvalidDestinationException, received " + e));
            }
            try {
                session.createDurableConsumer(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationException e) {
            }
            catch (Exception e) {
                InvalidDestinationTest.fail((String)("Expected InvalidDestinationException, received " + e));
            }
            try {
                session.createSharedConsumer(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
            }
            catch (Exception e) {
                InvalidDestinationTest.fail((String)("Expected InvalidDestinationException, received " + e));
            }
            try {
                session.createSharedConsumer(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE");
            }
            catch (InvalidDestinationException e) {
            }
            catch (Exception e) {
                InvalidDestinationTest.fail((String)("Expected InvalidDestinationException, received " + e));
            }
            try {
                session.createSharedDurableConsumer(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
            }
            catch (Exception e) {
                InvalidDestinationTest.fail((String)("Expected InvalidDestinationException, received " + e));
            }
            try {
                session.createSharedDurableConsumer(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE");
            }
            catch (InvalidDestinationException e) {
            }
            catch (Exception e) {
                InvalidDestinationTest.fail((String)("Expected InvalidDestinationException, received " + e));
            }
        }
    }
}

