/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSUsecase1Test
extends BasicOpenWireTest {
    public int deliveryMode;
    public byte destinationType;

    @Parameterized.Parameters(name="deliveryMode={0} destinationType={1}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, (byte)1}, {1, (byte)5}, {1, (byte)2}, {1, (byte)6}, {2, (byte)1}, {2, (byte)5}, {2, (byte)2}, {2, (byte)6});
    }

    public JMSUsecase1Test(int deliveryMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.destinationType = destinationType;
    }

    @Test
    public void testSendReceive() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(this.deliveryMode);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        ActiveMQMessage message = new ActiveMQMessage();
        producer.send((Message)message);
        JMSUsecase1Test.assertNotNull((Object)consumer.receive(1000L));
        JMSUsecase1Test.assertNull((Object)consumer.receiveNoWait());
    }

    @Test
    public void testSendReceiveTransacted() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(this.deliveryMode);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("test"));
        JMSUsecase1Test.assertNull((Object)consumer.receiveNoWait());
        session.commit();
        Message message = consumer.receive(1000L);
        JMSUsecase1Test.assertNotNull((Object)message);
        JMSUsecase1Test.assertFalse((boolean)message.getJMSRedelivered());
        JMSUsecase1Test.assertNull((Object)consumer.receiveNoWait());
        session.rollback();
        message = consumer.receive(2000L);
        JMSUsecase1Test.assertNotNull((Object)message);
        JMSUsecase1Test.assertTrue((boolean)message.getJMSRedelivered());
        JMSUsecase1Test.assertNull((Object)consumer.receiveNoWait());
        session.commit();
        JMSUsecase1Test.assertNull((Object)consumer.receiveNoWait());
    }
}

