/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.io.File;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.junit.Assert;
import org.junit.Test;

public class JournalFileSizeTest
extends ActiveMQTestBase {
    private static int align;

    protected ConfigurationImpl createBasicConfig(int serverID) {
        ConfigurationImpl configuration = new ConfigurationImpl().setJournalDirectory(this.getJournalDir(serverID, false)).setBindingsDirectory(this.getBindingsDir(serverID, false)).setPagingDirectory(this.getPageDir(serverID, false)).setLargeMessagesDirectory(this.getLargeMessagesDir(serverID, false));
        return configuration;
    }

    @Test
    public void testIncorrectFileSizeLower() throws Exception {
        ConfigurationImpl config = this.createBasicConfig();
        int origFileSize = config.getJournalFileSize();
        config.setJournalFileSize(origFileSize + (align / 2 - 1));
        JournalStorageManager manager = new JournalStorageManager((Configuration)config, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), (ExecutorFactory)new OrderedExecutorFactory(null), (ExecutorFactory)new OrderedExecutorFactory(null));
        int fileSize = manager.getMessageJournal().getFileSize();
        Assert.assertEquals((long)origFileSize, (long)fileSize);
    }

    @Test
    public void testIncorrectFileSizeHigher() throws Exception {
        ConfigurationImpl config = this.createBasicConfig();
        int origFileSize = config.getJournalFileSize();
        config.setJournalFileSize(origFileSize + (align / 2 + 1));
        JournalStorageManager manager = new JournalStorageManager((Configuration)config, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), (ExecutorFactory)new OrderedExecutorFactory(null), (ExecutorFactory)new OrderedExecutorFactory(null));
        int fileSize = manager.getMessageJournal().getFileSize();
        Assert.assertEquals((long)(origFileSize + align), (long)fileSize);
    }

    @Test
    public void testIncorrectFileSizeHalf() throws Exception {
        ConfigurationImpl config = this.createBasicConfig();
        int origFileSize = config.getJournalFileSize();
        config.setJournalFileSize(origFileSize + align / 2);
        JournalStorageManager manager = new JournalStorageManager((Configuration)config, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), (ExecutorFactory)new OrderedExecutorFactory(null), (ExecutorFactory)new OrderedExecutorFactory(null));
        int fileSize = manager.getMessageJournal().getFileSize();
        Assert.assertEquals((long)(origFileSize + align), (long)fileSize);
    }

    static {
        try {
            AIOSequentialFileFactory factory = new AIOSequentialFileFactory(new File("./target/"), 100);
            align = factory.getAlignment();
        }
        catch (Exception e) {
            align = 512;
        }
    }
}

