/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import jakarta.persistence.EntityManager;
import jakarta.transaction.Synchronization;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.automaticindexing.session.impl.ConfiguredAutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingEventSendingSessionContext;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.common.impl.EntityReferenceImpl;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionLoadingContext;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRuntimeIntrospector;
import org.hibernate.search.mapper.orm.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.orm.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.context.HibernateOrmSessionContext;
import org.hibernate.search.mapper.orm.session.impl.ConfiguredAutomaticIndexingStrategy;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionHolder;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContextProvider;
import org.hibernate.search.mapper.orm.session.impl.SynchronizationAdapter;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlan;
import org.hibernate.search.mapper.orm.work.SearchWorkspace;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanImpl;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanSessionContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchSession;
import org.hibernate.search.mapper.pojo.session.spi.PojoSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventProcessingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmSearchSession
extends AbstractPojoSearchSession
implements SearchSession,
HibernateOrmSessionContext,
HibernateOrmScopeSessionContext,
SearchIndexingPlanSessionContext,
DocumentReferenceConverter<EntityReference>,
AutomaticIndexingEventSendingSessionContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmSearchSessionMappingContext mappingContext;
    private final HibernateOrmSessionTypeContextProvider typeContextProvider;
    private final SessionImplementor sessionImplementor;
    private final HibernateOrmRuntimeIntrospector runtimeIntrospector;
    private final ConfiguredAutomaticIndexingStrategy automaticIndexingStrategy;
    private ConfiguredAutomaticIndexingSynchronizationStrategy indexingPlanSynchronizationStrategy;
    private SearchIndexingPlanImpl indexingPlan;

    public static HibernateOrmSearchSession get(HibernateOrmSearchSessionMappingContext context, SessionImplementor sessionImplementor) {
        return HibernateOrmSearchSession.get(context, sessionImplementor, true);
    }

    public static HibernateOrmSearchSession get(HibernateOrmSearchSessionMappingContext context, SessionImplementor sessionImplementor, boolean createIfDoesNotExist) {
        HibernateOrmSearchSessionHolder holder = HibernateOrmSearchSessionHolder.get(sessionImplementor, createIfDoesNotExist);
        if (holder == null) {
            return null;
        }
        HibernateOrmSearchSession searchSession = holder.searchSession();
        if (searchSession != null) {
            return searchSession;
        }
        if (!createIfDoesNotExist) {
            return null;
        }
        searchSession = context.createSessionBuilder(sessionImplementor).build();
        holder.searchSession(searchSession);
        return searchSession;
    }

    private HibernateOrmSearchSession(Builder builder) {
        super((PojoSearchSessionMappingContext)builder.mappingContext);
        this.mappingContext = builder.mappingContext;
        this.typeContextProvider = builder.typeContextProvider;
        this.automaticIndexingStrategy = builder.automaticIndexingStrategy;
        this.sessionImplementor = builder.sessionImplementor;
        this.runtimeIntrospector = builder.buildRuntimeIntrospector();
        this.indexingPlanSynchronizationStrategy = this.automaticIndexingStrategy.defaultIndexingPlanSynchronizationStrategy();
    }

    public String tenantIdentifier() {
        return this.session().getTenantIdentifier();
    }

    @Override
    public PojoIndexer createIndexer() {
        return this.mappingContext.createIndexer((PojoWorkSessionContext)this);
    }

    @Override
    public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(Collection<? extends Class<? extends T>> types) {
        return this.search((SearchScopeImpl<T>)this.scope((Collection)types));
    }

    @Override
    public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(SearchScope<T> scope) {
        return this.search((SearchScopeImpl)scope);
    }

    public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(SearchScopeImpl<T> scope) {
        return scope.search(this, this.loadingContextBuilder());
    }

    @Override
    public SearchSchemaManager schemaManager(Collection<? extends Class<?>> types) {
        return ((SearchScopeImpl)this.scope(types)).schemaManager();
    }

    @Override
    public SearchWorkspace workspace(Collection<? extends Class<?>> types) {
        return ((SearchScopeImpl)this.scope(types)).workspace(DetachedBackendSessionContext.of((BackendSessionContext)this));
    }

    @Override
    public MassIndexer massIndexer(Collection<? extends Class<?>> types) {
        return ((SearchScopeImpl)this.scope(types)).massIndexer(DetachedBackendSessionContext.of((BackendSessionContext)this));
    }

    public <T> SearchScopeImpl<T> scope(Collection<? extends Class<? extends T>> types) {
        this.checkOpen();
        return this.mappingContext.createScope(types);
    }

    @Override
    public <T> SearchScope<T> scope(Class<T> expectedSuperType, Collection<String> entityNames) {
        this.checkOpen();
        return this.mappingContext.createScope(expectedSuperType, entityNames);
    }

    @Override
    public EntityManager toEntityManager() {
        return this.sessionImplementor;
    }

    @Override
    public Session toOrmSession() {
        return this.sessionImplementor;
    }

    @Override
    public SearchIndexingPlan indexingPlan() {
        if (this.indexingPlan == null) {
            this.indexingPlan = new SearchIndexingPlanImpl(this.typeContextProvider, this);
        }
        return this.indexingPlan;
    }

    @Override
    public void automaticIndexingSynchronizationStrategy(AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        this.indexingPlanSynchronizationStrategy = this.automaticIndexingStrategy.configureOverriddenSynchronizationStrategy(synchronizationStrategy);
    }

    @Override
    public SessionImplementor session() {
        return this.sessionImplementor;
    }

    @Override
    public DocumentReferenceConverter<EntityReference> documentReferenceConverter() {
        return this;
    }

    public EntityReference fromDocumentReference(DocumentReference reference) {
        HibernateOrmSessionTypeContext<?> typeContext = this.typeContextProvider.forJpaEntityName(reference.typeName());
        if (typeContext == null) {
            throw new AssertionFailure("Document reference " + reference + " refers to an unknown type");
        }
        Object id = typeContext.identifierMapping().fromDocumentIdentifier(reference.id(), (BridgeSessionContext)this);
        return new EntityReferenceImpl(typeContext.typeIdentifier(), typeContext.jpaEntityName(), id);
    }

    public PojoSelectionLoadingContext defaultLoadingContext() {
        return this.loadingContextBuilder().build();
    }

    @Override
    public PojoRuntimeIntrospector runtimeIntrospector() {
        return this.runtimeIntrospector;
    }

    @Override
    public PojoIndexingPlan currentIndexingPlan(boolean createIfDoesNotExist) {
        HibernateOrmSearchSessionHolder holder = HibernateOrmSearchSessionHolder.get(this.sessionImplementor, createIfDoesNotExist);
        if (holder == null) {
            return null;
        }
        Transaction transactionIdentifier = this.sessionImplementor.isTransactionInProgress() ? this.sessionImplementor.accessTransaction() : null;
        PojoIndexingPlan plan = holder.pojoIndexingPlan(transactionIdentifier);
        if (plan != null) {
            return plan;
        }
        if (!createIfDoesNotExist) {
            return null;
        }
        ConfiguredAutomaticIndexingSynchronizationStrategy currentSynchronizationStrategy = this.indexingPlanSynchronizationStrategy;
        plan = this.automaticIndexingStrategy.createIndexingPlan(this, currentSynchronizationStrategy);
        holder.pojoIndexingPlan(transactionIdentifier, plan);
        if (this.sessionImplementor.isTransactionInProgress()) {
            Synchronization txSync = this.automaticIndexingStrategy.createTransactionWorkQueueSynchronization(plan, holder, transactionIdentifier, currentSynchronizationStrategy);
            this.registerSynchronization(this.sessionImplementor, txSync);
        }
        return plan;
    }

    public PojoIndexingQueueEventProcessingPlan createIndexingQueueEventProcessingPlan() {
        return this.automaticIndexingStrategy.createIndexingQueueEventProcessingPlan(this, this.indexingPlanSynchronizationStrategy);
    }

    @Override
    public void checkOpen() {
        HibernateOrmSearchSession.checkOpen(this.sessionImplementor);
    }

    @Override
    public ConfiguredAutomaticIndexingSynchronizationStrategy configuredAutomaticIndexingSynchronizationStrategy() {
        return this.indexingPlanSynchronizationStrategy;
    }

    private HibernateOrmSelectionLoadingContext.Builder loadingContextBuilder() {
        return new HibernateOrmSelectionLoadingContext.Builder(this.mappingContext, this.typeContextProvider, this);
    }

    private void registerSynchronization(SessionImplementor sessionImplementor, Synchronization synchronization) {
        ActionQueue actionQueue = sessionImplementor.getActionQueue();
        SynchronizationAdapter adapter = new SynchronizationAdapter(synchronization);
        boolean isLocal = this.isLocalTransaction(sessionImplementor);
        if (isLocal) {
            actionQueue.registerProcess((BeforeTransactionCompletionProcess)adapter);
        } else {
            actionQueue.registerProcess((BeforeTransactionCompletionProcess)adapter);
            sessionImplementor.accessTransaction().registerSynchronization((Synchronization)adapter);
        }
        actionQueue.registerProcess((AfterTransactionCompletionProcess)adapter);
    }

    private boolean isLocalTransaction(SessionImplementor sessionImplementor) {
        return !sessionImplementor.getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta();
    }

    private static void checkOpen(SessionImplementor session) {
        try {
            session.checkOpen();
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionIsClosed(e);
        }
    }

    public static class Builder {
        private final HibernateOrmSearchSessionMappingContext mappingContext;
        private final HibernateOrmSessionTypeContextProvider typeContextProvider;
        private final ConfiguredAutomaticIndexingStrategy automaticIndexingStrategy;
        private final SessionImplementor sessionImplementor;

        public Builder(HibernateOrmSearchSessionMappingContext mappingContext, HibernateOrmSessionTypeContextProvider typeContextProvider, ConfiguredAutomaticIndexingStrategy automaticIndexingStrategy, SessionImplementor sessionImplementor) {
            this.mappingContext = mappingContext;
            this.typeContextProvider = typeContextProvider;
            this.automaticIndexingStrategy = automaticIndexingStrategy;
            this.sessionImplementor = sessionImplementor;
        }

        private HibernateOrmRuntimeIntrospector buildRuntimeIntrospector() {
            return new HibernateOrmRuntimeIntrospector(this.typeContextProvider, (SharedSessionContractImplementor)this.sessionImplementor);
        }

        public HibernateOrmSearchSession build() {
            return new HibernateOrmSearchSession(this);
        }
    }
}

