/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.JChannel;
import org.jgroups.stack.ProtocolStack;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public enum StackOperation implements Operation<ChannelFactory>
{
    EXPORT_NATIVE_CONFIGURATION("export-native-configuration", ModelType.STRING){

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ChannelFactory factory) throws OperationFailedException {
            ModelNode modelNode;
            block8: {
                JChannel channel = factory.createChannel(UUID.randomUUID().toString());
                try {
                    List protocols = channel.getProtocolStack().getProtocols();
                    Collections.reverse(protocols);
                    ProtocolStack stack = new ProtocolStack();
                    stack.addProtocols(protocols);
                    modelNode = new ModelNode(stack.printProtocolSpecAsXML());
                    if (channel == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new OperationFailedException((Throwable)e);
                    }
                }
                channel.close();
            }
            return modelNode;
        }
    };

    private final OperationDefinition definition;

    private StackOperation(String name, ModelType replyType) {
        this.definition = new SimpleOperationDefinitionBuilder(name, JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{StackResourceDefinition.WILDCARD_PATH})).setReplyType(replyType).setReadOnly().build();
    }

    public OperationDefinition getDefinition() {
        return this.definition;
    }
}

