/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.util.Arrays;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.runner.AbstractFileTask;
import org.jboss.as.patching.runner.PatchingTaskDescription;

final class FileUpdateTask
extends AbstractFileTask {
    FileUpdateTask(PatchingTaskDescription description, File target, File backup) {
        super(description, target, backup);
    }

    @Override
    ContentModification createRollbackEntry(ContentModification original, MiscContentItem item, byte[] targetHash) {
        ModificationType type = Arrays.equals(IoUtils.NO_CONTENT, item.getContentHash()) && !this.backup.exists() ? ModificationType.REMOVE : ModificationType.MODIFY;
        return new ContentModification(item, targetHash, type, original.getCondition());
    }

    @Override
    protected ContentModification getOriginalModification(byte[] targetHash, byte[] itemHash) {
        ContentModification original = super.getOriginalModification(targetHash, itemHash);
        ModificationType type = Arrays.equals(IoUtils.NO_CONTENT, itemHash) && !this.backup.exists() ? ModificationType.ADD : ModificationType.MODIFY;
        return new ContentModification(original.getItem(), original.getTargetHash(), type, original.getCondition());
    }
}

