/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ElementAttributeMarshaller;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.capabilities.Capabilities;
import org.jboss.as.logging.handlers.AbstractHandlerDefinition;
import org.jboss.as.logging.handlers.HandlerOperations;
import org.jboss.as.logging.handlers.LogHandlerListAttributeDefinition;
import org.jboss.as.logging.resolvers.OverflowActionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.handlers.AsyncHandler;

public class AsyncHandlerResourceDefinition
extends AbstractHandlerDefinition {
    public static final String NAME = "async-handler";
    private static final String ADD_SUBHANDLER_OPERATION_NAME = "assign-subhandler";
    private static final String REMOVE_SUBHANDLER_OPERATION_NAME = "unassign-subhandler";
    private static final PathElement ASYNC_HANDLER_PATH = PathElement.pathElement((String)"async-handler");
    public static final PropertyAttributeDefinition QUEUE_LENGTH = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("queue-length", ModelType.INT).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setPropertyName("queueLength").setValidator((ParameterValidator)new IntRangeValidator(1, false))).build();
    public static final PropertyAttributeDefinition OVERFLOW_ACTION = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("overflow-action", ModelType.STRING).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(attribute.getXmlName());
                String content = resourceModel.get(attribute.getName()).asString().toLowerCase(Locale.ENGLISH);
                writer.writeAttribute("value", content);
                writer.writeEndElement();
            }
        }
    })).setRequired(false)).setDefaultValue(new ModelNode(AsyncHandler.OverflowAction.BLOCK.name()))).setPropertyName("overflowAction").setResolver(OverflowActionResolver.INSTANCE).setValidator((ParameterValidator)EnumValidator.create(AsyncHandler.OverflowAction.class, (Enum[])new AsyncHandler.OverflowAction[0]))).build();
    static final SimpleAttributeDefinition HANDLER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"handler", (ModelType)ModelType.STRING).setAllowExpression(false)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.NAME_ATTRIBUTE_MARSHALLER)).setCapabilityReference(Capabilities.HANDLER_REFERENCE_RECORDER)).build();
    public static final LogHandlerListAttributeDefinition SUBHANDLERS = ((LogHandlerListAttributeDefinition.Builder)((LogHandlerListAttributeDefinition.Builder)((LogHandlerListAttributeDefinition.Builder)LogHandlerListAttributeDefinition.Builder.of("subhandlers", (AttributeDefinition)HANDLER).setAllowDuplicates(false)).setAllowExpression(false)).setRequired(false)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.ENABLED, CommonAttributes.LEVEL, FILTER_SPEC, QUEUE_LENGTH, OVERFLOW_ACTION, SUBHANDLERS};

    public AsyncHandlerResourceDefinition(boolean includeLegacyAttributes) {
        super(ASYNC_HANDLER_PATH, AsyncHandler.class, includeLegacyAttributes ? Logging.join(ATTRIBUTES, LEGACY_ATTRIBUTES) : ATTRIBUTES, QUEUE_LENGTH);
    }

    @Override
    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        ResourceDescriptionResolver resourceDescriptionResolver = this.getResourceDescriptionResolver();
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(ADD_SUBHANDLER_OPERATION_NAME, resourceDescriptionResolver).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).build(), HandlerOperations.ADD_SUBHANDLER);
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(REMOVE_SUBHANDLER_OPERATION_NAME, resourceDescriptionResolver).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).build(), HandlerOperations.REMOVE_SUBHANDLER);
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("add-handler", resourceDescriptionResolver).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).build(), HandlerOperations.ADD_SUBHANDLER);
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("remove-handler", resourceDescriptionResolver).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).build(), HandlerOperations.REMOVE_SUBHANDLER);
    }

    @Override
    protected void registerResourceTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder resourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
    }
}

