/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeBiFunctionProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeFunctionProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeListProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeTriFunctionProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchDocumentReferenceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchEntityProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchEntityReferenceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchExplanationProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchIdProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchJsonHitProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchScoreProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSourceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexIdentifierContext;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.DocumentReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.EntityProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.EntityReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.IdProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ScoreProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.util.common.function.TriFunction;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class ElasticsearchSearchProjectionBuilderFactory
implements SearchProjectionBuilderFactory {
    private final ElasticsearchSearchIndexScope<?> scope;
    private final DocumentReferenceExtractionHelper documentReferenceExtractionHelper;
    private final ProjectionExtractionHelper<String> idProjectionExtractionHelper;

    public ElasticsearchSearchProjectionBuilderFactory(SearchProjectionBackendContext searchProjectionBackendContext, ElasticsearchSearchIndexScope<?> scope) {
        this.scope = scope;
        this.documentReferenceExtractionHelper = searchProjectionBackendContext.createDocumentReferenceExtractionHelper(scope);
        this.idProjectionExtractionHelper = searchProjectionBackendContext.idProjectionExtractionHelper();
    }

    public DocumentReferenceProjectionBuilder documentReference() {
        return new ElasticsearchDocumentReferenceProjection.Builder(this.scope, this.documentReferenceExtractionHelper);
    }

    public <E> EntityProjectionBuilder<E> entity() {
        return new ElasticsearchEntityProjection.Builder(this.scope, this.documentReferenceExtractionHelper);
    }

    public <R> EntityReferenceProjectionBuilder<R> entityReference() {
        return new ElasticsearchEntityReferenceProjection.Builder(this.scope, this.documentReferenceExtractionHelper);
    }

    public <I> IdProjectionBuilder<I> id(Class<I> identifierType) {
        SearchIndexIdentifierContext identifier = this.scope.identifier();
        return new ElasticsearchIdProjection.Builder(this.scope, this.idProjectionExtractionHelper, identifier.projectionConverter().withConvertedType(identifierType, (EventContextProvider)identifier));
    }

    public ScoreProjectionBuilder score() {
        return new ElasticsearchScoreProjection.Builder(this.scope);
    }

    public <P> CompositeProjectionBuilder<P> composite(Function<List<?>, P> transformer, SearchProjection<?> ... projections) {
        ArrayList typedProjections = new ArrayList(projections.length);
        for (SearchProjection<?> projection : projections) {
            typedProjections.add(this.toImplementation(projection));
        }
        return new AbstractElasticsearchCompositeProjection.Builder<P>(new ElasticsearchCompositeListProjection<P>(this.scope, transformer, typedProjections));
    }

    public <P1, P> CompositeProjectionBuilder<P> composite(Function<P1, P> transformer, SearchProjection<P1> projection) {
        return new AbstractElasticsearchCompositeProjection.Builder(new ElasticsearchCompositeFunctionProjection<P1, P>(this.scope, transformer, this.toImplementation(projection)));
    }

    public <P1, P2, P> CompositeProjectionBuilder<P> composite(BiFunction<P1, P2, P> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2) {
        return new AbstractElasticsearchCompositeProjection.Builder(new ElasticsearchCompositeBiFunctionProjection<P1, P2, P>(this.scope, transformer, this.toImplementation(projection1), this.toImplementation(projection2)));
    }

    public <P1, P2, P3, P> CompositeProjectionBuilder<P> composite(TriFunction<P1, P2, P3, P> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2, SearchProjection<P3> projection3) {
        return new AbstractElasticsearchCompositeProjection.Builder(new ElasticsearchCompositeTriFunctionProjection<P1, P2, P3, P>(this.scope, transformer, this.toImplementation(projection1), this.toImplementation(projection2), this.toImplementation(projection3)));
    }

    public SearchProjectionBuilder<JsonObject> source() {
        return new ElasticsearchSourceProjection.Builder(this.scope);
    }

    public SearchProjectionBuilder<JsonObject> explanation() {
        return new ElasticsearchExplanationProjection.Builder(this.scope);
    }

    public SearchProjectionBuilder<JsonObject> jsonHit() {
        return new ElasticsearchJsonHitProjection.Builder(this.scope);
    }

    private <T> ElasticsearchSearchProjection<?, T> toImplementation(SearchProjection<T> projection) {
        return ElasticsearchSearchProjection.from(this.scope, projection);
    }
}

