/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ClusteredRequestResponseTest
extends ClusterTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    protected boolean isNetty() {
        return false;
    }

    @Test
    public void testRequestResponse() throws Exception {
        this.setupCluster();
        this.startServers(0, 1, 2, 3, 4);
        for (int i = 0; i < 5; ++i) {
            ClusteredRequestResponseTest.waitForTopology((ActiveMQServer)this.servers[i], (int)5);
        }
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress1", "queueA", null, false);
        this.createQueue(4, "queues.testaddress2", "queueB", null, false);
        this.addConsumer(0, 0, "queueA", null);
        this.addConsumer(4, 4, "queueB", null);
        this.waitForBindings(0, "queues.testaddress1", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress2", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress1", 1, 1, false);
        this.waitForBindings(2, "queues.testaddress1", 1, 1, false);
        this.waitForBindings(3, "queues.testaddress1", 1, 1, false);
        this.waitForBindings(4, "queues.testaddress1", 1, 1, false);
        this.waitForBindings(0, "queues.testaddress2", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress2", 1, 1, false);
        this.waitForBindings(2, "queues.testaddress2", 1, 1, false);
        this.waitForBindings(3, "queues.testaddress2", 1, 1, false);
        this.send(0, "queues.testaddress2", 10, false, null);
        this.verifyReceiveAll(10, 4);
        this.send(4, "queues.testaddress1", 10, false, null);
        this.verifyReceiveAll(10, 0);
    }

    @Test
    @Ignore
    public void testRequestResponseNoWaitForBindings() throws Exception {
        this.setupCluster();
        this.startServers(0, 1, 2, 3, 4);
        for (int i = 0; i < 5; ++i) {
            ClusteredRequestResponseTest.waitForTopology((ActiveMQServer)this.servers[i], (int)5);
        }
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress1", "queueA", null, false);
        this.createQueue(4, "queues.testaddress2", "queueB", null, false);
        this.addConsumer(0, 0, "queueA", null);
        this.addConsumer(4, 4, "queueB", null);
        this.waitForBindings(4, "queues.testaddress2", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress2", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress2", 1, 1, false);
        this.waitForBindings(2, "queues.testaddress2", 1, 1, false);
        this.waitForBindings(3, "queues.testaddress2", 1, 1, false);
        this.send(0, "queues.testaddress2", 10, false, null);
        this.verifyReceiveAll(10, 4);
        this.send(4, "queues.testaddress1", 10, false, null);
        this.verifyReceiveAll(10, 0);
    }

    protected void setupCluster() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1, 2, 3, 4);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0, 2, 3, 4);
        this.setupClusterConnection("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 2, 0, 1, 3, 4);
        this.setupClusterConnection("cluster3", "queues", messageLoadBalancingType, 1, this.isNetty(), 3, 0, 1, 2, 4);
        this.setupClusterConnection("cluster4", "queues", messageLoadBalancingType, 1, this.isNetty(), 4, 0, 1, 2, 3);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupServer(3, this.isFileStorage(), this.isNetty());
        this.setupServer(4, this.isFileStorage(), this.isNetty());
    }
}

