/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ProducerBlockingTtlTest
extends BasicOpenWireTest {
    ActiveMQQueue queueA = new ActiveMQQueue("QUEUE.A");
    protected ActiveMQConnection flowControlConnection;

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        String match = "#";
        Map asMap = serverConfig.getAddressesSettings();
        ((AddressSettings)asMap.get(match)).setMaxSizeBytes(1L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.makeSureCoreQueueExist("QUEUE.A");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            if (this.flowControlConnection != null) {
                TcpTransport t = (TcpTransport)this.flowControlConnection.getTransport().narrow(TcpTransport.class);
                try {
                    this.flowControlConnection.getTransport().stop();
                    this.flowControlConnection.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected String getConnectionUrl() {
        return "tcp://localhost:61616?wireFormat.cacheEnabled=true&wireFormat.maxInactivityDuration=1000&wireFormat.maxInactivityDurationInitalDelay=1000";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProducerBlockWontGetTimeout() throws Exception {
        this.flowControlConnection = (ActiveMQConnection)this.factory.createConnection();
        Connection consumerConnection = this.factory.createConnection();
        Thread fillThread = null;
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        try {
            this.flowControlConnection.start();
            final Session session = this.flowControlConnection.createSession(false, 1);
            final MessageProducer producer = session.createProducer((Destination)this.queueA);
            producer.setDeliveryMode(1);
            String text = "Hello World";
            int num = 10;
            fillThread = new Thread("Fill thread."){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 10 && keepGoing.get(); ++i) {
                            producer.send((Message)session.createTextMessage("Hello World" + i));
                        }
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
            };
            fillThread.start();
            Thread.sleep(4000L);
            consumerConnection.start();
            Session consumerSession = consumerConnection.createSession(false, 1);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)this.queueA);
            for (int i = 0; i < 10; ++i) {
                TextMessage m = (TextMessage)consumer.receive(5000L);
                ProducerBlockingTtlTest.assertNotNull((Object)m);
                ProducerBlockingTtlTest.assertEquals((Object)("Hello World" + i), (Object)m.getText());
            }
            ProducerBlockingTtlTest.assertNull((Object)consumer.receive(3L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fillThread != null) {
                keepGoing.set(false);
                fillThread.interrupt();
                fillThread.join();
            }
            try {
                this.flowControlConnection.close();
                this.flowControlConnection = null;
            }
            catch (Throwable throwable) {}
            try {
                consumerConnection.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

