/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Cleaner;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;

class EntityOutputStream
extends OutputStream {
    private static final Cleaner CLEANER = Cleaner.create();
    private final Object lock = new Object();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean exported = new AtomicBoolean();
    private final int threshold;
    private final Supplier<String> filePrefix;
    private final ByteArrayOutputStream inMemory;
    private final Path tmpDir;
    private volatile Path file;
    private volatile OutputStream delegate;

    EntityOutputStream(int threshold, Supplier<String> filePrefix) {
        this(threshold, null, filePrefix);
    }

    EntityOutputStream(int threshold, Path tmpDir, Supplier<String> filePrefix) {
        this.threshold = threshold;
        this.filePrefix = filePrefix;
        this.inMemory = new ByteArrayOutputStream(threshold);
        this.delegate = this.inMemory;
        this.tmpDir = tmpDir;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException(Messages.MESSAGES.streamIsClosed());
        }
        this.getDelegate(1).write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException(Messages.MESSAGES.streamIsClosed());
        }
        this.getDelegate(b.length).write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException(Messages.MESSAGES.streamIsClosed());
        }
        this.getDelegate(len).write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.getDelegate().flush();
    }

    @Override
    public void close() throws IOException {
        this.getDelegate().close();
        this.closed.set(true);
    }

    InputStream toInputStream() throws IOException {
        if (!this.closed.get()) {
            throw Messages.MESSAGES.streamNotClosed((OutputStream)this);
        }
        if (!this.exported.compareAndSet(false, true)) {
            throw Messages.MESSAGES.alreadyExported();
        }
        Object object = this.lock;
        synchronized (object) {
            ByteArrayInputStream byteArrayInputStream;
            if (this.file != null) {
                InputStream in = Files.newInputStream(this.file, new OpenOption[0]);
                return new EntityInputStream(in, CLEANER.register(in, new FileCleaner(this.file)));
            }
            try {
                byteArrayInputStream = new ByteArrayInputStream(this.inMemory.toByteArray());
                this.inMemory.reset();
            }
            catch (Throwable throwable) {
                this.inMemory.reset();
                throw throwable;
            }
            return byteArrayInputStream;
        }
    }

    AbstractHttpEntity toEntity() {
        if (!this.closed.get()) {
            throw Messages.MESSAGES.streamNotClosed((OutputStream)this);
        }
        if (!this.exported.compareAndSet(false, true)) {
            throw Messages.MESSAGES.alreadyExported();
        }
        Object object = this.lock;
        synchronized (object) {
            ByteArrayEntity byteArrayEntity;
            if (this.file != null) {
                FileEntity result = new FileEntity(this.file.toFile());
                CLEANER.register(result, new FileCleaner(this.file));
                return result;
            }
            try {
                byteArrayEntity = new ByteArrayEntity(this.inMemory.toByteArray());
                this.inMemory.reset();
            }
            catch (Throwable throwable) {
                this.inMemory.reset();
                throw throwable;
            }
            return byteArrayEntity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getContentLength() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.file == null ? (long)this.inMemory.size() : Files.size(this.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream getDelegate() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream getDelegate(int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.file != null) {
                return this.delegate;
            }
            if (len + this.inMemory.size() < this.threshold) {
                return this.delegate;
            }
            this.file = this.tmpDir == null ? Files.createTempFile(this.filePrefix.get(), ".tmp", new FileAttribute[0]) : Files.createTempFile(this.tmpDir, this.filePrefix.get(), ".tmp", new FileAttribute[0]);
            OutputStream out = Files.newOutputStream(this.file, StandardOpenOption.CREATE);
            this.inMemory.writeTo(out);
            this.inMemory.reset();
            this.delegate = out;
            return this.delegate;
        }
    }

    private static class EntityInputStream
    extends InputStream {
        private final InputStream delegate;
        private final Cleaner.Cleanable cleanable;

        private EntityInputStream(InputStream delegate, Cleaner.Cleanable cleanable) {
            this.delegate = delegate;
            this.cleanable = cleanable;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            return this.delegate.readAllBytes();
        }

        @Override
        public byte[] readNBytes(int len) throws IOException {
            return this.delegate.readNBytes(len);
        }

        @Override
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            return this.delegate.readNBytes(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            this.cleanable.clean();
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public long transferTo(OutputStream out) throws IOException {
            return this.delegate.transferTo(out);
        }
    }

    private static class FileCleaner
    implements Runnable {
        private final Path path;

        private FileCleaner(Path path) {
            this.path = path;
        }

        @Override
        public void run() {
            try {
                Files.deleteIfExists(this.path);
            }
            catch (IOException e) {
                LogMessages.LOGGER.debugf((Throwable)e, "Failed to delete file %s", (Object)this.path);
            }
        }
    }
}

